/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmwcu;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUException;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUInputParameters;

public class OjvmWCUClasses {
    public OjvmWCUInputParameters inpParam = null;

    public OjvmWCUClasses(OjvmWCUInputParameters inpPar) {
        this.inpParam = inpPar;
    }

    public Boolean checkRequiredJars() throws OjvmWCUException {
        return Boolean.TRUE;
    }

    public Boolean runJAXRS() throws OjvmWCUException {
        this.inpParam.OWCULogger.info("Generating Client Stubs");
        String command = "";
        if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
            for (int k = 0; k < this.inpParam.jaxRSInputArgs.size(); ++k) {
                command = command + this.inpParam.jaxRSInputArgs.get(k) + " ";
            }
            this.inpParam.OWCULogger.info(command);
        }
        try {
            ProcessBuilder jaxrsProcess = new ProcessBuilder(this.inpParam.jaxRSInputArgs);
            Process p = jaxrsProcess.start();
            OutputStream out = p.getOutputStream();
            InputStream err = p.getErrorStream();
            BufferedReader ebr = new BufferedReader(new InputStreamReader(err));
            String errorLine = ebr.readLine();
            if (errorLine != null && !errorLine.contains("Info")) {
                if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
                    this.inpParam.OWCULogger.severe(errorLine);
                }
                throw new OjvmWCUException(4, "Error running wadl2java tool", this.inpParam, null);
            }
            if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
                String line;
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                this.inpParam.OWCULogger.info("JAX-RS Output");
                while ((line = br.readLine()) != null) {
                    this.inpParam.OWCULogger.info(line);
                }
            }
            p.waitFor();
            if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
                this.inpParam.OWCULogger.info("Finished JAX-RS");
            }
            p.destroy();
        }
        catch (InterruptedException ie) {
            throw new OjvmWCUException(10, this.inpParam, ie);
        }
        catch (IOException ioe) {
            throw new OjvmWCUException(10, this.inpParam, ioe);
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Running JAX-RS Exception " + e.getMessage(), this.inpParam, e);
        }
        return Boolean.TRUE;
    }

    public Boolean runJAXWS() throws OjvmWCUException {
        this.inpParam.OWCULogger.info("Generating Client Stubs");
        if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
            String command = "";
            for (int k = 0; k < this.inpParam.jaxWSInputArgs.size(); ++k) {
                command = command + this.inpParam.jaxWSInputArgs.get(k) + " ";
            }
            this.inpParam.OWCULogger.info(command);
        }
        try {
            ProcessBuilder jaxwsProcess = new ProcessBuilder(this.inpParam.jaxWSInputArgs);
            Process p = jaxwsProcess.start();
            OutputStream out = p.getOutputStream();
            InputStream err = p.getErrorStream();
            BufferedReader ebr = new BufferedReader(new InputStreamReader(err));
            String errorLine = ebr.readLine();
            if (errorLine != null && errorLine.contains("Failed to parse the WSDL")) {
                if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
                    this.inpParam.OWCULogger.severe(errorLine);
                }
                throw new OjvmWCUException(4, "Error running wsimport tool", this.inpParam, null);
            }
            if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
                String line;
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                this.inpParam.OWCULogger.info("JAX-WS Output");
                while ((line = br.readLine()) != null) {
                    this.inpParam.OWCULogger.info(line);
                }
            }
            p.waitFor();
            if (this.inpParam.OjvmWCUVerbose.booleanValue()) {
                this.inpParam.OWCULogger.info("Finished JAX-WS");
            }
            p.destroy();
        }
        catch (InterruptedException ie) {
            throw new OjvmWCUException(10, this.inpParam, ie);
        }
        catch (IOException ioe) {
            throw new OjvmWCUException(10, this.inpParam, ioe);
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Running JAX-WS Exception " + e.getMessage(), this.inpParam, e);
        }
        return Boolean.TRUE;
    }

    public Boolean generateClasses() throws OjvmWCUException {
        File[] fileList;
        String packagePath = this.inpParam.packageName;
        packagePath = packagePath.replaceAll("\\.", "/");
        this.inpParam.outputDirectory = this.inpParam.outputDirectory.replace("/.", "");
        File directory = new File(this.inpParam.outputDirectory + "/" + packagePath);
        if (this.inpParam.keepSrc.booleanValue()) {
            if (!directory.exists()) {
                directory.mkdirs();
            } else {
                fileList = directory.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    fileList[i].delete();
                }
            }
        }
        try {
            if (this.checkRequiredJars().booleanValue()) {
                if (this.inpParam.isWSDL.booleanValue()) {
                    this.runJAXWS();
                } else if (this.inpParam.isWADL.booleanValue()) {
                    this.runJAXRS();
                    fileList = directory.listFiles();
                    for (int fno = 0; fno < fileList.length; ++fno) {
                        if (!fileList[fno].isFile() || !fileList[fno].getName().endsWith(".java")) continue;
                        String fileNameOnly = fileList[fno].getName().substring(0, fileList[fno].getName().indexOf(".java"));
                        if (this.compileJavaClass(this.inpParam.outputDirectory + "/" + packagePath + "/" + fileNameOnly + ".java", this.getAdditionalClasspath()).booleanValue()) continue;
                        throw new OjvmWCUException(2, "Error in compiling Clinet Stubs", this.inpParam, null);
                    }
                    fileList = directory.listFiles();
                    if (!directory.exists() || fileList.length == 0) {
                        throw new OjvmWCUException(2, "Client Stub not Generated", this.inpParam, null);
                    }
                }
            }
        }
        catch (OjvmWCUException oe) {
            throw oe;
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Generate Classes Exception", this.inpParam, e);
        }
        return Boolean.TRUE;
    }

    public String[] getAdditionalClasspath() {
        ArrayList<String> addClassPath = new ArrayList<String>();
        String acp = this.inpParam.additionalClassPath;
        if (acp.endsWith(":")) {
            String tacp;
            acp = tacp = acp.substring(0, acp.length() - 1);
        }
        while (acp.contains(":")) {
            String tacp;
            int indSC = acp.indexOf(":");
            addClassPath.add(acp.substring(0, indSC));
            acp = tacp = acp.substring(indSC + 1);
        }
        addClassPath.add(acp);
        String[] array = new String[addClassPath.size() + 1];
        array[0] = this.inpParam.tmpDirectory + "/";
        for (int i = 1; i < array.length; ++i) {
            array[i] = (String)addClassPath.get(i - 1);
        }
        return array;
    }

    public Boolean compileJavaClass(String file, String[] classPath) throws OjvmWCUException {
        try {
            JavaCompiler x = ToolProvider.getSystemJavaCompiler();
            String[] classPathVariable = new String[5];
            classPathVariable[0] = file;
            classPathVariable[1] = "-cp";
            String fullCp = "";
            for (int i = 0; i < classPath.length; ++i) {
                fullCp = fullCp + classPath[i] + System.getProperty("path.separator");
            }
            classPathVariable[2] = fullCp;
            classPathVariable[3] = "-d";
            classPathVariable[4] = this.inpParam.tmpDirectory;
            if (x != null) {
                x.run(null, null, null, classPathVariable);
            } else {
                String javacPath = this.inpParam.jdkHome + "/bin/javac";
                String[] javacArgs = new String[classPathVariable.length + 3];
                javacArgs[0] = javacPath;
                javacArgs[1] = "-d";
                javacArgs[2] = this.inpParam.tmpDirectory;
                for (int i = 0; i < classPathVariable.length; ++i) {
                    javacArgs[i + 1] = classPathVariable[i];
                }
                ProcessBuilder javacProcess = new ProcessBuilder(javacArgs);
                Process p = javacProcess.start();
                OutputStream out = p.getOutputStream();
                InputStream err = p.getErrorStream();
                BufferedReader ebr = new BufferedReader(new InputStreamReader(err));
                if (ebr.readLine() != null) {
                    throw new OjvmWCUException(6, "Error running Javac tool", this.inpParam, null);
                }
                p.waitFor();
                p.destroy();
            }
        }
        catch (Exception e) {
            throw new OjvmWCUException(6, file + "\nA common reason is JDBC Driver not in CLASSPATH\nEither set CLASSPATH or use -cp with JDBC Driver\n", this.inpParam, e);
        }
        return Boolean.TRUE;
    }
}

