/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.ojvmwcu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUException;
import oracle.aurora.server.tools.ojvmwcu.OjvmWCUUtils;

public class OjvmWCUInputParameters {
    public String nameOfWebService = "defaultWebService";
    public String tmpDirectory = "";
    public String user = "";
    public String dbhost = "localhost";
    public int dbport = 1521;
    public String oraSID = "";
    public String oraServ = "";
    public String currentWorkingDir = "";
    public Logger OWCULogger = Logger.getLogger("OjvmWcu");
    public Boolean OjvmWCUVerbose = Boolean.FALSE;
    public String outputDirectory = "";
    public String inputWSDLLocation = "";
    public String inputWADLLocation = "";
    public Boolean requireJAR = Boolean.FALSE;
    public String packageName = "";
    public String jdkHome = "";
    public String wadlHome = "";
    public String wadl2javaLoc = "";
    public String wsimportLoc = "";
    public String jarFileName = "";
    public String plsqlWrapperName = "";
    public String grantFile = "";
    public String revokeFile = "";
    public String cleanUpFile = "";
    public ArrayList<String> jaxWSInputArgs = new ArrayList();
    public ArrayList<String> enumNameArray = new ArrayList();
    public ArrayList<String> jaxRSInputArgs = new ArrayList();
    public ArrayList<String> unProcessedjaxWSInputArgs = new ArrayList();
    public ArrayList<String> webServiceWrapperContents = new ArrayList();
    public ArrayList<String> grantPermissionContents = new ArrayList();
    public ArrayList<String> revokePermissionContents = new ArrayList();
    public HashMap<String, String> operationHelper = new HashMap();
    public Boolean fullAuto = Boolean.FALSE;
    public Boolean isWADL = Boolean.FALSE;
    public Boolean isWSDL = Boolean.FALSE;
    public int usageType = 0;
    public Boolean authSpecified = Boolean.FALSE;
    public String additionalClassPath = "";
    public ArrayList<String> newTypesCreate = new ArrayList();
    public ArrayList<String> webServiceCleanup = new ArrayList();
    private String authURL = "";
    private String xauthFileLoc = "";
    public Boolean keepSrc = Boolean.FALSE;
    public String trustStore = "";
    public String trustStoreProperty = "javax.net.ssl.trustStore";

    public OjvmWCUInputParameters() {
        this.OWCULogger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new OjvmWcuFormatter());
        this.OWCULogger.addHandler(handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInputArguments(String[] inpArgs) throws OjvmWCUException {
        String newCP;
        try {
            this.currentWorkingDir = new File(".").getCanonicalPath();
            this.tmpDirectory = this.currentWorkingDir + "/tmp";
            File tempDir = new File(this.tmpDirectory);
            if (tempDir.exists()) {
                this.cleanupTmpDir();
            }
            if (!tempDir.mkdirs()) {
                throw new OjvmWCUException(null, null);
            }
        }
        catch (Exception e) {
            throw new OjvmWCUException(1, "Directory Access Issue / Tmp dir already exist", null, e);
        }
        this.parseArgs(inpArgs);
        if (this.outputDirectory.equals("")) {
            this.outputDirectory = new File(".").getAbsolutePath();
        }
        if (this.packageName.equals("")) {
            this.packageName = "ojvm.webservice";
        }
        if (this.inputWSDLLocation.equals("") && this.inputWADLLocation.equals("")) {
            throw new OjvmWCUException(1, "Description file is not provided. Use -wsdl / -wadl", null, null);
        }
        if (this.fullAuto.booleanValue() && (this.user.equals("") || this.oraServ.equals("") && this.oraSID.equals(""))) {
            throw new OjvmWCUException(1, "With -auto option -user and oraserv/orasid are mandatory.", null, null);
        }
        this.jdkHome = System.getenv("JAVA_HOME");
        if (this.jdkHome == null || this.jdkHome.equalsIgnoreCase("")) {
            throw new OjvmWCUException(1, "Please set JDK to JAVA_HOME environment Variable\n", null, null);
        }
        String wsimportLoc = this.jdkHome + File.separator + "bin" + File.separator;
        if (!(new File(wsimportLoc + "wsimport").exists() || new File(wsimportLoc + "wsimport.sh").exists() || new File(wsimportLoc + "wsimport.bat").exists() || new File(wsimportLoc + "wsimport.exe").exists())) {
            throw new OjvmWCUException(1, "Please check if JAVA_HOME points to the JDK location, not to JRE location or any other invalid locations\n", null, null);
        }
        if (this.isWADL.booleanValue()) {
            if (this.wadlHome.equals("")) {
                String wadlHomeDefault = System.getenv("WADL_HOME");
                if (wadlHomeDefault == null || wadlHomeDefault.equalsIgnoreCase("")) {
                    throw new OjvmWCUException(1, "Please set WADL_HOME environment Variable Or use -t Option", null, null);
                }
                this.wadl2javaLoc = wadlHomeDefault + File.separator + "bin" + File.separator + "wadl2java";
                if (!new File(this.wadl2javaLoc).exists() && !new File(this.wadl2javaLoc + "wadl2java.sh").exists() && !new File(this.wadl2javaLoc + "wadl2java.bat").exists() && !new File(this.wadl2javaLoc + "wadl2java.exe").exists()) throw new OjvmWCUException(1, "Please check if WADL_HOME points to the WADL2JAVA location \nOr else use -t Option ", null, null);
                this.wadlHome = wadlHomeDefault;
            } else {
                this.wadl2javaLoc = this.wadlHome + File.separator + "bin" + File.separator + "wadl2java";
                if (!(new File(this.wadl2javaLoc).exists() || new File(this.wadl2javaLoc + "wadl2java.sh").exists() || new File(this.wadl2javaLoc + "wadl2java.bat").exists() || new File(this.wadl2javaLoc + "wadl2java.exe").exists())) {
                    throw new OjvmWCUException(1, "Please check if -t option points to WADL home directory", null, null);
                }
            }
        }
        if (!this.trustStore.equals("")) {
            System.setProperty(this.trustStoreProperty, this.trustStore);
            if (this.OjvmWCUVerbose.booleanValue()) {
                this.OWCULogger.warning("Overriding system property " + this.trustStoreProperty);
            }
        } else if ((this.inputWSDLLocation.contains("https") || this.inputWADLLocation.contains("https")) && this.OjvmWCUVerbose.booleanValue()) {
            this.OWCULogger.warning("URL is SSL secured. If certificate is not trusted then client generation may fail. \nUse -ts option Or Set " + this.trustStoreProperty + " Property. Or \n Add certificate in default trustStore");
        }
        this.jaxRSInputArgs.add("java");
        if (this.trustStore != null && !this.trustStore.equalsIgnoreCase("")) {
            this.jaxRSInputArgs.add("-D" + this.trustStoreProperty + "=" + this.trustStore);
        }
        this.jaxRSInputArgs.add("-jar");
        this.jaxRSInputArgs.add(this.wadlHome + File.separator + "lib" + File.separator + "wadl-cmdline-1.1.6.jar");
        this.jaxRSInputArgs.add("-o");
        this.jaxRSInputArgs.add(this.outputDirectory);
        this.jaxRSInputArgs.add("-p");
        this.jaxRSInputArgs.add(this.packageName);
        this.jaxRSInputArgs.add("-s");
        String code_style = "jaxrs20";
        this.jaxRSInputArgs.add(code_style);
        this.jaxWSInputArgs.add("java");
        this.jaxWSInputArgs.add("-classpath");
        this.jaxWSInputArgs.add(this.jdkHome + File.separator + "lib" + File.separator + "tools.jar");
        if (this.trustStore != null && !this.trustStore.equalsIgnoreCase("")) {
            this.jaxWSInputArgs.add("-D" + this.trustStoreProperty + "=" + this.trustStore);
        }
        this.jaxWSInputArgs.add("com.sun.tools.internal.ws.WsImport");
        this.jaxWSInputArgs.add("-d");
        this.jaxWSInputArgs.add(this.tmpDirectory);
        this.jaxWSInputArgs.add("-s");
        if (this.keepSrc.booleanValue()) {
            this.jaxWSInputArgs.add(this.outputDirectory);
        } else {
            this.jaxWSInputArgs.add(this.tmpDirectory);
        }
        this.jaxWSInputArgs.add("-p");
        this.jaxWSInputArgs.add(this.packageName);
        if (this.authSpecified.booleanValue()) {
            String auFileLoc;
            if (this.xauthFileLoc.equals("")) {
                ArrayList<String> tmpAu = new ArrayList<String>();
                tmpAu.add(this.authURL);
                auFileLoc = this.tmpDirectory + File.separator + "tmpAu";
                OjvmWCUUtils.writeToFile(auFileLoc, tmpAu, this);
            } else {
                auFileLoc = this.xauthFileLoc;
            }
            this.jaxWSInputArgs.add("-Xauthfile");
            this.jaxWSInputArgs.add(auFileLoc);
        }
        if (this.isWSDL.booleanValue()) {
            this.jaxWSInputArgs.add(this.inputWSDLLocation);
            this.jaxWSInputArgs.addAll(this.unProcessedjaxWSInputArgs);
        }
        if (this.isWADL.booleanValue()) {
            this.jaxRSInputArgs.add(this.inputWADLLocation);
        }
        this.jarFileName = this.outputDirectory + "/" + this.nameOfWebService + ".jar";
        this.plsqlWrapperName = this.outputDirectory + "/" + this.nameOfWebService + "_wrapper.sql";
        this.grantFile = this.outputDirectory + "/" + this.nameOfWebService + "_grant_permission.sql";
        this.revokeFile = this.outputDirectory + "/" + this.nameOfWebService + "_revoke_permission.sql";
        this.cleanUpFile = this.outputDirectory + "/" + this.nameOfWebService + "_cleanup_wrapper.sql";
        String presentClassPath = System.getenv("CLASSPATH");
        if (presentClassPath == null || presentClassPath.equalsIgnoreCase("")) return;
        this.additionalClassPath = newCP = presentClassPath + ";" + this.additionalClassPath;
    }

    public Boolean doubleWordOption(String[] arg, int pos, String optionName) throws OjvmWCUException {
        if (arg.length <= pos + 1 || arg[pos + 1].startsWith("-")) {
            throw new OjvmWCUException(1, arg[pos] + " <" + optionName + "> needs argument to be provided.", null, null);
        }
        return Boolean.TRUE;
    }

    public Boolean isInjectionPossibilities(String input) {
        if (input.contains("\"") || input.contains("'") || input.contains("`") || input.contains(" ")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean cleanupTmpDir() throws OjvmWCUException {
        Boolean retVal = Boolean.FALSE;
        try {
            retVal = this.deleteFolder(new File(this.tmpDirectory));
        }
        catch (Exception e) {
            throw new OjvmWCUException(2, "Exception while cleaning up tmp directory", null, null);
        }
        return retVal;
    }

    public Boolean deleteFolder(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteFolder(files[i]);
            }
            f.delete();
        } else {
            System.gc();
            f.deleteOnExit();
            new File(f.getAbsolutePath()).delete();
            if (f.exists()) {
                f.delete();
            }
        }
        return Boolean.TRUE;
    }

    private String[] getArgsFromFile(String filename) throws OjvmWCUException {
        ArrayList<String> lines = null;
        try {
            FileReader fileReader = new FileReader(filename);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            lines = new ArrayList<String>();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line);
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    lines.add(token);
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException ex) {
            throw new OjvmWCUException(1, "InputFile specified with -i option not found", null, null);
        }
        catch (IOException ex) {
            throw new OjvmWCUException(1, "Error in reading input file", null, null);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void parseArgs(String[] inpArgs) throws OjvmWCUException {
        for (int i = 0; i < inpArgs.length; ++i) {
            String interStr;
            if (inpArgs[i].equals("-i")) {
                if (!this.doubleWordOption(inpArgs, i, "Arguments file").booleanValue()) continue;
                String[] argsFromFile = this.getArgsFromFile(inpArgs[++i]);
                this.parseArgs(argsFromFile);
                continue;
            }
            if (inpArgs[i].equals("-v")) {
                this.OjvmWCUVerbose = Boolean.TRUE;
                continue;
            }
            if (inpArgs[i].equals("-auto")) {
                this.fullAuto = Boolean.TRUE;
                continue;
            }
            if (inpArgs[i].equals("-jar")) {
                this.requireJAR = Boolean.TRUE;
                continue;
            }
            if (inpArgs[i].equals("-keepsrc")) {
                this.keepSrc = Boolean.TRUE;
                continue;
            }
            if (inpArgs[i].equals("-out")) {
                if (!this.doubleWordOption(inpArgs, i, "output Folder").booleanValue()) continue;
                File thisF = new File(inpArgs[i + 1]);
                if (thisF.exists() && thisF.isDirectory()) {
                    this.outputDirectory = inpArgs[i + 1];
                    ++i;
                    continue;
                }
                try {
                    thisF.mkdir();
                    this.outputDirectory = inpArgs[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new OjvmWCUException(2, "Creation of Output Directory failed with Exception" + e, null, null);
                }
            }
            if (inpArgs[i].equals("-wadl")) {
                this.isWADL = Boolean.TRUE;
                if (this.doubleWordOption(inpArgs, i, "WADL file").booleanValue()) {
                    this.inputWADLLocation = inpArgs[i + 1];
                    this.inputWADLLocation = this.inputWADLLocation.replace("\"", "");
                    ++i;
                }
                if (!(interStr = this.inputWADLLocation.trim()).matches("(h|H)(t|T)(t|T)(p|P)(s|S)?://[a-zA-Z0-9]*:[a-zA-Z0-9]*@.*")) continue;
                this.authURL = this.inputWADLLocation;
                this.authSpecified = Boolean.TRUE;
                int indOfAt = interStr.indexOf("@");
                int indOfCl = interStr.indexOf("://");
                this.inputWADLLocation = interStr.substring(0, indOfCl + 3) + interStr.substring(indOfAt + 1);
                continue;
            }
            if (inpArgs[i].equals("-wsdl")) {
                this.isWSDL = Boolean.TRUE;
                if (this.doubleWordOption(inpArgs, i, "WSDL file").booleanValue()) {
                    this.inputWSDLLocation = inpArgs[i + 1];
                    this.inputWSDLLocation = this.inputWSDLLocation.replace("\"", "");
                    ++i;
                }
                if (!(interStr = this.inputWSDLLocation.trim()).matches("(h|H)(t|T)(t|T)(p|P)(s|S)?://[a-zA-Z0-9]*:[a-zA-Z0-9]*@.*")) continue;
                this.authURL = this.inputWSDLLocation;
                this.authSpecified = Boolean.TRUE;
                int indOfAt = interStr.indexOf("@");
                int indOfCl = interStr.indexOf("://");
                this.inputWSDLLocation = interStr.substring(0, indOfCl + 3) + interStr.substring(indOfAt + 1);
                continue;
            }
            if (inpArgs[i].equals("-Xauthfile")) {
                if (!this.doubleWordOption(inpArgs, i, "XAuthFile").booleanValue()) continue;
                this.xauthFileLoc = inpArgs[i + 1];
                this.authSpecified = Boolean.TRUE;
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-name")) {
                if (!this.doubleWordOption(inpArgs, i, "WS Name").booleanValue()) continue;
                this.nameOfWebService = inpArgs[i + 1];
                if (this.isInjectionPossibilities(this.nameOfWebService).booleanValue()) {
                    throw new OjvmWCUException(1, "Web Service Name contains invalid characters", null, null);
                }
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-p")) {
                if (!this.doubleWordOption(inpArgs, i, "Package Name").booleanValue()) continue;
                this.packageName = inpArgs[i + 1];
                if (this.isInjectionPossibilities(this.packageName).booleanValue()) {
                    throw new OjvmWCUException(1, "Package Name contains invalid characters", null, null);
                }
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-user")) {
                if (!this.doubleWordOption(inpArgs, i, "User").booleanValue()) continue;
                this.user = inpArgs[i + 1];
                if (this.isInjectionPossibilities(this.user).booleanValue()) {
                    throw new OjvmWCUException(1, "User Name contains invalid characters", null, null);
                }
                if (this.user.contains("/")) {
                    throw new OjvmWCUException(1, "User/Pass type of credentials are not supported.\nPlease enter password whenever prompted.", null, null);
                }
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-ts")) {
                if (!this.doubleWordOption(inpArgs, i, "trustStore").booleanValue()) continue;
                this.trustStore = inpArgs[i + 1];
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-dbhost")) {
                if (!this.doubleWordOption(inpArgs, i, "DbHost").booleanValue()) continue;
                this.dbhost = inpArgs[i + 1];
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-dbport")) {
                if (!this.doubleWordOption(inpArgs, i, "DbPort").booleanValue()) continue;
                try {
                    this.dbport = Integer.parseInt(inpArgs[i + 1]);
                }
                catch (NumberFormatException ne) {
                    throw new OjvmWCUException(2, "port should be an integer", this, ne);
                }
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-orasid")) {
                if (!this.doubleWordOption(inpArgs, i, "OracleSID").booleanValue()) continue;
                this.oraSID = inpArgs[i + 1];
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-oraserv")) {
                if (!this.doubleWordOption(inpArgs, i, "Oracle Service").booleanValue()) continue;
                this.oraServ = inpArgs[i + 1];
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-cp")) {
                if (!this.doubleWordOption(inpArgs, i, "ClassPath").booleanValue()) continue;
                this.additionalClassPath = this.additionalClassPath.equals("") ? inpArgs[i + 1] : this.additionalClassPath + File.pathSeparatorChar + inpArgs[i + 1];
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-t")) {
                if (this.doubleWordOption(inpArgs, i, "WSDL Tool Home").booleanValue()) {
                    this.wadlHome = inpArgs[i + 1];
                    ++i;
                }
                if (this.wadlHome.endsWith("\"")) {
                    this.wadlHome = this.wadlHome.substring(0, this.wadlHome.length() - 1);
                }
                try {
                    File wadlDir = new File(this.wadlHome);
                    if (!wadlDir.exists() || !wadlDir.isDirectory()) {
                        throw new OjvmWCUException(1, "WADL Home not found", null, null);
                    }
                    File wadltool = new File(this.wadlHome + "/bin/");
                    if (wadltool.exists() && wadltool.isDirectory()) {
                        File[] dirCont = wadltool.listFiles();
                        Boolean foundwadltool = Boolean.FALSE;
                        for (int j = 0; j < dirCont.length; ++j) {
                            if (!dirCont[j].getName().startsWith("wadl2java")) continue;
                            foundwadltool = Boolean.TRUE;
                            break;
                        }
                        if (foundwadltool.booleanValue()) continue;
                        throw new OjvmWCUException(1, "Cannot find wadl2java executable !!!", null, null);
                    }
                    throw new OjvmWCUException(1, "Cannot find wadl2java executable !!!", null, null);
                }
                catch (OjvmWCUException oe) {
                    throw oe;
                }
                catch (Exception e) {
                    throw new OjvmWCUException(2, "Issue with WADL_HOME " + e.getMessage(), null, null);
                }
            }
            if (inpArgs[i].equals("-log")) {
                if (!this.doubleWordOption(inpArgs, i, "Log File").booleanValue()) continue;
                try {
                    File logFile = new File(inpArgs[i + 1] + ".log");
                    FileHandler handler = new FileHandler(logFile.getAbsolutePath());
                    handler.setFormatter(new OjvmWcuFormatter());
                    this.OWCULogger.addHandler(handler);
                    this.OWCULogger.info("Please find log at " + logFile.getAbsolutePath());
                    Handler[] handlers = this.OWCULogger.getHandlers();
                    for (int index = 0; index < handlers.length; ++index) {
                        if (!(handlers[index] instanceof ConsoleHandler)) continue;
                        this.OWCULogger.removeHandler(handlers[index]);
                    }
                }
                catch (Exception e) {
                    throw new OjvmWCUException(2, " Exception with Log file " + e, this, e);
                }
                ++i;
                continue;
            }
            if (inpArgs[i].equals("-b") || inpArgs[i].equals("-catalog") || inpArgs[i].equals("-target")) {
                this.unProcessedjaxWSInputArgs.add(inpArgs[i]);
                this.unProcessedjaxWSInputArgs.add(inpArgs[i + 1]);
                ++i;
                continue;
            }
            if (inpArgs[i].startsWith("-B") || inpArgs[i].startsWith("-httpproxy")) {
                this.unProcessedjaxWSInputArgs.add(inpArgs[i]);
                continue;
            }
            throw new OjvmWCUException(1, inpArgs[i], this, null);
        }
    }

    public final class OjvmWcuFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append("OjvmWCU ").append(record.getLevel().getLocalizedName()).append(": ").append(this.formatMessage(record)).append("\n");
            return sb.toString();
        }
    }
}

