Rem
Rem $Header: javavm/install/install_fips.sql /st_javavm_19.0.0.0.0ojvmru/1 2024/03/02 07:42:15 etucker Exp $
Rem
Rem install_fips.sql
Rem
Rem Copyright (c) 2023, 2024, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      install_fips.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: javavm/install/install_fips.sql
Rem    SQL_SHIPPED_FILE: javavm/install/install_fips.sql
Rem    SQL_PHASE: UTILITY
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    etucker     07/14/23 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql
set echo on
begin
  -- the following permission is required to validate the FIPS jars.
  dbms_java.grant_permission( 'PUBLIC','SYS:java.io.FilePermission', 'jlib/jcmFIPS.jar', 'read' );
end;
/

-- it is not necessary to make the FIPS classes MDL.  They can be installed
-- into any PDB by themselves. If it is desired to have the FIPS classes 
-- be MDL then run this script with rdbms/admin/catcon.pl as SYS.

-- load with -definer
-- set echo on

begin
  dbms_java.loadjava('-v -s -jarsasdbobjects -definer -g public -resolver ((* SYS) (* -)) jlib/cryptojcommon.jar');
exception when others then 
  if sqlcode not in (-29552, -29537, -29532) then 
    raise;
  end if;
end;
/
show errors
-- load without -definer
begin
  dbms_java.loadjava('-s -v -jarsasdbobjects -g public -resolver ((* SYS) (* -)) jlib/cryptojce.jar jlib/jcmFIPS.jar');
exception when others then 
-- This could be dangerous but if there is a severe error then resolution will
-- fail below.
  if sqlcode not in (-29552, -29537, -29532) then 
    raise;
  end if;
end;
/
show errors

-- resolve all the classes.
call dbms_java.loadjava('-v -s -resolveonly -resolver ((* SYS) (* -)) jlib/cryptojce.jar jlib/cryptojcommon.jar jlib/jcmFIPS.jar');
show errors

begin
  dbms_java.loadjava('-v -s -r -jarsasdbobjects -g public jlib/osdt_cert.jar jlib/osdt_core.jar jlib/oraclepki.jar');
exception when others then
  if sqlcode not in (-29552, -29537, -29532) then 
    raise;
  end if;
end;
/

@?/rdbms/admin/sqlsessend.sql
 
