SET SERVEROUTPUT ON

REM Apply script for patch 36878697/25797620
DEFINE logfiledir = &1

COLUMN sqlpatch_logfile NEW_VALUE full_logfile
SELECT '&logfiledir' || '36878697_rollback_' ||
       CASE WHEN (sys_context('userenv', 'cdb_name') IS NULL)
            THEN name
            ELSE name || '_' || replace(sys_context('userenv', 'con_name'), '$')
             END || TO_CHAR(systimestamp, '_YYYYMonDD_HH24_MI_SS', 'NLS_DATE_LANGUAGE=AMERICAN') ||
                    '.log' AS sqlpatch_logfile
  FROM v$database;

SPOOL &full_logfile

SET PAGESIZE 0
SELECT 'Starting rollback for patch 36878697/25797620 on ' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

BEGIN
    dbms_sqlpatch.patch_initialize(p_patch_id      => 36878697,
                                   p_patch_uid     => 25797620,
                                   p_logfile       => '&full_logfile');
END;
/

COLUMN install_file NEW_VALUE sql_script


ALTER SESSION SET CURRENT_SCHEMA = SYS;

SET PAGESIZE 0
SELECT 'Calling javavm/install/jvmpsupdi.sql on ' || SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

PROMPT IGNORABLE ERRORS: NONE

SELECT dbms_sqlpatch.install_file('javavm/install/jvmpsupdi.sql') AS install_file
  FROM dual;
@@&sql_script


ALTER SESSION SET CURRENT_SCHEMA = SYS;


BEGIN dbms_sqlpatch.patch_finalize; END;
/

SET PAGESIZE 0
SELECT 'Finished rollback for patch 36878697/25797620 on' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

SPOOL off
