/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.util.BootstrapHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapParams;
import com.oracle.glcm.patch.auto.db.util.PatchPlatformValidator;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import com.oracle.glcm.patch.auto.session.PatchInfoImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class PatchReaderUtil {
    private static Logger _logger = Logger.getLogger(PatchReaderUtil.class.getName());
    private static ArrayList<String> optionsList = new ArrayList<String>(Arrays.asList("-oh", "-invPtrLoc", "-database", "-jre", "-help", "-h", "-systemsnapshotfilepath", "-phases", "-wallet", "-walletPassword", "-log", "-logLevel", "-parentid", "-port", "-host", "-sid", "-service", "-topology", "-family", "-target_type", "-customLogDir", "-customConfigDir", "-silent", "-drain_timeout"));
    private static ArrayList<String> switchList = new ArrayList<String>(Arrays.asList("-generatesteps", "-norestart", "-nonrolling", "-version", "-shardremote", "-analyze", "-sdb", "-dg", "-rolling", "-inplace", "-outofplace", "-prepare-clone", "-switch-clone", "-sidb", "-force_conflict", "-binary", "-filebusypatching", "-skip_conflict", "-no_relink", "-extreme_perf", "-deleteInactivePatches", "-skip_datapatch", "-post_twostage_enable", "-skip_twostage_enable", "-skip_rrpatch", "-ignorejdkvalidation"));

    public static PatchInfo getPatchInformation(List<String> arguments, BootstrapParams.OperationType operation, String crsVersion) throws OPatchAutoException {
        String patchLoc;
        PatchInfoImpl patchInfo = null;
        ArrayList<String> tmpArguments = new ArrayList<String>(arguments);
        tmpArguments.remove(0);
        ListIterator litr = tmpArguments.listIterator();
        while (litr.hasNext()) {
            String param = (String)litr.next();
            if (optionsList.contains(param)) {
                litr.remove();
                param = (String)litr.next();
                litr.remove();
                continue;
            }
            if (switchList.contains(param)) {
                litr.remove();
                continue;
            }
            if (param.equals("-phBaseDir")) {
                litr.remove();
                if (!litr.hasNext()) continue;
                String patchDir = (String)litr.next();
                patchInfo = new PatchInfoImpl(null, patchDir, null);
                break;
            }
            if (param.equals("-id")) {
                litr.remove();
                if (!litr.hasNext()) continue;
                String patchId = (String)litr.next();
                patchInfo = new PatchInfoImpl(null, null, patchId);
                break;
            }
            String patchLoc2 = (String)tmpArguments.get(0);
            patchInfo = new PatchInfoImpl(patchLoc2, null, null);
            _logger.info("Patch information is :  [Patch Location: " + patchInfo.getPatchLocation() + "]");
            break;
        }
        if (tmpArguments != null && tmpArguments.size() > 0 && null == patchInfo) {
            patchLoc = (String)tmpArguments.get(0);
            patchInfo = new PatchInfoImpl(patchLoc, null, null);
        }
        if (null == patchInfo) {
            patchLoc = System.getenv("PATCH_HOME");
            if (StringUtil.isNullOrEmpty((String)patchLoc)) {
                File directory = new File(".");
                try {
                    patchLoc = directory.getCanonicalPath();
                }
                catch (Exception e) {
                    patchLoc = directory.getAbsolutePath();
                }
            } else if (!new File(patchLoc).exists()) {
                throw new OPatchAutoException(Integer.toString(72084), new Object[0]);
            }
            patchInfo = new PatchInfoImpl(patchLoc, null, null);
        }
        if (PatchReaderUtil.skipPatchInfo(arguments, operation, crsVersion)) {
            patchInfo = new PatchInfoImpl(null, null, "PATCH_INFO_NOT_REQ");
        }
        _logger.info("Patch information is :  [Patch Location: " + patchInfo.getPatchLocation() + ", Patch Base Directory: " + patchInfo.getPatchBaseDirectory() + ", Patch Id: " + patchInfo.getPatchId() + "]");
        if (null != patchInfo) {
            patchInfo = PatchReaderUtil.validatePatchInfo((PatchInfo)patchInfo);
        }
        return patchInfo;
    }

    public static PatchInfo getPatchInfoFromContainerPath(PatchActionExecutorContainer container) throws OPatchAutoException {
        String command = "";
        PatchInfoImpl patchInfo = null;
        if (null != container) {
            command = container.getCommand().name();
            if (command.equals(OPatchAutoCommand.rollback.name())) {
                String patchID = (String)container.getPatchActionParameterValue("id");
                if (container.getPatchActionParameterValue(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue()) != null) {
                    patchID = "PATCH_INFO_NOT_REQ";
                }
                if (!StringUtil.isNullOrEmpty((String)patchID)) {
                    patchInfo = new PatchInfoImpl(null, null, patchID);
                }
            } else if (command.equals(OPatchAutoCommand.apply.name()) && null != container.getPatchActionParameterValue(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue()) && ((Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.OOP_SWITCH_SESSION.getValue())).booleanValue()) {
                patchInfo = new PatchInfoImpl(null, null, "PATCH_INFO_NOT_REQ");
            }
            if (null == patchInfo) {
                String phBaseDir;
                String patchLocation = (String)container.getPatchActionParameterValue("patch.location");
                if (!StringUtil.isNullOrEmpty((String)patchLocation)) {
                    patchInfo = new PatchInfoImpl(patchLocation, null, null);
                }
                if (null == patchInfo && !StringUtil.isNullOrEmpty((String)(phBaseDir = (String)container.getPatchActionParameterValue("patch.base.directory")))) {
                    patchInfo = new PatchInfoImpl(null, phBaseDir, null);
                }
            }
        }
        return patchInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PatchInfo validatePatchInfo(PatchInfo patchInfo) throws OPatchAutoException {
        if (null != patchInfo) {
            String patchInformation;
            String string = patchInformation = !StringUtil.isNullOrEmpty((String)patchInfo.getPatchLocation(), (boolean)true) ? patchInfo.getPatchLocation() : patchInfo.getPatchBaseDirectory();
            if (StringUtil.isNullOrEmpty((String)patchInformation, (boolean)true)) return patchInfo;
            if (new File(patchInformation).exists()) {
                PatchPlatformValidator patchvalidator = new PatchPlatformValidator();
                boolean ispatchvalid = patchvalidator.validatePatch(patchInformation);
                if (ispatchvalid) return patchInfo;
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72059), (Object[])new Object[0]), new Object[0]);
            }
            _logger.info("ERROR: Patch Location not found");
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72080), (Object[])new Object[0]), new Object[0]);
        }
        _logger.info("ERROR: Patch Location not found");
        throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72080), (Object[])new Object[0]), new Object[0]);
    }

    private static boolean skipPatchInfo(List<String> argList, BootstrapParams.OperationType operation, String crsVersion) {
        boolean ifSkipPatchInfo = false;
        if (null != crsVersion) {
            boolean isCrsVersionEqualOrlater = crsVersion.startsWith("12.2") || BootstrapHelper.isVersionEqualOrlater(crsVersion, "12.2.0.2.0");
            _logger.fine("CrsVersion " + crsVersion + " is equal or greater than " + "12.2.0.2.0" + " ? " + isCrsVersionEqualOrlater);
            if (isCrsVersionEqualOrlater && BootstrapParams.OperationType.ROLLBACK.equals((Object)operation) && !argList.contains("-inplace")) {
                ifSkipPatchInfo = true;
            } else if (argList.contains("-switch-clone")) {
                ifSkipPatchInfo = true;
            }
        }
        return ifSkipPatchInfo;
    }
}

