/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import dbmodel.common.Host;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.dbsysmodel.driver.sdk.productdriver.StringResources;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;

public class ClusterInformationLoader {
    private final Logger _logger = Logger.getLogger(ClusterInformationLoader.class.getName());
    private String _crsHome;
    private LocalInfo _localInfo = null;
    private ArrayList<File> crsSftwareInsOnly = new ArrayList();
    private ArrayList<Host> _hostList = new ArrayList();
    private CRSStatus crsStatus = CRSStatus.NONE;
    private CrsType crsType = CrsType.NONE;
    private String crsVersion = null;
    private boolean isInitialized = false;

    private ClusterInformationLoader() {
    }

    public static ClusterInformationLoader getInstance() {
        ClusterInformationLoader crsInfoLoader = Loader._crsInfoLoader;
        crsInfoLoader.loadInventory();
        return crsInfoLoader;
    }

    public static ClusterInformationLoader getInstance(String crsHome) {
        ClusterInformationLoader crsInfoLoader = Loader._crsInfoLoader;
        crsInfoLoader.setCRSHome(crsHome);
        return crsInfoLoader;
    }

    private void loadInventory() {
        this.detectCrsHome();
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.getCRSType();
            this.getCrsVersion(this.isStackRunning());
        }
    }

    private void setCRSHome(String crsHome) {
        this._crsHome = crsHome;
    }

    public String getGridHome() {
        return this._crsHome;
    }

    public ClusterStatus isStackRunningOnRemote(String hostName) {
        this._logger.info("hostName: " + hostName);
        ClusterStatus status = ClusterStatus.CRS_NOT_RUNNING;
        String crsHomePath = this._crsHome;
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSRunning(gridHome.getAbsolutePath(), hostName)) {
                status = ClusterStatus.CRS_RUNNING;
            }
        }
        catch (InstallException e) {
            status = ClusterStatus.CRS_STATUS_UNKNOWN;
        }
        this._logger.info("status: " + status.ordinal());
        return status;
    }

    public static boolean isGridHome(String oracleHomePath) {
        String crsctlCmd = oracleHomePath + File.separator + StringResources.CRSCTL_COMMAND;
        crsctlCmd = ComdevHelper.isWindows() ? crsctlCmd + ".exe" : crsctlCmd + ".bin";
        File crsctl = new File(crsctlCmd);
        return crsctl.exists();
    }

    public boolean isStackRunning() {
        boolean running = false;
        switch (this.crsStatus) {
            case RUNNING: {
                running = true;
                break;
            }
            case NOT_RUNNING: {
                running = false;
                break;
            }
            default: {
                running = this.isCRSRunning();
            }
        }
        this._logger.log(Level.INFO, "running: " + running);
        return running;
    }

    private boolean isCRSRunning() {
        boolean running = false;
        String crsHomePath = this._crsHome;
        CrsType crsType = CrsType.NONE;
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSConfigured(crsHomePath)) {
                crsType = CrsType.CRS;
            } else if (crsInfo.isHAConfigured(crsHomePath)) {
                crsType = CrsType.SIHA;
            } else if (this.crsSftwareInsOnly.size() > 0) {
                crsType = CrsType.SOFTWARE_INSTALLATION_ONLY;
            } else {
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            this._logger.log(Level.INFO, "crsType: " + (Object)((Object)crsType));
            if (crsType == CrsType.CRS) {
                running = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (crsType == CrsType.SIHA) {
                running = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
            this.crsStatus = running ? CRSStatus.RUNNING : CRSStatus.NOT_RUNNING;
        }
        catch (InstallException e) {
            this._logger.log(Level.FINE, e.getMessage());
        }
        return running;
    }

    public CrsType getCRSType() {
        block6: {
            if (this.crsType == CrsType.NONE) {
                File gridHome = new File(this._crsHome);
                ClusterwareInfo crsInfo = new ClusterwareInfo();
                try {
                    if (crsInfo.isCRSConfigured(gridHome.getAbsolutePath())) {
                        this.crsType = CrsType.CRS;
                        break block6;
                    }
                    if (crsInfo.isHAConfigured(gridHome.getAbsolutePath())) {
                        this.crsType = CrsType.SIHA;
                        break block6;
                    }
                    if (this.crsSftwareInsOnly.size() > 0) {
                        this.crsType = CrsType.SOFTWARE_INSTALLATION_ONLY;
                        break block6;
                    }
                    throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
                }
                catch (InstallException e) {
                    this._logger.log(Level.FINE, e.getMessage());
                }
            }
        }
        return this.crsType;
    }

    public boolean isGridEnv() {
        CrsType type = this.getCRSType();
        return type != CrsType.NONE;
    }

    public String getCrsVersion(boolean stackRunning) {
        this._logger.entering(ClusterInformationLoader.class.getName(), "getCrsVersion");
        if (StringUtil.isNullOrEmpty((String)this.crsVersion, (boolean)true)) {
            if (!stackRunning) {
                this._logger.log(Level.FINE, "CRS stack is down. Now getting crs version by OUI.");
                return this.getCrsVersion();
            }
            CrsType crsType = this.getCRSType();
            File ohpath = new File(this._crsHome);
            ClusterwareInfo crsInfo = new ClusterwareInfo();
            try {
                this.crsVersion = crsType != CrsType.CRS ? crsInfo.getSIHAReleaseVersionString(ohpath.getAbsolutePath()) : crsInfo.getCRSActiveVersionString(ohpath.getAbsolutePath());
            }
            catch (NoSuchExecutableException e) {
                throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
            }
            catch (NoSuchCRSHomeException e) {
                throw new ProductDriverException("OracleHome Path given does not exist", e, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            catch (ClusterInfoException e) {
                throw new ProductDriverException(e, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            catch (InstallException e) {
                throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
            }
        }
        return this.crsVersion;
    }

    protected String getCrsVersion() {
        this.createLocalInfo();
        String ver = "";
        for (OracleHome oh : this._localInfo.getOracleHomes()) {
            if (!new File(oh.getPath()).equals(new File(this._crsHome))) continue;
            ver = ((OUIComponent)oh.getTopLevelOUI().get(0)).getVersion();
            break;
        }
        return ver;
    }

    private void createLocalInfo() {
        if (this._localInfo == null) {
            this._localInfo = new LocalInfo();
            this._localInfo.setOracleHomes(OUIDriver.getLocalInfo());
            for (OracleHome oh : this._localInfo.getOracleHomes()) {
                this._logger.config("Found local home at " + oh.getPath());
            }
        }
    }

    protected Host findHostByName(String name) {
        for (Host host : this._hostList) {
            if (!host.getHostName().equals(name)) continue;
            return host;
        }
        throw new ProductDriverException("Unknown host name in config:" + name, ProductDriverException.Type.InvalidConfiguration);
    }

    private String detectCrsHome() {
        if (this._crsHome != null) {
            return this._crsHome;
        }
        try {
            ArrayList<String[]> homes = OUIDriver.getHomesList();
            boolean hasCrs = false;
            Iterator<String[]> iterator = homes.iterator();
            while (iterator.hasNext()) {
                String[] home;
                String[] homeInfo = home = iterator.next();
                String homePath = homeInfo[0];
                if ("IS_CRS_HOME".equals(homeInfo[1])) {
                    this._crsHome = homePath;
                    hasCrs = true;
                    continue;
                }
                File crsctl = new File(homePath + File.separator + "bin" + File.separator + "crsctl.bin");
                if (!crsctl.exists()) continue;
                this.crsSftwareInsOnly.add(new File(homePath));
            }
            if (!hasCrs && this.crsSftwareInsOnly.size() > 0) {
                String crsHomeInOlrFile = this.getCrsHomeFromOlrFile();
                this._crsHome = crsHomeInOlrFile != null && crsHomeInOlrFile.length() != 0 ? crsHomeInOlrFile : this.crsSftwareInsOnly.get(0).getAbsolutePath();
            }
            OUIDriver.endStdInventorySession();
        }
        catch (Exception e1) {
            throw new ProductDriverException("failed to detect Grid Infrastructure setup due to " + e1.getMessage());
        }
        if (this._crsHome == null) {
            throw new ProductDriverException("Cannot detect any valid Grid Infrastructure setup.");
        }
        return this._crsHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCrsHomeFromOlrFile() {
        File olrFile = new File("/etc/oracle/olr.loc");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(olrFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("crs_home")) continue;
                String[] crshomeLine = line.split("=");
                if (crshomeLine == null || crshomeLine.length != 2) continue;
                String string = crshomeLine[1];
                return string;
            }
            reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static class Loader {
        static ClusterInformationLoader _crsInfoLoader = new ClusterInformationLoader();

        private Loader() {
        }
    }

    public static enum ClusterStatus {
        CRS_RUNNING,
        CRS_NOT_RUNNING,
        CRS_STATUS_UNKNOWN;

    }

    public static enum CrsType {
        NONE,
        CRS,
        SIHA,
        SOFTWARE_INSTALLATION_ONLY;

    }

    static enum CRSStatus {
        NONE,
        RUNNING,
        NOT_RUNNING;

    }
}

