/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;

public class ClusterStatusLoader {
    private final Logger _logger = Logger.getLogger(ClusterStatusLoader.class.getName());
    private String _crsHome;
    private ArrayList<File> crsSftwareInsOnly = new ArrayList();
    private CRSStatus crsStatus = CRSStatus.NONE;

    private ClusterStatusLoader() {
    }

    private ClusterStatusLoader(String crsHome) {
        this._crsHome = crsHome;
    }

    public static ClusterStatusLoader getInstance(String crsHome) {
        ClusterStatusLoader crsStatusLoader = Loader._crsStatusLoader;
        crsStatusLoader.setCRSHome(crsHome);
        return crsStatusLoader;
    }

    private void setCRSHome(String crsHome) {
        this._crsHome = crsHome;
    }

    public String getGridHome() {
        return this._crsHome;
    }

    public ClusterStatus isStackRunningOnRemote(String hostName) {
        this._logger.info("hostName: " + hostName);
        ClusterStatus status = ClusterStatus.CRS_NOT_RUNNING;
        String crsHomePath = this._crsHome;
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSRunning(gridHome.getAbsolutePath(), hostName)) {
                status = ClusterStatus.CRS_RUNNING;
            }
        }
        catch (InstallException e) {
            status = ClusterStatus.CRS_STATUS_UNKNOWN;
        }
        this._logger.info("status: " + status.ordinal());
        return status;
    }

    public boolean isStackRunning() {
        boolean running = false;
        switch (this.crsStatus) {
            case RUNNING: {
                running = true;
                break;
            }
            case NOT_RUNNING: {
                running = false;
                break;
            }
            default: {
                running = this.isCRSRunning();
            }
        }
        this._logger.log(Level.INFO, "running: " + running);
        return running;
    }

    private boolean isCRSRunning() {
        boolean running = false;
        String crsHomePath = this._crsHome;
        CrsType crsType = CrsType.NONE;
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSConfigured(crsHomePath)) {
                crsType = CrsType.CRS;
            } else if (crsInfo.isHAConfigured(crsHomePath)) {
                crsType = CrsType.SIHA;
            } else if (this.crsSftwareInsOnly.size() > 0) {
                crsType = CrsType.SOFTWARE_INSTALLATION_ONLY;
            } else {
                throw new ProductDriverException("No valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            this._logger.log(Level.INFO, "crsType: " + (Object)((Object)crsType));
            if (crsType == CrsType.CRS) {
                running = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (crsType == CrsType.SIHA) {
                running = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
            this.crsStatus = running ? CRSStatus.RUNNING : CRSStatus.NOT_RUNNING;
        }
        catch (Exception e) {
            this._logger.log(Level.FINE, e.getMessage());
        }
        return running;
    }

    private static class Loader {
        static ClusterStatusLoader _crsStatusLoader = new ClusterStatusLoader();

        private Loader() {
        }
    }

    public static enum ClusterStatus {
        CRS_RUNNING,
        CRS_NOT_RUNNING,
        CRS_STATUS_UNKNOWN;

    }

    public static enum CrsType {
        NONE,
        CRS,
        SIHA,
        SOFTWARE_INSTALLATION_ONLY;

    }

    static enum CRSStatus {
        NONE,
        RUNNING,
        NOT_RUNNING;

    }
}

