/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver;

import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbsysmodel.driver.sdk.productdriver.HostComparatorCreator;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

public class LocalInfo {
    Host localHost;
    String localHostName;
    List<OracleHome> homes = null;

    public String getLocalHostName() {
        return this.localHostName;
    }

    public void setLocalHostName(String nodeName) {
        this.localHostName = nodeName;
    }

    public Host getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(Host host) {
        this.localHost = host;
        this.localHostName = host.getHostName();
    }

    public List<OracleHome> getOracleHomes() {
        return this.homes;
    }

    public void setOracleHomes(List<OracleHome> homes) {
        this.homes = homes;
    }

    public OracleHome getHome(String path) {
        Iterator<OracleHome> iterator = this.homes.iterator();
        while (iterator.hasNext()) {
            OiipgFileSystem oiiFS = new OiipgFileSystem();
            OracleHome oh = iterator.next();
            if (!oiiFS.areLocsSame(oh.getPath(), path)) continue;
            return oh;
        }
        return null;
    }

    public static LocalInfo getLocalInfoFromSystemInstance(SystemInstance si) {
        LocalInfo localInfo = new LocalInfo();
        localInfo.setOracleHomes(new ArrayList<OracleHome>());
        for (Object b : si.getEntities()) {
            if (!(b instanceof OracleHome)) continue;
            OracleHome oh = (OracleHome)b;
            localInfo.getOracleHomes().add(oh);
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (BaseClass b : si.getEntities()) {
            if (!(b instanceof Host)) continue;
            Host h = (Host)b;
            hosts.add(h);
        }
        if (hosts.size() == 0) {
            return null;
        }
        HostComparatorCreator hostComparatorCreator = HostComparatorCreator.getInstance();
        Collections.sort(hosts, hostComparatorCreator.getHostComparator());
        Host first = (Host)hosts.get(0);
        localInfo.setLocalHostName(first.getHostName());
        localInfo.setLocalHost(first);
        return localInfo;
    }
}

