/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver.remote;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.helper.remote.RemoteCommandListenerObject;
import com.oracle.helper.remote.RemoteExecutionResult;
import com.oracle.helper.remote.RemoteHandlerListener;
import com.oracle.helper.remote.RemoteRequestParam;
import com.oracle.helper.remote.RequestParam;
import com.oracle.helper.remote.ssh.SSHEquivalenceThreadHandler;
import com.oracle.helper.util.HelperUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.HostData;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class HostDataCollector
implements RemoteHandlerListener {
    private Logger logger = Logger.getLogger(HostDataCollector.class.getName());
    private List<String> hostList = new ArrayList<String>();
    private int executionStatus = 0;
    private Map<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
    private Map<String, Throwable> connectionFailureMap = new HashMap<String, Throwable>();
    private Map<String, Throwable> prereqFailureMap = new HashMap<String, Throwable>();
    private String homePath;
    private String action;

    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String homePath = null;
        String giHomePath = null;
        String[] clusterNodes = null;
        String objlocation = null;
        String action = null;
        for (int i = 0; i < argsList.size(); ++i) {
            if (((String)argsList.get(i)).equalsIgnoreCase("-oh")) {
                homePath = (String)argsList.get(++i);
                continue;
            }
            if (((String)argsList.get(i)).equalsIgnoreCase("-GRID_HOME")) {
                giHomePath = (String)argsList.get(++i);
                continue;
            }
            if (((String)argsList.get(i)).equalsIgnoreCase("-CLUSTERNODES")) {
                String clusterNodeStr = (String)argsList.get(++i);
                clusterNodes = clusterNodeStr.split(",");
                continue;
            }
            if (((String)argsList.get(i)).equalsIgnoreCase("-OBJECTLOC")) {
                objlocation = (String)argsList.get(++i);
                continue;
            }
            if (!((String)argsList.get(i)).equalsIgnoreCase("-CRS_ACTION")) continue;
            action = (String)argsList.get(++i);
        }
        HostDataCollector dataCollector = new HostDataCollector();
        HostData hostData = dataCollector.collectHostData(homePath, clusterNodes, giHomePath, action);
        int errorCode = 0;
        try {
            FileUtility.persistDataObj(objlocation, hostData, true);
        }
        catch (IOException e) {
            errorCode = 2;
        }
        if (hostData.getResultID() == 2) {
            errorCode = 7;
        } else if (hostData.getResultID() == 3) {
            errorCode = 8;
        } else if (hostData.getResultID() == 1) {
            errorCode = 5;
        }
        System.exit(errorCode);
    }

    public HostData collectHostData(String homePath, String[] clusterNodes, String giHome, String action) {
        HostData hostData = null;
        if (!StringUtil.isNullOrEmpty((String)action, (boolean)true)) {
            if (action.equals("get_all_homes") || action.equals("check") || action.equals("delete")) {
                hostData = this.performRemoteOperForActions(homePath, clusterNodes, giHome, action);
            } else if (action.equals("crs_status")) {
                hostData = this.collectCRSStatusOnAllNodes(clusterNodes, giHome);
            }
        }
        return hostData;
    }

    private HostData collectCRSStatusOnAllNodes(String[] clusterNodes, String giHome) {
        HostData hostData = new HostData();
        HashMap<String, ClusterInformationLoader.ClusterStatus> remoteNodesStatus = new HashMap<String, ClusterInformationLoader.ClusterStatus>();
        hostData.setLocalCRSStatus(ClusterInformationLoader.getInstance(giHome).isStackRunning());
        if (null != clusterNodes && clusterNodes.length > 0) {
            for (int i = 0; i < clusterNodes.length; ++i) {
                String clusterNode = clusterNodes[i];
                remoteNodesStatus.put(clusterNode, ClusterInformationLoader.getInstance(giHome).isStackRunningOnRemote(clusterNode));
            }
        }
        hostData.setRemoteNodesStatus(remoteNodesStatus);
        return hostData;
    }

    public HostData performRemoteOperForActions(String homePath, String[] clusterNodes, String giHome, String action) {
        this.logger.info("Host List before performing remote operations: " + this.hostList);
        this.logger.info("Initial size of Host List is " + this.hostList.size());
        this.homePath = homePath;
        this.action = action;
        ArrayList<RemoteRequestParam> remoteExecutionParams = new ArrayList<RemoteRequestParam>();
        if (null != clusterNodes) {
            for (int i = 0; i < clusterNodes.length; ++i) {
                String clusterNode = clusterNodes[i];
                this.logger.info("Fetching info from node : " + clusterNode);
                if (clusterNode.equalsIgnoreCase(this.extractHostName(OsysUtility.getHostname()))) continue;
                ArrayList<RequestParam> requestParams = new ArrayList<RequestParam>();
                HashMap<RequestParam.PrereqCode, List<String>> prereqMap = new HashMap<RequestParam.PrereqCode, List<String>>();
                ArrayList<String> prereqCommands = new ArrayList<String>();
                prereqCommands.add(homePath);
                prereqMap.put(RequestParam.PrereqCode.HOME_EXIST_CHECK, prereqCommands);
                requestParams.add(this.generateExecutionParams(this.getRemoteCommand(giHome, action, clusterNodes), this.getSerializedObjLoc(), prereqMap));
                RemoteRequestParam remoteExecutionParam = new RemoteRequestParam(clusterNode, requestParams, false);
                remoteExecutionParams.add(remoteExecutionParam);
            }
        }
        SSHEquivalenceThreadHandler commandHandler = new SSHEquivalenceThreadHandler(remoteExecutionParams, (RemoteHandlerListener)this);
        commandHandler.executeCommand();
        HostData hostData = new HostData();
        hostData.setHomeLoc(homePath);
        hostData.setNodeList(this.hostList);
        hostData.setExceptionMap(this.exceptionMap);
        hostData.setConnectionFailureMap(this.connectionFailureMap);
        hostData.setPrereqFailureMap(this.prereqFailureMap);
        hostData.setResultID(this.executionStatus);
        this.logger.info("Remote node list for home " + homePath + " : " + this.hostList);
        return hostData;
    }

    private String extractHostName(String nodeName) {
        String hostName = nodeName;
        if (nodeName.indexOf(".") != -1) {
            hostName = nodeName.substring(0, nodeName.indexOf("."));
        }
        return hostName;
    }

    private RequestParam generateExecutionParams(String command, String serializedObjLoc, Map<RequestParam.PrereqCode, List<String>> prereqMap) {
        RequestParam requestParam = new RequestParam(command, prereqMap);
        requestParam.setSerializedObjLoc(serializedObjLoc);
        return requestParam;
    }

    private String getRemoteCommand(String giHome, String action, String[] clusterNodes) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(this.homePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        String objLoc = this.getSerializedObjLoc();
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(this.homePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl");
        remoteCommand.append(" -GRID_HOME=").append(giHome);
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        if (!StringUtil.isNullOrEmpty((String)action, (boolean)true)) {
            remoteCommand.append(" -CRS_ACTION=").append(action);
            if (null != clusterNodes && clusterNodes.length > 0) {
                String clusterNodeSet = Arrays.toString(clusterNodes);
                clusterNodeSet = clusterNodeSet.substring(1, clusterNodeSet.length() - 1);
                clusterNodeSet = clusterNodeSet.replaceAll(" ", "");
                clusterNodeSet = clusterNodeSet + "," + this.extractHostName(OsysUtility.getHostname());
                remoteCommand.append(" -CLUSTERNODES=").append(clusterNodeSet);
            }
        }
        remoteCommand.append(" -JVM_HANDLER=oracle/dbsysmodel/driver/sdk/productdriver/remote/RemoteOperationHelper ");
        return remoteCommand.toString();
    }

    private String getSerializedObjLoc() {
        String objLoc = HelperUtility.detectOraBaseHome((String)this.homePath) + ProductDriverConstants.CFGTOOLLOGS_OPATCHAUTODB + File.separator + "hostdata.obj";
        return objLoc;
    }

    public void notifyResult(List<RemoteCommandListenerObject> commandListenerObjects) {
        if (null != commandListenerObjects) {
            this.logger.info("Total listener object size is " + commandListenerObjects.size());
            for (RemoteCommandListenerObject commandListenerObject : commandListenerObjects) {
                if (commandListenerObject.getResultID() == 1) {
                    this.logger.info("Command execution failed for host " + commandListenerObject.getHost() + " due to : " + commandListenerObject.getException());
                    this.exceptionMap.put(commandListenerObject.getHost(), commandListenerObject.getException());
                    this.executionStatus = 1;
                    continue;
                }
                this.logger.info("Consolidating result from host : " + commandListenerObject.getHost());
                this.logger.info("Remote Listener object data: " + commandListenerObject.toString());
                List remoteExecutionResults = commandListenerObject.getRemoteExecutionResults();
                for (RemoteExecutionResult remoteExecutionResult : remoteExecutionResults) {
                    this.logger.info("Remote Execution Result : " + remoteExecutionResult.toString());
                    if (remoteExecutionResult.getResultID() == 2) {
                        this.logger.info("Connection failed for host " + commandListenerObject.getHost() + " due to : " + remoteExecutionResult.getException().getMessage());
                        this.connectionFailureMap.put(commandListenerObject.getHost(), remoteExecutionResult.getException());
                        this.executionStatus = 2;
                        continue;
                    }
                    if (remoteExecutionResult.getResultID() == 1) {
                        this.logger.info("Execution failed for host " + commandListenerObject.getHost() + " due to : " + remoteExecutionResult.getException().getMessage());
                        this.exceptionMap.put(commandListenerObject.getHost(), remoteExecutionResult.getException());
                        this.executionStatus = 1;
                        continue;
                    }
                    if (remoteExecutionResult.getResultID() == 4) {
                        if (remoteExecutionResult.getPrereqFailureMap().containsKey(RemoteExecutionResult.PrereqFailureCode.HOME_DOES_NOT_EXIST)) {
                            this.logger.info("Prereq check failed for host due to " + remoteExecutionResult.getPrereqFailureMap().get(RemoteExecutionResult.PrereqFailureCode.HOME_DOES_NOT_EXIST));
                            continue;
                        }
                        if (!remoteExecutionResult.getPrereqFailureMap().containsKey(RemoteExecutionResult.PrereqFailureCode.OTHER_PREREQ_FAILURE)) continue;
                        this.logger.info("Prereq check failed for host due to " + remoteExecutionResult.getPrereqFailureMap().get(RemoteExecutionResult.PrereqFailureCode.OTHER_PREREQ_FAILURE));
                        this.prereqFailureMap.put(commandListenerObject.getHost(), (Throwable)remoteExecutionResult.getPrereqFailureMap().get(RemoteExecutionResult.PrereqFailureCode.OTHER_PREREQ_FAILURE));
                        this.executionStatus = 3;
                        continue;
                    }
                    this.logger.info("Data retrieved from host " + commandListenerObject.getHost());
                    if (null == remoteExecutionResult.getOutputMsg()) continue;
                    String result = remoteExecutionResult.getOutputMsg();
                    Map<String, String> resultMap = this.parseOutputResult(result);
                    if (StringUtil.isNullOrEmpty((String)this.action, (boolean)true)) continue;
                    if (this.action.equalsIgnoreCase("delete")) {
                        this.updateFileDeletionNodes(resultMap);
                        continue;
                    }
                    if (this.action.equalsIgnoreCase("get_all_homes")) {
                        this.updateHostList(resultMap);
                        continue;
                    }
                    if (!this.action.equalsIgnoreCase("check")) continue;
                    this.updateInitiatedHosts(resultMap);
                }
            }
        }
    }

    private void updateHostList(Map<String, String> resultMap) {
        this.logger.info("Updating the host list");
        boolean homeExists = false;
        String host = resultMap.get("HOST");
        if (!StringUtil.isNullOrEmpty((String)host)) {
            if (StringUtil.isNullOrEmpty((String)(host = OUIDriver.extractHostName(host)), (boolean)true)) {
                this.logger.info("Host name is an empty string");
            }
            List<String> homesList = Arrays.asList(resultMap.get("HOME_LIST").split(","));
            for (String home : homesList) {
                if (!FileUtils.getFile((String)this.homePath).equals(FileUtils.getFile((String)home))) continue;
                homeExists = true;
                break;
            }
            if (homeExists && !this.hostList.contains(host)) {
                this.logger.info("Adding host " + host);
                this.hostList.add(host);
            }
        }
    }

    private void updateInitiatedHosts(Map<String, String> resultMap) {
        String host = resultMap.get("HOST");
        if (null != resultMap.get("INIT_FILE_EXISTS") && resultMap.get("INIT_FILE_EXISTS").equals("true") && !this.hostList.contains(host)) {
            this.hostList.add(host);
        }
    }

    private void updateFileDeletionNodes(Map<String, String> resultMap) {
        String host = resultMap.get("HOST");
        if (null != resultMap.get("INIT_FILE_DELETED") && resultMap.get("INIT_FILE_DELETED").equals("true") && !this.hostList.contains(host)) {
            this.hostList.add(host);
        }
    }

    private Map<String, String> parseOutputResult(String result) {
        this.logger.info("Parsing the result : \n" + result);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String[] lines = result.split(System.lineSeparator());
        for (int i = 0; i < lines.length; ++i) {
            if (StringUtil.isNullOrEmpty((String)lines[i])) continue;
            String[] data = lines[i].split("=");
            resultMap.put(data[0], data[1]);
        }
        return resultMap;
    }
}

