/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.helper.util.WalletHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;

public class OsysUtility {
    private static final String BIN_PATH = File.separator + "bin";
    private static final String BASH_CMD = "bash";
    private static final String USR_BIN_PATH = File.separator + "usr" + File.separator + "bin";
    private static final String SUDO_CMD = "sudo";
    private static final String ROOT = "root";
    private static Logger logger = Logger.getLogger(OsysUtility.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSharedPath(String gridHome, String ohPath, String[] nodes, boolean isStackUp, String walletLoc, char[] walletCharPwd) {
        boolean shared;
        block20: {
            if (nodes.length < 2) {
                return false;
            }
            String checkOhPath = ohPath;
            if (new File(gridHome).equals(new File(ohPath))) {
                checkOhPath = ohPath + File.separator + "crs" + File.separator + "install";
            }
            if (isStackUp && !OsysUtility.isRootAccess()) {
                try {
                    return Cluster.isSharedPath((String)checkOhPath, (String[])nodes);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Can not determine if " + ohPath + " is a shared oracle home with srvm API.");
                }
            }
            shared = false;
            String nodeList = "";
            for (int i = 0; i < nodes.length; ++i) {
                nodeList = nodeList + nodes[i] + (i == nodes.length - 1 ? "" : ",");
            }
            StringBuilder cluvfyCmd = new StringBuilder(gridHome);
            cluvfyCmd.append(File.separator).append("bin");
            cluvfyCmd.append(File.separator).append("cluvfy");
            if (!new File(cluvfyCmd.toString()).exists()) {
                throw new ProductDriverException("Invalid Oracle Home \"" + gridHome + "\". Command \"" + cluvfyCmd.toString() + "\" does not exist.", ProductDriverException.Type.InvalidConfiguration);
            }
            String[] args = new String[]{"comp", "ssa", "-t", "software", "-s", checkOhPath, "-n", nodeList, "-display_status"};
            ArrayList<String> cmdArr = new ArrayList<String>();
            String homeOwner = OUIDriver.checkFileOwner(new File(ohPath, "oraInst.loc"));
            if (homeOwner.equals(ROOT)) {
                throw new ProductDriverException(ohPath + File.separator + "oraInst.loc file shouldn't be owned by root.", ProductDriverException.Type.InvalidConfiguration);
            }
            String password = null;
            if (!StringUtil.isNullOrEmpty((String)walletLoc)) {
                try {
                    Credential credential = WalletHelper.getCredentialForLocalHost((File)new File(walletLoc), (char[])walletCharPwd);
                    password = new String(credential.getPassword());
                }
                catch (OPatchAutoException e1) {
                    throw new ProductDriverException(e1.getMessage(), e1, ProductDriverException.Type.Unknown);
                }
            }
            OsysUtility.createCmdBase(cmdArr, ohPath, gridHome, password, homeOwner, args, cluvfyCmd);
            logger.info("Performing cluvfy shared home check.");
            logger.info("Cluvfy command : " + cmdArr.toString());
            boolean vfailFlag = false;
            boolean overallStatus = false;
            StringBuffer errorMessage = new StringBuffer("Failed: ");
            try {
                OsysUtility.canExecuteJava(ohPath, gridHome, password);
                ProcessBuilder pb = new ProcessBuilder(cmdArr);
                pb = pb.redirectErrorStream(true);
                Process p = pb.start();
                p.waitFor();
                BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String line;
                    while ((line = b.readLine()) != null) {
                        logger.info(line);
                        errorMessage.append(line);
                        errorMessage.append("\n");
                        if (line.contains("EFAIL")) {
                            OsysUtility.updateErrorString(errorMessage, errorReader);
                            throw new Exception("The result of cluvfy command contain EFAIL " + line);
                        }
                        if (line.contains("OVERALL_STATUS")) {
                            overallStatus = true;
                            continue;
                        }
                        if (!line.contains("VFAIL")) continue;
                        vfailFlag = true;
                    }
                    if (overallStatus) {
                        shared = !vfailFlag;
                        break block20;
                    }
                    OsysUtility.updateErrorString(errorMessage, errorReader);
                    throw new Exception("The result of cluvfy command does not contain OVERALL_STATUS String.");
                }
                finally {
                    b.close();
                    errorReader.close();
                }
            }
            catch (Exception e) {
                errorMessage.append(e.getMessage());
                logger.warning(errorMessage.toString());
                throw new ProductDriverException("Unable to determine if \"" + ohPath + "\" is a shared oracle home. \n" + errorMessage.toString(), e, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
        }
        return shared;
    }

    private static String getJavaHome(String gridHome) throws Exception {
        String javaHomeLocation = gridHome + File.separator + "jdk";
        File javaHome = new File(javaHomeLocation);
        if (javaHome.exists() && javaHome.isDirectory()) {
            return javaHomeLocation;
        }
        String CV_JDKHOME = System.getenv("CV_JDKHOME");
        if (CV_JDKHOME == null || CV_JDKHOME.equals("")) {
            throw new Exception("Error while locating JAVA for cluvfy\n Please set CV_JDKHOME to a valid JRE location");
        }
        return CV_JDKHOME;
    }

    private static void createCmdBase(ArrayList<String> cmdArr, String ohPath, String gridHome, String password, String homeOwner, String[] args, StringBuilder cmd) {
        if (OsysUtility.isRootAccess()) {
            cmdArr.add(OsysUtility.getSuCommand());
            cmdArr.add(homeOwner);
            String os = System.getProperty("os.name").toLowerCase();
            if (!os.startsWith("sunos")) {
                cmdArr.add("-m");
            }
            cmdArr.add("-c");
            for (String arg : args) {
                cmd.append(" ").append(arg);
            }
            cmdArr.add(cmd.toString());
        } else {
            String currentUser = System.getProperty("user.name");
            if (!currentUser.equalsIgnoreCase(homeOwner)) {
                OsysUtility.cleanSudoSession();
                cmdArr.add(OsysUtility.which(BASH_CMD));
                cmdArr.add("-c");
                for (String arg : args) {
                    cmd.append(" ").append(arg);
                }
                cmdArr.add("echo '" + new String(password) + "' | " + OsysUtility.getSudoCmd() + " -S -u " + homeOwner + " " + cmd.toString());
            } else {
                cmdArr.add(OsysUtility.which(BASH_CMD));
                cmdArr.add("-c");
                for (String arg : args) {
                    cmd.append(" ").append(arg);
                }
                cmdArr.add(cmd.toString());
            }
        }
    }

    private static void canExecuteJava(String ohPath, String gridHome, String password) throws Exception {
        String homeOwner = OUIDriver.checkFileOwner(new File(ohPath, "oraInst.loc"));
        ArrayList<String> cmdArr = new ArrayList<String>();
        StringBuilder javaHome = new StringBuilder(OsysUtility.getJavaHome(gridHome) + File.separator + "bin" + File.separator + "java -Xmx32m -version");
        OsysUtility.createCmdBase(cmdArr, ohPath, gridHome, password, homeOwner, new String[]{""}, javaHome);
        CommandExecutionResult cmdArrResult = OsysUtility.executeCmd(cmdArr);
        if (!cmdArrResult.isOk()) {
            throw new Exception("Unable to start java process as " + homeOwner + " under current location");
        }
    }

    public static void cleanSudoSession() {
        ArrayList<String> cmds = new ArrayList<String>();
        String bash = OsysUtility.which(BASH_CMD);
        cmds.add(OsysUtility.which(bash));
        cmds.add("-c");
        cmds.add(OsysUtility.getSudoCmd() + " -k");
        OsysUtility.execute(cmds);
    }

    private static void updateErrorString(StringBuffer errMsg, BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            logger.info(line);
            errMsg.append(line);
            errMsg.append("\n");
        }
    }

    private static String execute(ArrayList<String> cmds) {
        StringBuffer buff = new StringBuffer();
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(cmds);
            pb = pb.redirectErrorStream(true);
            Process p = pb.start();
            int rt = p.waitFor();
            if (rt != 0) {
                throw new Exception();
            }
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = b.readLine()) != null) {
                buff.append(line + "\n");
            }
            b.close();
        }
        catch (Exception e) {
            throw new ProductDriverException("Failed to execute system command", e);
        }
        return buff.toString().trim();
    }

    public static String which(String cmd) {
        String cmdPath = "";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("which");
        cmds.add(cmd);
        try {
            cmdPath = OsysUtility.execute(cmds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdPath;
    }

    public static String getSuCommand() {
        String suCmd = OsysUtility.which("su");
        if (suCmd != null && !suCmd.equals("")) {
            return suCmd;
        }
        String os = System.getProperty("os.name").toLowerCase();
        suCmd = os.startsWith("hp") || os.startsWith("aix") || os.startsWith("sunos") ? "/usr/bin/su" : "/bin/su";
        if (!new File(suCmd).exists()) {
            suCmd = "su";
        }
        return suCmd;
    }

    public static String getSudoCmd() {
        String sudo = "";
        if (new File(BIN_PATH + File.separator + SUDO_CMD).exists()) {
            sudo = BIN_PATH + File.separator + SUDO_CMD;
        } else if (new File(USR_BIN_PATH + File.separator + SUDO_CMD).exists()) {
            sudo = USR_BIN_PATH + File.separator + SUDO_CMD;
        } else {
            sudo = OsysUtility.which(SUDO_CMD);
            if (sudo.equals("")) {
                throw new ProductDriverException("Failed to find sudo command");
            }
        }
        return sudo;
    }

    public static String removeTrailingFileSeperator(String path) {
        String modifiedPath = path;
        if (null != path && path.endsWith(File.separator)) {
            modifiedPath = path.substring(0, path.lastIndexOf(File.separator));
        }
        return modifiedPath;
    }

    public static String getHostname() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.info("Failed to query hostname due to " + e.getMessage() + " trying to get through unix command");
            hostName = OsysUtility.getHostNameUsingUnixCommand();
        }
        logger.fine("hostName: " + hostName);
        return hostName;
    }

    private static String getHostNameUsingUnixCommand() {
        String os;
        String hostnameCmd = OsysUtility.which("hostname");
        ArrayList<String> cmds = new ArrayList<String>();
        if ((hostnameCmd == null || hostnameCmd.equals("")) && !new File(hostnameCmd = (os = System.getProperty("os.name").toLowerCase()).startsWith("hp") || os.startsWith("aix") || os.startsWith("sunos") ? "/usr/bin/hostname" : "/bin/hostname").exists()) {
            hostnameCmd = "hostname";
        }
        cmds.add(hostnameCmd);
        String hostname = "";
        try {
            hostname = OsysUtility.execute(cmds);
        }
        catch (Exception e) {
            throw new ProductDriverException("Failed to fetch host name " + e.getMessage(), e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        logger.fine("hostName: " + hostname);
        return hostname;
    }

    public static boolean isRootAccess() {
        if (OUIDriver.isWindows()) {
            return false;
        }
        try {
            int rootCheck = OiixEnvironmentOps.ssgetUidux();
            return rootCheck == 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println(OsysUtility.which("hostname"));
        System.out.println(OsysUtility.which("su"));
        System.out.println(OsysUtility.getHostname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandExecutionResult executeCmd(ArrayList<String> cmds) {
        logger.fine("Command to be executed: " + OsysUtility.replacePwdFrmCmd(cmds.toString()));
        CommandExecutionResult executionResult = new CommandExecutionResult(cmds);
        BufferedReader inputStreamReader = null;
        BufferedReader errorStreamReader = null;
        try {
            String errorLine;
            String line;
            ProcessBuilder pb = new ProcessBuilder(cmds);
            int retValue = 1;
            StringBuffer errorBuff = new StringBuffer();
            StringBuffer inputBuff = new StringBuffer();
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream);
            ReaderThread rinput = new ReaderThread(inputStream);
            rinput.start();
            rerror.start();
            retValue = process.waitFor();
            inputStreamReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = inputStreamReader.readLine()) != null) {
                inputBuff.append(line);
                inputBuff.append("\n");
            }
            errorStreamReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((errorLine = errorStreamReader.readLine()) != null) {
                errorBuff.append(errorLine);
                errorBuff.append("\n");
            }
            executionResult.setReturnCode(retValue);
            String outputMessage = StringUtil.isNullOrEmpty((String)inputBuff.toString(), (boolean)true) ? rinput.getOutputString() : inputBuff.toString();
            String errorMessage = StringUtil.isNullOrEmpty((String)errorBuff.toString(), (boolean)true) ? rerror.getOutputString() : errorBuff.toString();
            executionResult.setOutputMessage(outputMessage);
            executionResult.setErrorMessage(errorMessage);
        }
        catch (Throwable t) {
            executionResult.setErrorMessage(t.getMessage());
            executionResult.setReturnCode(1);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (errorStreamReader != null) {
                    errorStreamReader.close();
                }
            }
            catch (IOException e) {
                executionResult.setErrorMessage(e.getMessage());
                executionResult.setReturnCode(1);
            }
        }
        logger.info("Error message :::  " + executionResult.getErrorMessage());
        logger.info("Output message :::  " + executionResult.getOutputMessage());
        return executionResult;
    }

    private static String replacePwdFrmCmd(String command) {
        if (!StringUtil.isNullOrEmpty((String)command) && command.indexOf("echo ") != -1) {
            int echoIndx = command.indexOf("echo ");
            String firstStr = command.substring(0, echoIndx);
            if (command.contains("sudo -S -u ") && command.indexOf(OsysUtility.getSudoCmd()) != -1) {
                command = "echo '*****' | " + command.substring(command.indexOf(OsysUtility.getSudoCmd()));
                command = firstStr + command;
            }
        }
        return command;
    }

    static class ReaderThread
    extends Thread {
        private InputStreamReader isr;
        private Logger _log = Logger.getLogger(ReaderThread.class.getName());
        private String outputString;

        public ReaderThread(InputStreamReader isr) {
            this.isr = isr;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(this.isr);
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = br.readLine()) != null) {
                    this._log.info(line);
                    buffer.append(line);
                    buffer.append("\n");
                }
                this.outputString = buffer.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getOutputString() {
            return this.outputString;
        }
    }

    public static class CommandExecutionResult {
        List<String> commands;
        String errorMessage;
        String outputMessage;
        int retCode;
        boolean ok;

        public CommandExecutionResult(List<String> cmds) {
            this.commands = cmds;
            this.errorMessage = "";
            this.outputMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getOutputMessage() {
            return this.outputMessage;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setOutputMessage(String outputMessage) {
            this.outputMessage = outputMessage;
        }

        protected void setReturnCode(int ret) {
            this.retCode = ret;
            this.ok = this.retCode == 0;
        }

        public int getReturnCode() {
            return this.retCode;
        }
    }
}

