/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.RacSrvm;
import oracle.opatch.RemoteShellRunCommand;
import oracle.opatch.Rules;
import oracle.opatch.StringResource;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.RemoveListedFilesException;

public class RacSrvmImpl
extends RacSrvm {
    static boolean propagateListedFilesInstantiated = false;
    static boolean propagateListedDirInstantiated = false;
    static boolean removeListedFilesInstantiated = false;
    static boolean removeListedDirInstantiated = false;
    private ClusterCmd clusterCmd = null;
    private ClusterWindows clusterCmdWindows = null;

    public RacSrvmImpl() {
        if (OPatchEnv.isWindows()) {
            try {
                this.clusterCmdWindows = new ClusterWindows();
            }
            catch (ClusterException e) {
                OLogger.printStackTrace((Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.clusterCmd = new ClusterCmd();
        }
    }

    private boolean convertLiteralOracleHome(String oracleHomePath, String src, String dst) throws IOException {
        StringBuffer buff = new StringBuffer("RacSrvm::convertLiteralOracleHome()");
        OLogger.debug((StringBuffer)buff);
        if (src == null || dst == null) {
            throw new IOException("RacSRVM::convertLiteralOracleHome(): Null src and/or dst files during conversion");
        }
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists()) {
            buff = new StringBuffer("RacSRVM::convertLiteralOracleHome(): src file \"");
            buff.append(src);
            buff.append("\" does not exist.");
            throw new IOException(buff.toString());
        }
        if (!dstFile.exists()) {
            RacFileCreator.createZeroByteFile((String)dst);
        }
        String srcPath = srcFile.getCanonicalPath();
        String dstPath = dstFile.getCanonicalPath();
        boolean sameFile = srcPath.equals(dstPath);
        boolean needConversion = false;
        FileReader fr = new FileReader(src);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> srcContent = new ArrayList<String>();
        String literalOH = StringResource.getLiteralOracleHome();
        buff = new StringBuffer(" Looking for \"");
        buff.append(literalOH);
        buff.append("\"");
        OLogger.debug((StringBuffer)buff);
        String entry = null;
        int len = literalOH.length();
        while ((entry = br.readLine()) != null) {
            int index = entry.indexOf(literalOH);
            if (index == 0) {
                needConversion = true;
                buff = new StringBuffer(" This line needs conversion: \"");
                buff.append(entry);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
                StringBuffer cStr = new StringBuffer(oracleHomePath);
                cStr.append(entry.substring(len));
                String convertedLine = cStr.toString();
                buff = new StringBuffer(" --> \"");
                buff.append(convertedLine);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
                srcContent.add(convertedLine);
                continue;
            }
            if (index > 0) {
                needConversion = true;
                buff = new StringBuffer(" This line needs conversion: \"");
                buff.append(entry);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
                StringTokenizer tk = new StringTokenizer(entry, " ");
                StringBuffer cStr = new StringBuffer();
                int nOccur = 0;
                while (tk.hasMoreTokens()) {
                    String token;
                    String replaced = token = tk.nextToken();
                    buff = new StringBuffer("     scanning token \"");
                    buff.append(token);
                    buff.append("\" and compare against \"");
                    buff.append(literalOH);
                    buff.append("\"");
                    OLogger.debug((StringBuffer)buff);
                    int subIndex = token.indexOf(literalOH);
                    if (subIndex == 0 && nOccur == 0) {
                        buff = new StringBuffer("    replace \"");
                        buff.append(literalOH);
                        buff.append("\" by \"");
                        buff.append(oracleHomePath);
                        buff.append("\"");
                        OLogger.debug((StringBuffer)buff);
                        replaced = oracleHomePath + token.substring(len);
                        ++nOccur;
                    } else if (subIndex > 0 && nOccur == 1) {
                        replaced = "ORACLE_HOME=" + oracleHomePath;
                        ++nOccur;
                    }
                    cStr.append(replaced);
                    cStr.append(" ");
                }
                String convertedLine = cStr.toString();
                buff = new StringBuffer(" --> \"");
                buff.append(convertedLine);
                buff.append("\"");
                OLogger.debug((StringBuffer)buff);
                srcContent.add(convertedLine);
                continue;
            }
            buff = new StringBuffer(" Cache this line: \"");
            buff.append(entry);
            buff.append("\"");
            OLogger.debug((StringBuffer)buff);
            srcContent.add(entry);
        }
        br.close();
        fr.close();
        if (needConversion) {
            OLogger.println((String)("Instantiating the file \"" + dst + "\" by replacing " + StringResource.getLiteralOracleHome() + " in \"" + src + "\" with actual path."));
        }
        boolean ok = true;
        if (sameFile) {
            buff = new StringBuffer(" deleting identical source file \"");
            buff.append(srcFile);
            buff.append("\"");
            OLogger.debug((StringBuffer)buff);
            ok = srcFile.delete();
            if (!ok || srcFile.exists()) {
                buff = new StringBuffer("RacSRVM::convertLiteralOracleHome(): failed to delete identical file \"");
                buff.append(srcFile.getCanonicalPath());
                buff.append("\"");
                throw new IOException(buff.toString());
            }
        }
        buff = new StringBuffer("RacSRVM::convertLiteralOracleHome(): creating new file \"");
        buff.append(dstPath);
        buff.append("\"");
        OLogger.debug((StringBuffer)buff);
        File finalFile = new File(dstPath);
        if (finalFile.exists()) {
            ok = finalFile.delete();
        }
        RacFileCreator.createZeroByteFile((String)dstPath);
        if (!finalFile.exists()) {
            buff = new StringBuffer("RacSRVM::convertLiteralOracleHome(): failed to create final file \"");
            buff.append(srcFile.getCanonicalPath());
            buff.append("\"");
            throw new IOException(buff.toString());
        }
        buff = new StringBuffer("  opening file \"");
        buff.append(dstPath);
        buff.append("\" to write.");
        OLogger.debug((StringBuffer)buff);
        FileWriter fw = new FileWriter(finalFile);
        BufferedWriter bw = new BufferedWriter(fw);
        for (int i = 0; i < srcContent.size(); ++i) {
            String line = (String)srcContent.get(i);
            bw.write(line);
            bw.write("\n");
            bw.flush();
            buff = new StringBuffer("     write back entry \"");
            buff.append(line);
            buff.append("\"");
            OLogger.debug((StringBuffer)buff);
        }
        bw.close();
        fw.close();
        return needConversion;
    }

    public void propagateListedFilesToNodes(String oracleHomePath, String[] nodes, String listedFilesHolder, String finalFile) throws RuntimeException {
        block10: {
            StringBuffer buff = new StringBuffer("RacSrvm::propagateListedFilesToNodes()");
            OLogger.debug((StringBuffer)buff);
            if (oracleHomePath == null || listedFilesHolder == null || finalFile == null) {
                throw new RuntimeException("propagateListedFilesToNodes(): Either oracleHomePath, listed file or final file is NULL");
            }
            try {
                OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in propagateListedFilesToNodes", (Object[])nodes);
            }
            catch (NullPointerException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] != null) continue;
                buff = new StringBuffer("Null or blank node at index ");
                buff.append(i);
                throw new RuntimeException(buff.toString());
            }
            try {
                String src = listedFilesHolder;
                String dst = finalFile;
                if (!propagateListedFilesInstantiated) {
                    this.convertLiteralOracleHome(oracleHomePath, src, dst);
                    propagateListedFilesInstantiated = true;
                }
                String baseDir = oracleHomePath;
                String nodesString = RacProcessor.getNodesString((String[])nodes);
                buff = new StringBuffer("Propagating files listed in file \"");
                buff.append(dst);
                buff.append("\" to remote nodes ");
                buff.append(nodesString);
                OLogger.verbose(null, (StringBuffer)buff);
                buff = new StringBuffer("Calling ClusterCmd.transferListedFilesToNodes(nodes, baseDir, finalFile) on ");
                buff.append(nodesString);
                buff.append(" with baseDir=\"");
                buff.append(baseDir);
                buff.append("\", finalFile=\"");
                buff.append(finalFile);
                buff.append("\".");
                OLogger.debug((StringBuffer)buff);
                File file = new File(finalFile);
                if (file.exists()) {
                    if (file.length() <= 0L) {
                        OLogger.verbose(null, (StringBuffer)new StringBuffer("No files to be propagated to remote nodes..."));
                    } else {
                        OLogger.println((String)"Propagating files to remote nodes...");
                        this.clusterCmd.transferListedFilesToNodes(nodes, baseDir, finalFile);
                    }
                    break block10;
                }
                throw new RuntimeException("Cannot propagate listed files: file-holder doesn't exist");
            }
            catch (IOException | ClusterException | RemoteFileOperationException e) {
                OLogger.printStackTrace((Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void transferFileFromNode(String nodeName, String srcFile, String destFile) throws RuntimeException {
        StringBuffer buff = new StringBuffer("RacSrvm:transferFileFromNode()");
        OLogger.debug((StringBuffer)buff);
        try {
            OLogger.justlog((int)OLogger.INFO, (String)"Copy file from node...");
            this.clusterCmd.copyFileFromNode(nodeName, srcFile, destFile);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isFileExistsOnNode(String nodeName, String fileName) throws RuntimeException {
        StringBuffer buff = new StringBuffer("RacSrvm:isFileExistsOnNode()");
        OLogger.debug((StringBuffer)buff);
        try {
            return this.clusterCmd.fileExists(nodeName, fileName);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void propagateListedDirsToNodes(String oracleHomePath, String[] nodes, String listedDirHolder, String finalFile) throws RuntimeException {
        block10: {
            StringBuffer buff = new StringBuffer("RacSrvm::propagateListedDirsToNodes()");
            OLogger.debug((StringBuffer)buff);
            if (oracleHomePath == null || listedDirHolder == null || finalFile == null) {
                throw new RuntimeException("propagateListedDirsToNodes(): Either oracleHomePath, listed file or final file is NULL");
            }
            try {
                OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in propagateListedDirsToNodes", (Object[])nodes);
            }
            catch (NullPointerException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] != null) continue;
                buff = new StringBuffer("Null or blank node at index ");
                buff.append(i);
                throw new RuntimeException(buff.toString());
            }
            try {
                String src = listedDirHolder;
                String dst = finalFile;
                if (!propagateListedDirInstantiated) {
                    this.convertLiteralOracleHome(oracleHomePath, src, dst);
                    propagateListedDirInstantiated = true;
                }
                String baseDir = oracleHomePath;
                String nodesString = RacProcessor.getNodesString((String[])nodes);
                buff = new StringBuffer("Recursively propagating directories listed in file \"");
                buff.append(dst);
                buff.append("\" to remote nodes ");
                buff.append(nodesString);
                OLogger.verbose(null, (StringBuffer)buff);
                buff = new StringBuffer("Calling clusterCmd.transferListedDirsToNodes(nodes, baseDir, finalFile, excludedFiles); on ");
                buff.append(nodesString);
                buff.append(" with baseDir=\"");
                buff.append(baseDir);
                buff.append("\", finalFile=\"");
                buff.append(finalFile);
                buff.append("\".");
                OLogger.debug((StringBuffer)buff);
                File file = new File(finalFile);
                if (file.exists()) {
                    String excludedFiles = null;
                    if (file.length() <= 0L) {
                        OLogger.verbose(null, (StringBuffer)new StringBuffer("No directories to be propagated to remote nodes..."));
                    } else {
                        OLogger.println((String)"Propagating directories to remote nodes...");
                        this.clusterCmd.transferListedDirsToNodes(nodes, baseDir, finalFile, excludedFiles);
                    }
                    break block10;
                }
                throw new RuntimeException("Cannot propagate listed files: file-holder doesn't exist");
            }
            catch (IOException | ClusterException | RemoteFileOperationException e) {
                OLogger.printStackTrace((Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void removeListedFilesOnNodes(String oracleHomePath, String[] nodes, String listedFilesHolder, String finalFile) throws RuntimeException {
        block12: {
            StringBuffer buff = new StringBuffer("RacSrvm::removeListedFilesOnNodes()");
            OLogger.debug((StringBuffer)buff);
            if (oracleHomePath == null || listedFilesHolder == null || finalFile == null) {
                throw new RuntimeException("removeListedFilesOnNodes(): Either oracleHomePath, listed file or final file is NULL");
            }
            try {
                OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in removeListedFilesOnNodes", (Object[])nodes);
            }
            catch (NullPointerException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] != null) continue;
                buff = new StringBuffer("Null or blank node at index ");
                buff.append(i);
                throw new RuntimeException(buff.toString());
            }
            try {
                String src = listedFilesHolder;
                String dst = finalFile;
                if (!removeListedFilesInstantiated) {
                    this.convertLiteralOracleHome(oracleHomePath, src, dst);
                    removeListedFilesInstantiated = true;
                }
                String baseDir = oracleHomePath;
                String nodesString = RacProcessor.getNodesString((String[])nodes);
                buff = new StringBuffer("Removing files listed in file \"");
                buff.append(dst);
                buff.append("\" on remote nodes ");
                buff.append(nodesString);
                OLogger.verbose(null, (StringBuffer)buff);
                buff = new StringBuffer("Calling removeListedFilesFromNodes(nodes, finalFile); on ");
                buff.append(nodesString);
                buff.append(" with baseDir=\"");
                buff.append(baseDir);
                buff.append("\", finalFile=\"");
                buff.append(finalFile);
                buff.append("\".");
                OLogger.debug((StringBuffer)buff);
                File file = new File(finalFile);
                if (file.exists()) {
                    Object excludedFiles = null;
                    if (file.length() <= 0L) {
                        OLogger.verbose(null, (StringBuffer)new StringBuffer("No files to be removed on remote nodes..."));
                    } else {
                        OLogger.println((String)"Removing files on remote nodes...");
                        for (String node : nodes) {
                            this.clusterCmd.removeListedFilesFromNode(node, finalFile);
                        }
                    }
                    break block12;
                }
                throw new RuntimeException("Cannot propagate listed files: file-holder doesn't exist");
            }
            catch (IOException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            catch (ClusterException | RemoveListedFilesException e) {
                OLogger.printStackTrace((Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void removeListedDirsOnNodes(String oracleHomePath, String[] nodes, String listedFilesHolder, String finalFile) throws IOException {
        block10: {
            StringBuffer buff = new StringBuffer("RacSrvm::removeListedDirsOnNodes()");
            OLogger.debug((StringBuffer)buff);
            if (oracleHomePath == null || listedFilesHolder == null || finalFile == null) {
                throw new RuntimeException("removeListedDirsOnNodes(): Either oracleHomePath, listed file or final file is NULL");
            }
            try {
                OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in removeListedDirsOnNodes", (Object[])nodes);
            }
            catch (NullPointerException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] != null) continue;
                buff = new StringBuffer("Null or blank node at index ");
                buff.append(i);
                throw new RuntimeException(buff.toString());
            }
            try {
                String src = listedFilesHolder;
                String dst = finalFile;
                if (!removeListedDirInstantiated) {
                    this.convertLiteralOracleHome(oracleHomePath, src, dst);
                    removeListedDirInstantiated = true;
                }
                String baseDir = oracleHomePath;
                String nodesString = RacProcessor.getNodesString((String[])nodes);
                buff = new StringBuffer("Removing directories listed in file \"");
                buff.append(dst);
                buff.append("\" on remote nodes ");
                buff.append(nodesString);
                OLogger.verbose(null, (StringBuffer)buff);
                buff = new StringBuffer("Calling clusterCmd.removeListedDirsFromNodes(nodes, finalFile); on ");
                buff.append(nodesString);
                buff.append(" with baseDir=\"");
                buff.append(baseDir);
                buff.append("\", finalFile=\"");
                buff.append(finalFile);
                buff.append("\".");
                OLogger.debug((StringBuffer)buff);
                File file = new File(finalFile);
                if (file.exists()) {
                    Object excludedFiles = null;
                    if (file.length() <= 0L) {
                        OLogger.println((String)"No directories to be removed on remote nodes...");
                    } else {
                        OLogger.println((String)"Removing directories on remote nodes ...");
                        this.clusterCmd.removeListedDirsFromNodes(nodes, finalFile);
                    }
                    break block10;
                }
                throw new RuntimeException("Cannot propagate listed files: file-holder doesn't exist");
            }
            catch (IOException | ClusterException | RemoteFileOperationException e) {
                OLogger.printStackTrace((Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private boolean searchExceptionForErrorTag(String eachCmd, String msg) {
        StringBuffer buff = new StringBuffer("searchExceptionForErrorTag()");
        OLogger.debug((StringBuffer)buff);
        if (eachCmd == null) {
            buff = new StringBuffer("  Null command given, return true");
            OLogger.debug((StringBuffer)buff);
            return true;
        }
        if (msg == null) {
            buff = new StringBuffer("  Null message given, return true");
            OLogger.debug((StringBuffer)buff);
            return true;
        }
        buff = new StringBuffer("  Searching message \"");
        buff.append(msg);
        buff.append("\" for tag \"");
        buff.append("REMOTE_MAKE_FAILED::");
        buff.append("\"");
        OLogger.debug((StringBuffer)buff);
        int index = msg.indexOf("REMOTE_MAKE_FAILED::");
        if (index != -1) {
            buff = new StringBuffer("  Found the tag at the last position of ");
            buff.append(index);
            buff.append(", return true");
            OLogger.debug((StringBuffer)buff);
            return true;
        }
        buff = new StringBuffer("  Tag not found, return false");
        return false;
    }

    public void runMakeCmdOnNodes(String oracleHomePath, String[] nodes, String listedFilesHolder, String desiredServiceName, String finalFile) throws IOException, RuntimeException {
        block17: {
            StringBuffer buff = new StringBuffer("RacSrvm::runMakeCmdOnNodes()");
            OLogger.debug((StringBuffer)buff);
            if (oracleHomePath == null || listedFilesHolder == null || finalFile == null || desiredServiceName == null) {
                throw new RuntimeException("runMakeCmdOnNodes(): Either oracleHomePath, listed file, desiredServiceName or final file is NULL");
            }
            try {
                OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in runMakeCmdOnNodes", (Object[])nodes);
            }
            catch (NullPointerException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] != null) continue;
                buff = new StringBuffer("Null or blank node at index ");
                buff.append(i);
                throw new RuntimeException(buff.toString());
            }
            String nodesString = RacProcessor.getNodesString((String[])nodes);
            buff = new StringBuffer(" Run each command on each of the following nodes: ");
            buff.append(nodesString);
            OLogger.debug((StringBuffer)buff);
            String src = listedFilesHolder;
            String dst = finalFile;
            this.convertLiteralOracleHome(oracleHomePath, src, dst);
            File fFinal = new File(finalFile);
            ArrayList<FailedCommand> failList = new ArrayList<FailedCommand>();
            if (fFinal.exists()) {
                boolean makeError;
                buff = new StringBuffer("Invoking commands listed in file \"");
                buff.append(dst);
                buff.append("\" on remote nodes ");
                buff.append(nodesString);
                OLogger.verbose(null, (StringBuffer)buff);
                boolean noMakeError = true;
                boolean reportError = false;
                for (int i = 0; i < nodes.length && noMakeError; ++i) {
                    String node = nodes[i];
                    String[] nodeSet = new String[]{node};
                    FileReader fr = new FileReader(fFinal);
                    BufferedReader br = new BufferedReader(fr);
                    String eachCmd = null;
                    int line = 0;
                    while ((eachCmd = br.readLine()) != null && noMakeError) {
                        ++line;
                        buff = new StringBuffer("Calling  runAnyCmdOnNodes(eachCmd, nodes, desiredServiceName); \"");
                        buff.append(eachCmd);
                        buff.append("\" on node ");
                        buff.append(node);
                        OLogger.debug((StringBuffer)buff);
                        if (eachCmd == null || eachCmd.equals("")) continue;
                        if (Rules.shouldRunMake()) {
                            try {
                                StringBuffer msg = new StringBuffer("Running command on remote node '");
                                msg.append(node);
                                msg.append("': \n");
                                msg.append(eachCmd);
                                msg.append("\n");
                                OLogger.println((String)msg.toString());
                                this.runAnyCmdOnNodes(eachCmd, nodeSet, desiredServiceName);
                            }
                            catch (Exception e) {
                                makeError = true;
                                String stdErrMsg = "Error unavailable";
                                if (e != null) {
                                    Throwable t = e.getCause();
                                    String string = stdErrMsg = t != null ? t.getMessage() : e.getMessage();
                                    if (t != null) {
                                        makeError = this.searchExceptionForErrorTag(eachCmd, stdErrMsg);
                                    }
                                }
                                FailedCommand fc = new FailedCommand(node, eachCmd, makeError, finalFile, stdErrMsg, line);
                                String detail = stdErrMsg;
                                if (makeError) {
                                    StringBuffer question;
                                    boolean proceed;
                                    OLogger.warn((String)"OUI-67186", (Object[])new Object[]{eachCmd, node, finalFile, detail, new Integer(line)});
                                    failList.add(fc);
                                    if (!Rules.shouldPauseOnErrorOnNodes((String[])nodes) || (proceed = OPatchEnv.proceedWithOperationDefaultYes((StringBuffer)(question = new StringBuffer(OLogger.getString((String)"OUI-67195", (Object[])new Object[]{node})))))) continue;
                                    noMakeError = false;
                                    reportError = true;
                                    continue;
                                }
                                OLogger.warn((String)"OUI-67212", (Object[])new Object[]{eachCmd, node, finalFile, detail, new Integer(line)});
                            }
                            continue;
                        }
                        buff.append(" -- skipped");
                        OLogger.println((String)buff.toString());
                    }
                    br.close();
                    fr.close();
                }
                for (int f = 0; f < failList.size(); ++f) {
                    Object obj = failList.get(f);
                    if (!(obj instanceof FailedCommand)) continue;
                    FailedCommand fc = (FailedCommand)obj;
                    String eachFailCmd = fc.getCommand();
                    String commandFile = fc.getCommandFile();
                    String cause = fc.getCause();
                    int eachLine = fc.getLineNumber();
                    String node = fc.getNode();
                    makeError = fc.isError();
                    if (!makeError) continue;
                }
                if (reportError) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(213);
                    String msg = OLogger.getString((String)"OUI-67195", (Object[])new Object[]{nodesString});
                    RuntimeException e = new RuntimeException(msg);
                    throw e;
                }
                break block17;
            }
            throw new RuntimeException("Cannot run listed commands: file-holder doesn't exist");
        }
    }

    private void runPatchgenCmdOnNodes(String oracleHomePath, String eachCmd, String patchgenCmd, String[] nodes) {
        StringBuffer buff = new StringBuffer("RacSrvm::runPatchgenCmdOnNodes() called");
        OLogger.debug((StringBuffer)buff);
        if (oracleHomePath == null || eachCmd == null || patchgenCmd == null) {
            throw new RuntimeException("runPatchgenCmdOnNodes(): Either oracleHomePath eachCmd or patchgenCmd is NULL");
        }
        try {
            OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in runPatchgenCmdOnNodes", (Object[])nodes);
        }
        catch (NullPointerException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        StringBuffer env = new StringBuffer("ORACLE_HOME");
        env.append("=");
        env.append(oracleHomePath);
        String extractStr = eachCmd.substring(patchgenCmd.length());
        String[] cmdArgs = extractStr.trim().split("\\s");
        buff = new StringBuffer("Extract remain args string from given patchgen command as ");
        buff.append(extractStr);
        buff.append("\n");
        buff.append("Args are : ");
        for (int i = 0; i < cmdArgs.length; ++i) {
            buff.append(cmdArgs[i] + " ");
        }
        buff.append("\n");
        OLogger.debug((StringBuffer)buff);
        try {
            OLogger.justlog((int)OLogger.INFO, (String)"Run command on remote nodes");
            this.clusterCmd.runCmd(patchgenCmd, cmdArgs, new String[]{env.toString()}, nodes);
        }
        catch (ClusterException ce) {
            OLogger.printStackTrace((Throwable)ce);
            String sNodeList = this.implodeList(nodes, ",");
            throw new RuntimeException(OLogger.getString((String)"OUI-67658", (Object[])new Object[]{patchgenCmd, sNodeList, ce.getMessage()}), ce);
        }
    }

    private String implodeList(String[] nodes, String delim) {
        String result;
        String string = result = nodes != null ? "" : null;
        if (nodes != null && nodes.length > 0) {
            StringBuffer oneString = new StringBuffer();
            if (delim == null) {
                delim = "";
            }
            for (String node : nodes) {
                if (node == null) continue;
                oneString.append(node);
                oneString.append(delim);
            }
            result = oneString.toString();
        }
        return result;
    }

    private void runCmdOnUnix(String clsCmd, String[] nodeList) {
        try {
            this.clusterCmd.runCmd(clsCmd, (String[])null, (String[])null, nodeList);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private void deleteServiceOnNodes_Windows(String serviceName, String[] nodeList) {
        try {
            this.clusterCmdWindows.deleteServiceOnNodes(serviceName, nodeList);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void createServiceOnNodes_Windows(String exeName, String serviceName, int serviceType, String[] nodeList) {
        try {
            this.clusterCmdWindows.createServiceOnNodes(serviceName, exeName, serviceType, nodeList);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private void startServiceOnNodes_Windows(String serviceName, String[] nodeList) {
        try {
            this.clusterCmdWindows.startServiceOnNodes(serviceName, nodeList);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private void stopServiceOnNodes_Windows(String serviceName, String[] nodeList) {
        try {
            this.clusterCmdWindows.startServiceOnNodes(serviceName, nodeList);
        }
        catch (ClusterException e) {
            OLogger.printStackTrace((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private void runCmdOnWindows(String clsCmd, String[] nodeList, String serviceName) {
        String sNodeList = this.implodeList(nodeList, ",");
        String[] args = new String[]{serviceName, sNodeList};
        OLogger.justlog((int)OLogger.INFO, (String)("deleteServiceOnNodes_Windows, service: " + serviceName + " nodes: " + sNodeList));
        this.deleteServiceOnNodes_Windows(serviceName, nodeList);
        OLogger.justlog((int)OLogger.INFO, (String)("createServiceOnNodes_Windows, service: " + serviceName + " nodes: " + sNodeList));
        this.createServiceOnNodes_Windows(clsCmd, serviceName, 2, nodeList);
        OLogger.justlog((int)OLogger.INFO, (String)("startServiceOnNodes_Windows, service: " + serviceName + " nodes: " + sNodeList));
        this.startServiceOnNodes_Windows(serviceName, nodeList);
        OLogger.justlog((int)OLogger.INFO, (String)("stopServiceOnNodes_Windows, service: " + serviceName + " nodes: " + sNodeList));
        this.stopServiceOnNodes_Windows(serviceName, nodeList);
        OLogger.justlog((int)OLogger.INFO, (String)("deleteServiceOnNodes_Windows, service: " + serviceName + " nodes: " + sNodeList));
        this.deleteServiceOnNodes_Windows(serviceName, nodeList);
    }

    public void runAnyCmdOnNodes(String clsCmd, String[] nodeList, String desiredServiceName) {
        if (nodeList != null && nodeList.length > 0 && clsCmd != null) {
            String sMsg = this.implodeList(nodeList, ",");
            OLogger.justlog((int)OLogger.INFO, (String)("Remote command: " + clsCmd));
            OLogger.justlog((int)OLogger.INFO, (String)("Remote command args: " + sMsg));
            if (!OPatchEnv.isWindows()) {
                this.runCmdOnUnix(clsCmd, nodeList);
            } else {
                if (desiredServiceName == null) {
                    throw new RuntimeException("Remote command on windows env has null desiredServiceName");
                }
                this.runCmdOnWindows(clsCmd, nodeList, desiredServiceName);
            }
        } else {
            String mesg = "Nodelist or command on remote node is not valid (null or empty";
            OLogger.justlog((int)OLogger.SEVERE, (String)mesg);
            throw new RuntimeException(mesg);
        }
    }

    public void runAnyCmdOnNodes(String oracleHomePath, String[] nodes, String listedFilesHolder, String desiredServiceName, String finalFile) throws IOException, RuntimeException {
        block19: {
            StringBuffer buff = new StringBuffer("RacSrvm::runAnyCmdOnNodes()");
            OLogger.debug((StringBuffer)buff);
            if (oracleHomePath == null || listedFilesHolder == null || finalFile == null || desiredServiceName == null) {
                throw new RuntimeException("runAnyCmdOnNodes(): Either oracleHomePath, listed file, desiredServiceName or final file is NULL");
            }
            try {
                OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in runAnyCmdOnNodes", (Object[])nodes);
            }
            catch (NullPointerException e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] != null) continue;
                buff = new StringBuffer("Null or blank node at index ");
                buff.append(i);
                throw new RuntimeException(buff.toString());
            }
            String nodesString = RacProcessor.getNodesString((String[])nodes);
            buff = new StringBuffer(" Run each command on each of the following nodes: ");
            buff.append(nodesString);
            OLogger.debug((StringBuffer)buff);
            String src = listedFilesHolder;
            String dst = finalFile;
            this.convertLiteralOracleHome(oracleHomePath, src, dst);
            File fFinal = new File(finalFile);
            ArrayList<FailedCommand> failList = new ArrayList<FailedCommand>();
            if (fFinal.exists()) {
                boolean cmdError;
                buff = new StringBuffer("Invoking commands listed in file \"");
                buff.append(dst);
                buff.append("\" on remote nodes ");
                buff.append(nodesString);
                OLogger.verbose(null, (StringBuffer)buff);
                boolean noCmdError = true;
                boolean reportError = false;
                String patchgenCmd = "";
                OPatchProperty opp = new OPatchProperty();
                try {
                    patchgenCmd = opp.getPatchgenCommand();
                }
                catch (NoSuchMethodException e) {
                    patchgenCmd = "";
                }
                for (int i = 0; i < nodes.length && noCmdError; ++i) {
                    String node = nodes[i];
                    String[] nodeSet = new String[]{node};
                    FileReader fr = new FileReader(fFinal);
                    BufferedReader br = new BufferedReader(fr);
                    String eachCmd = null;
                    int line = 0;
                    while ((eachCmd = br.readLine()) != null && noCmdError) {
                        ++line;
                        buff = new StringBuffer("Calling  oiipgClusterRunCmd.runAnyCmdOnNodes(eachCmd, nodes, desiredServiceName); \"");
                        buff.append(eachCmd);
                        buff.append("\" on node ");
                        buff.append(node);
                        OLogger.debug((StringBuffer)buff);
                        if (eachCmd == null || eachCmd.equals("")) continue;
                        try {
                            StringBuffer msg = new StringBuffer("Running command on remote node '");
                            msg.append(node);
                            msg.append("': \n");
                            msg.append(eachCmd);
                            msg.append("\n");
                            OLogger.println((String)msg.toString());
                            if (!patchgenCmd.equals("") && eachCmd.startsWith(patchgenCmd)) {
                                this.runPatchgenCmdOnNodes(oracleHomePath, eachCmd, patchgenCmd, nodeSet);
                                continue;
                            }
                            this.runAnyCmdOnNodes(eachCmd, nodeSet, desiredServiceName);
                        }
                        catch (Exception e) {
                            cmdError = true;
                            String stdErrMsg = "Error unavailable";
                            if (e != null) {
                                Throwable t = e.getCause();
                                String string = stdErrMsg = t != null ? t.getMessage() : e.getMessage();
                                if (t != null) {
                                    cmdError = this.searchExceptionForErrorTag(eachCmd, stdErrMsg);
                                }
                            }
                            FailedCommand fc = new FailedCommand(node, eachCmd, cmdError, finalFile, stdErrMsg, line);
                            String detail = stdErrMsg;
                            if (cmdError) {
                                StringBuffer question;
                                boolean proceed;
                                OLogger.warn((String)"OUI-67253", (Object[])new Object[]{eachCmd, node, finalFile, detail, new Integer(line)});
                                failList.add(fc);
                                if (!Rules.shouldPauseOnErrorOnNodes((String[])nodes) || (proceed = OPatchEnv.proceedWithOperationDefaultYes((StringBuffer)(question = new StringBuffer(OLogger.getString((String)"OUI-67251", (Object[])new Object[]{eachCmd, node})))))) continue;
                                noCmdError = false;
                                reportError = true;
                                continue;
                            }
                            OLogger.warn((String)"OUI-67252", (Object[])new Object[]{eachCmd, node, finalFile, detail, new Integer(line)});
                        }
                    }
                    br.close();
                    fr.close();
                }
                for (int f = 0; f < failList.size(); ++f) {
                    Object obj = failList.get(f);
                    if (!(obj instanceof FailedCommand)) continue;
                    FailedCommand fc = (FailedCommand)obj;
                    String eachFailCmd = fc.getCommand();
                    String commandFile = fc.getCommandFile();
                    String cause = fc.getCause();
                    int eachLine = fc.getLineNumber();
                    String node = fc.getNode();
                    cmdError = fc.isError();
                    if (!cmdError) continue;
                }
                if (reportError) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(214);
                    String msg = OLogger.getString((String)"OUI-67251", (Object[])new Object[]{nodesString});
                    RuntimeException e = new RuntimeException(msg);
                    throw e;
                }
                break block19;
            }
            throw new RuntimeException("Cannot run listed commands: file-holder doesn't exist");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateRemoteNodes(String oracleHomePath, String[] nodes, boolean apply, boolean rollback, boolean auto_rollback, String FP, String DP, String FR, String DR, String MP, String RC, String patchStorageRac, PatchObject[] patchObjects, PatchObject[] autoRolledBackPatchObjects, String localNode, boolean propagateToRemote, boolean runOnRemote) throws RuntimeException {
        buff = new StringBuffer("updateRemoteNodes()");
        OLogger.debug((StringBuffer)buff);
        try {
            OPatchSessionHelper.checkArrayForNull((String)"RemoteNodes in updateRemoteNodes", (Object[])nodes);
        }
        catch (NullPointerException e) {
            re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        if (apply && rollback) {
            OPatchStateManagerFactory.getInstance().setErrorCode(207);
            msg = "Semantic error while attempting to patch remote nodes: both apply and rollback flags are set.";
            throw new RuntimeException(msg);
        }
        if (!apply && !rollback) {
            OPatchStateManagerFactory.getInstance().setErrorCode(208);
            msg = "Semantic error while attempting to patch remote nodes: none of apply and rollback flags is set.";
            throw new RuntimeException(msg);
        }
        if (oracleHomePath == null || nodes == null || nodes.length == 0 || patchStorageRac == null) {
            msg = "updateRemoteNodes(): either oracleHomePath, nodes or patchStorageRac is null";
            throw new RuntimeException(msg);
        }
        try {
            nodesString = RacProcessor.getNodesString((String[])nodes);
            buff = new StringBuffer("Updating nodes ");
            buff.append(nodesString);
            OLogger.println((String)buff.toString());
            if (apply) {
                buff = new StringBuffer(" Setting up Apply files FP, DP, RC and MP for Apply Session");
                OLogger.debug((StringBuffer)buff);
                FP = RacFileCreator.getFPFinalName((String)patchStorageRac);
                DP = RacFileCreator.getDPFinalName((String)patchStorageRac);
                MP = RacFileCreator.getMPFinalName((String)patchStorageRac);
                RC = RacFileCreator.getRCFinalName((String)patchStorageRac);
                buff = new StringBuffer("   Apply-related files are:\n");
                buff.append("     FP = \"");
                buff.append(FP);
                buff.append("\"\n");
                buff.append("     DP = \"");
                buff.append(DP);
                buff.append("\"\n");
                buff.append("     MP = \"");
                buff.append(MP);
                buff.append("\"\n");
                buff.append("     RC = \"");
                buff.append(RC);
                buff.append("\"\n");
                OLogger.println((String)buff.toString());
                if (auto_rollback) {
                    buff = new StringBuffer(" Setting up auto-rb files FP and DR for Auto-rollback Session");
                    OLogger.debug((StringBuffer)buff);
                    FR = RacFileCreator.getFRFinalName((String)patchStorageRac);
                    DR = RacFileCreator.getDRFinalName((String)patchStorageRac);
                    buff = new StringBuffer("   Auto-Rollback-related files are:\n");
                    buff.append("     FR = \"");
                    buff.append(FR);
                    buff.append("\"\n");
                    buff.append("     DR = \"");
                    buff.append(DR);
                    buff.append("\"\n");
                    OLogger.println((String)buff.toString());
                }
            } else if (rollback) {
                buff = new StringBuffer(" Setting up Rollback files FP, DR and MP for Rollback Session");
                OLogger.debug((StringBuffer)buff);
                FR = RacFileCreator.getFRFinalName((String)patchStorageRac);
                DR = RacFileCreator.getDRFinalName((String)patchStorageRac);
                FP = RacFileCreator.getFPFinalName((String)patchStorageRac);
                MP = RacFileCreator.getMPFinalName((String)patchStorageRac);
                RC = RacFileCreator.getRCFinalName((String)patchStorageRac);
                buff = new StringBuffer("   Rollback-related files are:\n");
                buff.append("     FR = \"");
                buff.append(FR);
                buff.append("\"\n");
                buff.append("     DR = \"");
                buff.append(DR);
                buff.append("\"\n");
                buff.append("     FP = \"");
                buff.append(FP);
                buff.append("\"\n");
                buff.append("     MP = \"");
                buff.append(MP);
                buff.append("\"\n");
                buff.append("     RC = \"");
                buff.append(RC);
                buff.append("\"\n");
                OLogger.println((String)buff.toString());
            }
            if (runOnRemote) {
                if (patchObjects != null && rollback) {
                    this.runPatchRemoteCommand(oracleHomePath, patchObjects, nodes, localNode, false);
                }
                if (autoRolledBackPatchObjects != null && auto_rollback) {
                    this.runPatchRemoteCommand(oracleHomePath, autoRolledBackPatchObjects, nodes, localNode, false);
                }
            }
            if (propagateToRemote) {
                if (FR != null) {
                    buff = new StringBuffer(" Processing FR list");
                    OLogger.debug((StringBuffer)buff);
                    fFinal = new File(FR);
                    if (fFinal.exists()) {
                        finalFile = RacFileCreator.getInstantiatedFile((String)FR);
                        try {
                            this.removeListedFilesOnNodes(oracleHomePath, nodes, FR, finalFile);
                        }
                        catch (RuntimeException e) {
                            detail = e.getMessage();
                            OLogger.warn((String)"OUI-67189", (Object[])new Object[]{nodesString, detail});
                            if (!Rules.shouldPauseOnErrorOnNodes((String[])nodes) || (proceed = OPatchEnv.proceedWithOperationDefaultYes((StringBuffer)(question = new StringBuffer(OLogger.getString((String)"OUI-67193", (Object[])new Object[]{nodesString})))))) ** GOTO lbl143
                            OPatchStateManagerFactory.getInstance().setErrorCode(209);
                            throw e;
                        }
                    } else {
                        OLogger.println((String)"FR file not exist.  There are no files to be removed on remote nodes.");
                    }
                }
lbl143:
                // 5 sources

                if (DR != null) {
                    buff = new StringBuffer(" Processing DR list");
                    OLogger.debug((StringBuffer)buff);
                    fFinal = new File(DR);
                    if (fFinal.exists()) {
                        finalFile = RacFileCreator.getInstantiatedFile((String)DR);
                        try {
                            this.removeListedDirsOnNodes(oracleHomePath, nodes, DR, finalFile);
                        }
                        catch (RuntimeException e) {
                            detail = e.getMessage();
                            OLogger.warn((String)"OUI-67190", (Object[])new Object[]{nodesString, detail});
                            if (!Rules.shouldPauseOnErrorOnNodes((String[])nodes) || (proceed = OPatchEnv.proceedWithOperationDefaultYes((StringBuffer)(question = new StringBuffer(OLogger.getString((String)"OUI-67194", (Object[])new Object[]{nodesString})))))) ** GOTO lbl160
                            OPatchStateManagerFactory.getInstance().setErrorCode(210);
                            throw e;
                        }
                    } else {
                        OLogger.println((String)"DR file not exist.  There are no dirs. to be removed on remote nodes.");
                    }
                }
lbl160:
                // 5 sources

                if (FP != null) {
                    buff = new StringBuffer(" Processing FP list");
                    OLogger.debug((StringBuffer)buff);
                    fFinal = new File(FP);
                    if (fFinal.exists()) {
                        finalFile = RacFileCreator.getInstantiatedFile((String)FP);
                        try {
                            this.propagateListedFilesToNodes(oracleHomePath, nodes, FP, finalFile);
                        }
                        catch (RuntimeException e) {
                            detail = e.getMessage();
                            OLogger.warn((String)"OUI-67187", (Object[])new Object[]{nodesString, detail});
                            if (!Rules.shouldPauseOnErrorOnNodes((String[])nodes) || (proceed = OPatchEnv.proceedWithOperationDefaultYes((StringBuffer)(question = new StringBuffer(OLogger.getString((String)"OUI-67191", (Object[])new Object[]{nodesString})))))) ** GOTO lbl177
                            OPatchStateManagerFactory.getInstance().setErrorCode(211);
                            throw e;
                        }
                    } else {
                        OLogger.println((String)"FP file not exist.  There are no files to be propagated to the remote nodes.");
                    }
                }
lbl177:
                // 5 sources

                if (DP != null) {
                    buff = new StringBuffer(" Processing DP list");
                    OLogger.debug((StringBuffer)buff);
                    fFinal = new File(DP);
                    if (fFinal.exists()) {
                        finalFile = RacFileCreator.getInstantiatedFile((String)DP);
                        try {
                            this.propagateListedDirsToNodes(oracleHomePath, nodes, DP, finalFile);
                        }
                        catch (RuntimeException e) {
                            detail = e.getMessage();
                            OLogger.warn((String)"OUI-67188", (Object[])new Object[]{nodesString, detail});
                            if (!Rules.shouldPauseOnErrorOnNodes((String[])nodes) || (proceed = OPatchEnv.proceedWithOperationDefaultYes((StringBuffer)(question = new StringBuffer(OLogger.getString((String)"OUI-67192", (Object[])new Object[]{nodesString})))))) ** GOTO lbl194
                            OPatchStateManagerFactory.getInstance().setErrorCode(212);
                            throw e;
                        }
                    } else {
                        OLogger.println((String)"DP file not exist.  There are no dirs. to be propagated to the remote nodes.");
                    }
                }
lbl194:
                // 5 sources

                if (MP != null) {
                    buff = new StringBuffer(" Processing MP list");
                    OLogger.debug((StringBuffer)buff);
                    fFinal = new File(MP);
                    if (fFinal.exists()) {
                        finalFile = RacFileCreator.getInstantiatedFile((String)MP);
                        this.runMakeCmdOnNodes(oracleHomePath, nodes, MP, "opatchUtil", finalFile);
                    } else {
                        OLogger.println((String)"MP file not exist.  There are no commands to be invoked on the remote nodes.");
                    }
                }
            }
            if (runOnRemote) {
                if (RC != null) {
                    buff = new StringBuffer(" Processing RC list");
                    OLogger.debug((StringBuffer)buff);
                    fFinal = new File(RC);
                    if (fFinal.exists()) {
                        finalFile = RacFileCreator.getInstantiatedFile((String)RC);
                        this.runAnyCmdOnNodes(oracleHomePath, nodes, RC, "opatchUtil", finalFile);
                    } else {
                        OLogger.println((String)"RC file not exist.  There are no commands to be run on the remote nodes.");
                    }
                }
                if (patchObjects != null && apply) {
                    this.runPatchRemoteCommand(oracleHomePath, patchObjects, nodes, localNode, true);
                }
            }
        }
        catch (IOException e) {
            re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void runPatchRemoteCommand(String oracleHomePath, PatchObject[] patchObjects, String[] nodes, String localNode, boolean apply) {
        for (int pIter = 0; pIter < patchObjects.length; ++pIter) {
            PatchAction[] pa = patchObjects[pIter].getAllIncludedActions();
            for (int paIter = 0; paIter < pa.length; ++paIter) {
                PatchAction p = pa[paIter];
                if (!(p instanceof RemoteShellRunCommand)) continue;
                RemoteShellRunCommand rpa = (RemoteShellRunCommand)p;
                if (!apply && p instanceof hotpatchAction) {
                    rpa.runRemoteCommand(oracleHomePath, apply, patchObjects[pIter].getCookedPatchID(), nodes, localNode);
                    continue;
                }
                rpa.runRemoteCommand(oracleHomePath, apply, patchObjects[pIter].getPatchID(), nodes, localNode);
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        File src = new File("O:\\tmp\\src.txt");
        File dst = new File("O:\\tmp\\dst.txt");
        if (!OPatchEnv.isWindows()) {
            src = new File("/tmp/src.txt");
            dst = new File("/tmp/dst.txt");
        }
        OPatchSession.processDebugEnvironment();
        RacSrvmImpl racSrvmImpl = new RacSrvmImpl();
        racSrvmImpl.convertLiteralOracleHome("CONVERTED_VALUE", src.getCanonicalPath(), dst.getCanonicalPath());
    }

    public static class FailedCommand {
        private String command;
        private String commandFile;
        private String probableCause;
        private int lineNumber;
        private String node;
        private boolean makeError = false;

        public FailedCommand(String node, String command, boolean makeError, String commandFile, String probableCause, int lineNumber) {
            this.node = node;
            this.command = command;
            this.makeError = makeError;
            this.commandFile = commandFile;
            this.probableCause = probableCause;
            this.lineNumber = lineNumber;
        }

        String getNode() {
            return this.node;
        }

        String getCommand() {
            return this.command;
        }

        String getCommandFile() {
            return this.commandFile;
        }

        String getCause() {
            return this.probableCause;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        boolean isError() {
            return this.makeError;
        }
    }
}

