/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchActions;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.dao.PatchActionDAO;

public class PatchActionsImpl
implements PatchActions {
    private PatchActionDAO padao = null;

    public PatchActionsImpl() {
    }

    public PatchActionsImpl(String actionsLoc) throws PatchMetadataLoadingException {
        this.padao = new PatchActionDAO(actionsLoc);
    }

    protected void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + dir + " for cloning patch actions.xml", (Throwable)e);
            }
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning patch actions.xml");
        }
        String inventoryFile = destinationPatchLoc + Constants.PATH + Constants.ACTIONS_XML;
        this.padao.save(inventoryFile);
    }

    public List<PatchActions.Component> getComponents() {
        return this.padao.getComponents();
    }

    public class ComponentImpl
    implements PatchActions.Component {
        private String name = null;
        private String version = null;
        private String symbol = null;
        private String patchLevel = null;
        private String optString = null;
        private List<PatchActions.Component.Archive> archives = null;
        private List<PatchActions.Component.Jar> jars = null;
        private List<PatchActions.Component.Copy> copies = null;
        private List<PatchActions.Component.Unzip> unzips = null;
        private List<PatchActions.Component.Delete> deletes = null;
        private List<PatchActions.Component.Make> makes = null;
        private List<PatchActions.Component.Copy> oneWayCopies = null;
        private List<PatchActions.Component.Sql> sqls = null;
        private List<PatchActions.Component.Sqlproc> sqlProcs = null;
        private List<PatchActions.Component.Portal> portals = null;
        private List<PatchActions.Component.Hotpatch> hotpatchs = null;
        private List<PatchActions.Component.StringSubs> stringsubs = null;

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setOptString(String optString) {
            this.optString = optString;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public void setPatchLevel(String patchLevel) {
            this.patchLevel = patchLevel;
        }

        public void setArchives(List<PatchActions.Component.Archive> list) {
            this.archives = list;
        }

        public void setJars(List<PatchActions.Component.Jar> list) {
            this.jars = list;
        }

        public void setCopies(List<PatchActions.Component.Copy> list) {
            this.copies = list;
        }

        public void setUnzips(List<PatchActions.Component.Unzip> list) {
            this.unzips = list;
        }

        public void setDeletes(List<PatchActions.Component.Delete> list) {
            this.deletes = list;
        }

        public void setOneWayCopies(List<PatchActions.Component.Copy> list) {
            this.oneWayCopies = list;
        }

        public void setMakes(List<PatchActions.Component.Make> list) {
            this.makes = list;
        }

        public void setSqls(List<PatchActions.Component.Sql> list) {
            this.sqls = list;
        }

        public void setSqlprocs(List<PatchActions.Component.Sqlproc> list) {
            this.sqlProcs = list;
        }

        public void setPortals(List<PatchActions.Component.Portal> list) {
            this.portals = list;
        }

        public void setHotpatchs(List<PatchActions.Component.Hotpatch> list) {
            this.hotpatchs = list;
        }

        public void setStringSubs(List<PatchActions.Component.StringSubs> list) {
            this.stringsubs = list;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public Boolean isRequired() {
            return this.optString.equalsIgnoreCase("R");
        }

        public String getOptString() {
            return this.optString;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getPatchLevel() {
            return this.patchLevel;
        }

        public List<PatchActions.Component.Archive> getArchives() {
            return this.archives;
        }

        public List<PatchActions.Component.Jar> getJars() {
            return this.jars;
        }

        public List<PatchActions.Component.Copy> getCopies() {
            return this.copies;
        }

        public List<PatchActions.Component.Unzip> getUnzips() {
            return this.unzips;
        }

        public List<PatchActions.Component.Delete> getDeletes() {
            return this.deletes;
        }

        public List<PatchActions.Component.Make> getMakes() {
            return this.makes;
        }

        public List<PatchActions.Component.Copy> getOneWayCopies() {
            return this.oneWayCopies;
        }

        public List<PatchActions.Component.Sql> getSqls() {
            return this.sqls;
        }

        public List<PatchActions.Component.Sqlproc> getSqlprocs() {
            return this.sqlProcs;
        }

        public List<PatchActions.Component.Portal> getPortal() {
            return this.portals;
        }

        public List<PatchActions.Component.Hotpatch> getHotpatchs() {
            return this.hotpatchs;
        }

        public List<PatchActions.Component.StringSubs> getStringSubs() {
            return this.stringsubs;
        }

        public class StringSubsImpl
        implements PatchActions.Component.StringSubs {
            private String config = null;
            private String schema = null;

            public StringSubsImpl(String config, String schema) {
                this.config = config;
                this.schema = schema;
            }

            public String getConfig() {
                return this.config;
            }

            public String getSchema() {
                return this.schema;
            }
        }

        public class HotpatchImpl
        implements PatchActions.Component.Hotpatch {
            private String name = null;
            private String objectName = null;
            private String modifiedFunction = null;
            private String fileName = null;
            private String path = null;
            private String mkPatchParam = null;

            public HotpatchImpl(String name, String objectName, String modifiedFunction, String fileName, String path, String mkPatchParam) {
                this.name = name;
                this.objectName = objectName;
                this.modifiedFunction = modifiedFunction;
                this.fileName = fileName;
                this.path = path;
                this.mkPatchParam = mkPatchParam;
            }

            public String getName() {
                return this.name;
            }

            public String getObjectName() {
                return this.objectName;
            }

            public String getModifiedFunction() {
                return this.modifiedFunction;
            }

            public String getFileName() {
                return this.fileName;
            }

            public String getPath() {
                return this.path;
            }

            public String getMkpatchParam() {
                return this.mkPatchParam;
            }
        }

        public class PortalImpl
        implements PatchActions.Component.Portal {
            private double order = 0.0;
            private String patchName = null;

            public PortalImpl(String patchName) {
                this.patchName = patchName;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public String getPatchName() {
                return this.patchName;
            }
        }

        public class SqlprocImpl
        implements PatchActions.Component.Sqlproc {
            private double order = 0.0;
            private String name = null;
            private String filePath = null;
            private String procTouchList = null;
            private Boolean backupInZipFlag = false;

            public SqlprocImpl(String name, String filePath, String procTouchList) {
                this.name = name;
                this.filePath = filePath;
                this.procTouchList = procTouchList;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }

            public String getName() {
                return this.name;
            }

            public String getFilePath() {
                return this.filePath;
            }

            public String getProcTouchedList() {
                return this.procTouchList;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }
        }

        public class SqlImpl
        implements PatchActions.Component.Sql {
            private double order = 0.0;
            private String name = null;
            private String filePath = null;
            private Boolean apply = null;
            private Boolean rollback = null;
            private Boolean backupInZipFlag = false;

            public SqlImpl(String name, String filePath, Boolean apply, Boolean rollback) {
                this.name = name;
                this.filePath = filePath;
                this.apply = apply;
                this.rollback = rollback;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }

            public String getName() {
                return this.name;
            }

            public String getFilePath() {
                return this.filePath;
            }

            public Boolean getApply() {
                return this.apply;
            }

            public Boolean getRollback() {
                return this.rollback;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }
        }

        public class MakeImpl
        implements PatchActions.Component.Make {
            private double order = 0.0;
            private String changeDir = null;
            private String makeFile = null;
            private String makeTarget = null;

            public MakeImpl(String changeDir, String makeFile, String makeTarget) {
                this.changeDir = changeDir;
                this.makeFile = makeFile;
                this.makeTarget = makeTarget;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
            }

            public String getChangeDir() {
                return this.changeDir;
            }

            public String getMakeFile() {
                return this.makeFile;
            }

            public String getMakeTarget() {
                return this.makeTarget;
            }
        }

        public class DeleteImpl
        implements PatchActions.Component.Delete {
            private double order = 0.0;
            private String name = null;
            private String path = null;
            private String fileVersion = null;
            private String opt_req = null;
            private Boolean oneWayFlag = false;
            private Boolean dirFlag = false;
            private Boolean backupInZipFlag = false;
            private String appDir = null;

            public DeleteImpl(String name, String path) {
                this.name = name;
                this.path = path;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public void setFileVersion(String fileVersion) {
                this.fileVersion = fileVersion;
            }

            public void setOpt_Req(String s) {
                this.opt_req = s;
            }

            public void setOneWayFlag(Boolean b) {
                this.oneWayFlag = b;
            }

            public void setDirFlag(Boolean b) {
                this.dirFlag = b;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }

            public void setAppDir(String appDir) {
                this.appDir = appDir;
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path;
            }

            public String getFileVersion() {
                return this.fileVersion;
            }

            public String getOpt_Req() {
                return this.opt_req;
            }

            public Boolean getOneWayFlag() {
                return this.oneWayFlag;
            }

            public Boolean getDirFlag() {
                return this.dirFlag;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }

            public String getAppDir() {
                return this.appDir;
            }
        }

        public class UnzipImpl
        implements PatchActions.Component.Unzip {
            private double order = 0.0;
            private String name = null;
            private String path = null;
            private String fileName = null;
            private Boolean updateTimeStamp = false;
            private String fileVersion = null;
            private Boolean retainPermission = false;
            private String shaolue = null;
            private Boolean backupInZipFlag = false;

            public UnzipImpl(String name, String path, String fileName, String shaolue) {
                this.name = name;
                this.path = path;
                this.fileName = fileName;
                this.shaolue = shaolue;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public void setFileVersion(String fileVersion) {
                this.fileVersion = fileVersion;
            }

            public void setRetainPermission(Boolean b) {
                this.retainPermission = b;
            }

            public void setUpdateTimeStamp(Boolean b) {
                this.updateTimeStamp = b;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path;
            }

            public String getFileName() {
                return this.fileName;
            }

            public Boolean getUpdateTimeStamp() {
                return this.updateTimeStamp;
            }

            public String getFileVersion() {
                return this.fileVersion;
            }

            public Boolean getRetainPersmission() {
                return this.retainPermission;
            }

            public String getShaolue() {
                return this.shaolue;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }
        }

        public class CopyImpl
        implements PatchActions.Component.Copy {
            private double order = 0.0;
            private String name = null;
            private String path = null;
            private String fileName = null;
            private Boolean updateTimeStamp = false;
            private String fileVersion = null;
            private String diagnosticString = null;
            private Boolean retainPermission = false;
            private String shaolue = null;
            private String appDir = null;
            private String mode = null;
            private Boolean backupInZipFlag = false;
            private Boolean archiveCopyFlag = false;

            public CopyImpl(String name, String path, String fileName, String shaolue) {
                this.name = name;
                this.path = path;
                this.fileName = fileName;
                this.shaolue = shaolue;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public void setUpdateTimeStamp(Boolean b) {
                this.updateTimeStamp = b;
            }

            public void setRetainPermission(Boolean b) {
                this.retainPermission = b;
            }

            public void setFileVersion(String fileVersion) {
                this.fileVersion = fileVersion;
            }

            public void setDiagnosticString(String diagString) {
                this.diagnosticString = diagString;
            }

            public void setAppDir(String appDir) {
                this.appDir = appDir;
            }

            public void setMode(String mode) {
                this.mode = mode;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }

            public void setArchiveCopyFlag(Boolean b) {
                this.archiveCopyFlag = b;
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path;
            }

            public String getFileName() {
                return this.fileName;
            }

            public Boolean getUpdateTimeStamp() {
                return this.updateTimeStamp;
            }

            public String getFileVersion() {
                return this.fileVersion;
            }

            public String getDiagnosticString() {
                return this.diagnosticString;
            }

            public Boolean getRetainPersmission() {
                return this.retainPermission;
            }

            public String getShaolue() {
                return this.shaolue;
            }

            public String getAppDir() {
                return this.appDir;
            }

            public String getMode() {
                return this.mode;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }

            public Boolean getArchiveCopyFlag() {
                return this.archiveCopyFlag;
            }
        }

        public class JarImpl
        implements PatchActions.Component.Jar {
            private double order = 0.0;
            private String name = null;
            private String path = null;
            private String className = null;
            private String shaolue = null;
            private Boolean backupInZipFlag = false;

            public JarImpl(String name, String path, String className, String shaolue) {
                this.name = name;
                this.path = path;
                this.className = className;
                this.shaolue = shaolue;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path;
            }

            public String getClassName() {
                return this.className;
            }

            public String getShaolue() {
                return this.shaolue;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }
        }

        public class ArchiveImpl
        implements PatchActions.Component.Archive {
            private double order = 0.0;
            private String name = null;
            private String path = null;
            private String objectName = null;
            private String shaolue = null;
            private Boolean backupInZipFlag = false;

            public ArchiveImpl(String name, String path, String objectName, String shaolue) {
                this.name = name;
                this.path = path;
                this.objectName = objectName;
                this.shaolue = shaolue;
            }

            public double getOrder() {
                return this.order;
            }

            public void setOrder(double order) {
                this.order = order;
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path;
            }

            public String getObjectName() {
                return this.objectName;
            }

            public String getShaolue() {
                return this.shaolue;
            }

            public Boolean getBackupInZipFlag() {
                return this.backupInZipFlag;
            }

            public void setBackupInZipFlag(Boolean b) {
                this.backupInZipFlag = b;
            }
        }
    }
}

