/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;

public class PatchCheckResultsImpl
implements PatchCheckResults {
    private Patch _patch;
    private Map<PatchInventory.Component, ComponentCheckResult> _results = new LinkedHashMap<PatchInventory.Component, ComponentCheckResult>();

    public PatchCheckResultsImpl(Patch patch) {
        this._patch = patch;
        List components = patch.getComponents();
        if (components != null) {
            for (PatchInventory.Component component : components) {
                this.setResult(component, null, null);
            }
        }
    }

    public Patch getPatch() {
        return this._patch;
    }

    public Map<PatchInventory.Component, ComponentCheckResult> getComponentCheckResults() {
        return this._results;
    }

    public ComponentCheckResult getComponentCheckResult(PatchInventory.Component component) {
        return this.getComponentCheckResults().get(component);
    }

    public Result getHighLevelResult() {
        ArrayList<Result> results = new ArrayList<Result>();
        for (ComponentCheckResult componentCheckResult : this.getComponentCheckResults().values()) {
            results.add(componentCheckResult.getResult());
        }
        return Result.getHighLevelResult(results);
    }

    public void setResult(PatchInventory.Component component, Result result, String details) {
        ComponentCheckResult componentCheckResult = this._results.get(component);
        if (componentCheckResult == null) {
            componentCheckResult = BasePatchFactory.instance().createComponentCheckResult(component);
            this._results.put(component, componentCheckResult);
        }
        componentCheckResult.setResult(result);
        componentCheckResult.setDetails(details);
    }

    public Set<ComponentCheckResult> getComponentCheckResults(Result ... results) {
        LinkedHashSet<ComponentCheckResult> matches = new LinkedHashSet<ComponentCheckResult>();
        if (results != null && results.length > 0) {
            HashSet<Result> resultSet = new HashSet<Result>(Arrays.asList(results));
            for (ComponentCheckResult componentCheckResult : this.getComponentCheckResults().values()) {
                if (!resultSet.contains(componentCheckResult.getResult())) continue;
                matches.add(componentCheckResult);
            }
        }
        return matches;
    }

    public Set<ComponentCheckResult> getFailureResults() {
        return this.getComponentCheckResults(Result.ERR_NOT_FOUND, Result.VERSION_MISMATCH);
    }
}

