/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchConfigInventory;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.helpers.PatchHelper;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.dao.PatchConfigInventoryDAO;

public class PatchConfigInventoryImpl
implements PatchConfigInventory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private PatchConfigInventoryDAO pcidao = null;

    public List<String> getAppliedConfigPatches() {
        return this.pcidao.getAll();
    }

    public List<Patch> getDeltaPatchInfo(String oracleHome) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        List<String> doneList = this.pcidao.getAll();
        this.logger.info("Configured patch list: " + doneList);
        List<String> patchesInOh = PatchHelper.getPatchIdsInOH(oracleHome);
        this.logger.info("In OH patch list:" + patchesInOh);
        List<String> listDelta = this.findDelta(patchesInOh, doneList);
        this.logger.info("Delta patch list: " + listDelta);
        List<Patch> patchList = this.getPatchInfo(oracleHome, listDelta);
        return patchList;
    }

    public List<Patch> getDeltaPatchInfo(String oracleHome, List<String> inputPatches) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        List<String> doneList = this.pcidao.getAll();
        this.logger.info("Configured patch list: " + doneList);
        this.logger.info("Incomming patches:" + inputPatches);
        List<String> listDelta = this.findDelta(inputPatches, doneList);
        this.logger.info("Delta patch list: " + listDelta);
        List<Patch> patchList = this.getPatchInfo(oracleHome, listDelta);
        return patchList;
    }

    public List<Patch> getPatchInfo(String oracleHome, List<String> inputPatches) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        ArrayList<Patch> result = new ArrayList<Patch>();
        List<String> listLocation = PatchHelper.getPatchIDsInOH(oracleHome, inputPatches);
        PatchFactory patchFac = BasePatchFactory.instance();
        for (String loc : listLocation) {
            String absoluteLoc = oracleHome + Constants.PATH + PatchHelper.ONEOFFS_PATH + Constants.PATH + loc;
            Patch patch = patchFac.createPatch(absoluteLoc);
            if (patch == null) continue;
            result.add(patch);
        }
        return result;
    }

    public void removeConfigPatchApplied(List<Patch> patchList) throws DomainInventoryUpdatingException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Patch patch : patchList) {
            map.put(patch.getPatchId(), patch.getPatchUpi());
        }
        this.pcidao.remove(map);
    }

    public void removeConfigPatchApplied(HashMap<String, String> map) throws DomainInventoryUpdatingException {
        this.pcidao.remove(map);
    }

    public void setConfigPatchApplied(List<Patch> listPatches) throws DomainInventoryUpdatingException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Patch patch : listPatches) {
            map.put(patch.getPatchId(), patch.getPatchUpi());
        }
        this.setConfigPatchApplied(map);
    }

    public void setConfigPatchApplied(HashMap<String, String> map) throws DomainInventoryUpdatingException {
        this.pcidao.add(map);
    }

    protected PatchConfigInventoryImpl(String instanceDir) throws FileNotFoundException, DomainInventoryLoadingException {
        this.pcidao = new PatchConfigInventoryDAO(instanceDir);
    }

    private List<String> findDelta(List<String> notdone, List<String> done) {
        ArrayList<String> result = new ArrayList<String>();
        for (String sNotDone : notdone) {
            boolean found = false;
            for (String sDone : done) {
                if (!sNotDone.equals(sDone)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(sNotDone);
        }
        return result;
    }
}

