/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias;

import com.oracle.xmlns.cie.glcm.patch.mai.ArtifactRefType;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasType;
import com.oracle.xmlns.cie.glcm.patch.mai.MappingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.alias.ArtifactReference;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasBuilderFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasInventory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasService;
import oracle.glcm.opatch.common.helpers.MaintenanceAliasInfoHelper;
import oracle.glcm.opatch.common.impl.alias.MaintenanceAliasServiceImpl;
import oracle.glcm.opatch.common.impl.dao.MaintenanceAliasInfoDAO;

public class MaintenanceAliasInventoryImpl
implements MaintenanceAliasInventory {
    private static final Logger _logger = Logger.getLogger(MaintenanceAliasInventoryImpl.class.getName());
    private MaintenanceAliasInfoDAO _aliasInfo = null;
    private Collection<MaintenanceAlias> _allAliases = null;

    public MaintenanceAliasInventoryImpl(String oracleHome) throws MaintenanceAliasException {
        String fileLoc = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasInfoPath(oracleHome);
        try {
            this._aliasInfo = new MaintenanceAliasInfoDAO(fileLoc, true);
            MaintenanceAliasInfoHelper.getInstance().validatesMaintenanceAliases(this._aliasInfo);
            this._allAliases = this.getAllAliases();
        }
        catch (MaintenanceAliasException e) {
            _logger.log(Level.FINE, e.getMessage());
            throw new MaintenanceAliasException(e.getMessage(), (Throwable)e);
        }
    }

    public MaintenanceAliasInventoryImpl(MaintenanceAliasService service) throws MaintenanceAliasException {
        try {
            this._aliasInfo = ((MaintenanceAliasServiceImpl)service).getMaintenanceAliasInfo();
            MaintenanceAliasInfoHelper.getInstance().validatesMaintenanceAliases(this._aliasInfo);
            this._allAliases = this.getAllAliases();
        }
        catch (MaintenanceAliasException e) {
            _logger.log(Level.FINE, e.getMessage());
            throw new MaintenanceAliasException(e.getMessage(), (Throwable)e);
        }
    }

    private Collection<MaintenanceAlias> getAllAliases() {
        ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
        List aliases = this._aliasInfo.getMaintenanceAliases() != null ? this._aliasInfo.getMaintenanceAliases().getMaintenanceAlias() : new ArrayList();
        for (MaintenanceAliasType alias : aliases) {
            List mappings = this._aliasInfo.getMaintenanceAliasArtifactsMapping().getMapping();
            ArrayList<ArtifactReference> mapping = new ArrayList<ArtifactReference>();
            MaintenanceAliasBuilderFactory builder = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasBuilderFactory();
            for (MappingType m : mappings) {
                if (!m.getMaintenanceAliasKey().equals(alias.getMaintenanceAliasKey())) continue;
                for (ArtifactRefType component : m.getComponent()) {
                    mapping.add(builder.getComponentArtifactReferenceBuilder(component.getName(), component.getVersion()).build());
                }
                for (ArtifactRefType featureset : m.getFeatureSet()) {
                    mapping.add(builder.getFeatureSetArtifactReferenceBuilder(featureset.getName(), featureset.getVersion()).build());
                }
                for (ArtifactRefType distribution : m.getDistribution()) {
                    mapping.add(builder.getDistributionArtifactReferenceBuilder(distribution.getName(), distribution.getVersion()).build());
                }
            }
            mantenianceAliases.add(builder.getMaintenanceAliasBuilder(alias.getProductFamily(), alias.getMaintenanceAliasKey(), alias.getProduct(), alias.getBundleType(), alias.getVersion(), alias.getTimestamp(), alias.getPatchType(), mapping).setPatchLevel(alias.getPatchLevel()).build());
        }
        return mantenianceAliases;
    }

    public Collection<MaintenanceAlias> getAllMaintenanceAliases() {
        return this._allAliases;
    }

    public Collection<MaintenanceAlias> getAllComponentMaintenanceAliases() {
        if (this._allAliases != null) {
            ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
            for (MaintenanceAlias alias : this._allAliases) {
                Collection ref = alias.getComponents();
                if (ref == null || ref.isEmpty()) continue;
                mantenianceAliases.add(alias);
            }
            return mantenianceAliases;
        }
        return null;
    }

    public Collection<MaintenanceAlias> getAllFeatureSetMaintenanceAliases() {
        if (this._allAliases != null) {
            ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
            for (MaintenanceAlias alias : this._allAliases) {
                Collection ref = alias.getFeatureSets();
                if (ref == null || ref.isEmpty()) continue;
                mantenianceAliases.add(alias);
            }
            return mantenianceAliases;
        }
        return null;
    }

    public Collection<MaintenanceAlias> getAllDistributionMaintenanceAliases() {
        if (this._aliasInfo != null) {
            ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
            for (MaintenanceAlias alias : this._allAliases) {
                Collection ref = alias.getDistributions();
                if (ref == null || ref.isEmpty()) continue;
                mantenianceAliases.add(alias);
            }
            return mantenianceAliases;
        }
        return null;
    }

    public Collection<MaintenanceAlias> getComponentMainantenceAlias(ArtifactReference component) {
        if (this._aliasInfo != null) {
            Collection<MaintenanceAlias> compMantenianceAliases = this.getAllComponentMaintenanceAliases();
            ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
            for (MaintenanceAlias alias : compMantenianceAliases) {
                Collection refs = alias.getComponents();
                for (ArtifactReference ref : refs) {
                    if (!ref.equals((Object)component)) continue;
                    mantenianceAliases.add(alias);
                }
            }
            return mantenianceAliases;
        }
        return null;
    }

    public Collection<MaintenanceAlias> getFeatureSetMainantenceAlias(ArtifactReference featureSet) throws MaintenanceAliasException {
        if (this._aliasInfo != null) {
            Collection<MaintenanceAlias> ftrMantenianceAliases = this.getAllFeatureSetMaintenanceAliases();
            ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
            for (MaintenanceAlias alias : ftrMantenianceAliases) {
                Collection refs = alias.getFeatureSets();
                for (ArtifactReference ref : refs) {
                    if (!ref.equals((Object)featureSet)) continue;
                    mantenianceAliases.add(alias);
                }
            }
            return mantenianceAliases;
        }
        return null;
    }

    public Collection<MaintenanceAlias> getDistributionMainantenceAlias(ArtifactReference distribution) throws MaintenanceAliasException {
        if (this._aliasInfo != null) {
            Collection<MaintenanceAlias> distMantenianceAliases = this.getAllDistributionMaintenanceAliases();
            ArrayList<MaintenanceAlias> mantenianceAliases = new ArrayList<MaintenanceAlias>();
            for (MaintenanceAlias alias : distMantenianceAliases) {
                Collection refs = alias.getComponents();
                for (ArtifactReference ref : refs) {
                    if (!ref.equals((Object)distribution)) continue;
                    mantenianceAliases.add(alias);
                }
            }
            return mantenianceAliases;
        }
        return null;
    }

    public Collection<ArtifactReference> getComponents(MaintenanceAlias alias) {
        if (this._aliasInfo != null) {
            Collection<MaintenanceAlias> compMantenianceAliases = this.getAllComponentMaintenanceAliases();
            ArrayList<ArtifactReference> comps = new ArrayList<ArtifactReference>();
            for (MaintenanceAlias cAlias : compMantenianceAliases) {
                if (!alias.equals((Object)cAlias)) continue;
                comps.addAll(alias.getComponents());
            }
            return comps;
        }
        return null;
    }

    public Collection<ArtifactReference> getFeatureSets(MaintenanceAlias alias) {
        if (this._aliasInfo != null) {
            Collection<MaintenanceAlias> ftsMantenianceAliases = this.getAllFeatureSetMaintenanceAliases();
            ArrayList<ArtifactReference> fts = new ArrayList<ArtifactReference>();
            for (MaintenanceAlias fAlias : ftsMantenianceAliases) {
                if (!alias.equals((Object)fAlias)) continue;
                fts.addAll(alias.getFeatureSets());
            }
            return fts;
        }
        return null;
    }

    public Collection<ArtifactReference> getDistributions(MaintenanceAlias alias) {
        if (this._aliasInfo != null) {
            Collection<MaintenanceAlias> distMantenianceAliases = this.getAllDistributionMaintenanceAliases();
            ArrayList<ArtifactReference> dist = new ArrayList<ArtifactReference>();
            for (MaintenanceAlias dAlias : distMantenianceAliases) {
                if (!alias.equals((Object)dAlias)) continue;
                dist.addAll(alias.getDistributions());
            }
            return dist;
        }
        return null;
    }
}

