/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias;

import com.oracle.xmlns.cie.glcm.patch.mai.ArtifactRefType;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasType;
import com.oracle.xmlns.cie.glcm.patch.mai.MappingType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.glcm.opatch.common.api.alias.ArtifactReference;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasService;
import oracle.glcm.opatch.common.helpers.MaintenanceAliasInfoHelper;
import oracle.glcm.opatch.common.impl.alias.ArtifactReferenceImpl;
import oracle.glcm.opatch.common.impl.dao.MaintenanceAliasInfoDAO;

public class MaintenanceAliasServiceImpl
implements MaintenanceAliasService {
    private String _oracleHome;
    private MaintenanceAliasInfoDAO _info;

    public MaintenanceAliasServiceImpl(String oracleHome) throws MaintenanceAliasException {
        File oh = new File(oracleHome);
        if (!oh.exists()) {
            throw new MaintenanceAliasException("The Oracle Home: " + oracleHome + " does not exist.");
        }
        this._oracleHome = oracleHome;
        if (new File(MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasInfoPath(this._oracleHome)).exists()) {
            this._info = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasInfoDAO(this._oracleHome);
        } else {
            MaintenanceAliasInfoHelper.getInstance().initMaintenanceAliasInfoFile(this._oracleHome);
            this._info = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasInfoDAO(this._oracleHome);
        }
    }

    public MaintenanceAliasInfoDAO getMaintenanceAliasInfo() {
        return this._info;
    }

    public boolean addMaintenanceAlias(MaintenanceAlias maintenanceAlias) throws MaintenanceAliasException {
        return this.addMaintenanceAlias(maintenanceAlias, false);
    }

    public boolean addMaintenanceAlias(MaintenanceAlias maintenanceAlias, boolean save) throws MaintenanceAliasException {
        if (!this._info.getAliases().isEmpty() || !this._info.getMappings().isEmpty()) {
            MaintenanceAliasInfoHelper.getInstance().validatesMaintenanceAliases(this._info, maintenanceAlias);
        }
        this._info.addMainenanceAlias(maintenanceAlias.getProductFamily(), maintenanceAlias.getMaintenanceAliasKey(), maintenanceAlias.getProduct(), maintenanceAlias.getBundleType(), maintenanceAlias.getVersion(), maintenanceAlias.getTimestamp(), maintenanceAlias.getPatchType(), maintenanceAlias.getPatchLevel());
        ArrayList<ArtifactRefType> components = new ArrayList<ArtifactRefType>();
        ArrayList<ArtifactRefType> featuresets = new ArrayList<ArtifactRefType>();
        ArrayList<ArtifactRefType> distributions = new ArrayList<ArtifactRefType>();
        for (ArtifactReference ref : maintenanceAlias.getComponents()) {
            components.add(this.toArtifactRefType(ref));
        }
        for (ArtifactReference ref : maintenanceAlias.getFeatureSets()) {
            featuresets.add(this.toArtifactRefType(ref));
        }
        for (ArtifactReference ref : maintenanceAlias.getDistributions()) {
            distributions.add(this.toArtifactRefType(ref));
        }
        this._info.addMapping(maintenanceAlias.getMaintenanceAliasKey(), components, featuresets, distributions);
        if (save) {
            this.save();
        }
        return true;
    }

    public boolean addMaintenanceAliasMapping(String maintenanceAliasKey, ArtifactReference mapping) throws MaintenanceAliasException {
        return this.addMaintenanceAliasMapping(maintenanceAliasKey, mapping, false);
    }

    public boolean addMaintenanceAliasMapping(MaintenanceAlias maintenanceAlias, ArtifactReference mapping, boolean save) throws MaintenanceAliasException {
        return this.addMaintenanceAliasMapping(maintenanceAlias.getMaintenanceAliasKey(), mapping, save);
    }

    public boolean addMaintenanceAliasMapping(String maintenanceAliasKey, ArtifactReference mapping, boolean save) throws MaintenanceAliasException {
        boolean added = false;
        List<MappingType> mappings = this._info.getMappings();
        ArtifactRefType specifiedRefType = this.toArtifactRefType(mapping);
        ArtifactReferenceImpl.ArtifactType artType = ((ArtifactReferenceImpl)mapping).getArtifactType();
        for (MappingType map : mappings) {
            if (!map.getMaintenanceAliasKey().equals(maintenanceAliasKey)) continue;
            switch (artType) {
                case component: {
                    added = this.addArtifactToList(map.getComponent(), specifiedRefType);
                    break;
                }
                case featureSet: {
                    added = this.addArtifactToList(map.getFeatureSet(), specifiedRefType);
                    break;
                }
                case distribution: {
                    added = this.addArtifactToList(map.getDistribution(), specifiedRefType);
                }
            }
        }
        if (added && save) {
            this.save();
        }
        return added;
    }

    public boolean updateMaintenanceAlias(MaintenanceAlias maintenanceAlias) throws MaintenanceAliasException {
        return this.updateMaintenanceAlias(maintenanceAlias, false);
    }

    public boolean updateMaintenanceAlias(MaintenanceAlias maintenanceAlias, boolean save) throws MaintenanceAliasException {
        boolean updated = false;
        List<MaintenanceAliasType> aliases = this._info.getAliases();
        if (aliases == null || aliases.isEmpty()) {
            throw new MaintenanceAliasException("Failed to update Maintenance Alias: " + maintenanceAlias.getMaintenanceAliasKey());
        }
        for (MaintenanceAliasType alias : aliases) {
            if (!alias.getMaintenanceAliasKey().equals(maintenanceAlias.getMaintenanceAliasKey())) continue;
            alias.setProductFamily(maintenanceAlias.getProductFamily());
            alias.setMaintenanceAliasKey(maintenanceAlias.getMaintenanceAliasKey());
            alias.setProduct(maintenanceAlias.getProduct());
            alias.setBundleType(maintenanceAlias.getBundleType());
            alias.setVersion(maintenanceAlias.getVersion());
            alias.setTimestamp(maintenanceAlias.getTimestamp());
            alias.setPatchType(maintenanceAlias.getPatchType());
            alias.setPatchLevel(maintenanceAlias.getPatchLevel());
            updated = true;
            break;
        }
        if (updated && save) {
            this.save();
        }
        return updated;
    }

    public boolean updateMaintenanceAliasMapping(String maintenanceAliasKey, ArtifactReference mapping) throws MaintenanceAliasException {
        return this.updateMaintenanceAliasMapping(maintenanceAliasKey, mapping, false);
    }

    public boolean updateMaintenanceAliasMapping(MaintenanceAlias maintenanceAlias, ArtifactReference mapping, boolean save) throws MaintenanceAliasException {
        return this.updateMaintenanceAliasMapping(maintenanceAlias.getMaintenanceAliasKey(), mapping, save);
    }

    public boolean updateMaintenanceAliasMapping(String maintenanceAliasKey, ArtifactReference mapping, boolean save) throws MaintenanceAliasException {
        boolean updated = false;
        List<MappingType> mappings = this._info.getMappings();
        if (mappings == null || mappings.isEmpty()) {
            throw new MaintenanceAliasException("Failed to update Maintenance Alias Mapping: " + mapping.toString());
        }
        ArtifactRefType specifiedRefType = this.toArtifactRefType(mapping);
        ArtifactReferenceImpl.ArtifactType artType = ((ArtifactReferenceImpl)mapping).getArtifactType();
        for (MappingType map : mappings) {
            if (map.getMaintenanceAliasKey().equals(maintenanceAliasKey)) {
                switch (artType) {
                    case component: {
                        updated = this.addArtifactToList(map.getComponent(), specifiedRefType);
                        break;
                    }
                    case featureSet: {
                        updated = this.addArtifactToList(map.getFeatureSet(), specifiedRefType);
                        break;
                    }
                    case distribution: {
                        updated = this.addArtifactToList(map.getDistribution(), specifiedRefType);
                    }
                }
                continue;
            }
            switch (artType) {
                case component: {
                    if (!this.isContainedInList(map.getComponent(), specifiedRefType)) break;
                    updated = this.deleteArtifactFromList(map.getComponent(), specifiedRefType);
                    break;
                }
                case featureSet: {
                    if (!this.isContainedInList(map.getFeatureSet(), specifiedRefType)) break;
                    updated = this.deleteArtifactFromList(map.getFeatureSet(), specifiedRefType);
                    break;
                }
                case distribution: {
                    if (!this.isContainedInList(map.getDistribution(), specifiedRefType)) break;
                    updated = this.deleteArtifactFromList(map.getDistribution(), specifiedRefType);
                }
            }
        }
        if (updated && save) {
            this.save();
        }
        return updated;
    }

    public boolean deleteMaintenanceAlias(MaintenanceAlias maintenanceAlias) throws MaintenanceAliasException {
        return this.deleteMaintenanceAlias(maintenanceAlias, false);
    }

    public boolean deleteMaintenanceAlias(MaintenanceAlias maintenanceAlias, boolean save) throws MaintenanceAliasException {
        boolean deleted = false;
        List<MaintenanceAliasType> aliases = this._info.getAliases();
        if (aliases == null || aliases.isEmpty()) {
            throw new MaintenanceAliasException("Failed to delete Maintenance Alias: " + maintenanceAlias.getMaintenanceAliasKey());
        }
        Iterator<MaintenanceAliasType> iter = aliases.iterator();
        while (iter.hasNext()) {
            MaintenanceAliasType alias = iter.next();
            if (!alias.getMaintenanceAliasKey().equals(maintenanceAlias.getMaintenanceAliasKey())) continue;
            iter.remove();
            deleted = true;
        }
        if (deleted && save) {
            this.save();
        }
        return deleted;
    }

    public boolean deleteMaintenanceAliasMapping(String maintenanceAliasKey, ArtifactReference mapping) throws MaintenanceAliasException {
        return this.deleteMaintenanceAliasMapping(maintenanceAliasKey, mapping, false);
    }

    public boolean deleteMaintenanceAliasMapping(MaintenanceAlias maintenanceAlias, ArtifactReference mapping, boolean save) throws MaintenanceAliasException {
        return this.deleteMaintenanceAliasMapping(maintenanceAlias.getMaintenanceAliasKey(), mapping, save);
    }

    public boolean deleteMaintenanceAliasMapping(String maintenanceAliasKey, ArtifactReference mapping, boolean save) throws MaintenanceAliasException {
        boolean deleted = false;
        List<MappingType> mappings = this._info.getMappings();
        if (mappings == null || mappings.isEmpty()) {
            throw new MaintenanceAliasException("Failed to delete Maintenance Alias Mapping: " + mapping.toString());
        }
        ArtifactRefType specifiedRefType = this.toArtifactRefType(mapping);
        ArtifactReferenceImpl.ArtifactType artType = ((ArtifactReferenceImpl)mapping).getArtifactType();
        for (MappingType map : mappings) {
            if (!map.getMaintenanceAliasKey().equals(maintenanceAliasKey)) continue;
            switch (artType) {
                case component: {
                    deleted = this.deleteArtifactFromList(map.getComponent(), specifiedRefType);
                    break;
                }
                case featureSet: {
                    deleted = this.deleteArtifactFromList(map.getFeatureSet(), specifiedRefType);
                    break;
                }
                case distribution: {
                    deleted = this.deleteArtifactFromList(map.getDistribution(), specifiedRefType);
                }
            }
        }
        if (deleted && save) {
            this.save();
        }
        return deleted;
    }

    public void save() throws MaintenanceAliasException {
        this._info.saveToFile();
    }

    private ArtifactRefType toArtifactRefType(ArtifactReference mapping) {
        ArtifactRefType refType = new ArtifactRefType();
        refType.setName(mapping.getName());
        refType.setVersion(mapping.getVersion());
        return refType;
    }

    private boolean addArtifactToList(List<ArtifactRefType> list, ArtifactRefType artifactRef) {
        boolean isAdded = true;
        for (ArtifactRefType arti : list) {
            if (!this.isSameArtifact(arti, artifactRef)) continue;
            return false;
        }
        list.add(artifactRef);
        return isAdded;
    }

    private boolean deleteArtifactFromList(List<ArtifactRefType> list, ArtifactRefType artifactRef) {
        boolean isDeleted = false;
        Iterator<ArtifactRefType> iter = list.iterator();
        while (iter.hasNext()) {
            ArtifactRefType item = iter.next();
            if (!this.isSameArtifact(item, artifactRef)) continue;
            iter.remove();
            isDeleted = true;
        }
        return isDeleted;
    }

    private boolean isContainedInList(List<ArtifactRefType> list, ArtifactRefType artifactRef) {
        for (ArtifactRefType ar : list) {
            if (!this.isSameArtifact(ar, artifactRef)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameArtifact(ArtifactRefType art1, ArtifactRefType art2) {
        boolean isSame = false;
        if (art1.getName().equals(art2.getName()) && art1.getVersion().equals(art2.getVersion())) {
            isSame = true;
        }
        return isSame;
    }
}

