/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.utils.LocalUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatchCompositeDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static String PATCH = "patch";
    private static String ID = "id";
    private static String UPI = "upi";
    private static String SERIES = "series";
    private static String REPLACES_SERIES = "replaces_series";
    private static String REPLACES_UPIS = "replaces_upis";
    private Document doc = null;
    private List<String> listSubpatchIds = null;
    private String compositeFileLoc = null;

    public PatchCompositeDAO(String compositeFile) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchCompositeDAO constructor (file)...");
        try {
            Path fXmlFile = NioServiceFactory.getNioService().getPath(compositeFile, new String[0]);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            try (InputStream inputStream = Files.newInputStream(fXmlFile, new OpenOption[0]);){
                this.doc = dBuilder.parse(inputStream);
            }
            this.doc.getDocumentElement().normalize();
            this.compositeFileLoc = compositeFile;
        }
        catch (ParserConfigurationException pe) {
            throw new PatchMetadataLoadingException("Failed to configure xml parser for composite.xml", (Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PatchMetadataLoadingException("Failed to read composite.xml file", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new PatchMetadataLoadingException("Failed to parse composite.xml file", (Throwable)se);
        }
        this.logger.info("Done PatchCompositeDAO constructor (file)...");
    }

    public PatchCompositeDAO(InputStream zis) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchCompositeDAO constructor (stream )...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(zis);
            this.doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException pe) {
            throw new PatchMetadataLoadingException("Failed to configure xml parser for composite.xml stream", (Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PatchMetadataLoadingException("Failed to read composite.xml stream", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new PatchMetadataLoadingException("Failed to parse composite.xml stream", (Throwable)se);
        }
        this.logger.info("Done PatchCompositeDAO constructor (stream)...");
    }

    public void save(String xmlFile) throws PatchMetadataWritingException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(xmlFile, new String[0]), new OpenOption[0]);){
                transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
            }
        }
        catch (TransformerException te) {
            throw new PatchMetadataWritingException("Failed transformation while writing out composite.xml file " + xmlFile, (Throwable)te);
        }
        catch (IOException fnfe) {
            throw new PatchMetadataWritingException("Failed to write to file composite.xml file " + xmlFile, (Throwable)fnfe);
        }
    }

    public void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + dir + " for cloning composite.xml data");
            }
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning composite.xml data");
        }
        String fileFullName = destinationPatchLoc + Constants.PATH + Constants.COMPOSITE_XML;
        this.save(fileFullName);
    }

    public List<String> getSubpatchIDs() {
        if (this.listSubpatchIds != null) {
            return this.listSubpatchIds;
        }
        ArrayList<String> result = new ArrayList<String>();
        NodeList nList = this.doc.getElementsByTagName(PATCH);
        for (int i = 0; i < nList.getLength(); ++i) {
            Node nNode = nList.item(i);
            if (nNode.getNodeType() != 1) continue;
            result.add(((Element)nNode).getAttribute(ID));
        }
        this.listSubpatchIds = result;
        return result;
    }

    public String getCompositePatchId() {
        if (this.listSubpatchIds != null) {
            return this.listSubpatchIds.get(this.listSubpatchIds.size() - 1);
        }
        ArrayList<String> result = new ArrayList<String>();
        NodeList nList = this.doc.getElementsByTagName(PATCH);
        for (int i = 0; i < nList.getLength(); ++i) {
            Node nNode = nList.item(i);
            if (nNode.getNodeType() != 1) continue;
            result.add(((Element)nNode).getAttribute(ID));
        }
        this.listSubpatchIds = result;
        return this.listSubpatchIds.get(this.listSubpatchIds.size() - 1);
    }

    public String getSeries() {
        String series = LocalUtils.getValue(this.doc, SERIES, this.compositeFileLoc);
        if (series == null) {
            this.logger.info("BP_SERIES does not exist in this composite patch" + this.compositeFileLoc);
        }
        return series;
    }

    public String getReplacesSeries() {
        String series = LocalUtils.getValue(this.doc, REPLACES_SERIES, this.compositeFileLoc);
        if (series == null) {
            this.logger.info("REPLACES_SERIES does not exist in this composite patch" + this.compositeFileLoc);
        }
        return series;
    }

    public List<String> getReplacesUPIs() {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nList = this.doc.getElementsByTagName(REPLACES_UPIS);
        if (nList == null || nList.getLength() == 0) {
            this.logger.info("REPLACES_UPIS does not exist in this composite patch" + this.compositeFileLoc);
            return result;
        }
        Node overridingNode = nList.item(0);
        if (overridingNode.getNodeType() == 1) {
            Element eElement = (Element)overridingNode;
            NodeList upiList = eElement.getElementsByTagName(UPI);
            for (int i = 0; i < upiList.getLength(); ++i) {
                Node nNode = upiList.item(i);
                result.add(((Element)nNode).getTextContent());
            }
        }
        return result;
    }
}

