/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.install;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchInfo;

public class PatchInfoImpl
implements PatchInfo {
    private String _patchId;
    private String _patchUpi;
    private PatchSubType _patchSubType;
    private Map<ComponentInfo, ComponentCheckResult> _patchComponents;
    private List<InventoryComponentInfo> _inventoryComponents;
    private Map<FileState, List<Path>> _affectedPaths;
    private boolean _rollback;
    private List<String> _bugList;
    private String _description;
    private List<String> _preReqs;
    private List<Locale> _languages;
    private List<String> _supersededPatches;
    private Calendar _appliedDate;
    private boolean _metaDataPatch;

    PatchInfoImpl(String patchId, String patchUpi, PatchSubType patchSubType, Map<ComponentInfo, ComponentCheckResult> patchComponents, List<InventoryComponentInfo> inventoryComponents, Map<FileState, List<Path>> affectedFiles, boolean rollback, List<String> bugList, String description, List<String> preReqs, List<Locale> languages, List<String> supersededPatches, Calendar appliedDate, boolean metaDataPatch) {
        this._patchId = patchId;
        this._patchUpi = patchUpi;
        this._patchSubType = patchSubType;
        this._patchComponents = patchComponents;
        this._inventoryComponents = inventoryComponents;
        this._affectedPaths = affectedFiles;
        this._rollback = rollback;
        this._bugList = bugList;
        this._description = description;
        this._preReqs = preReqs;
        this._languages = languages;
        this._supersededPatches = supersededPatches;
        this._appliedDate = appliedDate;
        this._metaDataPatch = metaDataPatch;
    }

    public String getPatchId() {
        return this._patchId;
    }

    public String getPatchUpi() {
        return this._patchUpi;
    }

    public PatchSubType getPatchSubType() {
        return this._patchSubType;
    }

    public Map<ComponentInfo, ComponentCheckResult> getPatchComponents() {
        return this._patchComponents;
    }

    public List<InventoryComponentInfo> getInventoryComponents() {
        return this._inventoryComponents;
    }

    @Deprecated
    public Map<FileState, List<File>> getAffectedFiles() {
        HashMap<FileState, List<File>> affectedFiles = new HashMap<FileState, List<File>>();
        for (FileState fileState : this._affectedPaths.keySet()) {
            ArrayList<File> files = new ArrayList<File>();
            List<Path> paths = this._affectedPaths.get(fileState);
            for (Path path : paths) {
                files.add(path.toFile());
            }
            affectedFiles.put(fileState, files);
        }
        return affectedFiles;
    }

    public Map<FileState, List<Path>> getAffectedPaths() {
        return this._affectedPaths;
    }

    public boolean isRollBack() {
        return this._rollback;
    }

    public List<String> getBugList() {
        return this._bugList;
    }

    public String getDescription() {
        return this._description;
    }

    public List<String> getPreReqs() {
        return this._preReqs;
    }

    public List<Locale> getLanguages() {
        return this._languages;
    }

    public List<String> getSupersededPatches() {
        return this._supersededPatches;
    }

    public Calendar getAppliedDate() {
        return this._appliedDate;
    }

    public boolean isMetaDataPatch() {
        return this._metaDataPatch;
    }

    public static PatchInfo.Builder builder() {
        return new Builder();
    }

    static class Builder
    implements PatchInfo.Builder {
        private String patchId;
        private String patchUpi;
        private PatchSubType patchSubType;
        private Map<ComponentInfo, ComponentCheckResult> patchComponents;
        private List<InventoryComponentInfo> inventoryComponents;
        private Map<FileState, List<Path>> affectedFiles;
        private boolean rollBack;
        private List<String> bugList;
        private String description;
        private List<String> preReqs;
        private List<Locale> languages;
        private List<String> supersededPatches;
        private Calendar appliedDate;
        private boolean metaDataPatch;

        Builder() {
        }

        public PatchInfo.Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public PatchInfo.Builder patchUpi(String patchUpi) {
            this.patchUpi = patchUpi;
            return this;
        }

        public PatchInfo.Builder patchSubType(PatchSubType patchSubType) {
            this.patchSubType = patchSubType;
            return this;
        }

        public PatchInfo.Builder patchComponents(Map<ComponentInfo, ComponentCheckResult> patchComponents) {
            this.patchComponents = patchComponents;
            return this;
        }

        public PatchInfo.Builder inventoryComponents(List<InventoryComponentInfo> inventoryComponents) {
            this.inventoryComponents = inventoryComponents;
            return this;
        }

        @Deprecated
        public PatchInfo.Builder affectedFiles(Map<FileState, List<File>> affectedFiles) {
            HashMap<FileState, List<Path>> affectedPaths = new HashMap<FileState, List<Path>>();
            if (affectedFiles != null) {
                for (FileState fileState : affectedFiles.keySet()) {
                    ArrayList<Path> paths = new ArrayList<Path>();
                    List<File> files = affectedFiles.get(fileState);
                    for (File file : files) {
                        paths.add(NioServiceFactory.getNioService().getPath(file));
                    }
                    affectedPaths.put(fileState, paths);
                }
            }
            return this.affectedPaths(affectedPaths);
        }

        public PatchInfo.Builder affectedPaths(Map<FileState, List<Path>> affectedPaths) {
            this.affectedFiles = affectedPaths;
            return this;
        }

        public PatchInfo.Builder rollBack(boolean rollBack) {
            this.rollBack = rollBack;
            return this;
        }

        public PatchInfo.Builder bugList(List<String> bugList) {
            this.bugList = bugList;
            return this;
        }

        public PatchInfo.Builder description(String description) {
            this.description = description;
            return this;
        }

        public PatchInfo.Builder preReqs(List<String> preReqs) {
            this.preReqs = preReqs;
            return this;
        }

        public PatchInfo.Builder languages(List<Locale> languages) {
            this.languages = languages;
            return this;
        }

        public PatchInfo.Builder supersededPatches(List<String> supersededPatches) {
            this.supersededPatches = supersededPatches;
            return this;
        }

        public PatchInfo.Builder appliedDate(Calendar appliedDate) {
            this.appliedDate = appliedDate;
            return this;
        }

        public PatchInfo.Builder metaDataPatch(boolean metaDataPatch) {
            this.metaDataPatch = metaDataPatch;
            return this;
        }

        public PatchInfo build() {
            return new PatchInfoImpl(this.patchId, this.patchUpi, this.patchSubType, this.patchComponents, this.inventoryComponents, this.affectedFiles, this.rollBack, this.bugList, this.description, this.preReqs, this.languages, this.supersededPatches, this.appliedDate, this.metaDataPatch);
        }
    }
}

