/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.SystemPatchZip;
import oracle.glcm.opatch.common.api.SystemSubpatchInfo;

public class CheckFixedBugsInSystemPatch {
    public static void main(String[] args) {
        LogManager.getLogManager().getLogger("").setLevel(Level.SEVERE);
        String zipfile = args[0];
        try {
            FileInputStream is = new FileInputStream(zipfile);
            PatchFactory fac = BasePatchFactory.instance();
            SystemPatchZip spz = fac.createSystemPatchZip((InputStream)is);
            HashMap map = spz.getFixedBugs();
            CheckFixedBugsInSystemPatch.printFixedBugs(map);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PatchMetadataLoadingException e) {
            e.printStackTrace();
        }
    }

    static void printFixedBugs(HashMap<SystemSubpatchInfo, HashSet<String>> map) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<SystemSubpatchInfo, HashSet<String>> entry : map.entrySet()) {
            SystemSubpatchInfo key = entry.getKey();
            HashSet<String> set = entry.getValue();
            sb.append("\nSubpatchInfo:" + key + ", Bugs fixed:" + set);
        }
        System.out.println(sb.toString());
    }
}

