/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.cont;

import com.oracle.cie.common.ui.gui.GUIHelper;
import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.ui.gui.ImagePanel;
import com.oracle.cie.common.ui.gui.SplashWindow;
import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardState;
import com.oracle.cie.wizard.event.WizardTaskActionEvent;
import com.oracle.cie.wizard.event.WizardTaskActionListener;
import com.oracle.cie.wizard.event.WizardWorkflowEvent;
import com.oracle.cie.wizard.event.WizardWorkflowListener;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.GUITaskContextProperties;
import com.oracle.cie.wizard.gui.TitlePanel;
import com.oracle.cie.wizard.gui.msgpanel.MessageKey;
import com.oracle.cie.wizard.gui.msgpanel.MessagePanel;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import com.oracle.cie.wizard.gui.msgpanel.impl.MessagePanelImpl;
import com.oracle.cie.wizard.gui.roadmap.Roadmap;
import com.oracle.cie.wizard.gui.roadmap.RoadmapMngmt;
import com.oracle.cie.wizard.gui.tasks.GUITask;
import com.oracle.cie.wizard.help.HelpDelegate;
import com.oracle.cie.wizard.help.HelpProvider;
import com.oracle.cie.wizard.help.HelpProviderException;
import com.oracle.cie.wizard.internal.cont.DefaultTaskContext;
import com.oracle.cie.wizard.internal.cont.GUITaskContainer;
import com.oracle.cie.wizard.wcf.TaskEntry;
import com.oracle.cie.wizard.wcf.UITaskEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

class GUIContext
extends DefaultTaskContext
implements GUITaskContext,
GUITaskContextProperties,
WizardWorkflowListener,
WizardTaskActionListener {
    public static final String DEFAULT_GUI_CONTEXT_IMAGE_ICON = "resources/wizard/images/oracle_Logo.png";
    public static final int DEFAULT_CONTEXT_WIDTH = 800;
    public static final int DEFAULT_CONTEXT_HEIGHT = 600;
    protected static final int DEFAULT_TASK_PANEL_HEIGHT = 400;
    protected static final int DEFAULT_ROADMAP_WIDTH = 200;
    protected static final int BTN_MOUSECLICK_THRESHOLD = 300;
    protected static final String DEFAULT_ROADMAP_IMPL = "com.oracle.cie.wizard.gui.roadmap.impl.WizRoadmap";
    protected static final Logger _log = Logger.getLogger(GUIContext.class.getName());
    protected static final Level[] LOG_KEY_LEVELS = new Level[]{null, Level.SEVERE, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.OFF};
    protected static final String LOG_KEY_MODIFIER = "alt";
    protected GUITaskContainer _parent;
    protected Map<String, Object> _props = new HashMap<String, Object>();
    protected Window _splashWindow;
    protected JFrame _frame;
    protected JPanel _contentPane;
    protected Image _companyLogo;
    protected MessageFormat _frameTitleFormat;
    protected List<UITaskEntryHolder> _uiTasks = new ArrayList<UITaskEntryHolder>();
    protected int _currentStep = -1;
    protected boolean _isSizeSetExternally;
    protected JWindow _cleanupWindow;
    protected TitlePanelImpl _titlePanel;
    protected RoadmapMngmt _roadmap;
    protected JPanel _taskContainerPanel;
    protected JComponent _taskUIComp;
    protected JPanel _taskMessageWrapper;
    protected JSplitPane _taskMessageSplit;
    protected MessagePanelImpl _messagePanel;
    protected Map<GUITaskContext.ButtonType, ButtonHolder> _buttons = new HashMap<GUITaskContext.ButtonType, ButtonHolder>();
    protected HelpProvider _help;
    protected ActionListener _contextActionListener;
    protected KeyEventDispatcher _keyEventDispatcher;
    protected boolean _consumeKeyEvents = false;
    protected JPanel _centralPanel;
    protected JSplitPane _vSplit;
    protected JPanel _roadmapPanel;
    protected volatile boolean _enableMessageInterception;
    protected List<MessageHolder> _interceptedNonValidationMessages;
    protected List<MessageHolder> _interceptedValidationMessages;
    protected JComponent _bypassedTaskComp;
    private volatile boolean _encounteredDialogInBypass;
    private boolean _enableFastFinish;

    GUIContext(GUITaskContainer parent) {
        super(parent.getProxy());
        this._parent = parent;
        if (!this._proxy.isEmbeddedProcess()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showSplashScreen();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIContext.this.showSplashScreen();
                    }
                });
            }
        }
    }

    @Override
    public Map<String, Object> getContextProperties() {
        return Collections.unmodifiableMap(this._props);
    }

    @Override
    public Object getContextProperty(String key) {
        return this._props.get(key);
    }

    @Override
    public void setIcon(Image image) {
        if (this.checkThread()) {
            this._frame.setIconImage(image);
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (this.checkThread()) {
            if (this._isSizeSetExternally) {
                _log.finer("Frame size was set externally. Disallowing resizing.");
            } else {
                this._frame.setSize(new Dimension(width, height));
            }
        }
    }

    @Override
    public Dimension getSize() {
        return this._frame.getSize();
    }

    @Override
    public void setResizable(boolean value) {
        if (this.checkThread()) {
            this._frame.setResizable(value);
        }
    }

    @Override
    public boolean isResizable() {
        return this._frame.isResizable();
    }

    @Override
    public void setVisible(boolean b) {
        if (this.checkThread()) {
            this._frame.setVisible(b);
        }
    }

    @Override
    public boolean isVisible() {
        return this._frame.isVisible();
    }

    @Override
    public void setMessagePanelVisible(boolean b) {
        for (Component c : this._taskMessageWrapper.getComponents()) {
            if (c == this._taskMessageSplit) {
                if (b) break;
                this._taskMessageWrapper.remove(this._taskMessageSplit);
                this._taskMessageSplit.remove(this._taskContainerPanel);
                this._taskMessageWrapper.add((Component)this._taskContainerPanel, "Center");
                this._taskMessageWrapper.revalidate();
                break;
            }
            if (c != this._taskContainerPanel) continue;
            if (!b) break;
            this._taskMessageWrapper.remove(this._taskContainerPanel);
            this._taskMessageSplit.setTopComponent(this._taskContainerPanel);
            this._taskMessageSplit.setDividerLocation(400);
            this._taskMessageWrapper.add((Component)this._taskMessageSplit, "Center");
            this._taskMessageWrapper.revalidate();
            break;
        }
    }

    @Override
    public boolean isMessagePanelVisible() {
        for (Component c : this._taskMessageWrapper.getComponents()) {
            if (c != this._taskContainerPanel) continue;
            return false;
        }
        return true;
    }

    @Override
    public void enableInput(boolean b) {
        boolean bl = this._consumeKeyEvents = !b;
        if (this.checkThread()) {
            this._frame.setCursor(b ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(3));
            this._frame.getGlassPane().setVisible(!b);
        }
    }

    @Override
    public boolean isInputEnabled() {
        return !this._consumeKeyEvents;
    }

    @Override
    public void enableForwardNavigation(boolean b) {
        if (this.checkThread()) {
            boolean bl = b = b && !this._messagePanel.hasValidationMessage(MessageType.ERROR);
            if (this._roadmap != null) {
                this._roadmap.getRoadmap().enableForwardNavigation(b);
            }
            this._buttons.get((Object)GUITaskContext.ButtonType.NEXT).setEnabled(b, false);
            this._buttons.get((Object)GUITaskContext.ButtonType.FINISH).setEnabled(b, false);
        }
    }

    @Override
    public boolean isForwardNavigationEnabled() {
        return this._buttons.get((Object)GUITaskContext.ButtonType.NEXT).isEnabled() || this._buttons.get((Object)GUITaskContext.ButtonType.FINISH).isEnabled();
    }

    @Override
    public void enableReverseNavigation(boolean b) {
        if (this.checkThread()) {
            if (this._roadmap != null) {
                this._roadmap.getRoadmap().enableReverseNavigation(b);
            }
            this._buttons.get((Object)GUITaskContext.ButtonType.BACK).setEnabled(b, false);
        }
    }

    @Override
    public boolean isReverseNavigationEnabled() {
        return this._buttons.get((Object)GUITaskContext.ButtonType.BACK).isEnabled();
    }

    @Override
    public void setRoadmapVisible(boolean value) {
        for (Component component : this._centralPanel.getComponents()) {
            if (component == this._vSplit) {
                if (value) break;
                this._centralPanel.remove(this._vSplit);
                this._vSplit.remove(this._roadmapPanel);
                this._centralPanel.add((Component)this._taskMessageWrapper, "Center");
                this._centralPanel.revalidate();
                break;
            }
            if (component != this._taskMessageWrapper) continue;
            if (!value) break;
            this._centralPanel.remove(this._taskMessageWrapper);
            this._vSplit.setTopComponent(this._roadmapPanel);
            this._vSplit.setDividerLocation(200);
            this._vSplit.setBottomComponent(this._taskMessageWrapper);
            this._centralPanel.add((Component)this._vSplit, "Center");
            this._centralPanel.revalidate();
            break;
        }
    }

    @Override
    public boolean isRoadmapVisible() {
        for (Component component : this._centralPanel.getComponents()) {
            if (component != this._vSplit) continue;
            return true;
        }
        return false;
    }

    @Override
    public void allowUserInteractionForRoadmap(boolean value) {
        if (this._roadmap != null) {
            this._roadmap.getRoadmap().enableUserInteraction(value);
        }
    }

    @Override
    public boolean isUserInteractionForRoadmapAllowed() {
        return this._roadmap != null && this._roadmap.getRoadmap().isUserInteractionEnabled();
    }

    @Override
    public void enableFlowActions(boolean b) {
        if (this.checkThread()) {
            this.enableForwardNavigation(b);
            this.enableReverseNavigation(b);
            this._buttons.get((Object)GUITaskContext.ButtonType.CANCEL).setEnabled(b, false);
        }
    }

    @Override
    public boolean areAllFlowActionsEnabled() {
        return this.isForwardNavigationEnabled() || this.isReverseNavigationEnabled() || this._buttons.get((Object)GUITaskContext.ButtonType.CANCEL).isEnabled();
    }

    @Override
    public void setFrameTitle(String title) {
        if (this.checkThread()) {
            try {
                this._frameTitleFormat = new MessageFormat(title);
                if (title != null && title.equals(this._frameTitleFormat.format(new Object[]{this._currentStep == -1 ? 1 : this._currentStep + 1, this._uiTasks.size()}))) {
                    this._frameTitleFormat = null;
                    this._frame.setTitle(title);
                } else {
                    this.substituteFrameTitle();
                }
            }
            catch (Throwable ex) {
                this._frameTitleFormat = null;
                this._frame.setTitle(title);
            }
        }
    }

    @Override
    public String getFrameTitle() {
        return this._frame.getTitle();
    }

    @Override
    public void setPanelTitle(String title) {
        if (this.checkThread() && this._titlePanel != null) {
            this._titlePanel.setTitle(title);
        }
    }

    @Override
    public String getPanelTitle() {
        return this._titlePanel == null ? null : this._titlePanel.getTitle();
    }

    @Override
    public void setCurrentStepDisplayTitleForRoadmap(String title) {
        if (this._roadmap != null && title != null && !title.equals("")) {
            this._roadmap.getRoadmap().setCurrentStepDisplayTitle(title);
        }
    }

    @Override
    public void configureButtonDefault(GUITaskContext.ButtonType type, String text, String mnemonic, String tooltip) {
        this.configureButton(type, GUIUtilities.insertMnemonic((String)text, (String)mnemonic), tooltip, true);
    }

    @Override
    public void configureButtonDefault(GUITaskContext.ButtonType type, String text, String tooltip) {
        this.configureButton(type, text, tooltip, true);
    }

    @Override
    public void configureButton(GUITaskContext.ButtonType type, String text, String mnemonic, String tooltip) {
        this.configureButton(type, GUIUtilities.insertMnemonic((String)text, (String)mnemonic), tooltip, false);
    }

    @Override
    public void configureButton(GUITaskContext.ButtonType type, String text, String tooltip) {
        this.configureButton(type, text, tooltip, false);
    }

    @Override
    public void setVisibleButtonState(GUITaskContext.ButtonType type, boolean value) {
        ButtonHolder btn;
        if (this.checkThread() && (btn = this._buttons.get((Object)type)) != null) {
            btn.setVisible(value);
        }
    }

    @Override
    public void setEnabledButtonState(GUITaskContext.ButtonType type, boolean value) {
        ButtonHolder btn;
        if (this.checkThread() && (btn = this._buttons.get((Object)type)) != null) {
            btn.setEnabled(value, true);
        }
    }

    @Override
    public void setEnableFastFinish(boolean value) {
        this._enableFastFinish = value;
    }

    @Override
    public void requestButtonFocus(GUITaskContext.ButtonType type) {
        ButtonHolder btn;
        if (this.checkThread() && (btn = this._buttons.get((Object)type)) != null && btn.isEnabled()) {
            btn.getButton().requestFocus();
        }
    }

    @Override
    public void setHelpProvider(HelpProvider help) {
        this._help = help;
        this.setEnabledButtonState(GUITaskContext.ButtonType.HELP, this._help != null);
    }

    @Override
    public TitlePanel getTitlePanel() {
        return this._titlePanel;
    }

    @Override
    public MessagePanel getMessagePanel() {
        return this._messagePanel;
    }

    @Override
    public Roadmap getRoadmap() {
        return this._roadmap == null ? null : this._roadmap.getRoadmap();
    }

    @Override
    public JComponent getTaskUIComponent() {
        return this._taskUIComp;
    }

    @Override
    public void addValidationMessage(PublishedMessage msg, JComponent ... comps) {
        if (msg == null) {
            _log.log(Level.WARNING, "Invalid message: null", new Exception("Message is null"));
            return;
        }
        this.addValidationMessage(this.getMessageType(msg), msg.getMessageText(), msg.getSubstitutedCause(), comps);
    }

    @Override
    public void addValidationMessage(MessageType type, String text, String details, JComponent ... comps) {
        if (type == null || text == null || details == null) {
            _log.log(Level.WARNING, "Invalid call: message type [" + (Object)((Object)type) + "], text [" + text + "], details [" + details + "]", new Exception("Invalid message"));
            return;
        }
        if (this._enableMessageInterception) {
            this.interceptMessage(new MessageHolder(this.getMethod("addValidationMessage", MessageType.class, String.class, String.class, JComponent[].class), type, new Object[]{type, text, details, comps}));
            return;
        }
        try {
            this._messagePanel.addValidationMessage(type, text, details, comps);
            if (type == MessageType.ERROR) {
                this.setRoadmapErrorState(true);
            }
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public void addValidationMessage(PublishedMessage msg, MessageKey ... keys) {
        if (msg == null) {
            _log.log(Level.WARNING, "Invalid message: null", new Exception("Message is null"));
            return;
        }
        this.addValidationMessage(this.getMessageType(msg), msg.getMessageText(), msg.getSubstitutedCause(), keys);
    }

    @Override
    public void addValidationMessage(MessageType type, String text, String details, MessageKey ... keys) {
        if (type == null || text == null || details == null) {
            _log.log(Level.WARNING, "Invalid call: message type [" + (Object)((Object)type) + "], text [" + text + "], details [" + details + "]", new Exception("Invalid message"));
            return;
        }
        if (this._enableMessageInterception) {
            this.interceptMessage(new MessageHolder(this.getMethod("addValidationMessage", MessageType.class, String.class, String.class, MessageKey[].class), type, new Object[]{type, text, details, keys}));
            return;
        }
        try {
            this._messagePanel.addValidationMessage(type, text, details, keys);
            if (type == MessageType.ERROR) {
                this.setRoadmapErrorState(true);
            }
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public void addPanelValidationMessage(PublishedMessage msg) {
        if (msg == null) {
            _log.log(Level.WARNING, "Invalid message: null", new Exception("Message is null"));
            return;
        }
        this.addPanelValidationMessage(this.getMessageType(msg), msg.getMessageText(), msg.getSubstitutedCause());
    }

    @Override
    public void addPanelValidationMessage(MessageType type, String text, String details) {
        if (type == null || text == null || details == null) {
            _log.log(Level.WARNING, "Invalid call: message type [" + (Object)((Object)type) + "], text [" + text + "], details [" + details + "]", new Exception("Invalid message"));
            return;
        }
        if (this._enableMessageInterception) {
            this.interceptMessage(new MessageHolder(this.getMethod("addPanelValidationMessage", MessageType.class, String.class, String.class), type, new Object[]{type, text, details}));
            return;
        }
        this._messagePanel.addPanelValidationMessage(type, text, details);
        if (type == MessageType.ERROR) {
            this.setRoadmapErrorState(true);
        }
    }

    private void interceptMessage(MessageHolder holder) {
        switch (holder._type) {
            case ERROR: 
            case WARNING: {
                if (this._interceptedValidationMessages == null) {
                    this._interceptedValidationMessages = new LinkedList<MessageHolder>();
                }
                this._interceptedValidationMessages.add(holder);
                break;
            }
            default: {
                if (this._interceptedNonValidationMessages == null) {
                    this._interceptedNonValidationMessages = new LinkedList<MessageHolder>();
                }
                this._interceptedNonValidationMessages.add(holder);
            }
        }
    }

    private Method getMethod(String name, Class<?> ... parameterTypes) {
        try {
            return GUIContext.class.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void clearValidationMessages(JComponent comp) {
        try {
            this._messagePanel.clearValidationMessages(comp);
            if (!this._messagePanel.hasValidationMessage(MessageType.ERROR)) {
                this.setRoadmapErrorState(false);
            }
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public void clearValidationMessages(MessageKey key) {
        try {
            this._messagePanel.clearValidationMessages(key);
            if (!this._messagePanel.hasValidationMessage(MessageType.ERROR)) {
                this.setRoadmapErrorState(false);
            }
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public void clearPanelValidationMessages() {
        this._messagePanel.clearPanelValidationMessages();
        if (!this._messagePanel.hasValidationMessage(MessageType.ERROR)) {
            this.setRoadmapErrorState(false);
        }
    }

    private void setRoadmapErrorState(boolean error) {
        if (this._roadmap != null) {
            this._roadmap.getRoadmap().setErrorState(error);
        }
        this.enableForwardNavigation(!error);
    }

    private MessageType getMessageType(PublishedMessage msg) {
        MessageType type = MessageType.ERROR;
        switch (msg.getType()) {
            case TRACE: 
            case NOTIFICATION: {
                type = MessageType.INFORMATION;
                break;
            }
            case WARNING: {
                type = MessageType.WARNING;
                break;
            }
            case ERROR: 
            case FAULT: {
                type = MessageType.ERROR;
            }
        }
        return type;
    }

    @Override
    public void clearAllValidationMessages() {
        this._messagePanel.clearAllValidationMessages();
        if (this._roadmap != null) {
            this._roadmap.getRoadmap().setErrorState(false);
        }
        this.enableForwardNavigation(true);
    }

    @Override
    public void setMessagePanelText(Object obj, MessageType type, String message) {
        this._messagePanel.setNonValidationMessage(obj, type, message);
    }

    @Override
    public void showMessagePanelBillboard(boolean show) {
        this._messagePanel.showBillboard(show);
    }

    @Override
    public void setBillboardImage(String resource) {
        this._messagePanel.setBillboard(resource);
    }

    @Override
    public void showMessageDialog(String msg, int messageType) {
        this.showMessageDialog(msg, this.getDialogTitle(messageType), messageType);
    }

    @Override
    public void showMessageDialog(String msg, String title, int messageType) {
        if (this._enableMessageInterception) {
            this._encounteredDialogInBypass = true;
        } else {
            JOptionPane.showMessageDialog(this._frame, this.convertMsgObj(msg), title, messageType);
        }
    }

    @Override
    public void showMessageDialog(PublishedMessage msg, int messageType) {
        this.showMessageDialog(msg, this.getDialogTitle(messageType), messageType);
    }

    @Override
    public void showMessageDialog(PublishedMessage msg, String title, int messageType) {
        if (this._enableMessageInterception) {
            this._encounteredDialogInBypass = true;
        } else {
            JOptionPane.showMessageDialog(this._frame, this.convertMsgObj(msg), title, messageType);
        }
    }

    @Override
    public int showConfirmDialog(String msg, int optionType, int messageType) {
        return this.showConfirmDialog(msg, this.getDialogTitle(messageType), optionType, messageType);
    }

    @Override
    public int showConfirmDialog(String msg, int optionType, int messageType, String additionalTextMsg) {
        return this.showConfirmDialog(msg, this.getDialogTitle(messageType), optionType, messageType, additionalTextMsg);
    }

    @Override
    public int showConfirmDialog(String msg, String title, int optionType, int messageType) {
        if (this._enableMessageInterception) {
            this._encounteredDialogInBypass = true;
            return -1;
        }
        boolean oldState = this._consumeKeyEvents;
        this._consumeKeyEvents = false;
        int result = JOptionPane.showConfirmDialog(this._frame, this.convertMsgObj(msg), title, optionType, messageType);
        this._consumeKeyEvents = oldState;
        return result;
    }

    @Override
    public int showConfirmDialog(String msg, String title, int optionType, int messageType, String additionalTextMsg) {
        if (this._enableMessageInterception) {
            this._encounteredDialogInBypass = true;
            return -1;
        }
        boolean oldState = this._consumeKeyEvents;
        this._consumeKeyEvents = false;
        int result = JOptionPane.showConfirmDialog(this._frame, this.convertMsgObj(msg, additionalTextMsg), title, optionType, messageType);
        this._consumeKeyEvents = oldState;
        return result;
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, int optionType) {
        return this.showConfirmDialog(msg, optionType, this.getJOptionMessageType(msg));
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, int optionType, String additionalTextMsg) {
        return this.showConfirmDialog(msg, optionType, this.getJOptionMessageType(msg), additionalTextMsg);
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, int optionType, int messageType) {
        return this.showConfirmDialog(msg, this.getDialogTitle(messageType), optionType, messageType);
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, int optionType, int messageType, String additionalTextMsg) {
        return this.showConfirmDialog(msg, this.getDialogTitle(messageType), optionType, messageType, additionalTextMsg);
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, String title, int messageType) {
        return this.showConfirmDialog(msg, title, 0, messageType);
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, String title, int messageType, String additionalTextMsg) {
        return this.showConfirmDialog(msg, title, 0, messageType, additionalTextMsg);
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, String title, int optionType, int messageType) {
        if (this._enableMessageInterception) {
            this._encounteredDialogInBypass = true;
            return -1;
        }
        boolean oldState = this._consumeKeyEvents;
        this._consumeKeyEvents = false;
        int result = JOptionPane.showConfirmDialog(this._frame, this.convertMsgObj(msg), title, optionType, messageType);
        this._consumeKeyEvents = oldState;
        return result;
    }

    @Override
    public int showConfirmDialog(PublishedMessage msg, String title, int optionType, int messageType, String additionalTextMsg) {
        if (this._enableMessageInterception) {
            this._encounteredDialogInBypass = true;
            return -1;
        }
        boolean oldState = this._consumeKeyEvents;
        this._consumeKeyEvents = false;
        int result = JOptionPane.showConfirmDialog(this._frame, this.convertMsgObj(msg, additionalTextMsg), title, optionType, messageType);
        this._consumeKeyEvents = oldState;
        return result;
    }

    @Override
    public int showConfirmDialog(List<PublishedMessage> msgList, int optionType, int messageType) {
        return this.showConfirmDialog(msgList, this.getDialogTitle(messageType), optionType, messageType);
    }

    @Override
    public int showConfirmDialog(List<PublishedMessage> msgList, String title, int optionType, int messageType) {
        return this.showConfirmDialog(msgList, title, optionType, messageType, null);
    }

    @Override
    public int showConfirmDialog(List<PublishedMessage> msgList, int optionType, int messageType, String additionalTextMsg) {
        return this.showConfirmDialog(msgList, this.getDialogTitle(messageType), optionType, messageType, additionalTextMsg);
    }

    @Override
    public int showConfirmDialog(List<PublishedMessage> msgList, String title, int optionType, int messageType, String additionalTextMsg) {
        StringBuilder sb = new StringBuilder();
        for (PublishedMessage msg : msgList) {
            sb.append(((PublishedMessage)PublishedMessage.class.cast(msg)).getFullMessage(this.getHTMLPattern()));
            sb.append("<br><br>");
        }
        if (additionalTextMsg != null && !additionalTextMsg.isEmpty()) {
            sb.append(additionalTextMsg);
        }
        return this.showConfirmDialog(sb.toString(), title, optionType, messageType);
    }

    private String getHTMLPattern() {
        return ResourceBundleManager.getString((String)"comdev", (String)"PublishedMessage.htmlFormat.pattern");
    }

    public int getIntPropValue(String key, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(this.getString("wizard-internal", key));
        }
        catch (Throwable ex) {
            value = defaultValue;
        }
        this._props.put(key, value);
        return value;
    }

    void setupGUI(GUITask task, boolean forBypass) {
        if (this._frame == null) {
            this.initGUI();
        }
        this.clearAllInterceptedMessage();
        this._enableMessageInterception = forBypass;
        JComponent taskComp = task.createUI();
        task.startBackgroundProcess();
        if (forBypass) {
            this._bypassedTaskComp = taskComp;
        } else {
            this.addToFrame(task, taskComp);
        }
    }

    private void clearAllInterceptedMessage() {
        if (this._interceptedNonValidationMessages != null) {
            this._interceptedNonValidationMessages.clear();
        }
        if (this._interceptedValidationMessages != null) {
            this._interceptedValidationMessages.clear();
        }
    }

    public boolean areMessagesIntercepted() {
        return this._interceptedValidationMessages != null && !this._interceptedValidationMessages.isEmpty() || this._encounteredDialogInBypass;
    }

    void postBypassRecovery(GUITask task) {
        if (this._frame == null) {
            this.initGUI();
        }
        this.addToFrame(task, this._bypassedTaskComp);
        this._enableMessageInterception = false;
        this._encounteredDialogInBypass = false;
        this.invokeInterceptedMethod(this._interceptedNonValidationMessages);
        this.invokeInterceptedMethod(this._interceptedValidationMessages);
    }

    private void invokeInterceptedMethod(List<MessageHolder> messageHolders) {
        if (messageHolders == null || messageHolders.isEmpty()) {
            return;
        }
        for (MessageHolder holder : messageHolders) {
            try {
                Method method = holder._method;
                method.setAccessible(true);
                method.invoke((Object)this, holder._args);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void addToFrame(GUITask task, JComponent taskComp) {
        TaskEntry entry = task.getEntry();
        Boolean showMessagePanel = null;
        if (entry instanceof UITaskEntry) {
            UITaskEntry uiEntry = (UITaskEntry)entry;
            String namespace = entry.getNamespace();
            if (namespace != null) {
                String titleKey = uiEntry.getTitleKey();
                String title = this.substitute(namespace, this.getI18nString(namespace, titleKey));
                this.getTitlePanel().setTitle(title == null || title.isEmpty() ? titleKey : title);
            }
            showMessagePanel = uiEntry.showMessagePane();
            UITaskEntry.StepCategory cat = uiEntry.getCategory();
            this.setEnabledButtonState(GUITaskContext.ButtonType.BACK, this._currentStep != 0 && !entry.isReverseDisallowed() && cat != UITaskEntry.StepCategory.MILESTONE && cat != UITaskEntry.StepCategory.FINAL);
            this.setEnabledButtonState(GUITaskContext.ButtonType.NEXT, this._currentStep != this._uiTasks.size() - 1 && cat != UITaskEntry.StepCategory.FINAL && cat != UITaskEntry.StepCategory.SUMMARY);
            this.setEnabledButtonState(GUITaskContext.ButtonType.FINISH, cat == UITaskEntry.StepCategory.SUMMARY || cat == UITaskEntry.StepCategory.FINAL || uiEntry.enableFastCompletion());
            this.setEnabledButtonState(GUITaskContext.ButtonType.CANCEL, cat != UITaskEntry.StepCategory.FINAL);
            this._buttons.get((Object)GUITaskContext.ButtonType.BACK).resetAll();
            this._buttons.get((Object)GUITaskContext.ButtonType.NEXT).resetAll();
            this._buttons.get((Object)GUITaskContext.ButtonType.FINISH).resetAll();
            this._buttons.get((Object)GUITaskContext.ButtonType.CANCEL).resetAll();
        }
        if (taskComp != null && this._taskUIComp != taskComp) {
            if (this._splashWindow != null) {
                this._splashWindow.dispose();
                this._splashWindow = null;
            }
            this._taskUIComp = taskComp;
            this._taskContainerPanel.removeAll();
            if (showMessagePanel != null && this.isMessagePanelVisible() != showMessagePanel.booleanValue()) {
                this.setMessagePanelVisible(showMessagePanel);
            }
            this._taskContainerPanel.add((Component)taskComp, "Center");
            this._taskContainerPanel.revalidate();
            if (!this._frame.isVisible()) {
                this._frame.setVisible(true);
            }
            this.enableInput(true);
            this.requestButtonFocus(GUITaskContext.ButtonType.NEXT);
        }
        task.postConfigureUI();
        this.substituteFrameTitle();
    }

    private void substituteFrameTitle() {
        if (this._frameTitleFormat != null) {
            try {
                this._frame.setTitle(this._frameTitleFormat.format(new Object[]{this._currentStep == -1 ? 1 : this._currentStep + 1, this._uiTasks.size()}));
            }
            catch (Throwable ex) {
                _log.log(Level.WARNING, "Error setting frame format", ex);
            }
        }
    }

    void resetContextUI() {
        if (this._roadmap != null) {
            this._roadmap.getRoadmap().setErrorState(false);
        }
        this._messagePanel.clearMessagePanel();
        this._messagePanel.showBillboard(false);
    }

    void displayCleanupMessage() {
        if (this._splashWindow != null) {
            this._splashWindow.dispose();
            this._splashWindow = null;
        }
        if (this._frame != null && this._frame.isDisplayable()) {
            this._frame.dispose();
        }
        this._cleanupWindow = new JWindow();
        JLabel messageLabel = new JLabel(this.getI18nString("wizard-internal", "GUIContext.dialog.cleanup.text"));
        messageLabel.setFont(messageLabel.getFont().deriveFont(1, 14.0f));
        messageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 2), BorderFactory.createEmptyBorder(4, 9, 4, 9)));
        messageLabel.setHorizontalTextPosition(0);
        this._cleanupWindow.getContentPane().add((Component)messageLabel, "Center");
        this._cleanupWindow.pack();
        this._cleanupWindow.setLocationRelativeTo(null);
        this._cleanupWindow.setVisible(true);
    }

    void handleFatalErrorMessage() {
        if (this._splashWindow != null) {
            this._splashWindow.dispose();
            this._splashWindow = null;
        }
        Throwable cause = this._proxy.getErrorCause();
        if (!this._proxy.isEmbeddedProcess()) {
            String msgText = cause == null ? this.getI18nString("wizard-internal", "GUIContext.dialog.fatalerror.text") : MessageFormat.format(this.getI18nString("wizard-internal", "GUIContext.dialog.fatalerror.subst.text"), cause);
            JOptionPane.showConfirmDialog(this._frame, msgText, this.getI18nString("wizard-internal", "GUIContext.dialog.fatalerror.title"), -1, 0);
        }
        if (this._frame != null) {
            for (GUITaskContext.ButtonType btn : this._buttons.keySet()) {
                this._buttons.get((Object)btn).setEnabled(btn == GUITaskContext.ButtonType.CANCEL, true);
            }
            LinkedList<JPanel> comps = new LinkedList<JPanel>(Arrays.asList(this._taskContainerPanel));
            while (!comps.isEmpty()) {
                Component c = (Component)comps.remove();
                c.setEnabled(false);
                if (!Container.class.isAssignableFrom(c.getClass())) continue;
                comps.addAll(Arrays.asList(((Container)Container.class.cast(c)).getComponents()));
            }
            this.enableInput(true);
        }
    }

    boolean canHandleFatalErrorExit() {
        return this._frame != null && this._frame.isVisible();
    }

    synchronized void disposeUI() {
        if (this._splashWindow != null) {
            this._splashWindow.dispose();
            this._splashWindow = null;
        }
        if (this._frame != null && this._frame.isDisplayable()) {
            this._frame.dispose();
        }
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        fm.removeKeyEventDispatcher(this._keyEventDispatcher);
        if (this._cleanupWindow != null) {
            this._cleanupWindow.dispose();
            this._cleanupWindow = null;
        }
    }

    synchronized void initGUI() {
        URL imageUrl;
        if (this._frame != null) {
            return;
        }
        this._contextActionListener = new ContextActionListener();
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this._keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                return GUIContext.this._consumeKeyEvents;
            }
        };
        fm.addKeyEventDispatcher(this._keyEventDispatcher);
        ControllerProxy proxy = this._parent.getProxy();
        TaskEntry currentTask = proxy.getCurrentWorkflowEntry();
        for (int i = 0; i < proxy.getWorkflowSize(); ++i) {
            TaskEntry task = proxy.getWorkflowEntryAt(i);
            if (!(task instanceof UITaskEntry)) continue;
            this._uiTasks.add(new UITaskEntryHolder(i, (UITaskEntry)task));
            if (currentTask != task) continue;
            this._currentStep = this._uiTasks.size() - 1;
        }
        this.substituteFrameTitle();
        this._parent.getProxy().addWizardWorkflowListener(this);
        this._parent.getProxy().addWizardTaskActionListener(this);
        this._frame = new JFrame();
        this.setFrameTitle(this.getI18nString("wizard-internal", "GUIContext.title.text"));
        this._frame.getGlassPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        String logoRes = this.getString("wizard-internal", "GUIContext.icon.resource");
        if (logoRes == null || logoRes.isEmpty()) {
            logoRes = DEFAULT_GUI_CONTEXT_IMAGE_ICON;
        }
        if ((imageUrl = this.getClass().getClassLoader().getResource(logoRes)) != null) {
            this._companyLogo = Toolkit.getDefaultToolkit().getImage(imageUrl);
            if (this._companyLogo != null) {
                this._frame.setIconImage(this._companyLogo);
            }
        }
        this._frame.setDefaultCloseOperation(0);
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!GUIContext.this.isInputEnabled()) {
                    _log.finer("UI input disabled. Ignoring closing action.");
                    return;
                }
                if (GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.CANCEL) != null && GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.CANCEL).isEnabled()) {
                    GUIContext.this.handleCancel();
                } else if (GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.FINISH) != null && GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.FINISH).isEnabled()) {
                    GUIContext.this.enableInput(false);
                    GUIContext.this._parent.getProxy().finish();
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
                GUIContext.this._frame.validate();
            }
        });
        this._frame.getRootPane().setBorder(BorderFactory.createLineBorder(UIManager.getColor("controlShadow")));
        InputMap inputMap = this._frame.getRootPane().getInputMap(1);
        ActionMap actionMap = this._frame.getRootPane().getActionMap();
        if (inputMap != null && actionMap != null) {
            final HashMap<String, Level> logKeyMap = new HashMap<String, Level>();
            for (int i = 0; i < LOG_KEY_LEVELS.length; ++i) {
                logKeyMap.put(String.valueOf(i), LOG_KEY_LEVELS[i]);
            }
            AbstractAction logAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Level level = (Level)logKeyMap.get(e.getActionCommand());
                    if (level != null) {
                        LogFactory.getFactory().changeGlobalLogLevel(level);
                    }
                }
            };
            for (String key : logKeyMap.keySet()) {
                inputMap.put(KeyStroke.getKeyStroke("alt " + key), logAction);
            }
            actionMap.put(logAction, logAction);
        }
        this._contentPane = ImagePanel.createImagePanel((String)this.getString("wizard-internal", "GUIContext.frame.imgpanel.spec"));
        this._contentPane.setName("GUIContext.contentPane");
        this._contentPane.setLayout(new BorderLayout());
        this._frame.setContentPane(this._contentPane);
        this._titlePanel = new TitlePanelImpl();
        this._contentPane.add((Component)this._titlePanel.getUIComponent(), "North");
        this._contentPane.add((Component)this.createCenterPanel(), "Center");
        this._contentPane.add((Component)this.createNavButtonPanel(), "South");
        this._frame.getRootPane().setDefaultButton(this._buttons.get((Object)GUITaskContext.ButtonType.NEXT).getButton());
        this._frame.pack();
        this._frame.setResizable(Boolean.valueOf(this.getString("wizard-internal", "GUIContext.frame.resizable")));
        this._frame.setSize(this.getDefaultSize());
        this._frame.setLocationRelativeTo(null);
    }

    private void showSplashScreen() {
        String displaySplash = System.getProperty("display.splash");
        if (displaySplash == null && ((displaySplash = this.getString("wizard-internal", "display.splash")) == null || displaySplash.trim().isEmpty())) {
            displaySplash = Boolean.TRUE.toString();
        }
        if (displaySplash != null && "false".equalsIgnoreCase(displaySplash)) {
            _log.finer("Splash display is disabled.");
        } else {
            try {
                URL splashImageUrl = this.getClass().getClassLoader().getResource(this.getString("wizard-internal", "splashwindow.image"));
                if (splashImageUrl == null) {
                    splashImageUrl = this.getClass().getClassLoader().getResource("resources/wizard/images/wizard-splash.gif");
                }
                if (splashImageUrl != null) {
                    String copyrightText = this.getWizardCustomProperty("splashwindow.copyright.text");
                    String title = this.getWizardCustomProperty("splashwindow.title.text");
                    this._splashWindow = SplashWindow.splash((URL)splashImageUrl, (String)title, (String)copyrightText);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getWizardCustomProperty(String key) {
        WizardConfiguration conf = this._parent.getProxy().getConfiguration();
        String wStr = conf.getOptionValue(WizardConfiguration.TARGET);
        String propValue = this.getI18nString("wizard-internal", wStr + "." + key);
        if (propValue == null || propValue.isEmpty()) {
            propValue = this.getI18nString("wizard-internal", key);
        }
        return propValue;
    }

    private JComponent createCenterPanel() {
        this._taskContainerPanel = ImagePanel.createImagePanel((String)this.getString("wizard-internal", "GUIContext.taskpanel.imgpanel.spec"));
        this._taskContainerPanel.setLayout(new BorderLayout());
        Color color_top = GUIUtilities.colorFromHex((String)this.getString("wizard-internal", "GUIContext.taskpanel.topborder.color"));
        int size = this.getIntPropValue("GUIContext.taskpanel.topborder.height.int", 0);
        if (color_top != null && size > 0) {
            this._taskContainerPanel.setBorder(new TopGradientBorder(size, color_top, this._taskContainerPanel.getBackground()));
        }
        this._messagePanel = new MessagePanelImpl(this);
        this._taskMessageWrapper = ImagePanel.createImagePanel((String)this.getString("wizard-internal", "GUIContext.taskwrapperpanel.imgpanel.spec"));
        this._taskMessageWrapper.setLayout(new BorderLayout());
        this._taskMessageSplit = new JSplitPane(0, this._taskContainerPanel, this._messagePanel.getMessagePanel());
        this._taskMessageSplit.setOneTouchExpandable(true);
        this._taskMessageSplit.setDividerLocation(this.getIntPropValue("GUIContext.taskpanel.height.int", 400));
        this._taskMessageSplit.setOpaque(false);
        this._taskMessageWrapper.add((Component)this._taskMessageSplit, "Center");
        this._centralPanel = ImagePanel.createImagePanel((String)this.getString("wizard-internal", "GUIContext.centerpanel.imgpanel.spec"));
        this._centralPanel.setLayout(new BorderLayout());
        this._roadmapPanel = ImagePanel.createImagePanel((String)this.getString("wizard-internal", "GUIContext.roadmap.imgpanel.spec"));
        this._roadmapPanel.setLayout(new BorderLayout());
        this._roadmapPanel.add((Component)this.createRoadmapPanel(), "Center");
        this._vSplit = new JSplitPane(1, this._roadmapPanel, this._taskMessageWrapper);
        this._vSplit.setOpaque(false);
        this._vSplit.setOneTouchExpandable(true);
        this._vSplit.setDividerLocation(this.getIntPropValue("GUIContext.roadmap.width.int", 200));
        this._centralPanel.add((Component)this._vSplit, "Center");
        return this._centralPanel;
    }

    private JComponent createRoadmapPanel() {
        try {
            Class<?> roadmapDriverImplClass = this.getClass().getClassLoader().loadClass(DEFAULT_ROADMAP_IMPL);
            this._roadmap = (RoadmapMngmt)roadmapDriverImplClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this._roadmap.init(this._parent.getProxy());
            JScrollPane scroll = new JScrollPane(this._roadmap.getUI(), 20, 31);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            scroll.getViewport().setOpaque(false);
            scroll.setOpaque(false);
            return scroll;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed to load com.oracle.cie.wizard.gui.roadmap.impl.WizRoadmap", e);
            return null;
        }
    }

    private JComponent createNavButtonPanel() {
        ImagePanel p = ImagePanel.createImagePanel((String)this.getString("wizard-internal", "GUIContext.btnpanel.imgpanel.spec"));
        p.setLayout((LayoutManager)new BoxLayout((Container)p, 0));
        p.setBorder(BorderFactory.createEmptyBorder(4, 9, 4, 9));
        ButtonHolder bthHolder = new ButtonHolder(this.getI18nString("wizard-internal", "wizard.button.help.text"), this.getI18nString("wizard-internal", "wizard.button.help.tooltip"), false);
        ArrayList<JButton> btnsToResize = new ArrayList<JButton>();
        this._buttons.put(GUITaskContext.ButtonType.HELP, bthHolder);
        btnsToResize.add(bthHolder.getButton());
        p.add((Component)bthHolder.getButton());
        p.add(Box.createHorizontalGlue());
        p.add(Box.createHorizontalStrut(8));
        bthHolder = new ButtonHolder(this.getI18nString("wizard-internal", "wizard.button.back.text"), this.getI18nString("wizard-internal", "wizard.button.back.tooltip"), false);
        this._buttons.put(GUITaskContext.ButtonType.BACK, bthHolder);
        btnsToResize.add(bthHolder.getButton());
        p.add((Component)bthHolder.getButton());
        p.add(Box.createHorizontalStrut(1));
        bthHolder = new ButtonHolder(this.getI18nString("wizard-internal", "wizard.button.next.text"), this.getI18nString("wizard-internal", "wizard.button.next.tooltip"), false);
        this._buttons.put(GUITaskContext.ButtonType.NEXT, bthHolder);
        btnsToResize.add(bthHolder.getButton());
        p.add((Component)bthHolder.getButton());
        p.add(Box.createHorizontalStrut(8));
        bthHolder = new ButtonHolder(this.getI18nString("wizard-internal", "wizard.button.finish.text"), this.getI18nString("wizard-internal", "wizard.button.finish.tooltip"), false);
        this._buttons.put(GUITaskContext.ButtonType.FINISH, bthHolder);
        btnsToResize.add(bthHolder.getButton());
        p.add((Component)bthHolder.getButton());
        p.add(Box.createHorizontalStrut(8));
        bthHolder = new ButtonHolder(this.getI18nString("wizard-internal", "wizard.button.cancel.text"), this.getI18nString("wizard-internal", "wizard.button.cancel.tooltip"), true);
        this._buttons.put(GUITaskContext.ButtonType.CANCEL, bthHolder);
        btnsToResize.add(bthHolder.getButton());
        p.add((Component)bthHolder.getButton());
        GUIUtilities.sameSizeButtons((JButton[])btnsToResize.toArray(new JButton[this._buttons.size()]));
        return p;
    }

    private Dimension getDefaultSize() {
        WizardConfiguration conf = this._parent.getProxy().getConfiguration();
        String wStr = conf.getOptionValue(WizardConfiguration.UI_CONTEXT_WIDTH);
        String hStr = conf.getOptionValue(WizardConfiguration.UI_CONTEXT_HEIGHT);
        int width = this.getDimensionParam(wStr, true);
        int height = this.getDimensionParam(hStr, false);
        width = width == 0 ? this.getIntPropValue("GUIContext.frame.width.int", 800) : width;
        height = height == 0 ? this.getIntPropValue("GUIContext.frame.height.int", 600) : height;
        return new Dimension(width, height);
    }

    private int getDimensionParam(String dimParameter, boolean isWidth) {
        int paramValue = 0;
        if (!StringUtil.isNullOrEmpty((String)dimParameter)) {
            try {
                paramValue = Integer.parseInt(dimParameter);
                this._isSizeSetExternally = true;
            }
            catch (NumberFormatException nfx) {
                _log.warning("Unable to parse given " + (isWidth ? "width" : "height") + ": [" + dimParameter + "]. Using default values.");
            }
        }
        return paramValue;
    }

    private void configureButton(GUITaskContext.ButtonType type, String text, String tooltip, boolean make_default) {
        ButtonHolder btn;
        if (this.checkThread() && (btn = this._buttons.get((Object)type)) != null && text != null && !text.isEmpty()) {
            btn.setValues(text, tooltip, make_default);
            int req_width = (GUIContext)this.new ButtonHolder((String)text, (String)tooltip, (boolean)true).getButton().getPreferredSize().width;
            int cur_width = btn.getButton().getPreferredSize().width;
            if (req_width > cur_width) {
                Insets margins = btn.getButton().getMargin();
                int max_vmargin = Math.max(margins.top, margins.bottom);
                if (margins.left > max_vmargin && margins.right > max_vmargin) {
                    if (req_width > (cur_width += margins.left - max_vmargin + (margins.right - max_vmargin))) {
                        this.setButtonRequiredWidth(btn, req_width);
                    } else {
                        margins.left = margins.right = max_vmargin;
                        btn.getButton().setMargin(margins);
                    }
                } else {
                    this.setButtonRequiredWidth(btn, req_width);
                }
            }
        }
    }

    private void setButtonRequiredWidth(ButtonHolder btn, int req_width) {
        Dimension ps = btn.getButton().getPreferredSize();
        ps.width = req_width;
        btn.getButton().setPreferredSize(ps);
        btn.getButton().setMinimumSize(ps);
        btn.getButton().invalidate();
    }

    private boolean checkThread() {
        boolean isEDT = SwingUtilities.isEventDispatchThread();
        if (!isEDT) {
            try {
                throw new Error("Call must be made from EventDispatchThread!!!");
            }
            catch (Throwable ex) {
                _log.log(Level.SEVERE, "Ignore method call", ex);
            }
        }
        return isEDT;
    }

    void showHelp() {
        if (this._help != null) {
            GUITask t = (GUITask)this._parent.getCurrentTask();
            if (HelpDelegate.class.isAssignableFrom(t.getClass())) {
                try {
                    this._help.showHelp((HelpDelegate)HelpDelegate.class.cast(t));
                }
                catch (HelpProviderException e) {
                    _log.log(Level.SEVERE, "Exception occured while loading the topic. ", e);
                }
            }
        } else {
            _log.info("Help related module is not available. Help topics will not be displayed.");
        }
    }

    void handleCancel() {
        boolean doExit;
        boolean bl = doExit = this._parent.getProxy().getState() == WizardState.ERROR;
        if (!doExit) {
            boolean bl2 = doExit = JOptionPane.showConfirmDialog(this._frame, this.getI18nString("wizard-internal", "GUIContext.dialog.confirmexit.text"), this.getI18nString("wizard-internal", "GUIContext.dialog.confirmexit.title"), 0) == 0;
        }
        if (doExit) {
            this.enableInput(false);
            this._parent.getProxy().cancel();
        }
    }

    private Object convertMsgObj(Object msg) {
        return this.convertMsgObj(msg, null);
    }

    private Object convertMsgObj(Object msg, String additionalText) {
        StringBuilder sb;
        Object retMsg = msg;
        if (msg instanceof PublishedMessage) {
            sb = new StringBuilder(((PublishedMessage)PublishedMessage.class.cast(msg)).getFullMessage(this.getHTMLPattern()));
            if (additionalText != null && !additionalText.isEmpty()) {
                sb.append("<br><br>");
                sb.append(additionalText);
            }
            retMsg = new JLabel(sb.toString());
        }
        if (msg instanceof String && ((String)String.class.cast(msg)).toUpperCase().startsWith("<HTML>")) {
            sb = new StringBuilder((String)String.class.cast(msg));
            if (additionalText != null && !additionalText.isEmpty()) {
                sb.append("<br><br>");
                sb.append(additionalText);
            }
            retMsg = new JLabel(sb.toString());
        }
        return retMsg;
    }

    private int getJOptionMessageType(PublishedMessage msg) {
        int optionType;
        switch (this.getMessageType(msg)) {
            case INFORMATION: {
                optionType = 1;
                break;
            }
            case WARNING: {
                optionType = 2;
                break;
            }
            case ERROR: {
                optionType = 0;
                break;
            }
            default: {
                optionType = -1;
            }
        }
        return optionType;
    }

    private String getDialogTitle(int type) {
        String title = "";
        if (type == 0) {
            title = ResourceBundleManager.getString((String)"comdev", (String)"OptionPane.dialog.title.error");
        } else if (type == 2) {
            title = ResourceBundleManager.getString((String)"comdev", (String)"OptionPane.dialog.title.warning");
        } else if (type == 1) {
            title = ResourceBundleManager.getString((String)"comdev", (String)"OptionPane.dialog.title.info");
        } else if (type == 3) {
            title = ResourceBundleManager.getString((String)"comdev", (String)"OptionPane.dialog.title.question");
        } else if (type == -1) {
            title = ResourceBundleManager.getString((String)"comdev", (String)"OptionPane.dialog.title.message");
        }
        return title;
    }

    @Override
    public void entriesAdded(WizardWorkflowEvent e) {
        int uiStartIdx = this.findUIStartIndex(e);
        int addedTotal = e.getTasks().size();
        for (int i = uiStartIdx; i < this._uiTasks.size(); ++i) {
            this._uiTasks.get(i).adjustWcfIndex(addedTotal);
        }
        ArrayList<UITaskEntryHolder> tasksToAdd = new ArrayList<UITaskEntryHolder>();
        for (int i = 0; i < addedTotal; ++i) {
            TaskEntry task = e.getTasks().get(i);
            if (!(task instanceof UITaskEntry)) continue;
            tasksToAdd.add(new UITaskEntryHolder(e.getStartIndex() + i, (UITaskEntry)task));
        }
        if (!tasksToAdd.isEmpty()) {
            this._uiTasks.addAll(uiStartIdx, tasksToAdd);
            this.substituteFrameTitle();
        }
    }

    @Override
    public void entriesRemoved(WizardWorkflowEvent e) {
        int uiStartIdx = this.findUIStartIndex(e);
        int removedTotal = e.getTasks().size();
        int endIndex = e.getStartIndex() + removedTotal - 1;
        ArrayList<UITaskEntryHolder> tasksToRemove = new ArrayList<UITaskEntryHolder>();
        for (int i = uiStartIdx; i < this._uiTasks.size(); ++i) {
            UITaskEntryHolder task = this._uiTasks.get(i);
            if (task.getWcfIndex() <= endIndex) {
                tasksToRemove.add(task);
                continue;
            }
            task.adjustWcfIndex(-removedTotal);
        }
        if (!tasksToRemove.isEmpty()) {
            this._uiTasks.removeAll(tasksToRemove);
            this.substituteFrameTitle();
        }
    }

    @Override
    public void taskActionPeformed(WizardTaskActionEvent e) {
        switch (e.getDirection()) {
            case FORWARD: {
                if (this._currentStep >= this._uiTasks.size() - 1 || this._uiTasks.get(this._currentStep + 1).getTask() != e.getTaskEntry()) break;
                ++this._currentStep;
                break;
            }
            case REVERSE: {
                if (this._currentStep <= 0 || this._uiTasks.get(this._currentStep - 1).getTask() != e.getTaskEntry()) break;
                --this._currentStep;
            }
        }
    }

    private int findUIStartIndex(WizardWorkflowEvent e) {
        int uiStartIdx = this._uiTasks.size();
        for (int i = 0; i < this._uiTasks.size(); ++i) {
            if (this._uiTasks.get(i).getWcfIndex() < e.getStartIndex()) continue;
            uiStartIdx = i;
            break;
        }
        return uiStartIdx;
    }

    static {
        try {
            GUIHelper.initPLAF();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class ButtonHolder {
        private JButton _button = new JButton();
        private String _defaultText;
        private int _defaultMnemonic;
        private int _defaultMnemonicIndex;
        private String _defaultToolTip;
        private boolean _defaultIsEnabled;
        private Dimension _defaultDimension;

        protected ButtonHolder(String txt, String tooltip, boolean enabled) {
            this._button.setMultiClickThreshhold(300L);
            this._button.addActionListener(GUIContext.this._contextActionListener);
            this.setValues(txt, tooltip, true);
            this.setEnabled(enabled, true);
        }

        protected void setValues(String text, String tooltip, boolean make_default) {
            GUIUtilities.configureButton((AbstractButton)this._button, (String)text, (String)tooltip);
            if (make_default) {
                this._defaultText = this._button.getText();
                this._defaultMnemonic = this._button.getMnemonic();
                this._defaultMnemonicIndex = this._button.getDisplayedMnemonicIndex();
                this._defaultToolTip = this._button.getToolTipText();
                this._defaultDimension = this._button.getPreferredSize();
            }
        }

        protected void resetAll() {
            this._button.setText(this._defaultText);
            this._button.setMnemonic(this._defaultMnemonic);
            this._button.setDisplayedMnemonicIndex(this._defaultMnemonicIndex);
            this._button.setToolTipText(this._defaultToolTip);
            this._button.setEnabled(this._defaultIsEnabled);
            this._button.setPreferredSize(this._defaultDimension);
        }

        protected void setVisible(boolean visible) {
            this._button.setVisible(visible);
        }

        protected boolean isVisible() {
            return this._button.isVisible();
        }

        protected void setEnabled(boolean enabled, boolean make_default) {
            if (make_default) {
                this._defaultIsEnabled = enabled;
            }
            this._button.setEnabled(this._defaultIsEnabled && enabled);
        }

        protected boolean isEnabled() {
            return this._button.isVisible() && this._button.isEnabled();
        }

        protected JButton getButton() {
            return this._button;
        }
    }

    protected class TitlePanelImpl
    implements TitlePanel {
        private ImagePanel _panel;
        private JLabel _titleLabel;

        public TitlePanelImpl() {
            this._panel = ImagePanel.createImagePanel((String)GUIContext.this.getString("wizard-internal", "GUIContext.titlepanel.imgpanel.spec"));
            this._panel.setLayout((LayoutManager)new BoxLayout((Container)this._panel, 2));
            this._panel.add(Box.createHorizontalStrut(20));
            this._titleLabel = new JLabel();
            this._titleLabel.setFont(new Font("Sans-serif", 1, 13));
            this._panel.add((Component)this._titleLabel);
            this._panel.add(Box.createHorizontalGlue());
        }

        @Override
        public String getTitle() {
            return this._titleLabel.getText();
        }

        @Override
        public void setTitle(String title) {
            this._titleLabel.setText(title);
            this._titleLabel.getAccessibleContext().setAccessibleName(this._titleLabel.getText());
        }

        @Override
        public void setLogoImage(Image image) {
            this._panel.setImage(image);
        }

        @Override
        public void setLogoImage(String resource) {
            this._panel.setImage(this.getClass().getClassLoader().getResource(resource));
        }

        public JComponent getUIComponent() {
            return this._panel;
        }
    }

    private static class MessageHolder {
        Method _method;
        Object[] _args;
        MessageType _type;

        MessageHolder(Method method, MessageType type, Object ... args) {
            this._method = method;
            this._type = type;
            this._args = args;
        }
    }

    protected class ContextActionListener
    implements ActionListener {
        protected ContextActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.HELP).getButton()) {
                GUIContext.this.showHelp();
            } else if (e.getSource() == GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.NEXT).getButton()) {
                GUIContext.this.enableInput(false);
                GUIContext.this._parent.getProxy().goNext();
            } else if (e.getSource() == GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.BACK).getButton()) {
                GUIContext.this.enableInput(false);
                GUIContext.this._parent.getProxy().goPrevious();
            } else if (e.getSource() == GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.FINISH).getButton()) {
                GUIContext.this.enableInput(false);
                if (GUIContext.this._enableFastFinish) {
                    GUIContext.this._parent.getProxy().finish();
                } else {
                    GUIContext.this._parent.getProxy().goNext();
                }
            } else if (e.getSource() == GUIContext.this._buttons.get((Object)GUITaskContext.ButtonType.CANCEL).getButton()) {
                GUIContext.this.handleCancel();
            }
        }
    }

    protected static class UITaskEntryHolder {
        UITaskEntry _task;
        int _wcfIndex;

        public UITaskEntryHolder(int wcfIndex, UITaskEntry task) {
            this._wcfIndex = wcfIndex;
            this._task = task;
        }

        public int getWcfIndex() {
            return this._wcfIndex;
        }

        public UITaskEntry getTask() {
            return this._task;
        }

        public void adjustWcfIndex(int num) {
            this._wcfIndex += num;
        }
    }

    protected static class TopGradientBorder
    extends AbstractBorder
    implements UIResource {
        protected Color _extColor;
        protected Color _intColor;
        private Insets _insets;

        public TopGradientBorder(int size, Color extColor, Color intColor) {
            this._insets = new Insets(size, 0, 0, 0);
            this._extColor = extColor;
            this._intColor = intColor;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            Graphics2D g2d = (Graphics2D)Graphics2D.class.cast(g);
            GradientPaint gpaint = new GradientPaint(0.0f, 0.0f, this._extColor, 0.0f, this._insets.top, this._intColor);
            g2d.setPaint(gpaint);
            g2d.fillRect(0, 0, w, Math.min(this._insets.top, h));
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this._insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = this._insets.top;
            newInsets.left = this._insets.left;
            newInsets.bottom = this._insets.bottom;
            newInsets.right = this._insets.right;
            return newInsets;
        }
    }
}

