/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;

@TaskDescription(name="dumpWizEnv", cachingPolicy=TaskCachingPolicy.REUSE)
public class DumpWizardEnvironment
extends AbstractSilentTask {
    protected Destination _destination;
    protected String _fileName;

    @TaskAttribute(type=TaskAttributeType.ENUM, required=false, defaultValue="LOG", typeConstraints={"LOG", "SYSOUT", "SYSERR", "FILE"})
    public void setDestination(String value) {
        this._destination = Destination.valueOf(value);
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=false)
    public void setFileName(String value) {
        this._fileName = value;
    }

    @Override
    public void configure(TaskContext context) throws TaskExecutionException {
        super.configure(context);
    }

    @Override
    public void execute() throws TaskExecutionException {
        StringBuilder sb = new StringBuilder("Wizard Environment\n\n");
        sb.append("\tEnvironment Variables:\n");
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            sb.append("\t\t").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("\tSystem Properties:\n");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            sb.append("\t\t").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("\tWizard Options:\n");
        for (Map.Entry<Object, Object> entry : this._context.getConfiguration().getOptions().entrySet()) {
            sb.append("\t\t").append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append("\n");
        }
        sb.append("\tWizard Arguments:\n");
        for (String string : this._context.getConfiguration().getArguments()) {
            sb.append("\t\t").append(string).append("\n");
        }
        if (this._destination == null) {
            this._destination = Destination.LOG;
        }
        switch (this._destination.ordinal()) {
            case 3: {
                try {
                    PrintWriter w = new PrintWriter(this._fileName);
                    w.println(sb);
                    w.close();
                }
                catch (FileNotFoundException e) {
                    this._logger.log(Level.WARNING, "Invalid filename: " + this._fileName);
                    this._logger.info(sb.toString());
                }
                break;
            }
            case 0: {
                this._logger.info(sb.toString());
                break;
            }
            case 1: {
                System.out.println(sb);
                break;
            }
            case 2: {
                System.err.println(sb);
            }
        }
    }

    @Override
    public void unconfigure() {
        this._destination = null;
        this._fileName = null;
    }

    public static enum Destination {
        LOG,
        SYSOUT,
        SYSERR,
        FILE;

    }
}

