/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;

@TaskDescription(name="properties")
public class PropertiesFileTask
extends AbstractSilentTask {
    private boolean _load = false;
    private boolean _overwrite = false;
    private String _file = null;
    private String _keys = null;
    private String _values = null;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setKeys(String keys) {
        this._keys = keys;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setValues(String values) {
        this._values = values;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setFile(String file) {
        this._file = file;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"read", "write", "append"}, defaultValue="append")
    public void setAction(String action) {
        if ("read".equalsIgnoreCase(action)) {
            this._load = true;
            this._overwrite = false;
        } else if ("write".equalsIgnoreCase(action)) {
            this._load = false;
            this._overwrite = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws TaskExecutionException {
        String[] values;
        if (!this.isValidPropertyFile()) {
            return;
        }
        Properties p = new Properties();
        File file = new File(this._file);
        String[] keys = this._keys == null ? new String[]{} : this._keys.split(",");
        String[] stringArray = values = this._values == null ? new String[]{} : this._values.split(",");
        if (this._load || !this._overwrite && file.exists()) {
            String[] fis = null;
            try {
                fis = new FileInputStream(file);
                p.load((InputStream)fis);
            }
            catch (IOException ioe) {
                this._logger.log(Level.SEVERE, "Error loading properties file: " + this._file, ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (this._load) {
            this._logger.finer("Loading properties from " + this._file);
            for (String prop : keys) {
                String value = p.getProperty(prop);
                if (value != null) {
                    this._context.storeObject(this._namespace, prop, value);
                    this._logger.finer("Successfully loaded \"" + prop + "\" into object store.");
                    continue;
                }
                this._logger.finer("Property \"" + prop + "\" did not exist in file.");
            }
        } else {
            if (this._values == null) {
                for (String prop : keys) {
                    p.setProperty(prop, this._context.getString(this._namespace, prop));
                }
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    p.setProperty(keys[i], this._context.substitute(this._namespace, values[i]));
                }
            }
            OutputStream fos = null;
            try {
                this._logger.finer("Storing properties to " + this._file);
                fos = new FileOutputStream(this._file, false);
                p.store(fos, null);
            }
            catch (IOException ioe) {
                this._logger.log(Level.SEVERE, "Error storing properties file: " + this._file, ioe);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        ((FileOutputStream)fos).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean isValidPropertyFile() {
        if (this._file == null) {
            this._logger.finer("Properties file not set, skipping...");
            return false;
        }
        if (this._keys == null) {
            this._logger.finer("No keys set, skipping...");
            return false;
        }
        this._file = this._context.substitute(this._namespace, this._file);
        if (this._load && !new File(this._file).exists()) {
            this._logger.finer("Unable to load Properties because file (" + this._file + ") didn't exist, skipping...");
            return false;
        }
        this._keys = this._context.substitute(this._namespace, this._keys);
        return true;
    }
}

