/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table.messages;

import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.msgpanel.MessageKey;
import com.oracle.cie.wizard.gui.msgpanel.MessageSelectionEvent;
import com.oracle.cie.wizard.gui.msgpanel.MessageSelectionListener;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import com.oracle.cie.wizardx.gui.table.messages.CellDecorationType;
import com.oracle.cie.wizardx.gui.table.messages.TableCell;
import com.oracle.cie.wizardx.gui.table.messages.TableComplexMessageKey;
import com.oracle.cie.wizardx.gui.table.messages.TableMessageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DefaultTableMessageHandler
implements TableMessageHandler,
MessageSelectionListener,
ListSelectionListener {
    protected GUITaskContext _taskContext;
    protected JTable _table;
    protected AbstractTableModel _tableModel;
    private Map<MessageKey, List<PublishedMessage>> _keyMsgListMap = new HashMap<MessageKey, List<PublishedMessage>>();
    private MessageKey _selectedKey;
    private CellDecorationType _selectedType = null;

    public DefaultTableMessageHandler(GUITaskContext taskContext, JTable table, AbstractTableModel tableModel) {
        ListSelectionModel colSelModel;
        ListSelectionModel rowSelModel;
        this._taskContext = taskContext;
        this._table = table;
        this._tableModel = tableModel;
        if (this._taskContext != null) {
            this._taskContext.getMessagePanel().addMessageSelectionListener(this);
        }
        if ((rowSelModel = table.getSelectionModel()) != null) {
            rowSelModel.addListSelectionListener(this);
        }
        if ((colSelModel = table.getColumnModel().getSelectionModel()) != null) {
            colSelModel.addListSelectionListener(this);
        }
    }

    @Override
    public void addMessage(List<TableCell> cells, PublishedMessage msg) {
        TableComplexMessageKey key = new TableComplexMessageKey(cells);
        if (this._keyMsgListMap.containsKey(key)) {
            List<PublishedMessage> msgList = this._keyMsgListMap.get(key);
            if (!this.isDuplicateMessage(msgList, msg)) {
                msgList.add(msg);
                this._taskContext.addValidationMessage(msg, key);
            }
        } else {
            ArrayList<PublishedMessage> msgList = new ArrayList<PublishedMessage>();
            msgList.add(msg);
            this._keyMsgListMap.put(key, msgList);
            this._taskContext.addValidationMessage(msg, key);
        }
    }

    @Override
    public CellDecorationType getDecorationType(int row, int column) {
        return this._selectedKey != null && ((TableComplexMessageKey)this._selectedKey).contains(row, column) && this._selectedType != null ? this._selectedType : CellDecorationType.NONE;
    }

    @Override
    public void clearValidationMessages(int row, int col) {
        ArrayList<MessageKey> toRemove = new ArrayList<MessageKey>();
        for (MessageKey key : this._keyMsgListMap.keySet()) {
            if (!((TableComplexMessageKey)key).contains(row, col)) continue;
            toRemove.add(key);
        }
        for (MessageKey key : toRemove) {
            this._taskContext.clearValidationMessages(key);
            this._keyMsgListMap.remove(key);
            if (key != this._selectedKey) continue;
            this._selectedKey = null;
            this._selectedType = CellDecorationType.NONE;
            for (TableCell addr : ((TableComplexMessageKey)key).getAssociatedAddresses()) {
                this.fireUpdateEvent(addr.getRow(), this._table.getColumnModel().getColumn(addr.getCol()).getModelIndex());
            }
        }
    }

    @Override
    public void clearAllValidationMessages() {
        this.clearValidationMessages(-1, -1);
    }

    @Override
    public void messageSelected(MessageSelectionEvent e) {
        for (MessageKey o : e.getMessageKey()) {
            if (!(o instanceof TableComplexMessageKey)) continue;
            TableComplexMessageKey key = (TableComplexMessageKey)TableComplexMessageKey.class.cast(o);
            if (this._keyMsgListMap == null || !this._keyMsgListMap.containsKey(key)) continue;
            if (e.isSelected()) {
                this._selectedKey = key;
                this._selectedType = this.mapMessageType(e.getMessageType());
            } else {
                this._selectedKey = null;
                this._selectedType = CellDecorationType.NONE;
            }
            for (TableCell addr : key.getAssociatedAddresses()) {
                this.fireUpdateEvent(addr.getRow(), addr.getCol());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this._table.getSelectedRow();
        int column = this._table.getSelectedColumn();
        for (MessageKey key : this._keyMsgListMap.keySet()) {
            this._taskContext.getMessagePanel().messageKeySelected(key, ((TableComplexMessageKey)key).contains(row, column));
        }
    }

    private boolean isDuplicateMessage(List<PublishedMessage> msgList, PublishedMessage message) {
        if (msgList != null && !msgList.isEmpty()) {
            for (PublishedMessage publishedMessage : msgList) {
                if (!publishedMessage.getMessageText().equals(message.getMessageText())) continue;
                return true;
            }
        }
        return false;
    }

    private void fireUpdateEvent(int row, int col) {
        if (row < 0 && col != this._table.getEditingColumn()) {
            if (this._table.isEditing()) {
                this._table.getCellEditor().stopCellEditing();
            }
            this._tableModel.fireTableDataChanged();
        } else if (col < 0 && row != this._table.getEditingRow()) {
            if (this._table.isEditing()) {
                this._table.getCellEditor().stopCellEditing();
            }
            this._tableModel.fireTableRowsUpdated(row, row);
        } else if (!this._table.isEditing() || row != this._table.getEditingRow() || col != this._table.getEditingColumn()) {
            this._tableModel.fireTableCellUpdated(row, col);
        }
    }

    private CellDecorationType mapMessageType(MessageType messageType) {
        if (messageType == null) {
            return CellDecorationType.NONE;
        }
        switch (messageType) {
            case WARNING: {
                return CellDecorationType.WARNING;
            }
            case ERROR: {
                return CellDecorationType.ERROR;
            }
        }
        return CellDecorationType.NONE;
    }
}

