/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting;

import com.oracle.cie.common.util.reporting.ReportLevel;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.ReporterTypes;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.MessagesFactory;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Reporting {
    private static final Logger _log = Logger.getLogger(Reporting.class.getName());
    public static final char MESSAGE_INDICATOR_CHAR = '~';
    public static final String MESSAGE_INDICATOR_STRING = new String(new char[]{'~'});
    public static final String MESSAGE_INDICATOR_ESCAPE = "&tild;";
    private static List<Reporter> _reporters = new ArrayList<Reporter>();
    private static Reporter _defaultReporter;
    private static ReporterType _defaultReporterType;

    public static List<Reporter> getReporters() {
        if (_reporters.isEmpty()) {
            Reporting.getDefaultReporter();
        }
        return _reporters;
    }

    public static Reporter getDefaultReporter() {
        if (!Reporting.hasDefaultReporter()) {
            try {
                _defaultReporter = Reporting.addReporter(_defaultReporterType, System.out);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Failed to configure default console reporter.", e);
            }
        }
        return _defaultReporter;
    }

    public static boolean hasDefaultReporter() {
        return _defaultReporter != null;
    }

    public static Reporter addReporter(ReporterType type, OutputStream outputStream) throws ReportingException {
        Reporter reporter;
        try {
            Class<? extends Reporter> reporterClass = type.getReporterClass();
            reporter = reporterClass.getConstructor(OutputStream.class).newInstance(outputStream);
            Reporting.addReporter(reporter);
        }
        catch (Exception e) {
            throw new ReportingException("Failed to load " + type + " reporter.", e);
        }
        return reporter;
    }

    public static void addReporter(Reporter reporter) {
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Adding reporter " + reporter);
        }
        if (reporter != null) {
            _reporters.add(reporter);
        }
    }

    public static Message report(String message) {
        return Reporting.report(ReportLevel.INFO, message);
    }

    public static Message report(ReportLevel level, String messageString) {
        return Reporting.report(level, null, messageString);
    }

    public static Message report(ReportLevel level, String id, String messageString) {
        Message message = MessagesFactory.getMessage(id, messageString);
        Reporting.report(level, message);
        return message;
    }

    public static void report(Message message) {
        Reporting.report(ReportLevel.INFO, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(ReportLevel level, Message message) {
        Iterator<Reporter> iterator = Reporting.getReporters().iterator();
        while (iterator.hasNext()) {
            Reporter reporter;
            Reporter reporter2 = reporter = iterator.next();
            synchronized (reporter2) {
                if (reporter.isReportable(level) && reporter.acceptMessageType(message.getType())) {
                    reporter.report(level, message);
                }
            }
        }
    }

    public static void report(Initiation initiation) {
        Reporting.report(ReportLevel.INFO, initiation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(ReportLevel level, Initiation initiation) {
        Iterator<Reporter> iterator = Reporting.getReporters().iterator();
        while (iterator.hasNext()) {
            Reporter reporter;
            Reporter reporter2 = reporter = iterator.next();
            synchronized (reporter2) {
                if (reporter.isReportable(level) && reporter.acceptMessageType(initiation.getType())) {
                    reporter.report(level, initiation);
                }
            }
        }
    }

    public static void report(Progress progress) {
        Reporting.report(ReportLevel.INFO, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(ReportLevel level, Progress progress) {
        Iterator<Reporter> iterator = Reporting.getReporters().iterator();
        while (iterator.hasNext()) {
            Reporter reporter;
            Reporter reporter2 = reporter = iterator.next();
            synchronized (reporter2) {
                if (reporter.isReportable(level) && reporter.acceptMessageType(progress.getType())) {
                    reporter.report(level, progress);
                }
            }
        }
    }

    public static void report(Completion completion) {
        Reporting.report(ReportLevel.INFO, completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(ReportLevel level, Completion completion) {
        Iterator<Reporter> iterator = Reporting.getReporters().iterator();
        while (iterator.hasNext()) {
            Reporter reporter;
            Reporter reporter2 = reporter = iterator.next();
            synchronized (reporter2) {
                if (reporter.isReportable(level) && reporter.acceptMessageType(completion.getType())) {
                    reporter.report(level, completion);
                }
            }
        }
    }

    public static void report(Report report) {
        Reporting.report(ReportLevel.INFO, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(ReportLevel level, Report report) {
        Iterator<Reporter> iterator = Reporting.getReporters().iterator();
        while (iterator.hasNext()) {
            Reporter reporter;
            Reporter reporter2 = reporter = iterator.next();
            synchronized (reporter2) {
                if (reporter.isReportable(level) && reporter.acceptMessageType(report.getType())) {
                    reporter.report(level, report);
                }
            }
        }
    }

    public static boolean isReportable(ReportLevel level) {
        for (Reporter reporter : Reporting.getReporters()) {
            if (!reporter.isReportable(level)) continue;
            return true;
        }
        return false;
    }

    public static void stopAll() {
        _reporters.clear();
    }

    public static void stop(Reporter reporter) {
        if (reporter != null) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Stopping reporter " + reporter);
            }
            _reporters.remove(reporter);
        }
    }

    static {
        _defaultReporterType = ReporterTypes.valueOf(System.getProperty("Reporting.default.reporter.type", ReporterTypes.console.name()));
    }
}

