/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.messages;

import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import java.util.Collection;

public class MessagesFactory {
    public static Message getMessage(String id, String msg) {
        Message message = new Message();
        message.setId(id);
        message.setMessage(msg);
        return message;
    }

    public static Initiation getInitiation(String id, String message) {
        Initiation initiation = new Initiation();
        initiation.setId(id);
        if (message != null) {
            initiation.setMessage(MessagesFactory.getMessage(id, message));
        }
        return initiation;
    }

    public static Progress getProgress(String id, String unitType, String units, String message) {
        return MessagesFactory.getProgressWithTotalUnits(id, unitType, units, null, message);
    }

    public static Progress getProgressWithTotalUnits(String id, String unitType, String units, String totalUnits, String message) {
        Progress progress = new Progress();
        progress.setId(id);
        progress.setUnitType(unitType);
        progress.setUnits(units);
        progress.setTotalUnits(totalUnits);
        if (message != null) {
            progress.setMessage(MessagesFactory.getMessage(id, message));
        }
        return progress;
    }

    public static Progress getProgress(String id, String elapsedTime, String message) {
        return MessagesFactory.getProgressWithExpectedTime(id, elapsedTime, null, message);
    }

    public static Progress getProgressWithExpectedTime(String id, String elapsedTime, String expectedTime, String message) {
        Progress progress = new Progress();
        progress.setId(id);
        progress.setElapsedTime(elapsedTime);
        progress.setExpectedTime(expectedTime);
        if (message != null) {
            progress.setMessage(MessagesFactory.getMessage(id, message));
        }
        return progress;
    }

    public static Completion getCompletion(String id, String action, String message) {
        Completion completion = new Completion();
        completion.setId(id);
        completion.setAction(action);
        if (message != null) {
            completion.setMessage(MessagesFactory.getMessage(id, message));
        }
        return completion;
    }

    public static Report getReport() {
        return MessagesFactory.getReport(null);
    }

    public static Report getReport(Collection<ReportMessage> reportMessages) {
        Report report = new Report();
        if (reportMessages != null) {
            report.setReportMessages(reportMessages);
        }
        return report;
    }
}

