/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OPatchAutoOptions {
    private static final Logger _log = Logger.getLogger(OPatchAutoOptions.class.getName());
    public static final String PATCH_LOCATION_KEY = "patch.location";
    public static final String PATCH_DIRECTORY_KEY = "patch.base.directory";
    public static final String PATCH_DIRECTORY_ARG = "-phBaseDir";
    public static final String ID_KEY = "id";
    public static final String ID_ARG = "-id";
    public static final String PATCH_LOCATION_GROUP_KEY = "patch.location.group";
    public static final String PATCH_ID_GROUP_KEY = "patch.id.group";
    public static final String HELP_KEY = "help";
    public static final String HELP_ARG = "-help";
    public static final String HOME_KEY = "home";
    public static final String HOME_ARG = "-oh";
    public static final String PHASES_KEY = "phases";
    public static final String PHASES_ARG = "-phases";
    public static final String LOG_KEY = WizardConfiguration.LOGFILE.getName();
    public static final String LOG_ARG = "-log";
    public static final String LOG_LEVEL_KEY = WizardConfiguration.LOGPRIORITY.getName();
    public static final String LOG_LEVEL_ARG = "-logLevel";
    public static final String CUSTOM_LOG_DIR_KEY = "customLogDir";
    public static final String CUSTOM_LOG_DIR_ARG = "-customLogDir";
    public static final String LOG_GROUP_KEY = "log.group";
    public static final String BINARY_KEY = "binary";
    public static final String BINARY_ARG = "-binary";
    public static final String ANALYZE_KEY = "analyze";
    public static final String ANALYZE_ARG = "-analyze";
    public static final String INSTANCE_KEY = "instance";
    public static final String INSTANCE_ARG = "-instance";
    public static final String INV_PTR_LOC_KEY = "inventory.pointer.location";
    public static final String INV_PTR_LOC_ARG = "-invPtrLoc";
    public static final String HOST_KEY = "host";
    public static final String HOST_ARG = "-host";
    public static final String USERNAME_KEY = "username";
    public static final String USERNAME_ARG = "-username";
    public static final String PASSWORD_KEY = "password";
    public static final String PASSWORD_ARG = "-password";
    public static final String PATCH_PLAN_KEY = "patch.plan";
    public static final String PATCH_PLAN_ARG = "-plan";
    public static final String CONTAINER_KEY = "container";
    public static final String CONTAINER_ARG = "-container";
    public static final String WALLET_KEY = "wallet";
    public static final String WALLET_ARG = "-wallet";
    public static final String WALLET_PASSWORD_KEY = "wallet.password";
    public static final String WALLET_PASSWORD_ARG = "-walletPassword";
    public static final String WALLET_AND_USERNAME_GROUP = "wallet.and.username.group";
    public static final String WALLET_AND_PASSWORD_GROUP = "wallet.and.password.group";
    public static final String WALLET_PASSWORD_AND_USERNAME_GROUP = "wallet.password.and.username.group";
    public static final String WALLET_PASSWORD_AND_PASSWORD_GROUP = "wallet.password.and.password.group";
    public static final String TOPOLOGY_KEY = "topology";
    public static final String TOPOLOGY_ARG = "-topology";
    public static final String SESSION_KEY = "session";
    public static final String SESSION_ARG = "-session";
    public static final String PARALLEL_KEY = "parallel";
    public static final String PARALLEL_ARG = "-parallel";
    public static final String RESTARTED_KEY = "restarted";
    public static final String RESTARTED_ARG = "-restarted";
    public static final String OUT_OF_PLACE_KEY = "out.of.place";
    public static final String OUT_OF_PLACE_ARG = "-oop";
    public static final String OUT_OF_PLACE_PATCH_GROUP = "out.of.place.patch.group";
    public static final String OUT_OF_PLACE_PHASES_GROUP = "out.of.place.phases.group";
    public static final String IMAGE_LOCATION_KEY = "image.location";
    public static final String IMAGE_LOCATION_ARG = "-image-location";
    public static final String CREATE_IMAGE_KEY = "create.image";
    public static final String CREATE_IMAGE_ARG = "-create-image";
    public static final String CREATE_IMAGE_GROUP_KEY = "create.image.group";
    public static final String APPLY_IMAGE_KEY = "apply.image";
    public static final String APPLY_IMAGE_ARG = "-apply-image";
    public static final String APPLY_IMAGE_GROUP_KEY = "apply.image.group";
    public static final String CREATE_APPLY_IMAGE_GROUP_KEY = "create.apply.image.group";
    public static final String CHECK_SUM_KEY = "check.sum";
    public static final String FORCE_CONFLICT_KEY = "force.conflict";
    public static final String FORCE_CONFLICT_ARG = "-force_conflict";
    public static final String SKIP_CONFLICT_KEY = "skip.conflict";
    public static final String SKIP_CONFLICT_ARG = "-skip_conflict";
    public static final String FORCE_SKIP_CONFLICT_GROUP_KEY = "force.skip.conflict.group";
    public static final String NO_RELINK_KEY = "no.relink";
    public static final String NO_RELINK_ARG = "-no_relink";
    public static final String SKIP_ENABLEALL_KEY = "skip.twostage.enable";
    public static final String SKIP_ENABLEALL_ARG = "-skip_twostage_enable";
    public static final String SKIP_RRPATCH_KEY = "skip.rrpatch";
    public static final String SKIP_RRPATCH_ARG = "-skip_rrpatch";
    public static final String POST_ENABLEALL_KEY = "post.twostage.enable";
    public static final String POST_ENABLEALL_ARG = "-post_twostage_enable";
    public static final String SKIP_ENABLEALL_RRPATCH_GROUP_KEY = "skip.enableall.rrpatch.group";
    public static final String POST_ENABLE_SKIP_RRPATCH_GROUP_KEY = "post.enableall.skip.rrpatch.group";
    public static final String SKIP_DATAPATCH_KEY = "skip.datapatch";
    public static final String SKIP_DATAPATCH_ARG = "-skip_datapatch";
    public static final String DELETE_INACTIVE_KEY = "delete.inactive";
    public static final String DELETE_INACTIVE_ARG = "-deleteInactivePatches";
    public static final String RELINK_EXTREME_PERF_KEY = "relink.extreme.performance";
    public static final String RELINK_EXTREME_PERF_ARG = "-extreme_perf";
    public static final String SSH_USER_EQUIVALENCE_KEY = "sshuserequivalence";
    public static final String SSH_USER_EQUIVALENCE_ARG = "-sshuserequivalence";
    public static final String SSH_USER_EQUIVALENCE_GROUP = "ssh.user.equivalence.group";
    public static final String SSH_ACCESS_KEY_GROUP = "ssh.access.key.group";
    public static final String SSH_ACCESS_KEY_PATH_KEY = "sshaccesskey";
    public static final String SSH_ACCESS_KEY_PATH_ARG = "-sshaccesskey";
    public static final String BACKUP_LOCATION_KEY = "backup.location";
    public static final String BACKUP_LOCATION_ARG = "-backup-location";
    public static final String REMOTE_IMAGE_LOCATION_KEY = "remote.image.location";
    public static final String REMOTE_IMAGE_LOCATION_ARG = "-remote-image-location";
    public static final String JRE_PATH_KEY = "jre";
    public static final String JRE_PATH_ARG = "-jre";
    public static final String DRAIN_TIMEOUT_KEY = "drain.timeout";
    public static final String DRAIN_TIMEOUT_ARG = "-drain_timeout";
    public static final String REPORTING_TYPE_KEY = "type";
    public static final String REPORTING_TYPE_ARG = "-type";
    public static final String REPORTING_FORMAT_KEY = "format";
    public static final String REPORTING_FORMAT_ARG = "-format";
    public static final String REPORTING_OUTPUT_LOCATION_KEY = "output";
    public static final String REPORTING_OUTPUT_LOCATION_ARG = "-output";
    private Map<OPatchAutoCommand, Set<OPatchAutoOption>> _commandOptions = new HashMap<OPatchAutoCommand, Set<OPatchAutoOption>>();
    private Set<OPatchAutoOption> _globalOptions = new LinkedHashSet<OPatchAutoOption>();
    private Map<OPatchAutoCommand, OPatchAutoOption> _commandParameters = new LinkedHashMap<OPatchAutoCommand, OPatchAutoOption>();
    private Set<OPatchAutoOption> _allOptions = new LinkedHashSet<OPatchAutoOption>();
    private Set<OPatchAutoOptionGroup> _optionGroups = new LinkedHashSet<OPatchAutoOptionGroup>();
    private OPatchAutoCommand _command;
    Set<OPatchAutoOption> _populatedOptions;

    public static OPatchAutoOptions getInstance() {
        return new OPatchAutoOptions();
    }

    protected OPatchAutoOptions() {
        this.loadOptions();
    }

    public Set<OPatchAutoOption> getPopulatedOptions() {
        return this._populatedOptions;
    }

    public void setPopulatedOptions(Set<OPatchAutoOption> populatedOptions) {
        this._populatedOptions = populatedOptions;
    }

    private void loadOptions() {
        OPatchAutoOption help = OPatchAutoOption.getGlobalOption(HELP_KEY, HELP_ARG, "opatchauto.option.help.description", true, false);
        help.setPerCommandGlobal(true);
        this.registerOption(help);
        OPatchAutoOption patchDirectory = OPatchAutoOption.getCommandOption(PATCH_DIRECTORY_KEY, PATCH_DIRECTORY_ARG, "opatchauto.option.patchDirectory.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        patchDirectory.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true) && !new File(value).isDirectory()) {
                    throw new OPatchAutoException("68052", value);
                }
            }
        });
        this.registerOption(patchDirectory);
        OPatchAutoOption patchLocation = OPatchAutoOption.getParameterOption(PATCH_LOCATION_KEY, "patch-location", "opatchauto.option.patchLocation.description", false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        patchLocation.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true) && !new File(value).exists()) {
                    throw new OPatchAutoException("68053", value);
                }
            }
        });
        this.registerOption(patchLocation);
        OPatchAutoOption id = OPatchAutoOption.getCommandOption(ID_KEY, ID_ARG, "opatchauto.option.id.description", OPatchAutoCommand.rollback);
        id.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    boolean allPatchesValid = true;
                    StringBuffer invalidPatches = new StringBuffer("");
                    Pattern pattern = Pattern.compile("[0-9]+");
                    StringTokenizer idTokenizer = new StringTokenizer(value, ",");
                    if (!idTokenizer.hasMoreTokens()) {
                        throw new OPatchAutoException("68154", new Object[0]);
                    }
                    while (idTokenizer.hasMoreTokens()) {
                        String patchID = idTokenizer.nextToken();
                        Matcher matcher = pattern.matcher(patchID);
                        if (matcher.matches()) continue;
                        allPatchesValid = false;
                        invalidPatches.append((invalidPatches.length() == 0 ? "" : ", ") + patchID);
                    }
                    if (!allPatchesValid) {
                        throw new OPatchAutoException("68153", invalidPatches);
                    }
                }
            }
        });
        this.registerOption(id);
        OPatchAutoOptionGroup patchLocationGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(PATCH_LOCATION_GROUP_KEY, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, patchDirectory, patchLocation);
        this.registerOptionGroup(patchLocationGroup);
        OPatchAutoOptionGroup patchIdGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(PATCH_ID_GROUP_KEY, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, patchDirectory, patchLocation, id);
        this.registerOptionGroup(patchIdGroup);
        OPatchAutoOption oh = OPatchAutoOption.getCommandOption(HOME_KEY, HOME_ARG, "opatchauto.option.oh.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        oh.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            @Override
            public String getDefaultValue() throws OPatchAutoException {
                return OPatchAutoHelper.getOPatchAutoHome();
            }
        });
        this.registerOption(oh);
        OPatchAutoOption phases = OPatchAutoOption.getCommandOption(PHASES_KEY, PHASES_ARG, "opatchauto.option.phases.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(phases);
        OPatchAutoOption log = OPatchAutoOption.getCommandOption(LOG_KEY, LOG_ARG, "opatchauto.option.log.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.action, OPatchAutoCommand.resume, OPatchAutoCommand.report);
        log.setTracked(false);
        this.registerOption(log);
        OPatchAutoOption logLevel = OPatchAutoOption.getCommandOption(LOG_LEVEL_KEY, LOG_LEVEL_ARG, "opatchauto.option.logLevel.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.action, OPatchAutoCommand.resume, OPatchAutoCommand.report);
        logLevel.setDefaultValue("INFO");
        logLevel.setTracked(false);
        logLevel.setSupportedValues(new String[]{OPatchAutoHelper.getSupportedLogLevels().toString()});
        logLevel.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    try {
                        Level.parse(value.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new OPatchAutoException("68054", value, OPatchAutoHelper.getSupportedLogLevels());
                    }
                }
            }
        });
        this.registerOption(logLevel);
        OPatchAutoOption customLogDir = OPatchAutoOption.getCommandOption(CUSTOM_LOG_DIR_KEY, CUSTOM_LOG_DIR_ARG, "opatchauto.option.customLogDir.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.action, OPatchAutoCommand.resume, OPatchAutoCommand.report);
        customLogDir.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true) && !new File(value).isDirectory()) {
                    throw new OPatchAutoException("68167", value);
                }
            }
        });
        this.registerOption(customLogDir);
        OPatchAutoOption binary = OPatchAutoOption.getCommandOption(BINARY_KEY, BINARY_ARG, "opatchauto.option.binary.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        binary.setTracked(false);
        this.registerOption(binary);
        OPatchAutoOption analyze = OPatchAutoOption.getCommandOption(ANALYZE_KEY, ANALYZE_ARG, "opatchauto.option.analyze.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(analyze);
        OPatchAutoOption instance = OPatchAutoOption.getCommandOption(INSTANCE_KEY, INSTANCE_ARG, "opatchauto.option.instance.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(instance);
        OPatchAutoOption inventoryPtr = OPatchAutoOption.getCommandOption(INV_PTR_LOC_KEY, INV_PTR_LOC_ARG, "opatchauto.option.inventoryPtr.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(inventoryPtr);
        OPatchAutoOption host = OPatchAutoOption.getCommandOption(HOST_KEY, HOST_ARG, "opatchauto.option.host.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        host.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            @Override
            public String getDefaultValue() throws OPatchAutoException {
                return OPatchAutoHelper.getOPatchAutoHost();
            }
        });
        this.registerOption(host);
        OPatchAutoOption username = OPatchAutoOption.getCommandOption(USERNAME_KEY, USERNAME_ARG, "opatchauto.option.username.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        this.registerOption(username);
        OPatchAutoOption password = OPatchAutoOption.getCommandOption(PASSWORD_KEY, PASSWORD_ARG, "opatchauto.option.password.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.resume, OPatchAutoCommand.report);
        password.setPassword(true);
        this.registerOption(password);
        OPatchAutoOption plan = OPatchAutoOption.getCommandOption(PATCH_PLAN_KEY, PATCH_PLAN_ARG, "opatchauto.option.plan.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        plan.setDefaultValue("rolling");
        this.registerOption(plan);
        OPatchAutoOption container = OPatchAutoOption.getCommandOption(CONTAINER_KEY, CONTAINER_ARG, "opatchauto.option.container.description", OPatchAutoCommand.action);
        this.registerOption(container);
        OPatchAutoOption wallet = OPatchAutoOption.getCommandOption(WALLET_KEY, WALLET_ARG, "opatchauto.option.wallet.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        this.registerOption(wallet);
        OPatchAutoOption walletPassword = OPatchAutoOption.getCommandOption(WALLET_PASSWORD_KEY, WALLET_PASSWORD_ARG, "opatchauto.option.walletPassword.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.resume, OPatchAutoCommand.report);
        walletPassword.setPassword(true);
        this.registerOption(walletPassword);
        OPatchAutoOptionGroup walletAndUsernameGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(WALLET_AND_USERNAME_GROUP, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, wallet, username);
        this.registerOptionGroup(walletAndUsernameGroup);
        OPatchAutoOptionGroup walletAndPasswordGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(WALLET_AND_PASSWORD_GROUP, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, wallet, password);
        this.registerOptionGroup(walletAndPasswordGroup);
        OPatchAutoOptionGroup walletPasswordAndUsernameGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(WALLET_PASSWORD_AND_USERNAME_GROUP, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, walletPassword, username);
        this.registerOptionGroup(walletPasswordAndUsernameGroup);
        OPatchAutoOptionGroup walletPasswordAndPasswordGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(WALLET_PASSWORD_AND_PASSWORD_GROUP, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, walletPassword, password);
        this.registerOptionGroup(walletPasswordAndPasswordGroup);
        OPatchAutoOption topology = OPatchAutoOption.getCommandOption(TOPOLOGY_KEY, TOPOLOGY_ARG, "opatchauto.option.topology.description", OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        this.registerOption(topology);
        OPatchAutoOption session = OPatchAutoOption.getCommandOption(SESSION_KEY, SESSION_ARG, "opatchauto.option.session.description", false, true, OPatchAutoCommand.rollback, OPatchAutoCommand.resume);
        this.registerOption(session);
        OPatchAutoOption parallel = OPatchAutoOption.getCommandOption(PARALLEL_KEY, PARALLEL_ARG, "opatchauto.option.parallel.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(parallel);
        OPatchAutoOption restarted = OPatchAutoOption.getCommandOption(RESTARTED_KEY, RESTARTED_ARG, "opatchauto.option.restarted.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.resume);
        restarted.setTracked(false);
        restarted.setVisible(false);
        this.registerOption(restarted);
        OPatchAutoOption outOfPlace = OPatchAutoOption.getCommandOption(OUT_OF_PLACE_KEY, OUT_OF_PLACE_ARG, "opatchauto.option.out.of.place.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(outOfPlace);
        OPatchAutoOptionGroup outOfPlacePatchOptionGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(OUT_OF_PLACE_PATCH_GROUP, OPatchAutoOptionGroup.Relationship.if_first_then_at_least_one_required, false, outOfPlace, patchLocation, patchDirectory);
        this.registerOptionGroup(outOfPlacePatchOptionGroup);
        OPatchAutoOptionGroup outOfPlacePhasesOptionGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(OUT_OF_PLACE_PHASES_GROUP, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, outOfPlace, phases);
        this.registerOptionGroup(outOfPlacePhasesOptionGroup);
        OPatchAutoOption imageLocation = OPatchAutoOption.getCommandOption(IMAGE_LOCATION_KEY, IMAGE_LOCATION_ARG, "opatchauto.option.image.location.description", OPatchAutoCommand.apply);
        this.registerOption(imageLocation);
        OPatchAutoOption createImage = OPatchAutoOption.getCommandOption(CREATE_IMAGE_KEY, CREATE_IMAGE_ARG, "opatchauto.option.create.image.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(createImage);
        OPatchAutoOption applyImage = OPatchAutoOption.getCommandOption(APPLY_IMAGE_KEY, APPLY_IMAGE_ARG, "opatchauto.option.apply.image.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(applyImage);
        OPatchAutoOptionGroup createImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(CREATE_IMAGE_GROUP_KEY, OPatchAutoOptionGroup.Relationship.if_first_then_all_required, false, createImage, imageLocation);
        this.registerOptionGroup(createImageGroup);
        OPatchAutoOptionGroup applyImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(APPLY_IMAGE_GROUP_KEY, OPatchAutoOptionGroup.Relationship.if_first_then_all_required, false, applyImage, imageLocation);
        this.registerOptionGroup(applyImageGroup);
        OPatchAutoOptionGroup createApplyImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(CREATE_APPLY_IMAGE_GROUP_KEY, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, createImage, applyImage);
        this.registerOptionGroup(createApplyImageGroup);
        OPatchAutoOption forceConflict = OPatchAutoOption.getCommandOption(FORCE_CONFLICT_KEY, FORCE_CONFLICT_ARG, "opatchauto.option.forceconflict.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(forceConflict);
        OPatchAutoOption skipConflict = OPatchAutoOption.getCommandOption(SKIP_CONFLICT_KEY, SKIP_CONFLICT_ARG, "opatchauto.option.skipconflict.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(skipConflict);
        OPatchAutoOptionGroup forceAndSkipConflictGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(FORCE_SKIP_CONFLICT_GROUP_KEY, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, forceConflict, skipConflict);
        this.registerOptionGroup(forceAndSkipConflictGroup);
        OPatchAutoOption noRelink = OPatchAutoOption.getCommandOption(NO_RELINK_KEY, NO_RELINK_ARG, "opatchauto.option.norelink.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(noRelink);
        OPatchAutoOption deleteInactive = OPatchAutoOption.getCommandOption(DELETE_INACTIVE_KEY, DELETE_INACTIVE_ARG, "opatchauto.option.deleteInactive.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(deleteInactive);
        OPatchAutoOption skipDatapatch = OPatchAutoOption.getCommandOption(SKIP_DATAPATCH_KEY, SKIP_DATAPATCH_ARG, "opatchauto.option.skipdatapatch.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(skipDatapatch);
        OPatchAutoOption skipenableall = OPatchAutoOption.getCommandOption(SKIP_ENABLEALL_KEY, SKIP_ENABLEALL_ARG, "opatchauto.option.skipenableall.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(skipenableall);
        OPatchAutoOption skiprrpatch = OPatchAutoOption.getCommandOption(SKIP_RRPATCH_KEY, SKIP_RRPATCH_ARG, "opatchauto.option.skiprrpatch.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(skiprrpatch);
        OPatchAutoOption postenableall = OPatchAutoOption.getCommandOption(POST_ENABLEALL_KEY, POST_ENABLEALL_ARG, "opatchauto.option.postenableall.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(postenableall);
        OPatchAutoOptionGroup enableAllAndSkiprrpatchGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(SKIP_ENABLEALL_RRPATCH_GROUP_KEY, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, skipenableall, skiprrpatch, postenableall);
        this.registerOptionGroup(enableAllAndSkiprrpatchGroup);
        OPatchAutoOption extremeperf = OPatchAutoOption.getCommandOption(RELINK_EXTREME_PERF_KEY, RELINK_EXTREME_PERF_ARG, "opatchauto.option.extremeperf.description", true, false, OPatchAutoCommand.apply);
        this.registerOption(extremeperf);
        OPatchAutoOption sshUserEquivalence = OPatchAutoOption.getCommandOption(SSH_USER_EQUIVALENCE_KEY, SSH_USER_EQUIVALENCE_ARG, "opatchauto.option.sshuserequivalence.description", true, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        this.registerOption(sshUserEquivalence);
        OPatchAutoOption sshAccessKey = OPatchAutoOption.getCommandOption(SSH_ACCESS_KEY_PATH_KEY, SSH_ACCESS_KEY_PATH_ARG, "opatchauto.option.sshaccesskey.description", false, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.report);
        sshAccessKey.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            @Override
            public String getDefaultValue() throws OPatchAutoException {
                if (OPatchAutoOptions.this.getOption(OPatchAutoOptions.SSH_USER_EQUIVALENCE_KEY).isSwitchEnabled()) {
                    String sshAccessKey = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_rsa";
                    if (!new File(sshAccessKey).exists()) {
                        sshAccessKey = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_dsa";
                    }
                    return sshAccessKey;
                }
                return null;
            }
        });
        this.registerOption(sshAccessKey);
        OPatchAutoOptionGroup sshUserEquivalenceOptionGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(SSH_USER_EQUIVALENCE_GROUP, OPatchAutoOptionGroup.Relationship.mutually_exclusive, false, sshUserEquivalence, username);
        this.registerOptionGroup(sshUserEquivalenceOptionGroup);
        OPatchAutoOptionGroup sshAccessKeyOptionGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup(SSH_ACCESS_KEY_GROUP, OPatchAutoOptionGroup.Relationship.if_first_then_all_required, false, sshAccessKey, sshUserEquivalence);
        this.registerOptionGroup(sshAccessKeyOptionGroup);
        OPatchAutoOption jrePathKey = OPatchAutoOption.getCommandOption(JRE_PATH_KEY, JRE_PATH_ARG, "opatchauto.option.jre.description", false, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(jrePathKey);
        OPatchAutoOption drainTimeoutKey = OPatchAutoOption.getCommandOption(DRAIN_TIMEOUT_KEY, DRAIN_TIMEOUT_ARG, "opatchauto.option.draintimeout.description", false, false, OPatchAutoCommand.apply, OPatchAutoCommand.rollback);
        this.registerOption(drainTimeoutKey);
        OPatchAutoOption backupLocationKey = OPatchAutoOption.getCommandOption(BACKUP_LOCATION_KEY, BACKUP_LOCATION_ARG, "opatchauto.option.backuplocation.description", false, false, OPatchAutoCommand.apply);
        backupLocationKey.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            @Override
            public String getDefaultValue() throws OPatchAutoException {
                File homePath;
                String backupLocation = null;
                if ((OPatchAutoOptions.this.getOption(OPatchAutoOptions.APPLY_IMAGE_KEY).isSwitchEnabled() || OPatchAutoOptions.this.getOption(OPatchAutoOptions.OUT_OF_PLACE_KEY).isSwitchEnabled()) && (homePath = FileUtils.getFile((String)OPatchAutoOptions.this.getOption(OPatchAutoOptions.HOME_KEY).getValue())) != null) {
                    File backupDir = FileUtils.getFile((String)System.getProperty("backup.home.dir", homePath.getParent()));
                    backupLocation = backupDir.getPath() + File.separator + homePath.getName() + "_" + OPatchAutoOptions.this.getOption(OPatchAutoOptions.SESSION_KEY).getValue();
                }
                return backupLocation;
            }
        });
        backupLocationKey.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                File ohpath = FileUtils.getFile((String)OPatchAutoOptions.this.getOption(OPatchAutoOptions.HOME_KEY).getValue());
                File backupLoc = FileUtils.getFile((String)value);
                if (backupLoc != null) {
                    String backupRoot;
                    String ohRoot;
                    if (ohpath.equals(backupLoc) || backupLoc.getPath().startsWith(ohpath.getPath() + File.separator)) {
                        throw new OPatchAutoException("68156", value);
                    }
                    if (ComdevHelper.isWindows() && !(ohRoot = OPatchAutoOptions.this.findRootDirectory(ohpath)).equals(backupRoot = OPatchAutoOptions.this.findRootDirectory(backupLoc))) {
                        throw new OPatchAutoException("68157", value);
                    }
                }
            }
        });
        this.registerOption(backupLocationKey);
        OPatchAutoOption remoteImage = OPatchAutoOption.getCommandOption(REMOTE_IMAGE_LOCATION_KEY, REMOTE_IMAGE_LOCATION_ARG, "opatchauto.option.remote.image.location.description", OPatchAutoCommand.apply);
        this.registerOption(remoteImage);
        OPatchAutoOption reportType = OPatchAutoOption.getCommandOption(REPORTING_TYPE_KEY, REPORTING_TYPE_ARG, "opatchauto.option.report.type.description", false, true, OPatchAutoCommand.report);
        String[] reportTypeSupportedValues = new String[]{"patches"};
        reportType.setSupportedValues(reportTypeSupportedValues);
        reportType.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    ArrayList<String> supportedVal = new ArrayList<String>();
                    supportedVal.addAll(Arrays.asList(OPatchAutoOptions.this.getOption(OPatchAutoOptions.REPORTING_TYPE_KEY).getSupportedValues()));
                    if (!supportedVal.contains(value)) {
                        throw new OPatchAutoException("68162", value, supportedVal);
                    }
                }
            }
        });
        this.registerOption(reportType);
        OPatchAutoOption reportFormat = OPatchAutoOption.getCommandOption(REPORTING_FORMAT_KEY, REPORTING_FORMAT_ARG, "opatchauto.option.report.format.description", false, false, OPatchAutoCommand.report);
        String[] reportFormatSupportedValues = new String[]{"xml"};
        reportFormat.setSupportedValues(reportFormatSupportedValues);
        reportFormat.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            @Override
            public String getDefaultValue() throws OPatchAutoException {
                return "xml";
            }
        });
        reportFormat.setValueValidator(new OPatchAutoOption.ValueValidator(){

            @Override
            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    ArrayList<String> supportedVal = new ArrayList<String>();
                    supportedVal.addAll(Arrays.asList(OPatchAutoOptions.this.getOption(OPatchAutoOptions.REPORTING_FORMAT_KEY).getSupportedValues()));
                    if (!supportedVal.contains(value)) {
                        throw new OPatchAutoException("68163", value, supportedVal);
                    }
                }
            }
        });
        this.registerOption(reportFormat);
        OPatchAutoOption reportOutputLocation = OPatchAutoOption.getCommandOption(REPORTING_OUTPUT_LOCATION_KEY, REPORTING_OUTPUT_LOCATION_ARG, "opatchauto.option.report.output.location.description", false, false, OPatchAutoCommand.report);
        reportOutputLocation.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            @Override
            public String getDefaultValue() throws OPatchAutoException {
                return "console";
            }
        });
        this.registerOption(reportOutputLocation);
    }

    public void loadProductOptions(ProductSupportManager productSupportManager) throws OPatchAutoException {
        if (productSupportManager != null) {
            for (ProductSupport productSupport : productSupportManager.getProductSupport()) {
                Set<OPatchAutoOptionGroup> productOptionGroups;
                Set<OPatchAutoOption> productOptions = productSupport.getOptions();
                if (productOptions != null) {
                    this.registerOptions(productOptions);
                }
                if ((productOptionGroups = productSupport.getOptionGroups(this)) == null) continue;
                this.registerOptionGroups(productOptionGroups);
            }
            for (ProductSupport productSupport : productSupportManager.getProductSupport()) {
                productSupport.updateOptionApplicability(this);
            }
        }
    }

    void registerOption(OPatchAutoOption option) {
        OPatchAutoCommand[] commands;
        if (option == null) {
            throw new NullPointerException(OPatchAutoHelper.getPublishedMessage("68055", new Object[0]));
        }
        if (StringUtil.isNullOrEmpty((String)option.getArg())) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68056", new Object[0]));
        }
        try {
            OPatchAutoOption existingOption = this.getOption(option.getKey(), false);
            if (existingOption != null) {
                throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68057", option, existingOption));
            }
        }
        catch (OPatchAutoException existingOption) {
            // empty catch block
        }
        if (option.isGlobal()) {
            this._globalOptions.add(option);
        } else if (option.isParameter()) {
            commands = option.getCommands();
            if (commands != null) {
                for (OPatchAutoCommand command : commands) {
                    if (this._commandParameters.containsKey((Object)command)) {
                        throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68058", new Object[]{command}));
                    }
                    this._commandParameters.put(command, option);
                }
            }
        } else {
            commands = option.getCommands();
            if (commands != null) {
                for (OPatchAutoCommand command : commands) {
                    Set<OPatchAutoOption> options = this._commandOptions.get((Object)command);
                    if (options == null) {
                        options = new LinkedHashSet<OPatchAutoOption>();
                        this._commandOptions.put(command, options);
                    }
                    options.add(option);
                }
            }
        }
        this._allOptions.add(option);
    }

    void unregisterOption(OPatchAutoOption option) {
        if (option != null) {
            this._globalOptions.remove(option);
            Iterator<Map.Entry<OPatchAutoCommand, OPatchAutoOption>> it = this._commandParameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<OPatchAutoCommand, OPatchAutoOption> entry = it.next();
                if (!option.equals(entry.getValue())) continue;
                it.remove();
            }
            for (Set<OPatchAutoOption> options : this._commandOptions.values()) {
                if (options == null) continue;
                options.remove(option);
            }
            this._allOptions.remove(option);
        }
    }

    public void updateOptionRegistration(OPatchAutoOption option) {
        if (option != null) {
            this.unregisterOption(option);
            this.registerOption(option);
        }
    }

    void registerOptions(Collection<OPatchAutoOption> options) {
        if (options != null) {
            for (OPatchAutoOption option : options) {
                this.registerOption(option);
            }
        }
    }

    void registerOptionGroups(Collection<OPatchAutoOptionGroup> optionGroups) {
        if (optionGroups != null) {
            for (OPatchAutoOptionGroup option : optionGroups) {
                this.registerOptionGroup(option);
            }
        }
    }

    public OPatchAutoCommand getCommand() {
        return this._command;
    }

    public void setCommand(OPatchAutoCommand command) {
        this._command = command;
    }

    Set<OPatchAutoOption> getGlobalOptions() {
        return this._globalOptions;
    }

    public Set<OPatchAutoOption> getAllOptions() {
        return this._allOptions;
    }

    Set<OPatchAutoOption> getCommandOptions(OPatchAutoCommand command) {
        Set<OPatchAutoOption> options = this._commandOptions.get((Object)command);
        return options != null ? new LinkedHashSet<OPatchAutoOption>(options) : new LinkedHashSet();
    }

    Set<OPatchAutoOption> getRequiredCommandOptions(OPatchAutoCommand command) {
        OPatchAutoOption parameter;
        LinkedHashSet<OPatchAutoOption> required = new LinkedHashSet<OPatchAutoOption>();
        Set<OPatchAutoOption> options = this.getCommandOptions(command);
        if (options != null) {
            for (OPatchAutoOption option : options) {
                if (option == null || !option.isRequired()) continue;
                required.add(option);
            }
        }
        if ((parameter = this.getCommandParameter(command)) != null && parameter.isRequired()) {
            required.add(parameter);
        }
        return required;
    }

    OPatchAutoOption getCommandParameter(OPatchAutoCommand command) {
        return this._commandParameters.get((Object)command);
    }

    public OPatchAutoOption getOption(String key) throws OPatchAutoException {
        return this.getOption(key, false);
    }

    OPatchAutoOption getOption(String name, boolean isArg) throws OPatchAutoException {
        Set<OPatchAutoOption> options;
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true) && (options = this.getAllOptions()) != null && !options.isEmpty()) {
            for (OPatchAutoOption option : options) {
                if ((!isArg || !name.equalsIgnoreCase(option.getArg())) && (isArg || !name.equalsIgnoreCase(option.getKey()))) continue;
                return option;
            }
        }
        String argOrOption = isArg ? OPatchAutoHelper.getLocalizedString("OPatchAutoOptions.argument", new Object[0]) : OPatchAutoHelper.getLocalizedString("OPatchAutoOptions.option", new Object[0]);
        throw new OPatchAutoException("68059", argOrOption, name);
    }

    void registerOptionGroup(OPatchAutoOptionGroup group) {
        this._optionGroups.add(group);
    }

    Set<OPatchAutoOptionGroup> getOptionGroups() {
        return this._optionGroups;
    }

    public OPatchAutoOptionGroup getOptionGroup(String key) throws OPatchAutoException {
        if (!StringUtil.isNullOrEmpty((String)key)) {
            for (OPatchAutoOptionGroup group : this._optionGroups) {
                if (group == null || !key.equals(group.getKey())) continue;
                return group;
            }
        }
        throw new OPatchAutoException("68060", key);
    }

    public boolean isOptionGroup(String key) {
        if (!StringUtil.isNullOrEmpty((String)key)) {
            for (OPatchAutoOptionGroup group : this._optionGroups) {
                if (group == null || !key.equals(group.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<OPatchAutoOptionGroup> getRequiredOptionGroups() {
        LinkedHashSet<OPatchAutoOptionGroup> required = new LinkedHashSet<OPatchAutoOptionGroup>();
        Set<OPatchAutoOptionGroup> groups = this.getOptionGroups();
        if (groups != null) {
            for (OPatchAutoOptionGroup group : groups) {
                if (group == null || !group.isRequired()) continue;
                required.add(group);
            }
        }
        return required;
    }

    Map<String, String> getOptionsValueMap() throws OPatchAutoException {
        return this.getOptionsValueMap(false);
    }

    Map<String, String> getOptionsValueMap(boolean useArgs) throws OPatchAutoException {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Set<OPatchAutoOption> options = this.getAllOptions();
        if (options != null && !options.isEmpty()) {
            for (OPatchAutoOption option : options) {
                if (option.isPassword() || !option.hasValue()) continue;
                values.put(useArgs ? option.getArg() : option.getKey(), option.getValue());
            }
        }
        return values;
    }

    public void validate(OPatchAutoCommand command) throws OPatchAutoException {
        OPatchAutoOption parameter;
        Set<OPatchAutoOption> options = this.getCommandOptions(command);
        if (options != null) {
            for (OPatchAutoOption option : options) {
                option.validate();
            }
        }
        if ((parameter = this.getCommandParameter(command)) != null && parameter.isRequired()) {
            parameter.validate();
        }
    }

    public void logOptions() throws OPatchAutoException {
        _log.info(this.getClass().getSimpleName() + " configured options:");
        for (OPatchAutoOption option : this.getAllOptions()) {
            String value;
            if (!option.hasValue()) continue;
            if (option.isPassword()) {
                value = "";
                char[] password = option.getPasswordValue();
                if (password != null) {
                    Arrays.fill(password, '*');
                    value = new String(password);
                }
            } else {
                value = option.getValue();
            }
            _log.info("Option: " + option + " Value:" + value);
        }
    }

    private String findRootDirectory(File file) {
        File[] rootDirList;
        String rootDirStr = null;
        for (File rootDir : rootDirList = File.listRoots()) {
            if (!file.getPath().startsWith(rootDir.getPath())) continue;
            rootDirStr = rootDir.getName();
            break;
        }
        return rootDirStr;
    }
}

