/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.credential;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import java.io.Serializable;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class ValueHolder
implements Serializable {
    private final Random RANDOM = new SecureRandom();
    private byte[] _s = this.getS();
    private char[] _p = this.getP();
    private byte[] _e;
    private byte[] _iv;

    public ValueHolder(char[] value) throws OPatchAutoException {
        this._e = this.e(value, this._p, this._s);
    }

    public char[] getValue() throws OPatchAutoException {
        return this.d(this._e, this._p, this._s);
    }

    private byte[] getS() {
        byte[] s = new byte[8];
        this.RANDOM.nextBytes(s);
        return s;
    }

    private char[] getP() {
        int length = 32;
        char[] p = new char[length];
        char[] chars = "abcdefghijklmnopqrstuvwxyz1234567890".toCharArray();
        for (int i = 0; i < 32; ++i) {
            p[i] = chars[this.RANDOM.nextInt(chars.length)];
        }
        return p;
    }

    private byte[] e(char[] value, char[] p, byte[] s) throws OPatchAutoException {
        try {
            SecretKey secret = this.getSK(p, s);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = new byte[12];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(iv);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secret, gcmSpec);
            this._iv = iv;
            return cipher.doFinal(OPatchAutoHelper.toBytes(value));
        }
        catch (Exception e) {
            throw new OPatchAutoException(e);
        }
    }

    private char[] d(byte[] processedValue, char[] p, byte[] s) throws OPatchAutoException {
        try {
            SecretKey secret = this.getSK(p, s);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            int GCM_TAG_LENGTH = 128;
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this._iv);
            cipher.init(2, (Key)secret, gcmSpec);
            return OPatchAutoHelper.toChars(cipher.doFinal(processedValue));
        }
        catch (Exception e) {
            throw new OPatchAutoException(e);
        }
    }

    private SecretKey getSK(char[] p, byte[] s) throws OPatchAutoException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(p, s, 110000, 128);
            SecretKey tmp = factory.generateSecret(spec);
            return new SecretKeySpec(tmp.getEncoded(), "AES");
        }
        catch (Exception e) {
            throw new OPatchAutoException(e);
        }
    }
}

