/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.session;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.MutablePatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Instance;
import com.oracle.glcm.patch.auto.tracking.InstanceInventory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchTargetImpl
implements MutablePatchTarget {
    private static final Logger _log = Logger.getLogger(PatchTargetImpl.class.getName());
    private ProductType _productType;
    private Home _home;
    private Home _homeClone;
    private boolean _usingHomeClone;
    private Instance _instance;
    private transient InstanceInventory _instanceInventory;

    public PatchTargetImpl(ProductType productType, Home home) {
        this(productType, home, null);
    }

    public PatchTargetImpl(ProductType productType, Home home, Instance instance) {
        if (productType == null) {
            throw new NullPointerException(OPatchAutoHelper.getPublishedMessage("68101", new Object[0]));
        }
        this._productType = productType;
        this.setHome(home);
        this.setInstance(instance);
    }

    @Override
    public String getType() {
        return this._productType.getType();
    }

    @Override
    public ProductType getProductType() {
        return this._productType;
    }

    @Override
    public boolean isHome() {
        return this._productType.getSupportType().isHome();
    }

    @Override
    public boolean isInstance() {
        return this._productType.getSupportType().isInstance();
    }

    @Override
    public Home getHome() {
        return this.getHome(false);
    }

    @Override
    public Home getHome(boolean originalSource) {
        if (originalSource) {
            return this._home;
        }
        return this._usingHomeClone ? this._homeClone : this._home;
    }

    @Override
    public void setHome(Home home) {
        if (home == null) {
            throw new NullPointerException(OPatchAutoHelper.getPublishedMessage("68102", new Object[0]));
        }
        this._home = home;
    }

    @Override
    public Home getHomeClone() {
        return this._homeClone;
    }

    @Override
    public void setHomeClone(Home homeClone) {
        this._homeClone = homeClone;
    }

    @Override
    public boolean isUsingHomeClone() {
        return this._usingHomeClone;
    }

    @Override
    public void setUsingHomeClone(boolean usingHomeClone) {
        this._usingHomeClone = usingHomeClone;
    }

    @Override
    public Instance getInstance() {
        return this._instance;
    }

    @Override
    public void setInstance(Instance instance) {
        if (this._productType.getSupportType().isInstance() && instance == null) {
            throw new NullPointerException(OPatchAutoHelper.getPublishedMessage("68103", new Object[0]));
        }
        this._instance = instance;
    }

    public boolean hasInstance() {
        return this.getInstance() != null;
    }

    @Override
    public boolean isRemote() throws OPatchAutoException {
        Host host = this.getHost();
        return host != null && host.isRemote();
    }

    @Override
    public Host getHost() {
        return this._home.getHost();
    }

    @Override
    public InstanceInventory getInstanceInventory() {
        if (this.hasInstance() && this._instanceInventory == null) {
            this._instanceInventory = new InstanceInventory(this.getInstance());
        }
        return this._instanceInventory;
    }

    @Override
    public String toReportingString() {
        String s = (Object)((Object)this._productType.getSupportType()) + " ";
        try {
            if (this.isRemote()) {
                s = s + this.getHost().getHost() + ":";
            }
        }
        catch (OPatchAutoException e) {
            _log.log(Level.WARNING, "Failed to determine if host was remote.", e);
        }
        s = this._productType.getSupportType().isInstance() ? s + this.getInstance().getLocation() : s + this.getHome().getLocation();
        return s;
    }

    @Override
    public String toOrigReportingString() {
        String s = (Object)((Object)this._productType.getSupportType()) + " ";
        try {
            if (this.isRemote()) {
                s = s + this.getHost().getHost() + ":";
            }
        }
        catch (OPatchAutoException e) {
            _log.log(Level.WARNING, "Failed to determine if host was remote.", e);
        }
        s = this._productType.getSupportType().isInstance() ? s + this.getInstance().getLocation() : s + this.getHome(true).getLocation();
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchTargetImpl)) {
            return false;
        }
        PatchTargetImpl that = (PatchTargetImpl)o;
        if (!this._home.equals(that._home)) {
            return false;
        }
        if (this._productType != null ? !this._productType.equals(that._productType) : that._productType != null) {
            return false;
        }
        return !(this._instance != null ? !this._instance.equals(that._instance) : that._instance != null);
    }

    public int hashCode() {
        int result = this._home.hashCode();
        result = 31 * result + (this._productType != null ? this._productType.hashCode() : 0);
        result = 31 * result + (this._instance != null ? this._instance.hashCode() : 0);
        return result;
    }

    public String toString() {
        String s = "";
        Host host = this.getHost();
        if (host != null) {
            String username = host.getUsername();
            if (username != null) {
                s = s + username + "@";
            }
            s = s + host.getHost();
            Integer port = host.getPort();
            if (port != null) {
                s = s + ":" + port;
            }
            s = s + "->";
        }
        s = s + this.getHome().getLocation();
        if (this.hasInstance()) {
            s = s + "->" + this.getInstance().getLocation();
        }
        s = s + " " + OPatchAutoHelper.getLocalizedString("PatchTargetImpl.type", this.getType());
        return s;
    }
}

