/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.topology;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Instance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HostImpl
implements Host {
    private static final Logger _log = Logger.getLogger(HostImpl.class.getName());
    public static final String LOCAL_HOST = "localhost";
    private static final String HOSTNAME = "hostname";
    private static final String IPV4_PATTERN = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
    private static final String IPV6_COMMPRESSED_PATTERN = "^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$";
    private static final String IPV6_PATTERN = "^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$";
    private String _host = "localhost";
    private Integer _port;
    private Credential _credential;
    private String _proxyHost;
    private Integer _proxyPort;
    private String _remoteConnectionType = "ssh";
    private String _fileTransferType = "sftptransfer";
    private List<Home> _homes = new ArrayList<Home>();
    private String _patchLocation;
    private transient Boolean _remote;

    @Override
    public Set<Home> getHomes() {
        return new LinkedHashSet<Home>(this._homes);
    }

    @Override
    public void setHomes(Set<Home> homes) {
        if (!this._homes.isEmpty()) {
            this._homes.clear();
        }
        if (homes != null) {
            for (Home home : homes) {
                this.addHome(home);
            }
        }
    }

    @Override
    public void addHome(Home home) {
        if (home != null && !this._homes.contains(home)) {
            this._homes.add(home);
        }
    }

    @Override
    public Set<Instance> getInstances() {
        LinkedHashSet<Instance> instances = new LinkedHashSet<Instance>();
        Set<Home> homes = this.getHomes();
        if (homes != null && !homes.isEmpty()) {
            for (Home home : homes) {
                instances.addAll(home.getInstances());
            }
        }
        return instances;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public Integer getPort() {
        return this._port;
    }

    public void setPort(Integer port) {
        this._port = port;
    }

    @Override
    public Credential getCredential() {
        return this._credential;
    }

    @Override
    public void setCredential(Credential credential) {
        this._credential = credential;
    }

    public String getSSHPrivateKeyLocation() {
        return this._credential != null ? this._credential.getAccessKeyLocation() : null;
    }

    public void setSSHPrivateKeyLocation(String location) {
        if (this._credential == null) {
            this._credential = new Credential();
        }
        this._credential.setAccessKeyLocation(location);
    }

    public String getUsername() {
        return this._credential != null ? this._credential.getUsername() : null;
    }

    public void setUsername(String username) {
        if (this._credential == null) {
            this._credential = new Credential();
        }
        this._credential.setUsername(username);
    }

    public byte[] getPassword() {
        if (this._credential != null) {
            char[] password = null;
            try {
                password = this._credential.getPassword();
            }
            catch (OPatchAutoException e) {
                _log.log(Level.WARNING, "Failed to get password from credential", e);
            }
            if (password != null) {
                return OPatchAutoHelper.toBytes(password);
            }
        }
        return null;
    }

    public void setPassword(byte[] password) {
        if (this._credential == null) {
            this._credential = new Credential();
        }
        try {
            this._credential.setPassword(password != null ? OPatchAutoHelper.toChars(password) : null);
        }
        catch (OPatchAutoException e) {
            _log.log(Level.WARNING, "Failed to set password on credential", e);
        }
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this._proxyPort = proxyPort;
    }

    @Override
    public boolean isRemote() throws OPatchAutoException {
        if (this._remote == null) {
            if (LOCAL_HOST.equals(this.getHost()) || "127.0.0.1".equals(this.getHost())) {
                this._remote = false;
            } else {
                String hostName = this.getHost();
                try {
                    InetAddress hostInetAddress = InetAddress.getByName(this.getHost());
                    _log.finest("Host InetAddress=" + hostInetAddress);
                    if (hostInetAddress.isAnyLocalAddress() || hostInetAddress.isLoopbackAddress()) {
                        this._remote = false;
                    } else {
                        if (Pattern.matches(IPV4_PATTERN, hostName) || Pattern.matches(IPV6_PATTERN, hostName) || Pattern.matches(IPV6_COMMPRESSED_PATTERN, hostName)) {
                            hostName = hostInetAddress.getHostName();
                        }
                        InetAddress localInetAddress = InetAddress.getLocalHost();
                        _log.finest("Local host InetAddress=" + localInetAddress);
                        this._remote = !hostInetAddress.equals(localInetAddress);
                        if (this._remote.booleanValue()) {
                            this.compareWithHostName(hostName);
                        }
                    }
                }
                catch (UnknownHostException e) {
                    _log.log(Level.WARNING, "Failed to resolve host:" + this.getHost(), e);
                    this.compareWithHostName(hostName);
                }
            }
        }
        return this._remote;
    }

    private void compareWithHostName(String hostName) throws OPatchAutoException {
        _log.finest("Comparing with host name::" + hostName);
        String localHostName = "";
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            localHostName = this.getHostNameUsingCommand();
        }
        _log.finest("Local host name:" + localHostName);
        if (!hostName.contains(".") || !localHostName.contains(".")) {
            hostName = this.extractShortHostName(hostName);
            localHostName = this.extractShortHostName(localHostName);
        }
        this._remote = !hostName.equalsIgnoreCase(localHostName);
    }

    private String extractShortHostName(String nodeName) {
        String hostName = nodeName;
        int index = nodeName.indexOf(".");
        if (index != -1) {
            hostName = nodeName.substring(0, index);
        }
        return hostName;
    }

    private String getHostNameUsingCommand() throws OPatchAutoException {
        StringBuilder hostname = new StringBuilder();
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(HOSTNAME);
        try {
            List<String> commandOutput = OPatchAutoHelper.runtimeExecAndCaptureOutput(commandList, null, null, false);
            for (String output : commandOutput) {
                hostname.append(output);
                hostname.append("\n");
            }
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Host name using command:" + hostname.toString().trim());
            }
        }
        catch (IOException e) {
            _log.warning("Host command execution failed with " + e.getMessage());
            throw new OPatchAutoException("68107", (Throwable)e, new Object[0]);
        }
        return hostname.toString().trim();
    }

    public void setRemote(Boolean remote) {
        this._remote = remote;
    }

    public String getRemoteConnectionType() {
        return this._remoteConnectionType;
    }

    public void setRemoteConnectionType(String type) {
        this._remoteConnectionType = type;
    }

    public String getPatchLocation() {
        return this._patchLocation;
    }

    public void setPatchLocation(String patchLocation) {
        this._patchLocation = patchLocation;
    }

    public String getFileTransferType() {
        return this._fileTransferType;
    }

    public void setFileTransferType(String fileTransferType) {
        this._fileTransferType = fileTransferType;
    }

    @Override
    public Host getShallowCopy() {
        HostImpl host = new HostImpl();
        host._host = this._host;
        host._port = this._port;
        host._credential = this._credential;
        host._remoteConnectionType = this._remoteConnectionType;
        host._patchLocation = this._patchLocation;
        host._fileTransferType = this._fileTransferType;
        return host;
    }

    public String toString() {
        String username;
        String s = this.getHost();
        Integer port = this.getPort();
        if (port != null) {
            s = s + ":" + port;
        }
        if ((username = this.getUsername()) != null) {
            s = username + "@" + s;
        }
        if (this._homes != null && !this._homes.isEmpty()) {
            s = s + " " + OPatchAutoHelper.getLocalizedString("HostImpl.homes", new Object[0]) + " " + this._homes;
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostImpl)) {
            return false;
        }
        HostImpl hostInfo = (HostImpl)o;
        if (!this._host.equals(hostInfo._host)) {
            return false;
        }
        if (this._port != null ? !this._port.equals(hostInfo._port) : hostInfo._port != null) {
            return false;
        }
        if (this._credential != null ? !this._credential.equals(hostInfo._credential) : hostInfo._credential != null) {
            return false;
        }
        if (this._remoteConnectionType != null ? !this._remoteConnectionType.equals(hostInfo._remoteConnectionType) : hostInfo._remoteConnectionType != null) {
            return false;
        }
        return !(this._fileTransferType != null ? !this._fileTransferType.equals(hostInfo._fileTransferType) : hostInfo._fileTransferType != null);
    }

    public int hashCode() {
        int result = this._host.hashCode();
        result = 31 * result + (this._port != null ? this._port.hashCode() : 0);
        result = 31 * result + (this._credential != null ? this._credential.hashCode() : 0);
        result = 31 * result + (this._remoteConnectionType != null ? this._remoteConnectionType.hashCode() : 0);
        result = 31 * result + (this._fileTransferType != null ? this._fileTransferType.hashCode() : 0);
        return result;
    }
}

