/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.topology;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Instance;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstanceImpl
implements Instance {
    private static final Logger _log = Logger.getLogger(InstanceImpl.class.getName());
    private String _location;
    private List<ProductType> _productTypes = new ArrayList<ProductType>();
    private Home _home;
    private Properties _properties;

    @Override
    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    @Override
    public Set<ProductType> getProductTypes() {
        return new LinkedHashSet<ProductType>(this._productTypes);
    }

    @Override
    public void setProductTypes(Set<ProductType> productTypes) {
        if (!this._productTypes.isEmpty()) {
            this._productTypes.clear();
        }
        if (productTypes != null) {
            for (ProductType productType : productTypes) {
                this.addProductType(productType);
            }
        }
    }

    @Override
    public void addProductType(ProductType productType) {
        if (productType != null && !this._productTypes.contains(productType)) {
            if (!productType.getSupportType().isInstance()) {
                throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68109", new Object[]{SupportType.instance}));
            }
            this._productTypes.add(productType);
        }
    }

    @Override
    public void addProductTypes(Set<ProductType> productTypes) {
        if (productTypes != null) {
            for (ProductType productType : productTypes) {
                this.addProductType(productType);
            }
        }
    }

    @Override
    public Home getHome() {
        return this._home;
    }

    @Override
    public void setHome(Home home) {
        this._home = home;
    }

    @Override
    public Host getHost() {
        return this.getHome() != null ? this.getHome().getHost() : null;
    }

    @Override
    public String getProperty(String name) {
        return this._properties != null ? this._properties.getProperty(name) : null;
    }

    @Override
    public void setProperty(String name, String value) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        if (value == null) {
            this._properties.remove(name);
        } else {
            this._properties.setProperty(name, value);
        }
    }

    @Override
    public Instance getShallowCopy() {
        InstanceImpl instance = new InstanceImpl();
        instance._location = this._location;
        instance._productTypes.addAll(this._productTypes);
        if (this._properties != null) {
            instance._properties = new Properties();
            instance._properties.putAll((Map<?, ?>)this._properties);
        }
        return instance;
    }

    @Override
    public String getDisplayLocation() {
        boolean isRemote = false;
        try {
            isRemote = this.getHost().isRemote();
        }
        catch (OPatchAutoException e) {
            _log.log(Level.WARNING, "Failed to determine if host " + this.getHost() + " is remote.", e);
        }
        return (isRemote ? this.getHost().getHost() + ":" : "") + this.getLocation();
    }

    public String toString() {
        return this.getLocation() + " " + this.getProductTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceImpl)) {
            return false;
        }
        InstanceImpl instance = (InstanceImpl)o;
        if (this._home != null ? !this._home.equals(instance._home) : instance._home != null) {
            return false;
        }
        return !(this._location != null ? !this._location.equals(instance._location) : instance._location != null);
    }

    public int hashCode() {
        int result = this._location != null ? this._location.hashCode() : 0;
        result = 31 * result + (this._home != null ? this._home.hashCode() : 0);
        return result;
    }
}

