/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.topology;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.session.PatchTargetImpl;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import com.oracle.glcm.patch.auto.topology.Instance;
import com.oracle.glcm.patch.auto.topology.InstanceImpl;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.glcm.patch.auto.topology.TopologyImpl;
import com.oracle.glcm.patch.auto.utils.HostPortUrlHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TopologyFactory {
    public static Topology getBasicTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
        String homeLocation = options.getOption("home").getValue();
        String instanceLocation = options.getOption("instance").getValue();
        String invPtrLoc = options.getOption("inventory.pointer.location").getValue();
        String hostName = options.getOption("host").getValue();
        String remoteConnectionType = null;
        String accessKeyLocation = null;
        boolean isSSHUserEquivalence = options.getOption("sshuserequivalence").isSwitchEnabled();
        if (isSSHUserEquivalence) {
            accessKeyLocation = options.getOption("sshaccesskey").getValue();
            remoteConnectionType = "sshuserequivalence";
        }
        return TopologyFactory.buildBasicTopology(hostName, credentialManager, homeLocation, invPtrLoc, instanceLocation, remoteConnectionType, accessKeyLocation);
    }

    public static Host getHost(String hostName, String username, char[] password) throws OPatchAutoException {
        Credential credential = new Credential(username, password);
        return TopologyFactory.getHost(hostName, credential);
    }

    public static Host getHost(String hostName, Credential credential) {
        HostImpl host = new HostImpl();
        if (!StringUtil.isNullOrEmpty((String)hostName, (boolean)true)) {
            HostPortUrlHolder hostPort = OPatchAutoHelper.parseHostAndPort(hostName);
            host.setHost(hostPort.getHost());
            if (hostPort.hasPort()) {
                host.setPort(Integer.parseInt(hostPort.getPort()));
            }
            host.setCredential(credential);
        }
        return host;
    }

    public static Home getHome(String homeLocation, String invPtrLoc, Host host) {
        HomeImpl home = new HomeImpl();
        home.setLocation(homeLocation);
        home.setInvPtrLoc(invPtrLoc);
        home.setHost(host);
        return home;
    }

    public static Instance getInstance(String instanceLocation, Home home) {
        InstanceImpl instance = new InstanceImpl();
        instance.setLocation(instanceLocation);
        instance.setHome(home);
        return instance;
    }

    public static Topology getTopology(Host ... hosts) {
        TopologyImpl topology = new TopologyImpl();
        if (hosts != null) {
            for (Host host : hosts) {
                topology.addHost(host);
            }
        }
        return topology;
    }

    public static Topology buildBasicTopology(String hostName, String username, char[] password, String homeLocation, String invPtrLoc, String instanceLocation) throws OPatchAutoException {
        HostImpl host = (HostImpl)TopologyFactory.getHost(hostName, username, password);
        return TopologyFactory.buildBasicTopology(host, homeLocation, invPtrLoc, instanceLocation);
    }

    public static Topology buildBasicTopology(String hostName, CredentialManager credentialManager, String homeLocation, String invPtrLoc, String instanceLocation, String remoteConnectionType, String accessKeyLocation) throws OPatchAutoException {
        if (hostName.contains(",")) {
            String[] hostsArray;
            LinkedHashSet<Host> hosts = new LinkedHashSet<Host>();
            for (String name : hostsArray = hostName.split(",")) {
                Credential credential = TopologyFactory.getCredential(credentialManager, accessKeyLocation, name);
                HostImpl host = (HostImpl)TopologyFactory.getHost(name.trim(), credential);
                if (!StringUtil.isNullOrEmpty((String)remoteConnectionType, (boolean)true)) {
                    host.setRemoteConnectionType(remoteConnectionType);
                }
                hosts.add(host);
            }
            return TopologyFactory.buildBasicTopology(hosts, homeLocation, invPtrLoc, instanceLocation);
        }
        Credential credential = TopologyFactory.getCredential(credentialManager, accessKeyLocation, hostName);
        HostImpl host = (HostImpl)TopologyFactory.getHost(hostName, credential);
        if (!StringUtil.isNullOrEmpty((String)remoteConnectionType, (boolean)true)) {
            host.setRemoteConnectionType(remoteConnectionType);
        }
        return TopologyFactory.buildBasicTopology(host, homeLocation, invPtrLoc, instanceLocation);
    }

    private static Credential getCredential(CredentialManager credentialManager, String accessKeyLocation, String name) throws OPatchAutoException {
        Credential credential = credentialManager.getCredential(name);
        if (!StringUtil.isNullOrEmpty((String)accessKeyLocation, (boolean)true)) {
            if (credential == null) {
                credentialManager.addCredential(name, accessKeyLocation);
                credential = credentialManager.getCredential(name);
            } else {
                credential.setAccessKeyLocation(accessKeyLocation);
            }
        }
        return credential;
    }

    public static Topology buildBasicTopology(Host host, String homeLocation, String invPtrLoc, String instanceLocation) {
        return TopologyFactory.buildBasicTopology(Collections.singleton(host), homeLocation, invPtrLoc, instanceLocation);
    }

    public static Topology buildBasicTopology(Set<Host> hosts, String homeLocation, String invPtrLoc, String instanceLocation) {
        for (Host host : hosts) {
            HomeImpl home = (HomeImpl)TopologyFactory.getHome(homeLocation, invPtrLoc, host);
            host.addHome(home);
            if (StringUtil.isNullOrEmpty((String)instanceLocation, (boolean)true)) continue;
            Instance instance = TopologyFactory.getInstance(instanceLocation, home);
            home.addInstance(instance);
        }
        return TopologyFactory.getTopology(hosts.toArray(new Host[hosts.size()]));
    }

    public static Topology mergeTopologies(Collection<Topology> topologies) {
        Topology mergedTopology = TopologyFactory.getTopology(new Host[0]);
        if (topologies != null) {
            ArrayList<Home> homeCopies = new ArrayList<Home>();
            ArrayList<Instance> instancesCopies = new ArrayList<Instance>();
            LinkedHashMap hostsToHomes = new LinkedHashMap();
            LinkedHashMap homesToInstances = new LinkedHashMap();
            for (Topology topology : topologies) {
                Set<Host> topologyHosts = topology.getHosts();
                if (topologyHosts == null) continue;
                for (Host topologyHost : topologyHosts) {
                    Set<Home> hostHomes;
                    LinkedHashSet<Home> homes = (LinkedHashSet<Home>)hostsToHomes.get(topologyHost);
                    if (homes == null) {
                        Host hostCopy = topologyHost.getShallowCopy();
                        homes = new LinkedHashSet<Home>();
                        hostsToHomes.put(hostCopy, homes);
                    }
                    if ((hostHomes = topologyHost.getHomes()) == null) continue;
                    for (Home hostHome : hostHomes) {
                        Set<Instance> homeInstances;
                        Home homeCopy;
                        LinkedHashSet<Instance> instances = (LinkedHashSet<Instance>)homesToInstances.get(hostHome);
                        if (instances == null) {
                            homeCopy = hostHome.getShallowCopy();
                            homeCopies.add(homeCopy);
                            homes.add(homeCopy);
                            instances = new LinkedHashSet<Instance>();
                            homesToInstances.put(homeCopy, instances);
                        } else {
                            homeCopy = (Home)homeCopies.get(homeCopies.indexOf(hostHome));
                            homeCopy.addProductTypes(hostHome.getProductTypes());
                        }
                        if ((homeInstances = hostHome.getInstances()) == null) continue;
                        for (Instance homeInstance : homeInstances) {
                            Instance instanceCopy;
                            int index = instancesCopies.indexOf(homeInstance);
                            if (index < 0) {
                                instanceCopy = homeInstance.getShallowCopy();
                                instancesCopies.add(instanceCopy);
                                instances.add(instanceCopy);
                                continue;
                            }
                            instanceCopy = (Instance)instancesCopies.get(index);
                            instanceCopy.addProductTypes(homeInstance.getProductTypes());
                        }
                    }
                }
            }
            for (Map.Entry entry : hostsToHomes.entrySet()) {
                for (Home home : (Set)entry.getValue()) {
                    home.setHost((Host)entry.getKey());
                }
                ((Host)entry.getKey()).setHomes((Set)entry.getValue());
            }
            for (Map.Entry entry : homesToInstances.entrySet()) {
                for (Instance instance : (Set)entry.getValue()) {
                    instance.setHome((Home)entry.getKey());
                }
                ((Home)entry.getKey()).setInstances((Set)entry.getValue());
            }
            mergedTopology.setHosts(hostsToHomes.keySet());
        }
        return mergedTopology;
    }

    public static Set<PatchTarget> getPatchTargets(Topology topology) throws OPatchAutoException {
        Set<Home> homes;
        LinkedHashSet<PatchTarget> patchTargets = new LinkedHashSet<PatchTarget>();
        if (topology != null && (homes = topology.getHomes()) != null && !homes.isEmpty()) {
            for (Home home : homes) {
                Set<Instance> instances;
                Set<ProductType> homeProductTypes = home.getProductTypes();
                if (homeProductTypes != null) {
                    for (ProductType productType : homeProductTypes) {
                        patchTargets.add(new PatchTargetImpl(productType, home));
                    }
                }
                if ((instances = home.getInstances()) == null || instances.isEmpty()) continue;
                for (Instance instance : instances) {
                    Set<ProductType> instanceProductTypes = instance.getProductTypes();
                    if (instanceProductTypes == null) continue;
                    for (ProductType productType : instanceProductTypes) {
                        patchTargets.add(new PatchTargetImpl(productType, home, instance));
                    }
                }
            }
        }
        return patchTargets;
    }
}

