/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.oracle.cie.common.util.reporting.CommonReceiver;
import com.oracle.cie.common.util.reporting.ReportingException;
import com.oracle.cie.common.util.reporting.jackson.ObjectMapperFactory;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import com.oracle.cie.common.util.reporting.messages.TypedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JacksonReceiver
extends CommonReceiver {
    private static final Logger _log = Logger.getLogger(JacksonReceiver.class.getName());
    private JsonParser _parser;
    private MappingIterator<JsonNode> _mappingIterator;

    public JacksonReceiver(InputStream in) throws ReportingException {
        super(in);
    }

    public JacksonReceiver(InputStream in, String messageIndicator) throws ReportingException {
        super(in, messageIndicator);
    }

    @Override
    public TypedMessage readNextMessage() throws ReportingException {
        try {
            if (this._mappingIterator.hasNextValue()) {
                JsonNode node = (JsonNode)this._mappingIterator.nextValue();
                if (node.has("report_messages")) {
                    return (TypedMessage)ObjectMapperFactory.getObjectMapper().treeToValue((TreeNode)node, Report.class);
                }
                return (TypedMessage)ObjectMapperFactory.getObjectMapper().treeToValue((TreeNode)node, ReportMessage.class);
            }
        }
        catch (Exception e) {
            throw new ReportingException("Failed to read next message.", e);
        }
        return null;
    }

    @Override
    protected void configure() throws ReportingException {
        try {
            this._parser = ObjectMapperFactory.getObjectMapper().getFactory().createParser(this.getIn()).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        catch (IOException e) {
            throw new ReportingException("Failed to create jackson json parser.", e);
        }
        try {
            this._mappingIterator = ObjectMapperFactory.getObjectMapper().readValues(this._parser, JsonNode.class);
        }
        catch (IOException e) {
            throw new ReportingException("Failed to create jackson mapping iterator.", e);
        }
    }

    @Override
    public void close() {
        block7: {
            block6: {
                super.close();
                try {
                    if (this._mappingIterator != null) {
                        this._mappingIterator.close();
                    }
                }
                catch (IOException e) {
                    if (!_log.isLoggable(Level.FINER)) break block6;
                    _log.log(Level.FINER, "Failed to close jackson mapping iterator.", e);
                }
            }
            try {
                if (this._parser != null) {
                    this._parser.close();
                }
            }
            catch (IOException e) {
                if (!_log.isLoggable(Level.FINER)) break block7;
                _log.log(Level.FINER, "Failed to close jackson json parser.", e);
            }
        }
    }
}

