/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.dao.DependencyRef;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dependency.FeatureSelectionConflictException;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.Repository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureLoader {
    private static final Logger _log = Logger.getLogger(FeatureLoader.class.getName());
    private Set<FeatureSet> _featureSets;
    protected MetaDataHome _metaDataHome;
    protected boolean _loadFeatureDependencies = true;
    protected Set<FeatureSetReference> _externalFeatures = new HashSet<FeatureSetReference>();

    protected FeatureLoader() {
    }

    public FeatureLoader(MetaDataHome metaDataHome) throws GdrException, IOException, DataHandlerException {
        this._metaDataHome = metaDataHome;
        this.validate();
        this.loadMetaData(null, FeatureSetHelper.getInstance().getFeatureSets(this.getMetaDataHome()));
    }

    public FeatureLoader(File metaDataDir, Set<FeatureSetReference> featureRefs) throws GdrException, IOException, DataHandlerException {
        this(new MetaDataHome(metaDataDir), featureRefs, null);
    }

    public FeatureLoader(Path metaDataDir, Set<FeatureSetReference> featureRefs) throws GdrException, IOException, DataHandlerException {
        this(new MetaDataHome(metaDataDir), featureRefs, null);
    }

    public FeatureLoader(MetaDataHome metaDataHome, Set<FeatureSetReference> featureRefs) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, featureRefs, null);
    }

    public FeatureLoader(MetaDataHome metaDataHome, Set<FeatureSetReference> featureRefs, Set<FeatureSet> features) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, featureRefs, features, true);
    }

    public FeatureLoader(MetaDataHome metaDataHome, Set<FeatureSetReference> featureRefs, Set<FeatureSet> features, boolean loadFeatureDependencies) throws GdrException, IOException, DataHandlerException {
        this._metaDataHome = metaDataHome;
        this._loadFeatureDependencies = loadFeatureDependencies;
        this.init(featureRefs, features);
    }

    public Set<FeatureSet> getFeatureSets() {
        return Collections.unmodifiableSet(this._featureSets);
    }

    public boolean isLoadFeatureDependencies() {
        return this._loadFeatureDependencies;
    }

    public Set<FeatureSetReference> getExternalFeatures() {
        return this._externalFeatures;
    }

    public MetaDataHome getMetaDataHome() {
        return this._metaDataHome;
    }

    protected void validate() throws GdrException {
        if (this._metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(FeatureLoader.class.getName(), "validate", ex);
            throw ex;
        }
    }

    protected void init(Set<FeatureSetReference> featuresRefs, Set<FeatureSet> features) throws GdrException, IOException, DataHandlerException {
        if ((featuresRefs == null || featuresRefs.isEmpty()) && (features == null || features.isEmpty())) {
            GdrException ex = new GdrException("No features were provided.");
            _log.throwing(FeatureLoader.class.getName(), "init", ex);
            throw ex;
        }
        this.validate();
        this.loadMetaData(featuresRefs, features);
    }

    protected void loadMetaData(Set<FeatureSetReference> featuresRefs, Set<FeatureSet> features) throws GdrException, IOException, DataHandlerException {
        if (featuresRefs != null && !featuresRefs.isEmpty()) {
            this._featureSets = this.loadFeatureSets(featuresRefs);
        }
        if (features != null && !features.isEmpty()) {
            if (this._featureSets == null) {
                this._featureSets = new LinkedHashSet<FeatureSet>();
            }
            this._featureSets.addAll(features);
        }
        if (this._featureSets == null || this._featureSets.isEmpty()) {
            GdrException ex = new GdrException("No feature sets were loaded.");
            _log.throwing(FeatureLoader.class.getName(), "loadMetaData", ex);
            throw ex;
        }
        this._featureSets = this.sortFeatureSets(this._featureSets);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featureSets.size() + " feature sets.");
        }
    }

    public void addFeatureSet(FeatureSet featureSet) {
        this._featureSets.add(featureSet);
    }

    protected Set<FeatureSet> sortFeatureSets(Set<FeatureSet> featureSets) {
        return FeatureSetHelper.getInstance().getSortedByReverseDependencyOrder(featureSets);
    }

    public FeatureSet getFeatureSet(String name, String version) {
        if (!StringUtil.isNullOrEmpty((String)name) && !StringUtil.isNullOrEmpty((String)version)) {
            for (FeatureSet feature : this.getFeatureSets()) {
                if (!name.equals(feature.getName()) || !version.equals(feature.getVersion())) continue;
                return feature;
            }
        }
        return null;
    }

    public Set<Reference> getComponentReferences() {
        HashSet<Reference> compRefs = new HashSet<Reference>();
        Set<FeatureSet> features = this.getFeatureSets();
        for (FeatureSet feature : features) {
            compRefs.addAll(feature.getComponentReferences());
        }
        return compRefs;
    }

    public void saveFeatures(File dir) throws GdrException, DataHandlerException, IOException {
        this.saveFeatures(NioHelper.getInstance().getPath(dir));
    }

    public void saveFeatures(Path dir) throws GdrException, DataHandlerException, IOException {
        FeatureSetHelper.getInstance().saveFeatureSets(this.getFeatureSets(), dir);
    }

    public void saveFeatures(Repository repository) throws GdrException, DataHandlerException, IOException {
        FeatureSetHelper.getInstance().saveFeatureSets(this.getFeatureSets(), repository);
    }

    protected FeatureSet loadFeatureSet(MetaDataHome metaDataHome, FeatureSetReference featureRef) throws IOException, DataHandlerException, GdrException {
        return FeatureSetHelper.getInstance(this.getMetaDataHome().getClassLoader()).getFeatureSet(metaDataHome, featureRef);
    }

    private Set<FeatureSet> loadFeatureSets(Collection<FeatureSetReference> featureRefs) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        if (featureRefs != null && !featureRefs.isEmpty()) {
            for (FeatureSetReference featureRef : featureRefs) {
                if (!featureRef.isExternal()) {
                    FeatureSet feature = this.loadFeatureSet(this.getMetaDataHome(), featureRef);
                    featureSets.add(feature);
                    continue;
                }
                this._externalFeatures.add(featureRef);
            }
            if (this.isLoadFeatureDependencies()) {
                try {
                    this.addFeatureDependencies(featureSets, this._externalFeatures, this.getMetaDataHome());
                }
                catch (DependencyException e) {
                    throw new GdrException((Throwable)e);
                }
            }
        }
        return featureSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFeatureDependencies(Set<FeatureSet> featureSets, Set<FeatureSetReference> externalFeatureRefs, MetaDataHome metaDataHome) throws IOException, DataHandlerException, GdrException, DependencyException {
        LinkedHashSet<FeatureSet> allFeatures = new LinkedHashSet<FeatureSet>(featureSets);
        LinkedHashSet<FeatureSet> externalFeatures = new LinkedHashSet<FeatureSet>();
        for (FeatureSetReference ref : externalFeatureRefs) {
            externalFeatures.add(new FeatureSet(ref.getName(), ref.getVersion(), metaDataHome != null ? metaDataHome.getClassLoader() : null));
        }
        allFeatures.addAll(externalFeatures);
        FeatureSelectionTarget target = FeatureSelectionTargetFactory.getFeatureSelectionTarget(allFeatures, null);
        boolean clean = false;
        while (!clean) {
            target.unselectAll();
            List ordered = target.getOrderedItems();
            boolean repeatCurrent = false;
            boolean repeatingCurrent = false;
            FeatureSet currentFeature = null;
            Iterator it = ordered.iterator();
            while (it.hasNext() || repeatCurrent) {
                if (!repeatCurrent) {
                    currentFeature = (FeatureSet)it.next();
                } else {
                    repeatCurrent = false;
                    repeatingCurrent = true;
                }
                try {
                    if (!target.isSelected(currentFeature)) {
                        target.selectWithPrerequisites(currentFeature, true);
                    }
                    it.remove();
                }
                catch (FeatureSelectionConflictException fsce) {
                    Collection<TVertex> selfConflicts = fsce.getSelfConflicts();
                    if (selfConflicts != null && !selfConflicts.isEmpty()) {
                        if (repeatingCurrent) {
                            throw fsce;
                        }
                        target.unselectAll();
                        repeatCurrent = true;
                        continue;
                    }
                    Collection<TVertex> unresolved = fsce.getUnresolvedPrereqs();
                    if (unresolved == null || fsce.getInstalledConflicts() != null && !fsce.getInstalledConflicts().isEmpty() || fsce.getPrereqsConflictingWithInstalled() != null && !fsce.getPrereqsConflictingWithInstalled().isEmpty()) {
                        GdrException ex = new GdrException("Encountered unexpected dependency error when selecting the " + currentFeature + " feature. Check nested exception for cause.", (Throwable)((Object)fsce));
                        _log.throwing(FeatureLoader.class.getName(), "addFeatureDependencies", ex);
                        throw ex;
                    }
                    boolean newUnresolved = false;
                    for (TVertex vertex : unresolved) {
                        FeatureSet fs = this.getFeatureDependency(((VKey)vertex.getKey()).getUnresolvedDep(), featureSets, metaDataHome);
                        if (fs == null) {
                            throw fsce;
                        }
                        if (!featureSets.contains(fs)) {
                            if (_log.isLoggable(Level.FINE)) {
                                _log.fine("Importing feature set " + fs.toString(false) + " which was required when selecting the feature set " + currentFeature.toString(false));
                            }
                            featureSets.add(fs);
                            newUnresolved = true;
                        } else if (this.swapUpgradesFeatureSet(featureSets, fs)) {
                            newUnresolved = true;
                        }
                        target.resolveVertex(fs, vertex);
                    }
                    if (newUnresolved) break;
                    allFeatures = new LinkedHashSet<FeatureSet>(featureSets);
                    allFeatures.addAll(externalFeatures);
                    target = FeatureSelectionTargetFactory.getFeatureSelectionTarget(allFeatures, null);
                    break;
                }
                finally {
                    repeatingCurrent = false;
                }
            }
            clean = ordered.isEmpty();
        }
    }

    private FeatureSet getFeatureDependency(DependencyRef ref, Set<FeatureSet> featureSets, MetaDataHome metaDataHome) throws GdrException, IOException, DataHandlerException {
        FeatureSet depFeature = this.getLoadedFeatureDependency(ref, featureSets, metaDataHome);
        if (depFeature == null) {
            depFeature = this.loadFeatureSet(metaDataHome, new FeatureSetReference(ref.getName(), ref.getVersion(), metaDataHome != null ? metaDataHome.getClassLoader() : null));
            depFeature.setSelected(false);
        }
        return depFeature;
    }

    protected FeatureSet getLoadedFeatureDependency(DependencyRef ref, Set<FeatureSet> featureSets, MetaDataHome metaDataHome) throws GdrException, IOException, DataHandlerException {
        return FeatureSetHelper.getInstance(metaDataHome != null ? metaDataHome.getClassLoader() : null).getFeatureDependency(ref, featureSets);
    }

    protected boolean swapUpgradesFeatureSet(Set<FeatureSet> featureSets, FeatureSet featureSet) {
        return false;
    }
}

