/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.pch.Patch;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.packaging.Packager;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class PatchLoader {
    private static final Logger _log = Logger.getLogger(PatchLoader.class.getName());
    private Set<Patch> _patches;
    private List<ComponentReference> _components;
    protected MetaDataHome _metaDataHome;

    public PatchLoader(MetaDataHome metaDataHome, List<ComponentReference> components) throws GdrException, IOException, DataHandlerException {
        this._metaDataHome = metaDataHome;
        this._components = components;
        this.init();
    }

    protected void init() throws GdrException, IOException, DataHandlerException {
        if (this._metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(PatchLoader.class.getName(), "init", ex);
            throw ex;
        }
        this.loadMetaData();
    }

    public Patch getPatch(String patchId) {
        if (!StringUtil.isNullOrEmpty((String)patchId)) {
            for (Patch patch : this.getPatches()) {
                if (!patchId.equals(patch.getPatchId())) continue;
                return patch;
            }
        }
        return null;
    }

    public Set<Patch> getPatches() {
        return this._patches;
    }

    public void loadMetaData() throws IOException, DataHandlerException, GdrException {
        Set<Patch> patches = PatchHelper.getInstance(this._metaDataHome.getClassLoader()).getPatches(this._metaDataHome.getGdrMetaDataHomePath());
        this._patches = new HashSet<Patch>();
        for (Patch patch : patches) {
            List<ComponentReference> patchComponents = patch.getComponents();
            for (ComponentReference componentRef : patchComponents) {
                if (!this._components.contains((Object)componentRef) || this._patches.contains((Object)patch)) continue;
                this._patches.add(patch);
            }
        }
    }

    public void savePatches(File dir) throws DataHandlerException, GdrException {
        this.savePatches(NioHelper.getInstance().getPath(dir));
    }

    public void savePatches(Path dir) throws DataHandlerException, GdrException {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir, (Throwable)e);
                _log.throwing(Packager.class.getName(), "savePatches", ex);
                throw ex;
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(Packager.class.getName(), "savePatches", ex);
            throw ex;
        }
        Set<Patch> patches = this.getPatches();
        for (Patch patch : patches) {
            PatchHelper.getInstance(this._metaDataHome.getClassLoader()).save(patch, dir.resolve(PatchHelper.getInstance().getPatchFileName(patch)));
        }
    }

    public void refresh() throws IOException, DataHandlerException, GdrException {
        this.loadMetaData();
    }
}

