/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;

public class SessionInfo
extends AbstractDataHandlerWrapper {
    public SessionInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public SessionInfo(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("session-info"));
    }

    public SessionInfo(ClassLoader classLoader, int id) {
        this(classLoader);
        this.setId(id);
    }

    public int getId() {
        return (Integer)this.getNumberAttribute("id", Integer.class, 0);
    }

    public void setId(int id) {
        this.setAttribute("id", id);
    }

    public Calendar getDate() {
        return this.getCalendarAttribute("date");
    }

    public void setDate(Calendar date) {
        this.setAttribute("date", date);
    }

    public SessionAction getAction() {
        String action = this.getStringAttribute("action");
        return StringUtil.isNullOrEmpty((String)action, (boolean)true) ? null : SessionAction.valueOf(action);
    }

    public void setAction(SessionAction action) {
        this.setAttribute("action", action.name());
    }

    public String getPreviousVersion() {
        return this.getStringAttribute("previous-version");
    }

    public void setPreviousVersion(String version) {
        this.setAttribute("previous-version", version);
    }

    public String getPreviousPatchLevel() {
        return this.getStringAttribute("previous-patch-level");
    }

    public void setPreviousPatchLevel(String patchLevel) {
        this.setAttribute("previous-patch-level", patchLevel);
    }

    public String getVersion() {
        return this.getStringAttribute("version");
    }

    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    public String getPatchLevel() {
        return this.getStringAttribute("patch-level");
    }

    public void setPatchLevel(String patchLevel) {
        this.setAttribute("patch-level", patchLevel);
    }

    public String getPatchIds() {
        return this.getStringAttribute("patch-ids");
    }

    public Set<String> getPatchIdsSet() {
        LinkedHashSet<String> patchIdsSet = new LinkedHashSet<String>();
        String patchIds = this.getPatchIds();
        if (!StringUtil.isNullOrEmpty((String)patchIds, (boolean)true)) {
            for (String id : patchIds.split(",")) {
                patchIdsSet.add(id.trim());
            }
        }
        return patchIdsSet;
    }

    public void setPatchIds(String patchIds) {
        this.setAttribute("patch-ids", patchIds);
    }

    public void setPatchIds(Set<String> patchIdsSet) {
        StringBuilder patchIds = null;
        if (patchIdsSet != null) {
            for (String id : patchIdsSet) {
                if (patchIds == null) {
                    patchIds = new StringBuilder(id.trim());
                    continue;
                }
                patchIds.append(",").append(id.trim());
            }
        }
        this.setPatchIds(patchIds != null ? patchIds.toString() : null);
    }

    public void addPatchId(String patchId) {
        Set<String> patchIdsSet;
        if (patchId != null && !(patchIdsSet = this.getPatchIdsSet()).contains(patchId)) {
            patchIdsSet.add(patchId);
            this.setPatchIds(patchIdsSet);
        }
    }

    public void removePatchId(String patchId) {
        Set<String> patchIdsSet;
        if (patchId != null && (patchIdsSet = this.getPatchIdsSet()).remove(patchId)) {
            this.setPatchIds(patchIdsSet);
        }
    }

    public String getOriginatingPatchId() {
        return this.getStringAttribute("originating-patch-id");
    }

    public void setOriginatingPatchId(String patchIds) {
        this.setAttribute("originating-patch-id", patchIds);
    }

    public SessionInfo copy() {
        return new SessionInfo(this.getDataHandler().copy());
    }
}

