/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dependency;

import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.dependency.SelectionTarget;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.gdr.common.NLS;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import java.util.Collection;

public class FeatureSelectionConflictException
extends DependencyException {
    private Collection<TVertex> _unresolvedPrereqs;
    private Collection<TVertex> _selfConflicts;
    private Collection<TVertex> _prereqsConflictingWithInstalled;
    private Collection<TVertex> _installedConflicts;

    public FeatureSelectionConflictException(Collection<TVertex> unresolvedPrereqs, Collection<TVertex> selfConflicts, Collection<TVertex> prereqsConflictingWithInstalled, Collection<TVertex> installedConflicts) {
        this._unresolvedPrereqs = unresolvedPrereqs;
        this._selfConflicts = selfConflicts;
        this._prereqsConflictingWithInstalled = prereqsConflictingWithInstalled;
        this._installedConflicts = installedConflicts;
        this.setDetails(this.constructDetails());
    }

    public FeatureSelectionConflictException(Collection<TVertex> unresolvedPrereqs, Collection<TVertex> selfConflicts) {
        this(unresolvedPrereqs, selfConflicts, null, null);
    }

    public FeatureSelectionConflictException(Collection<TVertex> selfConflicts) {
        this(null, selfConflicts, null, null);
    }

    public SelectionTarget.ErrorType getType() {
        return SelectionTarget.ErrorType.CONFLICTS;
    }

    public Collection<TVertex> getUnresolvedPrereqs() {
        return this._unresolvedPrereqs;
    }

    public Collection<TVertex> getSelfConflicts() {
        return this._selfConflicts;
    }

    public Collection<TVertex> getPrereqsConflictingWithInstalled() {
        return this._prereqsConflictingWithInstalled;
    }

    public Collection<TVertex> getInstalledConflicts() {
        return this._installedConflicts;
    }

    protected String constructDetails() {
        StringBuilder sb = new StringBuilder();
        if (this.getUnresolvedPrereqs() != null && !this.getUnresolvedPrereqs().isEmpty()) {
            sb.append(NLS.getString("FeatureSelectionConflict.missing.prerequisites")).append('\n');
            for (TVertex v : this.getUnresolvedPrereqs()) {
                sb.append(((VKey)v.getKey()).getUnresolvedDep().getName());
                sb.append(((VKey)v.getKey()).getVersionDetails(((VKey)v.getKey()).getUnresolvedDep()));
            }
        }
        if (this.getSelfConflicts() != null && !this.getSelfConflicts().isEmpty()) {
            sb.append(NLS.getString("FeatureSelectionConflict.prerequisites.conflict")).append('\n');
            for (TVertex v : this.getSelfConflicts()) {
                sb.append(((FeatureSet)v.getKey(FeatureSet.class).getItem()).getName()).append(':').append(((FeatureSet)v.getKey(FeatureSet.class).getItem()).getVersion()).append('\n');
            }
        }
        if (this.getPrereqsConflictingWithInstalled() != null && !this.getPrereqsConflictingWithInstalled().isEmpty()) {
            sb.append(NLS.getString("FeatureSelectionConflict.installed.conflict")).append('\n');
            for (TVertex v : this.getPrereqsConflictingWithInstalled()) {
                sb.append(((FeatureSet)v.getKey(FeatureSet.class).getItem()).getName()).append(':').append(((FeatureSet)v.getKey(FeatureSet.class).getItem()).getVersion()).append('\n');
            }
        }
        if (this.getInstalledConflicts() != null && !this.getInstalledConflicts().isEmpty()) {
            sb.append(NLS.getString("FeatureSelectionConflict.installed.conflict")).append('\n');
            for (TVertex v : this.getInstalledConflicts()) {
                sb.append(((FeatureSet)v.getKey(FeatureSet.class).getItem()).getName()).append(':').append(((FeatureSet)v.getKey(FeatureSet.class).getItem()).getVersion()).append('\n');
            }
        }
        return sb.toString();
    }
}

