/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.external.BugInfo;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FileMap;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.Library;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.external.Permission;
import com.oracle.cie.gdr.external.Variable;
import com.oracle.cie.gdr.external.impl.BugInfoImpl;
import com.oracle.cie.gdr.external.impl.FileMapImpl;
import com.oracle.cie.gdr.external.impl.LibraryImpl;
import com.oracle.cie.gdr.external.impl.PermissionImpl;
import com.oracle.cie.gdr.external.impl.VariableImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.selection.Status;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentImpl
implements Component {
    protected String _name;
    protected String _version;
    private MetaDataHome _metaDataHome;
    private LabelMap _labelMap;
    private Mode _mode;
    protected com.oracle.cie.gdr.dao.cpd.Component _component;
    private static Logger _log = Logger.getLogger(ComponentImpl.class.getName());

    ComponentImpl() {
    }

    ComponentImpl(String name, String version) {
        this._name = name;
        this._version = version;
    }

    ComponentImpl(com.oracle.cie.gdr.dao.cpd.Component component) {
        this._component = component;
    }

    protected void loadComponent() throws InventoryException {
        if (null == this._component) {
            try {
                this._component = ComponentHelper.getInstance(this._metaDataHome.getClassLoader()).getComponent(this._metaDataHome, this._labelMap, new ComponentReference(this._name, this._version, this._metaDataHome.getClassLoader()), null, this._mode);
            }
            catch (Exception exception) {
                _log.log(Level.FINE, "A problem occurred when loading the component.", exception);
                throw new InventoryException(exception);
            }
            if (null == this._component) {
                throw new InventoryException("A problem occurred when loading the component.");
            }
        }
    }

    @Override
    public List<FileMap> getFileMaps() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            ArrayList<FileMap> fileMaps = new ArrayList<FileMap>();
            for (com.oracle.cie.gdr.dao.cpd.FileMap fileMap : this._component.getFileMaps()) {
                fileMaps.add(new FileMapImpl(fileMap));
            }
            return fileMaps;
        }
        return null;
    }

    @Override
    public List<Permission> getPermissions() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (com.oracle.cie.gdr.dao.cpd.Permission permission : this._component.getPermissions()) {
                permissions.add(new PermissionImpl(permission));
            }
            return permissions;
        }
        return null;
    }

    @Override
    public BugInfo getBugInfo() throws InventoryException {
        this.loadComponent();
        if (null != this._component && null != this._component.getBugInfo()) {
            BugInfoImpl bugInfo = new BugInfoImpl(this._component.getBugInfo());
            return bugInfo;
        }
        return null;
    }

    public void setBugInfo(com.oracle.cie.gdr.dao.cpd.BugInfo bugInfo) throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            this._component.setBugInfo(bugInfo);
        }
    }

    @Override
    public List<Variable> getVariables() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (com.oracle.cie.gdr.dao.cpd.Variable variable : this._component.getVariables()) {
                variables.add(new VariableImpl(variable));
            }
            return variables;
        }
        return null;
    }

    @Override
    public List<Library> getLibraries() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            ArrayList<Library> librarys = new ArrayList<Library>();
            for (com.oracle.cie.gdr.dao.cpd.Library library : this._component.getLibraries()) {
                librarys.add(new LibraryImpl(library, ComponentHelper.getShortenedVersion(this._component.getVersion())));
            }
            return librarys;
        }
        return null;
    }

    @Override
    public String getName() {
        if (null == this._component) {
            return this._name;
        }
        return this._component.getName();
    }

    @Override
    public String getVersion() {
        if (null == this._component) {
            return this._version;
        }
        return this._component.getVersion();
    }

    @Override
    public String getPatchLevel() {
        return this._component.getPatchLevel();
    }

    @Override
    public String getDescription() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            return this._component.getDescription();
        }
        return null;
    }

    @Override
    public boolean isReplicable() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            return this._component.isReplicable();
        }
        return false;
    }

    @Override
    public Status getStatus() throws InventoryException {
        this.loadComponent();
        if (null != this._component) {
            return this._component.getStatus();
        }
        return null;
    }

    void setMetaDataHome(MetaDataHome metaDataHome) {
        this._metaDataHome = metaDataHome;
    }

    void setMode(Mode mode) {
        this._mode = mode;
    }

    void setLabelMap(LabelMap labelMap) {
        this._labelMap = labelMap;
    }

    static Component newInstance(String name, String version, MetaDataHome metaDatHome, Mode mode, LabelMap labelMap) {
        ComponentImpl component = new ComponentImpl(name, version);
        component.setMetaDataHome(metaDatHome);
        component.setLabelMap(labelMap);
        component.setMode(mode);
        return component;
    }

    static Component newInstance(String name, String version, MetaDataHome metaDatHome, Mode mode) {
        ComponentImpl component = new ComponentImpl(name, version);
        component.setMetaDataHome(metaDatHome);
        component.setMode(mode);
        return component;
    }

    public static Component newInstance(String name, String version) {
        ComponentImpl component = new ComponentImpl(name, version);
        return component;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        Component that = (Component)o;
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        String thatName = that.getName();
        String thatVersion = that.getVersion();
        return !(thisName == null ? thatName != null : !thisName.equals(thatName)) && !(thisVersion == null ? thatVersion != null : !thisVersion.equals(thatVersion));
    }

    public int hashCode() {
        String thisName = this.getName();
        String thisVersion = this.getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }

    @Override
    public Set<File> getProductDirs() throws InventoryException {
        HashSet<File> prodDirs = new HashSet<File>();
        OracleHomeInventory ohInventory = InventoryFactory.getOracleHomeInventory(this._metaDataHome.getSrchome());
        for (Distribution dist : ohInventory.getInstalledDistributions(this)) {
            for (Mapping map : dist.getDirectoryMap().getMappings(this)) {
                File dir = map.getDirectoryLocation();
                if (dir == null) continue;
                prodDirs.add(dir);
            }
        }
        return prodDirs;
    }

    @Override
    public List<Patch> getPatches() throws InventoryException {
        OracleHomeInventory ohInventory = InventoryFactory.getOracleHomeInventory(this._metaDataHome.getSrchome());
        return new ArrayList<Patch>(ohInventory.getInstalledPatches(this));
    }

    @Override
    public String[] getSymbols() throws InventoryException {
        List<FileMap> fileMaps = this.getFileMaps();
        LinkedHashSet<String> symbols = new LinkedHashSet<String>();
        for (FileMap fileMap : fileMaps) {
            symbols.add(fileMap.getSymbol());
        }
        return symbols.toArray(new String[0]);
    }
}

