/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.FeatureSet;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.impl.DistributionImpl;
import com.oracle.cie.gdr.external.impl.RepositoryFeatureSetImpl;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import java.util.Collection;

public class RepositoryDistributionImpl
extends DistributionImpl
implements Distribution {
    private String _name;
    private String _version;
    private RepositoryProcessor _repositoryProcessor;
    private RepositoryVersionResolver _versionResolver;
    private Repository _repository;

    private RepositoryDistributionImpl(com.oracle.cie.gdr.dao.dbd.Distribution distribution) throws InventoryException {
        this._distribution = distribution;
    }

    private RepositoryDistributionImpl(String name, String version, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        this._name = name;
        this._version = version;
        this._repositoryProcessor = repositoryProcessor;
        this._versionResolver = versionResolver;
        this._repository = repository;
        this.loadDistribution();
    }

    static RepositoryDistributionImpl newInstance(String name, String version, RepositoryProcessor repositoryProcessor, RepositoryVersionResolver versionResolver, Repository repository) throws InventoryException {
        return new RepositoryDistributionImpl(name, version, repositoryProcessor, versionResolver, repository);
    }

    static RepositoryDistributionImpl newInstance(com.oracle.cie.gdr.dao.dbd.Distribution distribution) throws InventoryException {
        return new RepositoryDistributionImpl(distribution);
    }

    private void loadDistribution() throws InventoryException {
        if (this._distribution == null) {
            try {
                this._distribution = this._repositoryProcessor.getDistribution(this._name, this._version, false, false);
            }
            catch (Exception anyException) {
                throw new InventoryException(anyException);
            }
        }
    }

    @Override
    public Collection<Component> getComponents() throws InventoryException {
        return super.getComponents();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public Collection<FeatureSet> getFeatureSets() throws InventoryException {
        try {
            return this.getFeatureSets(this._repositoryProcessor.getFeatures(this._distribution, true, false, true, false));
        }
        catch (Exception anyException) {
            throw new InventoryException(anyException);
        }
    }

    @Override
    public Collection<FeatureSet> getFeatureDependencies(FeatureSet feature) throws InventoryException {
        throw new InventoryException("The feature dependencies are not available.");
    }

    @Override
    public Collection<FeatureSet> getExternalFeatureSets() throws InventoryException {
        throw new InventoryException("The external feature sets are not available.");
    }

    @Override
    Collection<FeatureSet> getFeatureSets(Collection<com.oracle.cie.gdr.dao.ftr.FeatureSet> featureSets) throws InventoryException {
        return RepositoryFeatureSetImpl.getFeatureSetsFromSet(featureSets, this._repositoryProcessor, this._versionResolver, this._repository);
    }
}

