/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfo;
import com.oracle.cie.gdr.dao.cmn.ResourceBundleInfoHolder;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.gdr.nio.NioClassLoaderService;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GdrHelper<T extends IDataHandlerWrapper>
extends DaoHelper<T> {
    private static final Logger _log = Logger.getLogger(GdrHelper.class.getName());
    public static final String COMMON_NAMESPACE = "http://xmlns.oracle.com/cie/gdr/cmn";
    public static final String GDR_SCHEMA_MODULE_PREFIX = "com.oracle.cie.gdr-schema";
    public static final String RESOURCES_DIR = "resources";
    public static final String MODULES_DIR = "modules";
    public static final String HOME_MODULES_PATH = "oui/modules";

    protected GdrHelper(Class<T> wrapperClass) {
        this(wrapperClass, null);
    }

    protected GdrHelper(Class<T> wrapperClass, ClassLoader classLoader) {
        super(wrapperClass, classLoader != null ? classLoader : GdrHelper.getConfiguredClassLoader());
    }

    public static ClassLoader getConfiguredClassLoader() {
        return GdrHelper.getConfiguredClassLoader((Path)null);
    }

    public static ClassLoader getConfiguredClassLoader(File moduleDir) {
        return GdrHelper.getConfiguredClassLoader(NioHelper.getInstance().getPath(moduleDir));
    }

    public static ClassLoader getConfiguredClassLoader(Path moduleDir) {
        URL latestJar;
        String classLoaderKey;
        block27: {
            if (moduleDir == null || !Files.isDirectory(moduleDir, new LinkOption[0])) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("The modules directory " + moduleDir + " is not an existing directory, falling back to default gdr-schema class loader.");
                }
                moduleDir = null;
                classLoaderKey = "GDR_HELPER_DEFAULT";
            } else {
                classLoaderKey = moduleDir.toAbsolutePath().toString();
            }
            if (NioClassLoaderService.getInstance().hasClassLoader(classLoaderKey)) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Using cached class loader for " + classLoaderKey);
                }
                return NioClassLoaderService.getInstance().getClassLoader(classLoaderKey);
            }
            try {
                Class<?> clazz = Class.forName("com.oracle.cie.gdr.xml.cmn.RefType");
                if (clazz != null) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Found gdr-schema on current classpath, using default class loader.");
                    }
                    return NioClassLoaderService.getInstance().getClassLoader(classLoaderKey, null, clazz.getClassLoader());
                }
            }
            catch (ClassNotFoundException clazz) {
                // empty catch block
            }
            latestJar = null;
            try {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Attempting to locate com.oracle.cie.gdr-schema module under " + moduleDir);
                }
                List jars = NioClassLoaderService.getInstance().getModuleJars(moduleDir, GDR_SCHEMA_MODULE_PREFIX, GdrHelper.class);
                latestJar = NioClassLoaderService.getInstance().getLatestJar(jars);
                if (latestJar == null) break block27;
                try {
                    Path latestJarPath = NioHelper.getInstance().getPath(latestJar.toURI());
                    if (NioHelper.getInstance().getFileSystem(latestJarPath) != null) {
                        latestJar = NioHelper.getInstance().getURL(latestJarPath);
                    }
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Error getting location URL for " + latestJar, e);
                }
            }
            catch (MalformedURLException e) {
                _log.log(Level.WARNING, "Error getting location URL for " + moduleDir, e);
            }
        }
        if (latestJar == null) {
            Path myLoc = NioClassLoaderService.getInstance().locateClass(GdrHelper.class.getName(), GdrHelper.class.getClassLoader());
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Currently running from " + myLoc);
            }
            if (myLoc != null && !myLoc.getFileName().toString().endsWith(".jar")) {
                while (myLoc != null && !"target".equals(myLoc.getFileName().toString())) {
                    myLoc = myLoc.getParent();
                }
                if (myLoc != null) {
                    moduleDir = myLoc.resolve("schema-classes");
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.finest("Using directory " + moduleDir + " for gdr-schema classes.");
                    }
                    try {
                        latestJar = moduleDir.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        _log.log(Level.WARNING, "Error getting location URL for " + myLoc, e);
                    }
                }
            }
        }
        if (latestJar != null) {
            ClassLoader classLoader = NioClassLoaderService.getInstance().getCachedClassLoader(latestJar.getPath());
            if (classLoader == null) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.fine("Using latest gdr-schema module " + latestJar + " under " + moduleDir);
                }
                classLoader = NioClassLoaderService.getInstance().getClassLoader(classLoaderKey, new URL[]{latestJar}, GdrHelper.class.getClassLoader());
                NioClassLoaderService.getInstance().setCacheClassLoader(latestJar.getPath(), classLoader);
            }
            return classLoader;
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Unable to locate gdr-schema module, using default class loader.");
        }
        return NioClassLoaderService.getInstance().getClassLoader(classLoaderKey, null, GdrHelper.class.getClassLoader());
    }

    public String getCommonNamespace() {
        return COMMON_NAMESPACE;
    }

    public T getRootWrapperFromMetaDataDir(File metaDataRoot, String name) throws IOException, DataHandlerException {
        return this.getRootWrapperFromMetaDataDir(NioHelper.getInstance().getPath(metaDataRoot), name);
    }

    public T getRootWrapperFromMetaDataDir(Path metaDataRoot, String name) throws IOException, DataHandlerException {
        Path path = this.getFileLocatorService(metaDataRoot).getPath(this.getPath(), name);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Creating root wrapper from metaDataRoot=" + metaDataRoot + " for " + name + " at " + path);
        }
        return (T)this.getRootWrapper(path);
    }

    public String getDefaultResourceBundleBaseName() {
        return this.getRootElement();
    }

    public String getResourceBundleBaseName(String name, String version) {
        return "resources/" + GdrHelper.getFormattedNameVersion(name, version) + "/" + this.getDefaultResourceBundleBaseName();
    }

    public String getResourceLocation(String name, String version) {
        return "resources/modules/" + GdrHelper.getFormattedNameVersion(name, version) + ".jar";
    }

    public static String getFormattedNameVersion(String name, String version) {
        return GdrHelper.getFormattedName(name) + "_" + version;
    }

    public static String getFormattedName(String name) {
        return name.replaceAll(" ", "_");
    }

    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, MetaDataHome metaDataHome) throws GdrException {
        this.setResourcesBundleInfo(rbiHolder, metaDataHome, null);
    }

    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, MetaDataHome metaDataHome, Artifact artifact) throws GdrException {
        this.setResourcesBundleInfo(rbiHolder, metaDataHome, artifact, null);
    }

    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, MetaDataHome metaDataHome, Artifact artifact, String innerPath) throws GdrException {
        if (metaDataHome.isArchive()) {
            Path resourceJarFile = metaDataHome.getGdrMetaDataHomePath();
            if (resourceJarFile != null) {
                ResourceBundleInfo rbi = new ResourceBundleInfo(resourceJarFile, rbiHolder.getName(), rbiHolder.getVersion(), this);
                rbiHolder.setResourceBundleInfo(rbi);
            }
        } else if (metaDataHome.isRepository()) {
            this.setResourcesBundleInfo(rbiHolder, metaDataHome.getRepositoryService(), artifact, innerPath);
        } else {
            this.setResourcesBundleInfo(rbiHolder, metaDataHome.getGdrMetaDataHomePath());
        }
    }

    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, File metaDataRoot) {
        this.setResourcesBundleInfo(rbiHolder, NioHelper.getInstance().getPath(metaDataRoot));
    }

    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, Path metaDataRoot) {
        Path resourceJarFile = this.getResourceBundleFilePath(rbiHolder, metaDataRoot);
        this.setResourcesBundleInfoJarFile(rbiHolder, resourceJarFile);
    }

    public void setResourcesBundleInfo(ResourceBundleInfoHolder rbiHolder, RepositoryService repositoryService, Artifact artifact, String innerPath) throws GdrException {
        if (rbiHolder == null) {
            throw new GdrException("The resource bundle info holder provided was null.");
        }
        if (repositoryService == null) {
            throw new GdrException("The repository service provided was null.");
        }
        if (artifact == null) {
            throw new GdrException("The resource bundle artifact provided was null.");
        }
        this.setResourcesBundleInfoJarFile(rbiHolder, repositoryService.getArtifactLocation(artifact), artifact, innerPath);
    }

    public void setResourcesBundleInfoJarFile(ResourceBundleInfoHolder rbiHolder, File resourceJarFile) {
        this.setResourcesBundleInfoJarFile(rbiHolder, NioHelper.getInstance().getPath(resourceJarFile));
    }

    public void setResourcesBundleInfoJarFile(ResourceBundleInfoHolder rbiHolder, Path resourceJarFile) {
        this.setResourcesBundleInfoJarFile(rbiHolder, resourceJarFile, null, null);
    }

    public void setResourcesBundleInfoJarFile(ResourceBundleInfoHolder rbiHolder, File resourceJarFile, Artifact resourceArtifact, String innerPath) {
        this.setResourcesBundleInfoJarFile(rbiHolder, NioHelper.getInstance().getPath(resourceJarFile), resourceArtifact, innerPath);
    }

    public void setResourcesBundleInfoJarFile(ResourceBundleInfoHolder rbiHolder, Path resourceJarFile, Artifact resourceArtifact, String innerPath) {
        if (resourceJarFile != null) {
            String qualifiedName = innerPath == null ? rbiHolder.getName() : innerPath + "/" + rbiHolder.getName();
            ResourceBundleInfo rbi = new ResourceBundleInfo(resourceJarFile, qualifiedName, rbiHolder.getVersion(), this);
            rbi.setResourceArtifact(resourceArtifact);
            rbiHolder.setResourceBundleInfo(rbi);
        }
    }

    public File getResourceBundleFile(ResourceBundleInfoHolder rbiHolder, File metaDataRoot) {
        if (rbiHolder != null) {
            return this.getResourceBundleFile(rbiHolder.getName(), rbiHolder.getVersion(), metaDataRoot);
        }
        return null;
    }

    public Path getResourceBundleFilePath(ResourceBundleInfoHolder rbiHolder, Path metaDataRoot) {
        if (rbiHolder != null) {
            return this.getResourceBundleFilePath(rbiHolder.getName(), rbiHolder.getVersion(), metaDataRoot);
        }
        return null;
    }

    public File getResourceBundleFile(String name, String version, File metaDataRoot) {
        Path resourceBundle = this.getResourceBundleFilePath(name, version, NioHelper.getInstance().getPath(metaDataRoot));
        return resourceBundle != null ? resourceBundle.toFile() : null;
    }

    public Path getResourceBundleFilePath(String name, String version, Path metaDataRoot) {
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true) && !StringUtil.isNullOrEmpty((String)version, (boolean)true) && metaDataRoot != null) {
            String resourceLocation = this.getPath() + "/" + this.getResourceLocation(name, version);
            try {
                return this.getFileLocatorService(metaDataRoot).getPath(resourceLocation);
            }
            catch (FileNotFoundException e) {
                _log.log(Level.FINEST, "Failed to locate resource jar " + resourceLocation + " under " + metaDataRoot);
            }
        }
        return null;
    }

    public ResourceBundle loadResourceBundle(File resourceLocation, String name, String version) {
        return this.loadResourceBundle(NioHelper.getInstance().getPath(resourceLocation), name, version);
    }

    public ResourceBundle loadResourceBundle(Path resourceLocation, String name, String version) {
        String resourceBundlePath;
        ResourceBundle resourceBundle = null;
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true) && !StringUtil.isNullOrEmpty((String)(resourceBundlePath = this.getResourceBundleBaseName(name, version)), (boolean)true)) {
            try {
                resourceBundle = this.loadResourceBundle(resourceBundlePath, resourceLocation);
            }
            catch (Exception e) {
                _log.warning(e.getMessage());
            }
        }
        return resourceBundle;
    }
}

