/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.dao.VersionRange;
import com.oracle.cie.dependency.graph.DefaultEdge;
import com.oracle.cie.dependency.graph.DefaultVertex;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.DirectedGraphHelper;
import com.oracle.cie.dependency.graph.EdgeFactory;
import com.oracle.cie.dependency.graph.GraphPrePostVisitor;
import com.oracle.cie.dependency.graph.Vertex;
import com.oracle.cie.dependency.graph.VertexFactory;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import com.oracle.cie.gdr.dao.pld.ProductLayer;
import com.oracle.cie.gdr.dao.pld.ProductLayerDependency;
import com.oracle.cie.gdr.dao.pld.ProductLayerDistribution;
import com.oracle.cie.gdr.dao.pld.ProductLayerPatch;
import com.oracle.cie.gdr.dao.pld.ProductLayers;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.GdrHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;

public class ProductLayersDefinitionHelper
extends GdrHelper<ProductLayers> {
    private static final Logger _log = Logger.getLogger(ProductLayersDefinitionHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/shiphome/layers";
    public static final String PRODUCT_LAYERS = "product-layers";
    public static final String PRODUCT_LAYERS_DIR = "product-layers";
    private static ProductLayersDefinitionHelper _instance;

    public static ProductLayersDefinitionHelper getInstance() {
        if (_instance == null) {
            _instance = new ProductLayersDefinitionHelper(null);
        }
        return _instance;
    }

    public static ProductLayersDefinitionHelper getInstance(ClassLoader classLoader) {
        if (classLoader == null) {
            return ProductLayersDefinitionHelper.getInstance();
        }
        return new ProductLayersDefinitionHelper(classLoader);
    }

    private ProductLayersDefinitionHelper(ClassLoader classLoader) {
        super(ProductLayers.class, classLoader);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getRootElement() {
        return "product-layers";
    }

    public String getPath() {
        return "product-layers";
    }

    public String getProductLayersXmlFileName(ProductLayer productLayers) {
        return this.getProductLayersFileName(productLayers.getName(), productLayers.getVersion(), "xml");
    }

    public String getProductLayersJsonFileName(ProductLayer productLayers) {
        return this.getProductLayersFileName(productLayers.getName(), productLayers.getVersion(), "json");
    }

    public String getRelativeHomePath(ProductLayer productLayer) {
        return "inventory" + File.separator + ProductLayersDefinitionHelper.getInstance().getPath() + File.separator + ProductLayersDefinitionHelper.getInstance().getProductLayersJsonFileName(productLayer);
    }

    public String getProductLayersFileName(String name, String version, String extension) {
        return ProductLayersDefinitionHelper.getFormattedNameVersion(name, version) + "." + extension;
    }

    public String getProductLayerImageArchiveName(String layerName, String layerVersion, String versionQualifier, String extension) {
        String name = ProductLayersDefinitionHelper.getFormattedNameVersion(layerName, layerVersion) + "-" + versionQualifier;
        if (!StringUtil.isNullOrEmpty((String)extension, (boolean)true)) {
            name = name + "." + extension;
        }
        return name;
    }

    public ProductLayers getWrappedProductLayer(ProductLayer ... productLayer) {
        ProductLayers productLayers = new ProductLayers();
        if (productLayer != null) {
            ArrayList<ProductLayer> productLayerList = new ArrayList<ProductLayer>(Arrays.asList(productLayer));
            productLayers.setProductLayers(productLayerList);
        }
        return productLayers;
    }

    public ProductLayers createProductLayersDefinition(String name, String version, String directoryName, String distributions, String uuid, String installTypes, String dependencies, String patches) throws GdrException {
        String[] dists;
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            GdrException ex = new GdrException("The product layer definition name is required.");
            _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            GdrException ex = new GdrException("The product layer definition version is required.");
            _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)directoryName, (boolean)true)) {
            GdrException ex = new GdrException("The product layer definition directory name is required.");
            _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
            throw ex;
        }
        if (StringUtil.isNullOrEmpty((String)distributions, (boolean)true)) {
            GdrException ex = new GdrException("The product layer definition distributions are required.");
            _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
            throw ex;
        }
        ProductLayer productLayer = new ProductLayer();
        productLayer.setName(name);
        productLayer.setVersion(version);
        productLayer.setDirectoryName(directoryName);
        if (StringUtil.isNullOrEmpty((String)uuid, (boolean)true)) {
            uuid = UUID.randomUUID().toString();
        }
        productLayer.setUUID(uuid);
        HashMap<String, String> installTypeMap = new HashMap<String, String>();
        if (!StringUtil.isNullOrEmpty((String)installTypes, (boolean)true)) {
            String[] installTypesSplit;
            for (String s : installTypesSplit = installTypes.split(",")) {
                String[] entrySplit = s.split(":");
                if (entrySplit.length != 3) {
                    GdrException ex = new GdrException("The install types provided were not in the expected format \"name:version:install-type,...\" : " + installTypes);
                    _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
                    throw ex;
                }
                installTypeMap.put(entrySplit[0] + ":" + entrySplit[1], entrySplit[2]);
            }
        }
        ArrayList<ProductLayerDistribution> productLayerDistributions = new ArrayList<ProductLayerDistribution>();
        for (String dist : dists = distributions.split(",(?![^\\[]*\\])")) {
            String installType;
            NameVersionHolder nameVersion;
            try {
                nameVersion = this.parseNameVersion(dist);
            }
            catch (GdrException e) {
                GdrException ex = new GdrException("The distributions provided were not in the expected format \"name:version:<version-range>:[propName=propValue],...\" : " + distributions, (Throwable)e);
                _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
                throw ex;
            }
            ProductLayerDistribution productLayerDistribution = new ProductLayerDistribution();
            productLayerDistribution.setName(nameVersion._name);
            productLayerDistribution.setVersion(nameVersion._version);
            if (nameVersion._range != null) {
                productLayerDistribution.setVersionRange(nameVersion._range);
            }
            if (nameVersion._properties != null) {
                String jdkPath;
                boolean jdk;
                String platforms;
                String generic = nameVersion._properties.getProperty("generic");
                if (generic != null && "false".equalsIgnoreCase(generic)) {
                    productLayerDistribution.setGeneric(false);
                }
                if (!StringUtil.isNullOrEmpty((String)(platforms = nameVersion._properties.getProperty("platforms")))) {
                    productLayerDistribution.setPlatforms(platforms.toLowerCase().replace(" ", ""));
                }
                if (jdk = Boolean.parseBoolean(nameVersion._properties.getProperty("jdk"))) {
                    productLayerDistribution.setJdk(true);
                }
                if (!StringUtil.isNullOrEmpty((String)(jdkPath = nameVersion._properties.getProperty("jdk-path")))) {
                    productLayerDistribution.setJdkPath(jdkPath);
                }
            }
            if (!StringUtil.isNullOrEmpty((String)(installType = (String)installTypeMap.get(nameVersion._name + ":" + nameVersion._version)))) {
                productLayerDistribution.setInstallType(installType);
            }
            productLayerDistributions.add(productLayerDistribution);
        }
        productLayer.setDistributions(productLayerDistributions);
        if (!StringUtil.isNullOrEmpty((String)dependencies, (boolean)true)) {
            String[] deps;
            ArrayList<ProductLayerDependency> productLayerDependencies = new ArrayList<ProductLayerDependency>();
            for (String dep : deps = dependencies.split(",(?![^\\[]*\\])")) {
                NameVersionHolder nameVersion;
                try {
                    nameVersion = this.parseNameVersion(dep);
                }
                catch (GdrException e) {
                    GdrException ex = new GdrException("The dependencies provided were not in the expected format \"name:version,...\" : " + dependencies);
                    _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
                    throw ex;
                }
                ProductLayerDependency productLayerDependency = new ProductLayerDependency();
                productLayerDependency.setName(nameVersion._name);
                productLayerDependency.setVersion(nameVersion._version);
                if (nameVersion._range != null) {
                    productLayerDependency.setVersionRange(nameVersion._range);
                }
                productLayerDependencies.add(productLayerDependency);
            }
            productLayer.setDependencies(productLayerDependencies);
        }
        if (!StringUtil.isNullOrEmpty((String)patches, (boolean)true)) {
            String[] split;
            ArrayList<ProductLayerPatch> pldPatches = new ArrayList<ProductLayerPatch>();
            for (String patch : split = patches.split(",")) {
                String[] patchDetails = patch.split(":");
                if (patchDetails.length != 4) {
                    GdrException ex = new GdrException("The patches provided were not in the expected format \"id:aru-platform:oui-platform:release,...\" : " + patches);
                    _log.throwing(DistributionHelper.class.getName(), "createProductLayersDefinition", ex);
                    throw ex;
                }
                ProductLayerPatch pldPatch = new ProductLayerPatch();
                pldPatch.setId(patchDetails[0]);
                pldPatch.setAruPlatform(patchDetails[1]);
                pldPatch.setOuiPlatform(Integer.parseInt(patchDetails[2]));
                pldPatch.setRelease(patchDetails[3]);
                pldPatches.add(pldPatch);
            }
            productLayer.setPatches(pldPatches);
        }
        return this.getWrappedProductLayer(productLayer);
    }

    private NameVersionHolder parseNameVersion(String delimitedString) throws GdrException {
        NameVersionHolder result = new NameVersionHolder();
        String[] nameVersion = delimitedString.split(":");
        if (nameVersion.length < 2) {
            GdrException ex = new GdrException("The name:version:<version-range>:[propName=propValue] string provided was not in the expected format : " + delimitedString);
            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
            throw ex;
        }
        if (nameVersion[1].contains("-")) {
            GdrException ex = new GdrException("The name:version:<version-range>:[propName=propValue] string provided was not in the expected format : " + delimitedString);
            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
            throw ex;
        }
        result._name = nameVersion[0];
        String[] versionSplit = nameVersion[1].split("\\.");
        if (versionSplit.length != 5) {
            GdrException ex = new GdrException("The version string provided was not the expected length.  Only a 5 position versions may be provided : " + nameVersion[1]);
            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
            throw ex;
        }
        result._version = nameVersion[1];
        for (int x = 2; x < nameVersion.length; ++x) {
            if (nameVersion[x].startsWith("[")) {
                String[] propsSplit;
                if (!nameVersion[x].endsWith("]")) {
                    GdrException ex = new GdrException("The name:version:<version-range>:[propName=propValue] string provided was not in the expected format, unmatched bracket : " + delimitedString);
                    _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
                    throw ex;
                }
                String props = nameVersion[x].substring(1, nameVersion[x].length() - 1).trim();
                if (props.isEmpty()) continue;
                for (String prop : propsSplit = props.split(",(?![^\\{]*\\})")) {
                    int equalsIndex = prop.indexOf("=");
                    if (equalsIndex < 1) {
                        GdrException ex = new GdrException("The name:version:<version-range>:[propName=propValue] string provided was not in the expected format : " + delimitedString);
                        _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
                        throw ex;
                    }
                    String propName = prop.substring(0, equalsIndex);
                    String propValue = prop.substring(equalsIndex + 1).trim();
                    if (propValue.startsWith("{")) {
                        if (!propValue.endsWith("}")) {
                            GdrException ex = new GdrException("The name:version:<version-range>:[propName=propValue] string provided was not in the expected format, unmatched bracket : " + delimitedString);
                            _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
                            throw ex;
                        }
                        propValue = propValue.substring(1, propValue.length() - 1).trim();
                    }
                    if (result._properties == null) {
                        result._properties = new Properties();
                    }
                    result._properties.setProperty(propName, propValue);
                }
                continue;
            }
            if (!nameVersion[x].contains(">")) continue;
            String[] range = nameVersion[x].split(">");
            if (range.length != 2) {
                GdrException ex = new GdrException("The name:version:<version-range>:[] string provided was not in the expected format : " + delimitedString);
                _log.throwing(DistributionHelper.class.getName(), "parseNameVersion", ex);
                throw ex;
            }
            result._range = new VersionRange(ProductLayersDefinitionHelper.getInstance().create(NAMESPACE, "VersionRange"));
            if (range[0].endsWith("+") || range[0].endsWith("-")) {
                if (range[0].endsWith("-")) {
                    result._range.setMinInclusive(Boolean.valueOf(false));
                }
                range[0] = range[0].substring(0, range[0].length() - 1);
            }
            if (range[1].endsWith("+") || range[1].endsWith("-")) {
                if (range[1].endsWith("+")) {
                    result._range.setMaxInclusive(Boolean.valueOf(true));
                }
                range[1] = range[1].substring(0, range[1].length() - 1);
            }
            result._range.setMin(range[0]);
            result._range.setMax(range[1]);
        }
        return result;
    }

    public LinkedHashMap<ProductLayerKey, ProductLayer> getProductLayerDependencies(String layerName, String layerVersion, ProductLayers highLevelProductLayers, ProductLayersResolver productLayersResolver) throws GdrException {
        ProductLayerKey targetProductLayer = null;
        LinkedHashMap<ProductLayerKey, ProductLayer> productLayerMap = new LinkedHashMap<ProductLayerKey, ProductLayer>();
        List<ProductLayer> productLayerList = highLevelProductLayers.getProductLayers();
        for (ProductLayer productLayer : productLayerList) {
            String name = productLayer.getName();
            String version = productLayer.getVersion();
            ProductLayerKey layerKey = this.getProductLayerKey(name, version);
            if (layerName.equals(name) && layerVersion.equals(version)) {
                if (targetProductLayer != null) {
                    GdrException ex = new GdrException("Encountered two product layers which match the target layer: " + layerName + " " + layerVersion);
                    _log.throwing(DistributionHelper.class.getName(), "getProductLayerDependencies", ex);
                    throw ex;
                }
                targetProductLayer = layerKey;
            }
            productLayerMap.put(layerKey, productLayer);
        }
        if (targetProductLayer == null) {
            GdrException ex = new GdrException("Unable to locate product layer " + layerName + " " + layerVersion);
            _log.throwing(DistributionHelper.class.getName(), "getProductLayerDependencies", ex);
            throw ex;
        }
        LinkedHashSet<ProductLayerKey> keys = this.resolveProductLayerDependencies(targetProductLayer, productLayerMap, productLayersResolver);
        LinkedHashMap<ProductLayerKey, ProductLayer> orderedMap = new LinkedHashMap<ProductLayerKey, ProductLayer>();
        for (ProductLayerKey key : keys) {
            orderedMap.put(key, (ProductLayer)((Object)productLayerMap.get(key)));
        }
        return orderedMap;
    }

    private LinkedHashSet<ProductLayerKey> resolveProductLayerDependencies(ProductLayerKey targetProductLayer, Map<ProductLayerKey, ProductLayer> productLayerMap, ProductLayersResolver productLayersResolver) throws GdrException {
        DirectedGraph layerGraph = new DirectedGraph((VertexFactory)new DefaultVertex.DefaultVertexFactory(), (EdgeFactory)new DefaultEdge.DefaultEdgeFactory());
        for (ProductLayerKey layerKey : new ArrayList<ProductLayerKey>(productLayerMap.keySet())) {
            this.populateGraph(layerKey, productLayerMap.get(layerKey), productLayerMap, productLayersResolver, (DirectedGraph<ProductLayerKey, DefaultVertex<ProductLayerKey>, String, DefaultEdge<DefaultVertex<ProductLayerKey>, String>>)layerGraph);
        }
        DefaultVertex startVertex = (DefaultVertex)layerGraph.getVertex((Object)targetProductLayer);
        ProductLayerVisitor visitor = new ProductLayerVisitor(null);
        DirectedGraphHelper.depthFirstEdgeTraversal((DirectedGraph)layerGraph, (GraphPrePostVisitor)visitor, (Vertex)startVertex, (boolean)true);
        return visitor.getVisited();
    }

    private void populateGraph(ProductLayerKey key, ProductLayer productLayer, Map<ProductLayerKey, ProductLayer> productLayerMap, ProductLayersResolver productLayersResolver, DirectedGraph<ProductLayerKey, DefaultVertex<ProductLayerKey>, String, DefaultEdge<DefaultVertex<ProductLayerKey>, String>> layerGraph) throws GdrException {
        List<ProductLayerDependency> dependencies;
        DefaultVertex vertex = (DefaultVertex)layerGraph.getVertex((Object)key);
        if (vertex == null) {
            vertex = (DefaultVertex)layerGraph.insertVertex((Object)key);
        }
        if ((dependencies = productLayer.getDependencies()) != null) {
            for (ProductLayerDependency dependency : dependencies) {
                String dependencyVersion;
                String dependencyName = dependency.getName();
                ProductLayerKey dependencyKey = this.getProductLayerKey(dependencyName, dependencyVersion = dependency.getVersion());
                DefaultVertex dependencyVertex = (DefaultVertex)layerGraph.getVertex((Object)dependencyKey);
                if (dependencyVertex == null) {
                    ProductLayer dependencyProductLayer = productLayerMap.get(dependencyKey);
                    if (dependencyProductLayer == null) {
                        if (productLayersResolver == null) {
                            GdrException ex = new GdrException("Unable to locate product layer " + dependencyKey + " because product layers resolver was not provided.");
                            _log.throwing(DistributionHelper.class.getName(), "populateGraph", ex);
                            throw ex;
                        }
                        ProductLayers productLayers = productLayersResolver.resolve(dependencyKey);
                        LinkedHashMap<ProductLayerKey, ProductLayer> depLayerMap = new LinkedHashMap<ProductLayerKey, ProductLayer>();
                        for (ProductLayer productLayer2 : productLayers.getProductLayers()) {
                            ProductLayerKey layerKey = this.getProductLayerKey(productLayer2.getName(), productLayer2.getVersion());
                            if (productLayerMap.containsKey(layerKey)) continue;
                            depLayerMap.put(layerKey, productLayer2);
                            productLayerMap.put(layerKey, productLayer2);
                        }
                        for (Map.Entry entry : depLayerMap.entrySet()) {
                            this.populateGraph((ProductLayerKey)entry.getKey(), (ProductLayer)((Object)entry.getValue()), productLayerMap, productLayersResolver, layerGraph);
                        }
                    } else {
                        this.populateGraph(dependencyKey, dependencyProductLayer, productLayerMap, productLayersResolver, layerGraph);
                    }
                }
                if ((dependencyVertex = (DefaultVertex)layerGraph.getVertex((Object)dependencyKey)) == null) {
                    GdrException ex = new GdrException("Failed to locate prpduct layer dependency: " + dependencyKey);
                    _log.throwing(DistributionHelper.class.getName(), "populateGraph", ex);
                    throw ex;
                }
                layerGraph.insertDirectedEdge((Vertex)vertex, (Vertex)dependencyVertex, (Object)dependencyKey.toString());
            }
        }
    }

    public ProductLayerKey getProductLayerKey(String name, String version) {
        return new ProductLayerKey(name, version);
    }

    class NameVersionHolder {
        String _name;
        String _version;
        VersionRange _range;
        Properties _properties;

        NameVersionHolder() {
        }
    }

    public class ProductLayerKey {
        String _name;
        String _version;

        public ProductLayerKey(String name, String version) {
            this._name = name;
            this._version = version;
        }

        public String getName() {
            return this._name;
        }

        public String getVersion() {
            return this._version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProductLayerKey that = (ProductLayerKey)o;
            return this._name.equals(that._name) && this._version.equals(that._version);
        }

        public int hashCode() {
            int result = this._name.hashCode();
            result = 31 * result + this._version.hashCode();
            return result;
        }

        public String toString() {
            return this._name + "_" + this._version;
        }
    }

    public static interface ProductLayersResolver {
        public ProductLayers resolve(ProductLayerKey var1) throws GdrException;
    }

    class ProductLayerVisitor
    extends VisitorAdaptor<ProductLayerKey, DefaultVertex<ProductLayerKey>, String, DefaultEdge<DefaultVertex<ProductLayerKey>, String>, DirectedGraph<ProductLayerKey, DefaultVertex<ProductLayerKey>, String, DefaultEdge<DefaultVertex<ProductLayerKey>, String>>> {
        protected LinkedHashSet<ProductLayerKey> _visited;

        public ProductLayerVisitor(PrintStream traceOut) {
            super(traceOut);
            this._visited = new LinkedHashSet();
        }

        public LinkedHashSet<ProductLayerKey> getVisited() {
            return this._visited;
        }

        public boolean preVisit(DefaultEdge<DefaultVertex<ProductLayerKey>, String> edge, DefaultVertex<ProductLayerKey> vertex) {
            super.visit(edge, vertex);
            this._visited.add((ProductLayerKey)vertex.getKey());
            return true;
        }
    }
}

