/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.Components;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dependency.FeatureSelectionTarget;
import com.oracle.cie.gdr.dependency.FeatureSelectionTargetFactory;
import com.oracle.cie.gdr.external.InstallerSession;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchComponentArchiveInstallationSession
extends InstallationSession
implements InstallerSession {
    private static final Logger _log = Logger.getLogger(PatchComponentArchiveInstallationSession.class.getName());
    private DirectoryMap _directoryMap;
    private LabelMap _labelMap;
    protected FeatureLoader _featureLoader;
    protected InstallerDistributionInfo _installerDistributionInfo;
    protected ComponentLoader _componentLoader;
    Map<FeatureSet, Set<Component>> _featureSetMap;
    private Map<FeatureSet, Set<DistributionTarget>> _featureToDistributionsMap;
    private Set<Distribution> _distributions;
    protected FeatureSelectionTarget _featureSelectionTarget;

    public PatchComponentArchiveInstallationSession(MetaDataHome metaDataHome, Home home, Set<Reference> componentRefs, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, Map<Reference, Component> previouslyLoadedComponents, Map<FeatureSet, Set<Component>> featureSetMap, Set<Distribution> distributions) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, home.getHomePath(), platforms, locales, previouslyLoadedComponents);
        this._directoryMap = directoryMap;
        this._featureSetMap = featureSetMap;
        this._distributions = distributions;
        this.init(new HashSet<Reference>(), componentRefs, directoryMap);
    }

    protected void init(Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap) throws GdrException, IOException, DataHandlerException {
        if (directoryMap == null) {
            GdrException ex = new GdrException("Directory map was null and is required for installation.");
            _log.throwing(PatchComponentArchiveInstallationSession.class.getName(), "init", ex);
            throw ex;
        }
        if ((featureRefs == null || featureRefs.isEmpty()) && (componentReferences == null || componentReferences.isEmpty())) {
            GdrException ex = new GdrException("Failed to install component archives because no components or features were provided.");
            _log.throwing(PatchComponentArchiveInstallationSession.class.getName(), "init", ex);
            throw ex;
        }
        this._featureLoader = new FeatureLoader(this.getMetaDataHome(), FeatureSetHelper.getInstance().convertReferences(featureRefs), this._featureSetMap.keySet());
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featureLoader.getFeatureSets().size() + " feature sets.");
        }
        this._installerDistributionInfo = InstallerInfoHelper.getInstance().getInstallerDistributionInfo(this.getInstallerInfo());
        HashSet<Reference> componentFilter = new HashSet<Reference>();
        for (FeatureSet feature : this.getFeatureLoader().getFeatureSets()) {
            for (Components components : feature.getComponents()) {
                for (ComponentReference comp : components.getComponentReferences()) {
                    if (this.getHome().isComponentInstalled(comp.getName(), comp.getVersion())) continue;
                    componentFilter.add(comp);
                }
            }
        }
        this.buildFeatureSelectionTarget();
        this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.INSTALL, this.getFeatureLoader().getFeatureSets(), this.getDirectoryMap(), this.getInstallerDistributionInfo(), this.getLabelMap(), componentFilter, this.getPreviouslyLoadedComponents());
        this.setInstallationStates(this._componentLoader.getComponentsMap());
    }

    public Set<Distribution> getDistributions() {
        return this._distributions;
    }

    @Override
    public InstallerDistributionInfo getInstallerDistributionInfo() {
        return this._installerDistributionInfo;
    }

    public FeatureLoader getFeatureLoader() {
        return this._featureLoader;
    }

    @Override
    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getFeatureLoader().getFeatureSets();
    }

    @Override
    public DirectoryMap getDirectoryMap() {
        return this._directoryMap;
    }

    public LabelMap getLabelMap() {
        return this._labelMap;
    }

    @Override
    public DistributionTarget getDistributionTarget() {
        for (Set<DistributionTarget> targets : this._featureToDistributionsMap.values()) {
            Iterator<DistributionTarget> iterator = targets.iterator();
            if (!iterator.hasNext()) continue;
            DistributionTarget target = iterator.next();
            return target;
        }
        return null;
    }

    @Override
    public void validateInstallation() throws DependencyException, GdrException {
        super.validateInstallation();
    }

    @Override
    public FeatureSelectionTarget getFeatureSelectionTarget() {
        return this._featureSelectionTarget;
    }

    protected void buildFeatureSelectionTarget() throws GdrException {
        Set<FeatureSet> features = this.getSelectedFeatures();
        Set<FeatureSet> installedFeatures = null;
        Home home = this.getHome();
        installedFeatures = home != null ? home.getInstalledFeatures() : null;
        for (FeatureSet feature : FeatureSetHelper.getInstance().getUpgradeInstalledFesturesToRemove(features, installedFeatures)) {
            _log.info("Skipping installation of " + feature.getDisplayName() + " featureset");
            features.remove(feature);
        }
        if (installedFeatures != null && !installedFeatures.isEmpty()) {
            for (FeatureSet feature : features) {
                if (!installedFeatures.contains(feature)) continue;
                installedFeatures.remove(feature);
            }
        }
        this._featureSelectionTarget = FeatureSelectionTargetFactory.getFeatureSelectionTarget(features, installedFeatures, Mode.INSTALL);
    }

    @Override
    protected void setInstallationStates(Distribution distribution, Map<FeatureSet, Collection<Component>> componentsMap) throws GdrException {
        if (componentsMap != null && !componentsMap.isEmpty()) {
            Home home = this.getHome();
            Collection<DistributionTarget> installedDistributions = home != null ? home.getInstalledDistributions() : null;
            HashSet<FeatureSet> allInstalledFeatures = home != null ? home.getInstalledFeatures() : new HashSet<FeatureSet>();
            LinkedHashSet<Component> singletonFeatureSetComponents = new LinkedHashSet<Component>();
            for (FeatureSet featureSet : componentsMap.keySet()) {
                featureSet.setFullyInstalled(false);
            }
            LinkedHashMap incrementedReplacesDependenciesMap = new LinkedHashMap();
            for (FeatureSet featureSet : componentsMap.keySet()) {
                if (installedDistributions == null || installedDistributions.isEmpty()) continue;
                for (DistributionTarget installedDistribution : installedDistributions) {
                    Set<FeatureSet> installedFeatures = installedDistribution.getInstalledFeatureSets();
                    for (FeatureSet installedFeature : installedFeatures) {
                        if (!featureSet.getName().equals(installedFeature.getName())) continue;
                        if (featureSet.isUpgradeInstalled()) {
                            featureSet.setSingleton(true);
                        }
                        if (!featureSet.isSingleton() && !installedFeature.isSingleton()) continue;
                        Collection<Component> components = componentsMap.get(featureSet);
                        singletonFeatureSetComponents.addAll(components);
                        Version version = new Version(featureSet.getVersion());
                        Version installedVersion = new Version(installedFeature.getVersion());
                        int versionCompare = version.compareTo(installedVersion);
                        if (versionCompare < 0) {
                            String currentSupersedingVersion = featureSet.getSupersededVersion();
                            if (!StringUtil.isNullOrEmpty((String)currentSupersedingVersion, (boolean)true) && installedVersion.compareTo(new Version(currentSupersedingVersion)) >= 0) continue;
                            featureSet.setSuperseded(installedFeature);
                            for (Component component : components) {
                                component.setOmitted(true);
                            }
                            continue;
                        }
                        if (versionCompare > 0) {
                            featureSet.addReplaces(installedFeature);
                            featureSet.setInitialRefCount(0);
                            Set<FeatureSet> replacesDependencies = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureSetDependenciesFiltered(featureSet, this.getFeatureSelectionTarget().getFeatures(), this.getFeatureSelectionTarget().getInstalledFeatures(), null);
                            replacesDependencies.remove(featureSet);
                            if (replacesDependencies.isEmpty()) continue;
                            LinkedHashSet<FeatureSet> incrementedReplacesDependencies = (LinkedHashSet<FeatureSet>)incrementedReplacesDependenciesMap.get(installedDistribution);
                            if (incrementedReplacesDependencies == null) {
                                incrementedReplacesDependencies = new LinkedHashSet<FeatureSet>();
                                incrementedReplacesDependenciesMap.put(installedDistribution, incrementedReplacesDependencies);
                            }
                            for (FeatureSet replacesDependency : replacesDependencies) {
                                if (incrementedReplacesDependencies.contains(replacesDependency)) continue;
                                if (allInstalledFeatures.contains(replacesDependency)) {
                                    Set<FeatureSet> installedFeatureDeps = FeatureSetHelper.getInstance(home.getClassLoader()).getResolvedFeatureSetDependenciesFiltered(installedFeature, allInstalledFeatures, null, null);
                                    if (installedFeatureDeps.contains(replacesDependency)) continue;
                                    replacesDependency.incrementInitialRefCount();
                                    incrementedReplacesDependencies.add(replacesDependency);
                                    continue;
                                }
                                if (replacesDependency.hasReplaces()) continue;
                                replacesDependency.incrementInitialRefCount();
                                incrementedReplacesDependencies.add(replacesDependency);
                            }
                            featureSet.setReplacesDependencies(replacesDependencies);
                            continue;
                        }
                        if (!installedFeature.isUpgrades()) continue;
                        featureSet.setUpgradesInHome(installedFeature.getUpgrades());
                    }
                }
            }
        }
    }
}

