/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ManifestBuilder;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Selection;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryAccessException;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioDelete;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.tools.NextGenPropertiesManager;
import com.oracle.cie.gdr.utils.StagingFileFilter;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClientLibraryHandler
extends JarLibraryHandler {
    private static final Logger _log = Logger.getLogger(ClientLibraryHandler.class.getName());
    public static final String CLIENTS_DIR = "clients";
    public static final String EXTERNAL_JAR_LOCATION = "modules/clients";
    public static final String INTERNAL_JAR_LOCATION = "modules/internal/clients";

    @Override
    public LibraryType getLibraryType() {
        return LibraryType.client;
    }

    @Override
    protected Collection<Path> generate(Home home, Set<LibraryEntryLocation> entryLocations, String productHome, List<String> jarLocations, Attributes manifestAttribs) throws LibraryHandlerException {
        ArrayList<Path> created;
        Path clientJar;
        block44: {
            block42: {
                Path myTempDir;
                ZipFile sourceJarFile;
                block41: {
                    String jarLoc = "";
                    clientJar = null;
                    if (jarLocations != null && !jarLocations.isEmpty()) {
                        jarLoc = jarLocations.get(0);
                    }
                    if (home == null) {
                        LibraryHandlerException ex = new LibraryHandlerException("The home provided was null.");
                        _log.throwing(this.getClass().getName(), "handle", (Throwable)((Object)ex));
                        throw ex;
                    }
                    created = new ArrayList<Path>();
                    if (StringUtil.isNullOrEmpty((String)productHome, (boolean)true)) break block42;
                    clientJar = NioHelper.getInstance().getPath(this.getFullJarLocation(productHome + File.separator + jarLoc), new String[0]);
                    this.cleanLibraryDirectory(clientJar);
                    JarHelper jarHelper = null;
                    sourceJarFile = null;
                    myTempDir = null;
                    try {
                        if (_log.isLoggable(Level.FINE)) {
                            _log.fine("Creating client jar at " + clientJar + " with jars " + entryLocations);
                        }
                        if (RegenerationHelper.isRegenerateState() && Files.exists(clientJar, new LinkOption[0]) && this.extractUpdatedEntries(entryLocations, clientJar.getParent(), home)) {
                            myTempDir = this.createTempDir(clientJar.getParent());
                            jarHelper = new JarHelper(clientJar.toFile(), 2);
                            jarHelper.setPreserve(true);
                            if (!StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
                                jarHelper.setStoredLibrariesTimeStamp(Long.valueOf(UtilityOps.getLibrariesTimeStamp()));
                            }
                            if (!jarHelper.update(myTempDir.toFile(), NextGenPropertiesManager.getInstance().getVariable("JAVA_HOME", home.getHomePath().toAbsolutePath().toString()))) {
                                throw new LibraryHandlerException("Failed to update library " + clientJar);
                            }
                        } else {
                            Manifest manifest = ManifestBuilder.getManifest((Attributes)manifestAttribs, null);
                            jarHelper = new JarHelper(clientJar.toFile(), 1, manifest, Long.valueOf(UtilityOps.getLibrariesTimeStamp()));
                            if (!StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
                                jarHelper.setStoredLibrariesTimeStamp(Long.valueOf(UtilityOps.getLibrariesTimeStamp()));
                            }
                            jarHelper.setPreserve(true);
                            jarHelper.setLevel(1);
                            if (entryLocations != null && !entryLocations.isEmpty()) {
                                for (LibraryEntryLocation entryLocation : entryLocations) {
                                    Path sourceJar = ClientLibraryHandler.getEntryLocationFile(entryLocation, home, this.getMode());
                                    if (entryLocation.getEntry().getExplode().booleanValue() && Files.isRegularFile(sourceJar, new LinkOption[0]) && sourceJar.toString().endsWith(".jar")) {
                                        final List<Selection> includes = entryLocation.getIncludes();
                                        Version gdrVersion = entryLocation.getLibraryTarget().getComponent().getGdrVersion();
                                        if (gdrVersion != null && gdrVersion.compareTo(new Version("1.1.0.0")) >= 0) {
                                            sourceJarFile = new JarFile(sourceJar.toFile());
                                            if (includes != null && !includes.isEmpty()) {
                                                for (Selection include : includes) {
                                                    try {
                                                        JarEntry entry = ((JarFile)sourceJarFile).getJarEntry(include.getName());
                                                        if (!StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
                                                            entry.setTime(UtilityOps.getLibrariesTimeStamp());
                                                        }
                                                        jarHelper.append(entry, ((JarFile)sourceJarFile).getInputStream(entry));
                                                    }
                                                    catch (NullPointerException npe) {
                                                        _log.warning("Entry not found: " + include.getName() + " in jar: " + sourceJarFile.getName());
                                                    }
                                                }
                                            } else {
                                                jarHelper.append((JarFile)sourceJarFile, null);
                                            }
                                        } else {
                                            FileFilter filter = null;
                                            final List<Selection> excludes = entryLocation.getExcludes();
                                            if (includes != null && !includes.isEmpty() || excludes != null && !excludes.isEmpty()) {
                                                filter = new FileFilter(){

                                                    @Override
                                                    public boolean accept(File file) {
                                                        return StagingFileFilter.accept(file.toPath(), includes, excludes) && !file.isDirectory();
                                                    }
                                                };
                                            }
                                            sourceJarFile = new JarFile(new File(sourceJar.toString()));
                                            jarHelper.append((JarFile)sourceJarFile, filter);
                                        }
                                        sourceJarFile.close();
                                        continue;
                                    }
                                    try {
                                        if (sourceJar.toString().endsWith(".jar")) {
                                            JarFile jarFile = new JarFile(new File(sourceJar.toString()));
                                            jarFile.close();
                                        }
                                        jarHelper.append(sourceJar.toFile(), entryLocation.getEntry().getIncludeParent().booleanValue());
                                    }
                                    catch (FileNotFoundException | NoSuchFileException | ZipException e) {
                                        jarHelper.close();
                                        Files.delete(clientJar);
                                        throw new LibraryAccessException("Library " + sourceJar.toAbsolutePath() + " not available for inclusion", e);
                                    }
                                }
                            }
                            jarHelper.close();
                        }
                        if (jarHelper == null) break block41;
                    }
                    catch (IOException e) {
                        try {
                            throw new LibraryHandlerException(e);
                        }
                        catch (Throwable throwable) {
                            if (jarHelper != null) {
                                jarHelper.close();
                            }
                            if (sourceJarFile != null) {
                                try {
                                    sourceJarFile.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (myTempDir != null && Files.exists(myTempDir, new LinkOption[0])) {
                                NioDelete.delete(myTempDir);
                            }
                            throw throwable;
                        }
                    }
                    jarHelper.close();
                }
                if (sourceJarFile != null) {
                    try {
                        sourceJarFile.close();
                    }
                    catch (IOException manifest) {
                        // empty catch block
                    }
                }
                if (myTempDir != null && Files.exists(myTempDir, new LinkOption[0])) {
                    NioDelete.delete((Path)myTempDir);
                }
                created.add(clientJar);
                break block44;
            }
            _log.finest("No " + (Object)((Object)this.getLibraryType()) + " jars were created for " + jarLocations + " because no product home directories were provided.");
        }
        if (jarLocations != null && jarLocations.size() > 1 && clientJar != null) {
            for (String location : jarLocations) {
                Path target = NioHelper.getInstance().getPath(this.getFullJarLocation(productHome + File.separator + location), new String[0]);
                try {
                    if (clientJar.equals(target)) continue;
                    NioCopy.copyFile((Path)clientJar, (Path)target);
                    if (!Files.isRegularFile(target, new LinkOption[0]) || !Files.exists(target, new LinkOption[0])) {
                        throw new FileNotFoundException("Failed to create client library " + target + " because source jar was not a file or did not exist: " + target);
                    }
                    created.add(target);
                }
                catch (IOException e) {
                    throw new LibraryHandlerException(e);
                }
            }
        }
        return created;
    }

    @Override
    protected String getInternalJarLocation() {
        return INTERNAL_JAR_LOCATION;
    }

    @Override
    protected String getExternalJarLocation() {
        return EXTERNAL_JAR_LOCATION;
    }

    @Override
    protected String getComponentJarName(Component component, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        if (suppressVersion) {
            return key.getName() + "." + (Object)((Object)key.getExtension());
        }
        return key.getName() + "_" + key.getVersion() + "." + (Object)((Object)key.getExtension());
    }

    @Override
    protected String getFeatureJarName(FeatureSet feature, LibraryKey key, boolean suppressPrefix, boolean suppressVersion) {
        if (suppressVersion) {
            return key.getName() + "." + (Object)((Object)key.getExtension());
        }
        return key.getName() + "_" + key.getVersion() + "." + (Object)((Object)key.getExtension());
    }

    @Override
    public boolean isThreadable() {
        return true;
    }

    private boolean extractUpdatedEntries(Set<LibraryEntryLocation> entryLocations, Path clientDir, Home home) throws LibraryHandlerException {
        boolean result = false;
        if (entryLocations != null && !entryLocations.isEmpty()) {
            for (LibraryEntryLocation entryLocation : entryLocations) {
                Path entryLocationPath = NioHelper.getInstance().getPath(entryLocation.getFullPath(), new String[0]);
                if (!RegenerationHelper.getInstance().getModifiedFiles().containsKey(entryLocationPath)) continue;
                Set<String> jarEntries = RegenerationHelper.getInstance().getModifiedFiles().get(entryLocationPath);
                if (!jarEntries.isEmpty()) {
                    block3: for (String jarEntry : jarEntries) {
                        result = false;
                        Path localTempDir = this.createTempDir(clientDir);
                        Path extractedEntry = localTempDir.resolve(jarEntry);
                        for (LibraryEntryLocation entryLocationToExtract : entryLocations) {
                            try {
                                JarHelper jarToExtract = new JarHelper(ClientLibraryHandler.getEntryLocationFile(entryLocationToExtract, home, this.getMode()).toFile());
                                jarToExtract.setPreserve(true);
                                List<Selection> includes = entryLocationToExtract.getIncludes();
                                List<Selection> excludes = entryLocationToExtract.getExcludes();
                                if (includes.isEmpty() && excludes.isEmpty()) {
                                    if (jarToExtract.getJar().getEntry(jarEntry) == null) continue;
                                    jarToExtract.extract(jarEntry, extractedEntry.toFile());
                                    result = true;
                                    continue block3;
                                }
                                Version gdrVersion = entryLocationToExtract.getLibraryTarget().getComponent().getGdrVersion();
                                if (gdrVersion != null && gdrVersion.compareTo(new Version("1.1.0.0")) >= 0) {
                                    for (Selection include : entryLocationToExtract.getIncludes()) {
                                        if (!include.getName().equals(jarEntry)) continue;
                                        jarToExtract.extract(jarEntry, extractedEntry.toFile());
                                        result = true;
                                        continue block3;
                                    }
                                    continue;
                                }
                                if (!StagingFileFilter.accept(NioHelper.getInstance().getPath(jarEntry, new String[0]), includes, excludes)) continue;
                                jarToExtract.extract(jarEntry, extractedEntry.toFile());
                                result = true;
                                continue block3;
                            }
                            catch (IOException e) {
                                throw new LibraryHandlerException(e);
                            }
                        }
                        if (result) continue;
                        return result;
                    }
                    continue;
                }
                return false;
            }
        }
        return result;
    }

    private Path createTempDir(Path parentDir) throws LibraryHandlerException {
        Path myTempDir;
        try {
            myTempDir = Files.createTempDirectory(parentDir, "temp", new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new LibraryHandlerException("Failed to create temporary directory for : " + parentDir + e1.getMessage());
        }
        if (!Files.exists(myTempDir, new LinkOption[0])) {
            throw new LibraryHandlerException("Failed to create temporary directory for : " + parentDir);
        }
        return myTempDir;
    }
}

