/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.Version;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ManifestBuilder;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.cmn.ManifestAttribute;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.external.impl.LibraryGeneratorImpl;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.installation.InstallerWrapper;
import com.oracle.cie.gdr.libraries.DefaultLibraryHandler;
import com.oracle.cie.gdr.libraries.HK2Generator;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JarLibraryHandler
extends DefaultLibraryHandler {
    private static final Logger _log = Logger.getLogger(JarLibraryHandler.class.getName());
    public static final String MODULES_DIR = "modules";
    public static final String INTERNAL_DIR = "internal";
    public static final String FEATURES_DIR = "features";
    public static final String FILENAME_SEPARATOR = "_";
    public static final String PATH_SEPARATOR = "/";
    public static final String LIBRARY_VERSION_ATTRIBUTE = "Library-Version";

    @Override
    public abstract LibraryType getLibraryType();

    @Override
    public boolean isSupportedLibraryType(LibraryType libraryType) {
        return libraryType == this.getLibraryType();
    }

    protected abstract String getInternalJarLocation();

    protected abstract String getExternalJarLocation();

    protected abstract String getComponentJarName(Component var1, LibraryKey var2, boolean var3, boolean var4);

    protected abstract String getFeatureJarName(FeatureSet var1, LibraryKey var2, boolean var3, boolean var4);

    @Override
    public String getEntryLocationPrefix() {
        return MODULES_DIR;
    }

    @Override
    protected void processComponentLibrary(LibraryKey key, LibraryTarget target, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        block15: {
            List<String> filteredJarLocations;
            block14: {
                List<String> jarLocations = this.getComponentJarLocations(key, target);
                filteredJarLocations = this.getFilteredJarLocations(key, target.getComponent().getVersion(), location, jarLocations);
                if (!RegenerationHelper.getInstance().getQueryMode()) break block14;
                if (StringUtil.isNullOrEmpty((String)location)) break block15;
                Logger regenLog = Logger.getLogger(LibraryGeneratorImpl.class.getName());
                for (String jarLoc : filteredJarLocations) {
                    String libraryPath = this.getFullJarLocation(location + File.separator + jarLoc);
                    Path libraryFile = NioHelper.getInstance().getPath(libraryPath, new String[0]);
                    if (Files.exists(libraryFile, new LinkOption[0])) {
                        RegenerationHelper.getInstance().addSourceFilesToRegenerate(libraryFile, this.getEntryLocationPaths(entryLocations));
                        regenLog.fine("Re-generating component library library at: " + libraryPath + " with jars " + entryLocations);
                    } else {
                        regenLog.fine("Generating new component library library at: " + libraryPath + " with jars " + entryLocations);
                    }
                    if (!key.getHK2Gen()) continue;
                    try {
                        RegenerationHelper.getInstance().addSourceFilesToRegenerate(libraryFile, HK2Generator.getHK2Jars(this.getInstallerWrapper()));
                    }
                    catch (DataHandlerException | GdrException | IOException e) {
                        _log.warning("Could not calculate HK2 files.");
                        _log.warning(e.getMessage());
                    }
                }
                break block15;
            }
            if (!filteredJarLocations.isEmpty()) {
                Attributes manifestAttribs = this.getManifestAttributes(target.getComponent().getName(), target.getComponent().getVersion(), key.getName(), key.getVersion(), JarLibraryHandler.getOtherComponentAttributes(target), key.getSuppressManifestProperties());
                if (RegenerationHelper.isRegenerateState()) {
                    Logger regenLog = Logger.getLogger(LibraryGeneratorImpl.class.getName());
                    for (String jarLoc : filteredJarLocations) {
                        regenLog.fine("Re-generating component library library at: " + this.getFullJarLocation(location + File.separator + jarLoc));
                    }
                }
                Collection<Path> created = this.generate(this.getHome(), entryLocations, location, filteredJarLocations, manifestAttribs);
                InstallerWrapper installerWrapper = this.getInstallerWrapper();
                this.generateHK2Metadata(key, created);
                if (key.getHK2Gen() && !StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
                    try {
                        JarHelper.overrideContentTimestamp(created, (Long)UtilityOps.getLibrariesTimeStamp());
                    }
                    catch (Exception e) {
                        throw new LibraryHandlerException(e);
                    }
                }
                if (installerWrapper != null && created != null && !created.isEmpty()) {
                    try {
                        installerWrapper.addExtraFilesToDeInstallInfo(target.getComponent().getName(), target.getComponent().getVersion(), created, false);
                    }
                    catch (DataHandlerException | GdrException | IOException e) {
                        throw new LibraryHandlerException(e);
                    }
                }
            }
        }
    }

    @Override
    protected void processFeatureLibrary(LibraryKey key, LibraryTargetHolder holder, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        block15: {
            List<String> filteredJarLocations;
            block14: {
                List<String> jarLocations = this.getFeaturesetJarLocations(key, holder);
                filteredJarLocations = this.getFilteredJarLocations(key, holder.getFeature().getVersion(), location, jarLocations);
                if (!RegenerationHelper.getInstance().getQueryMode()) break block14;
                if (StringUtil.isNullOrEmpty((String)location)) break block15;
                Logger regenLog = Logger.getLogger(LibraryGeneratorImpl.class.getName());
                for (String jarLoc : filteredJarLocations) {
                    String libraryPath = this.getFullJarLocation(location + File.separator + jarLoc);
                    Path libraryFile = NioHelper.getInstance().getPath(libraryPath, new String[0]);
                    if (Files.exists(libraryFile, new LinkOption[0])) {
                        RegenerationHelper.getInstance().addSourceFilesToRegenerate(libraryFile, this.getEntryLocationPaths(entryLocations));
                        regenLog.fine("Re-generating featureset library library at: " + libraryPath + " with jars " + entryLocations);
                    } else {
                        regenLog.fine("Generating new featureset library library at: " + libraryPath + " with jars " + entryLocations);
                    }
                    if (!key.getHK2Gen()) continue;
                    try {
                        RegenerationHelper.getInstance().addSourceFilesToRegenerate(libraryFile, HK2Generator.getHK2Jars(this.getInstallerWrapper()));
                    }
                    catch (DataHandlerException | GdrException | IOException e) {
                        _log.warning("Could not calculate HK2 files.");
                        _log.warning(e.getMessage());
                    }
                }
                break block15;
            }
            if (!filteredJarLocations.isEmpty()) {
                Attributes manifestAttribs = this.getManifestAttributes(holder.getFeature().getName(), holder.getFeature().getVersion(), key.getName(), key.getVersion(), JarLibraryHandler.getOtherFeatureAttributes(key, holder), key.getSuppressManifestProperties());
                if (RegenerationHelper.isRegenerateState()) {
                    Logger regenLog = Logger.getLogger(LibraryGeneratorImpl.class.getName());
                    for (String jarLoc : filteredJarLocations) {
                        regenLog.fine("Re-generating feature library at: " + this.getFullJarLocation(location + File.separator + jarLoc));
                    }
                }
                Collection<Path> created = this.generate(this.getHome(), entryLocations, location, filteredJarLocations, manifestAttribs);
                InstallerWrapper installerWrapper = this.getInstallerWrapper();
                this.generateHK2Metadata(key, created);
                if (key.getHK2Gen() && !StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
                    try {
                        JarHelper.overrideContentTimestamp(created, (Long)UtilityOps.getLibrariesTimeStamp());
                    }
                    catch (Exception e) {
                        throw new LibraryHandlerException(e);
                    }
                }
                if (installerWrapper != null && created != null && !created.isEmpty()) {
                    try {
                        installerWrapper.addExtraFilesToDeInstallInfo(holder.getFeature().getName(), holder.getFeature().getVersion(), created, true);
                    }
                    catch (DataHandlerException | GdrException | IOException e) {
                        throw new LibraryHandlerException(e);
                    }
                }
            }
        }
    }

    protected void generateHK2Metadata(LibraryKey key, Collection<Path> created) throws LibraryHandlerException {
        if (key.getHK2Gen()) {
            for (Path jarFile : created) {
                try {
                    HK2Generator.generateHK2Metadata(jarFile, key.getHK2Location(), this.getInstallerWrapper());
                }
                catch (DataHandlerException | GdrException | IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new LibraryHandlerException(e);
                }
            }
        }
    }

    protected abstract Collection<Path> generate(Home var1, Set<LibraryEntryLocation> var2, String var3, List<String> var4, Attributes var5) throws LibraryHandlerException;

    public Attributes getManifestAttributes(String implTitle, String implVer, String specTitle, String specVer) {
        return this.getManifestAttributes(implTitle, implVer, specTitle, specVer, null);
    }

    public Attributes getManifestAttributes(String implTitle, String implVer, String specTitle, String specVer, Map<String, String> others) {
        return this.getManifestAttributes(implTitle, implVer, specTitle, specVer, others, null);
    }

    public Attributes getManifestAttributes(String implTitle, String implVer, String specTitle, String specVer, Map<String, String> others, String suppressManifestProperties) {
        Attributes manifestAttribs = new Attributes();
        HashSet<String> suppressedProperties = new HashSet<String>();
        if (!StringUtil.isNullOrEmpty((String)suppressManifestProperties)) {
            suppressedProperties.addAll(Arrays.asList(suppressManifestProperties.split(",")));
        }
        if (!suppressedProperties.contains(Attributes.Name.IMPLEMENTATION_TITLE.toString())) {
            manifestAttribs.put(Attributes.Name.IMPLEMENTATION_TITLE, implTitle != null ? implTitle : "");
        }
        if (!suppressedProperties.contains(Attributes.Name.IMPLEMENTATION_VERSION.toString())) {
            manifestAttribs.put(Attributes.Name.IMPLEMENTATION_VERSION, implVer != null ? implVer : "");
        }
        if (!suppressedProperties.contains(Attributes.Name.SPECIFICATION_TITLE.toString())) {
            manifestAttribs.put(Attributes.Name.SPECIFICATION_TITLE, specTitle != null ? specTitle : "");
        }
        if (!suppressedProperties.contains(Attributes.Name.SPECIFICATION_VERSION.toString())) {
            manifestAttribs.put(Attributes.Name.SPECIFICATION_VERSION, specVer != null ? specVer : "");
        }
        if (!suppressedProperties.contains(Attributes.Name.MANIFEST_VERSION.toString())) {
            manifestAttribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        if (!suppressedProperties.contains("Created-By")) {
            manifestAttribs.put(new Attributes.Name("Created-By"), System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        }
        if (!suppressedProperties.contains(LIBRARY_VERSION_ATTRIBUTE)) {
            manifestAttribs.put(new Attributes.Name(LIBRARY_VERSION_ATTRIBUTE), implVer != null ? implVer : "");
        }
        if (others != null && !others.isEmpty()) {
            for (String key : others.keySet()) {
                if (suppressedProperties.contains(key)) continue;
                manifestAttribs.put(new Attributes.Name(key), others.get(key));
            }
        }
        return manifestAttribs;
    }

    protected String getClasspathString(Set<LibraryEntryLocation> entryLocations, String jarLocation, String productHome) {
        String cp = null;
        if (entryLocations != null && !entryLocations.isEmpty()) {
            for (LibraryEntryLocation entryLocation : entryLocations) {
                cp = cp != null ? cp + " " : "";
                cp = cp + this.calculateRelativeEntryPath(entryLocation, jarLocation, productHome);
            }
        }
        return cp != null ? cp : "";
    }

    protected String calculateRelativeEntryPath(LibraryEntryLocation entryLocation, String jarLocation, String productHome) {
        boolean federated;
        int depth = jarLocation.replace("\\", PATH_SEPARATOR).split(PATH_SEPARATOR).length;
        if (productHome == null || productHome.isEmpty()) {
            --depth;
        }
        boolean bl = federated = !entryLocation.getHome().equals(this.getHome());
        if (federated) {
            ++depth;
        }
        String prefixPath = null;
        for (int x = 0; x < depth; ++x) {
            prefixPath = prefixPath == null ? ".." : prefixPath + "/..";
        }
        if (prefixPath == null) {
            prefixPath = "";
        }
        if (federated) {
            prefixPath = prefixPath + PATH_SEPARATOR + entryLocation.getHome().getHomePath().getFileName().toString();
        }
        return prefixPath + PATH_SEPARATOR + entryLocation.getFullPath();
    }

    public static void createManifestJar(Path jar, String cp) throws IOException {
        JarLibraryHandler.createManifestJar(jar, cp, null);
    }

    public static void createManifestJar(Path jar, String cp, Attributes mainAttribs) throws IOException {
        JarLibraryHandler.createManifestJar(jar, cp, mainAttribs, null);
    }

    public static void createManifestJar(Path jar, String cp, Attributes mainAttribs, Map<String, Attributes> sectionAttribs) throws IOException {
        Attributes attr = new Attributes();
        attr.put(Attributes.Name.CLASS_PATH, cp);
        if (mainAttribs != null) {
            attr.putAll((Map<?, ?>)mainAttribs);
        }
        JarLibraryHandler.createManifestJar(jar, attr, sectionAttribs);
    }

    public static void createManifestJar(Path jar, Attributes mainAttribs, Map<String, Attributes> sectionAttribs) throws IOException {
        Manifest manifest = ManifestBuilder.getManifest((Attributes)mainAttribs, sectionAttribs);
        if (_log.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (manifest != null) {
                manifest.write(bos);
            }
            _log.finest("Creating manifest classpath jar " + jar + " with manifest: " + bos.toString());
        }
        JarHelper jarHelper = new JarHelper(jar.toFile(), 1, manifest, Long.valueOf(UtilityOps.getLibrariesTimeStamp()));
        if (!StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
            jarHelper.setStoredLibrariesTimeStamp(Long.valueOf(UtilityOps.getLibrariesTimeStamp()));
        }
        jarHelper.close();
    }

    public static Map<String, String> getOtherComponentAttributes(LibraryTarget target) {
        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
        com.oracle.cie.gdr.dao.cmn.Manifest man = target.getLibrary().getManifest();
        if (man != null) {
            for (ManifestAttribute attribute : man.getAttributes()) {
                attrMap.put(attribute.getName(), attribute.getValue());
            }
        }
        return attrMap;
    }

    public static Map<String, String> getOtherFeatureAttributes(LibraryKey key, LibraryTargetHolder holder) {
        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
        com.oracle.cie.gdr.dao.cmn.Manifest man = holder.getFeatureLibrary(key).getManifest();
        if (man != null) {
            for (ManifestAttribute attribute : man.getAttributes()) {
                attrMap.put(attribute.getName(), attribute.getValue());
            }
        }
        return attrMap;
    }

    @Override
    public List<String> getAbsoluteComponentJarPaths(LibraryKey key, LibraryTarget target) throws LibraryHandlerException {
        ArrayList<String> jarAbsoluteLocations = new ArrayList<String>();
        for (String jarLoc : this.getComponentJarLocations(key, target)) {
            jarAbsoluteLocations.add(this.getFullJarLocation(jarLoc));
        }
        return jarAbsoluteLocations;
    }

    @Override
    public List<String> getAbsoluteFeaturesetJarPaths(LibraryKey key, LibraryTargetHolder holder) throws LibraryHandlerException {
        ArrayList<String> jarAbsoluteLocations = new ArrayList<String>();
        for (String jarLoc : this.getFeaturesetJarLocations(key, holder)) {
            jarAbsoluteLocations.add(this.getFullJarLocation(jarLoc));
        }
        return jarAbsoluteLocations;
    }

    protected List<String> getComponentJarLocations(LibraryKey key, LibraryTarget target) throws LibraryHandlerException {
        List<String> jarLocations = target.getLibraryJarLocations();
        if (jarLocations == null) {
            jarLocations = new ArrayList<String>();
            Set<String> targetLocation = target.getLibrary().getLocation();
            if (targetLocation.isEmpty()) {
                String loc = this.getJarLocation(key, null);
                loc = loc + PATH_SEPARATOR + this.getComponentJarName(target.getComponent(), key, target.getLibrary().getSuppressPrefix(), target.getLibrary().getSuppressVersion());
                jarLocations.add(loc);
            } else {
                for (String loc : targetLocation) {
                    if (this.isValidLocation(loc)) {
                        loc = this.getJarLocation(key, loc);
                        if (this.getLibraryType().equals((Object)key.getType())) {
                            loc = loc + PATH_SEPARATOR + this.getComponentJarName(target.getComponent(), key, target.getLibrary().getSuppressPrefix(), target.getLibrary().getSuppressVersion());
                        } else {
                            try {
                                JarLibraryHandler libHandler = (JarLibraryHandler)key.getType().getHandler();
                                loc = loc + PATH_SEPARATOR + libHandler.getComponentJarName(target.getComponent(), key, target.getLibrary().getSuppressPrefix(), target.getLibrary().getSuppressVersion());
                            }
                            catch (ClassNotFoundException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (NoSuchMethodException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (InstantiationException e) {
                                throw new LibraryHandlerException(e);
                            }
                        }
                        jarLocations.add(loc);
                        continue;
                    }
                    throw new LibraryHandlerException("The location must be a relative path and cannot contain \".\"");
                }
            }
            target.setLibraryJarLocations(jarLocations);
        }
        return jarLocations;
    }

    public List<String> getComponentJarLocations(Library library, Component component) throws LibraryHandlerException {
        String version;
        ArrayList<String> jarLocations = new ArrayList<String>();
        Set<String> targetLocation = library.getLocation();
        String type = library.getType();
        String name = library.getName();
        String extension = library.getExtension();
        String completeVersion = version = library.getVersion();
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            version = ComponentHelper.getShortenedVersion(component.getVersion());
            completeVersion = component.getVersion();
        }
        LibraryKey key = new LibraryKey(type, name, extension, version, completeVersion, library.getVisibility(), library.getIgnoreType(), library.getIgnoreVersion(), library.getPomGen(), library.getHK2Gen(), library.getHK2Location(), library.getOverwriteHigherVersion(), library.getSuppressManifestProperties());
        if (targetLocation.isEmpty()) {
            String loc = this.getJarLocation(key, null);
            loc = loc + PATH_SEPARATOR + this.getComponentJarName(component, key, library.getSuppressPrefix(), library.getSuppressVersion());
            jarLocations.add(loc);
        } else {
            for (String loc : targetLocation) {
                if (this.isValidLocation(loc)) {
                    loc = this.getJarLocation(key, loc);
                    loc = loc + PATH_SEPARATOR + this.getComponentJarName(component, key, library.getSuppressPrefix(), library.getSuppressVersion());
                    jarLocations.add(loc);
                    continue;
                }
                throw new LibraryHandlerException("The location must be a relative path and cannot contain \".\"");
            }
        }
        return jarLocations;
    }

    protected List<String> getFeaturesetJarLocations(LibraryKey key, LibraryTargetHolder holder) throws LibraryHandlerException {
        List<String> jarLocations = holder.getFeaturesetJarLocations(key);
        if (jarLocations == null) {
            jarLocations = new ArrayList<String>();
            Set<String> holderLocation = holder.getFeatureLibrary(key).getLocation();
            if (holderLocation.isEmpty()) {
                String loc = this.getJarLocation(key, null);
                loc = loc + PATH_SEPARATOR + this.getFeatureJarName(holder.getFeature(), key, holder.getFeatureLibrary(key).getSuppressPrefix(), holder.getFeatureLibrary(key).getSuppressVersion());
                jarLocations.add(loc);
            } else {
                for (String loc : holderLocation) {
                    if (this.isValidLocation(loc)) {
                        loc = this.getJarLocation(key, loc);
                        if (this.getLibraryType().equals((Object)key.getType())) {
                            loc = loc + PATH_SEPARATOR + this.getFeatureJarName(holder.getFeature(), key, holder.getFeatureLibrary(key).getSuppressPrefix(), holder.getFeatureLibrary(key).getSuppressVersion());
                        } else {
                            try {
                                JarLibraryHandler libHandler = (JarLibraryHandler)key.getType().getHandler();
                                loc = loc + PATH_SEPARATOR + libHandler.getFeatureJarName(holder.getFeature(), key, holder.getFeatureLibrary(key).getSuppressPrefix(), holder.getFeatureLibrary(key).getSuppressVersion());
                            }
                            catch (ClassNotFoundException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (NoSuchMethodException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new LibraryHandlerException(e);
                            }
                            catch (InstantiationException e) {
                                throw new LibraryHandlerException(e);
                            }
                        }
                        jarLocations.add(loc);
                        continue;
                    }
                    throw new LibraryHandlerException("The location must be a relative path and cannot contain \".\"");
                }
            }
            holder.setFeaturesetJarLocations(key, jarLocations);
        }
        return jarLocations;
    }

    public List<String> getFeaturesetJarLocations(FeatureLibrary library, FeatureSet featureSet) throws LibraryHandlerException {
        String version;
        ArrayList<String> jarLocations = new ArrayList<String>();
        Set<String> holderLocation = library.getLocation();
        String type = library.getType();
        String name = library.getName();
        String extension = library.getExtension();
        String completeVersion = version = library.getVersion();
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            version = ComponentHelper.getShortenedVersion(featureSet.getVersion());
            completeVersion = featureSet.getVersion();
        }
        LibraryKey key = new LibraryKey(type, name, extension, version, completeVersion, library.getVisibility(), library.getIgnoreType(), library.getIgnoreVersion(), library.getPomGen(), library.getHK2Gen(), library.getHK2Location(), library.getOverwriteHigherVersion(), library.getSuppressManifestProperties());
        if (holderLocation.isEmpty()) {
            String loc = this.getJarLocation(key, null);
            loc = loc + PATH_SEPARATOR + this.getFeatureJarName(featureSet, key, library.getSuppressPrefix(), library.getSuppressVersion());
            jarLocations.add(loc);
        } else {
            for (String loc : holderLocation) {
                if (this.isValidLocation(loc)) {
                    loc = this.getJarLocation(key, loc);
                    loc = loc + PATH_SEPARATOR + this.getFeatureJarName(featureSet, key, library.getSuppressPrefix(), library.getSuppressVersion());
                    jarLocations.add(loc);
                    continue;
                }
                throw new LibraryHandlerException("The location must be a relative path and cannot contain \".\"");
            }
        }
        return jarLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFilteredJarLocations(LibraryKey key, String compVersion, String location, List<String> jarLocations) {
        if (key.getOverWriteHigherVersion()) {
            return jarLocations;
        }
        ArrayList<String> filteredJarLocations = new ArrayList<String>();
        for (String jarLoc : jarLocations) {
            String libraryPath = this.getFullJarLocation(location + File.separator + jarLoc);
            Path libraryFile = NioHelper.getInstance().getPath(libraryPath, new String[0]);
            if (Files.exists(libraryFile, new LinkOption[0])) {
                JarHelper jar = null;
                try {
                    Manifest man;
                    jar = new JarHelper(libraryFile.toFile());
                    jar.setPreserve(true);
                    if (!StringUtil.isNullOrEmpty((String)System.getProperty("oracle.installer.libraries.timestamp"))) {
                        jar.setStoredLibrariesTimeStamp(Long.valueOf(UtilityOps.getLibrariesTimeStamp()));
                    }
                    if ((man = jar.getManifest()) != null) {
                        if (man.getMainAttributes().containsKey(new Attributes.Name(LIBRARY_VERSION_ATTRIBUTE))) {
                            Version newVersion = new Version(compVersion);
                            String libraryVersion = man.getMainAttributes().getValue(new Attributes.Name(LIBRARY_VERSION_ATTRIBUTE));
                            Version existingVersion = new Version(libraryVersion);
                            if (newVersion.compareTo(existingVersion) < 0) {
                                _log.info("Skipping generation of library " + key.getName() + " " + key.getVersion() + " in location " + libraryPath + " because overwrite-higher-version property was set to true and existing library version is higher: " + libraryVersion);
                                continue;
                            }
                            filteredJarLocations.add(jarLoc);
                            continue;
                        }
                        filteredJarLocations.add(jarLoc);
                        continue;
                    }
                    filteredJarLocations.add(jarLoc);
                    continue;
                }
                catch (Exception e) {
                    filteredJarLocations.add(jarLoc);
                    continue;
                }
                finally {
                    if (jar != null) {
                        jar.close();
                    }
                    continue;
                }
            }
            filteredJarLocations.add(jarLoc);
        }
        return filteredJarLocations;
    }

    public String getFullJarLocation(String relativePath) {
        return FileUtils.formatPath(this.getHome() + File.separator + relativePath);
    }

    public Set<Path> getEntryLocationPaths(Set<LibraryEntryLocation> entryLocations) {
        HashSet<Path> sourcePaths = new HashSet<Path>();
        if (entryLocations != null) {
            for (LibraryEntryLocation entryLocation : entryLocations) {
                sourcePaths.add(NioHelper.getInstance().getPath(entryLocation.getFullPath(), new String[0]));
            }
        }
        return sourcePaths;
    }

    private boolean isValidLocation(String location) {
        if (location != null) {
            String[] locationFragments;
            String newLocation = location.replaceAll("\\\\", PATH_SEPARATOR);
            if (newLocation.contains(":") || newLocation.startsWith(PATH_SEPARATOR)) {
                return false;
            }
            for (String fragment : locationFragments = newLocation.split(PATH_SEPARATOR)) {
                if (!fragment.equals(".") && !fragment.equals("..")) continue;
                return false;
            }
        }
        return true;
    }

    private String getJarLocation(LibraryKey key, String locationOverride) {
        if (locationOverride != null) {
            return locationOverride.trim();
        }
        if (key.getVisibility().isInternal()) {
            return this.getInternalJarLocation();
        }
        return this.getExternalJarLocation();
    }
}

