/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.merger;

import com.oracle.cie.gdr.merger.AttributeDescriptor;
import com.oracle.cie.gdr.merger.IManifestConflictResolver;
import com.oracle.cie.gdr.merger.LibraryJarHelper;
import com.oracle.cie.gdr.merger.MergeException;
import com.oracle.cie.gdr.utils.FileUtils;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;

public class WLSManifestResolver
implements IManifestConflictResolver {
    private static final String MANIFEST_SEPARATOR = "/";

    @Override
    public String resolve(List<AttributeDescriptor> attrList, List<LibraryJarHelper> jars) throws MergeException {
        String name = attrList.get(0).getName().toString();
        for (AttributeDescriptor attr : attrList) {
            if (attr.getJar() != null || name.equals(Attributes.Name.CLASS_PATH.toString())) continue;
            return attr.getValue();
        }
        if (name.equals(Attributes.Name.CLASS_PATH.toString())) {
            return this.classPathMerge(attrList, jars);
        }
        return "";
    }

    private String classPathMerge(List<AttributeDescriptor> attrList, List<LibraryJarHelper> jars) {
        String separator = " ";
        LinkedHashSet<String> contentSet = new LinkedHashSet<String>();
        for (AttributeDescriptor attrD : attrList) {
            String[] contents;
            for (String unit : contents = attrD.getValue().split(separator)) {
                if (this.isMerged(unit, jars)) continue;
                if (attrD.getJar() == null) {
                    contentSet.add(FileUtils.formatPath(unit, MANIFEST_SEPARATOR));
                    continue;
                }
                contentSet.add(this.calculateClasspath(unit, attrD.getJar().getModuleLocation(), attrD.getJar().getMergedLocation(), attrD.getJar().getProductHome(), attrD.getJar().getMergedProductHome()));
            }
        }
        StringBuilder value = new StringBuilder();
        for (String key : contentSet) {
            if (value.length() == 0) {
                value.append(key);
                continue;
            }
            value.append(separator + key);
        }
        return value.toString();
    }

    private String calculateClasspath(String unitPath, String jarPath, String mergedPath, String jarProductHome, String mergedProductHome) {
        StringBuilder path = new StringBuilder();
        String formatedJarPath = FileUtils.formatPath(jarPath, MANIFEST_SEPARATOR);
        String formatedUnitPath = FileUtils.formatPath(unitPath, MANIFEST_SEPARATOR);
        String[] jarPathTokens = formatedJarPath.split(MANIFEST_SEPARATOR);
        String formatedPath = FileUtils.formatPath(mergedPath, MANIFEST_SEPARATOR);
        String[] mergedPathTokens = formatedPath.split(MANIFEST_SEPARATOR);
        String[] unitPathTokens = formatedUnitPath.split(MANIFEST_SEPARATOR);
        LinkedList<String> pathTokens = new LinkedList<String>();
        if (jarProductHome.equals(mergedProductHome)) {
            int i;
            int commonDirs;
            for (commonDirs = 0; commonDirs < jarPathTokens.length && commonDirs < mergedPathTokens.length && jarPathTokens[commonDirs].equals(mergedPathTokens[commonDirs]); ++commonDirs) {
            }
            int goBack = mergedPathTokens.length - commonDirs - 1;
            for (i = 0; i < goBack; ++i) {
                pathTokens.add("..");
            }
            for (i = commonDirs; i < jarPathTokens.length - 1; ++i) {
                pathTokens.add(jarPathTokens[i]);
            }
        } else {
            int i;
            for (i = 0; i < mergedPathTokens.length; ++i) {
                pathTokens.add("..");
            }
            pathTokens.add(jarProductHome);
            for (i = 0; i < jarPathTokens.length - 1; ++i) {
                pathTokens.add(jarPathTokens[i]);
            }
        }
        for (String dir : unitPathTokens) {
            if (dir.equals("..") && !pathTokens.isEmpty() && !((String)pathTokens.get(pathTokens.size() - 1)).equals("..")) {
                pathTokens.remove(pathTokens.size() - 1);
                continue;
            }
            pathTokens.add(dir);
        }
        for (int i = 0; i < pathTokens.size(); ++i) {
            if (i == pathTokens.size() - 1) {
                path.append((String)pathTokens.get(i));
                continue;
            }
            path.append((String)pathTokens.get(i) + MANIFEST_SEPARATOR);
        }
        return path.toString();
    }

    private boolean isMerged(String name, List<LibraryJarHelper> jars) {
        for (LibraryJarHelper jar : jars) {
            File temp = new File(jar.getJar().getJar().getName());
            if (!name.contains(temp.getName())) continue;
            return true;
        }
        return false;
    }
}

