/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.packaging;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionLoader;
import com.oracle.cie.gdr.DistributionLoaderFactory;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.Bug;
import com.oracle.cie.gdr.dao.nfo.BugInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.dao.pai.PatchAttachmentInfo;
import com.oracle.cie.gdr.dao.pai.PatchInfo;
import com.oracle.cie.gdr.dependency.FeatureDependencyManager;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.helpers.PatchAttachmentInfoHelper;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.installation.InstallationValidator;
import com.oracle.cie.gdr.packaging.CommonPackager;
import com.oracle.cie.gdr.services.RepositoryService;
import com.oracle.cie.gdr.services.TopLevelDirectoryService;
import com.oracle.cie.gdr.tools.FeatureSetConsumer;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.inputs.impl.InputHandlerException;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.cie.rest.Repository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DistributionPackager
extends CommonPackager {
    private static final Logger _log = Logger.getLogger(DistributionPackager.class.getName());
    private DistributionLoader _distributionLoader;
    private ComponentLoader _componentLoader;
    private LabelMap _labelMap;
    private InstallerInfo _installerInfo;
    private PatchAttachmentInfo _patchAttachmentInfo;
    private FeatureSetConsumer _consumer;
    private boolean _repositoryShiphome;
    private Map<FeatureSetReference, Set<Distribution>> _externalDistributionMap;

    public DistributionPackager(File srcHome, String distributionName, String distributionVersion, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException, DependencyException {
        this(new MetaDataHome(TopLevelDirectoryService.getGdrLabelTopLevelDirectory(srcHome), false), distributionName, distributionVersion, platforms, locales, variableMap);
    }

    public DistributionPackager(MetaDataHome metaDataHome, String distributionName, String distributionVersion, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap) throws IOException, DataHandlerException, GdrException, DependencyException {
        this(metaDataHome, distributionName, distributionVersion, platforms, locales, variableMap, false);
    }

    public DistributionPackager(MetaDataHome metaDataHome, String distributionName, String distributionVersion, Set<Integer> platforms, Set<Integer> locales, Map<String, String> variableMap, boolean repositoryShiphome) throws IOException, DataHandlerException, GdrException, DependencyException {
        super(metaDataHome, platforms, locales, variableMap);
        if (repositoryShiphome || metaDataHome.isRepository()) {
            this._repositoryShiphome = repositoryShiphome;
        }
        this.init(distributionName, distributionVersion);
        this.validate();
    }

    public DistributionLoader getDistributionLoader() {
        return this._distributionLoader;
    }

    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    public Set<FeatureSet> getInstalledFeatureSets() {
        return this.getDistributionLoader().getDistributionTarget().getInstalledFeatureSets();
    }

    public LabelMap getLabelMap() {
        return this._labelMap;
    }

    public boolean isRepositoryShiphome() {
        return this._repositoryShiphome;
    }

    protected void init(String distributionName, String distributionVersion) throws GdrException, IOException, DataHandlerException {
        this._distributionLoader = DistributionLoaderFactory.getDistributionLoader(this.getMetaDataHome(), distributionName, distributionVersion);
        if (this._distributionLoader == null) {
            GdrException ex = new GdrException("The distribution loader was not loaded properly.");
            _log.throwing(DistributionPackager.class.getName(), "init", ex);
            throw ex;
        }
        InstallerDistributionInfo dinfo = null;
        if (!this.getMetaDataHome().isShiphome() && !this.getMetaDataHome().isRepository()) {
            this._labelMap = LabelMapHelper.getInstance().getLabelMap(this.getMetaDataHome().getGdrMetaDataHomePath());
            if (this._labelMap == null) {
                GdrException ex = new GdrException("The label map definition was not loaded properly.");
                _log.throwing(DistributionPackager.class.getName(), "init", ex);
                throw ex;
            }
        } else {
            Path infoFile = this.getMetaDataHome().getGdrMetaDataHomePath().resolve(InstallerInfoHelper.getInstance().getPath() + File.separator + "installer-info.xml");
            if (Files.exists(infoFile, new LinkOption[0])) {
                this._installerInfo = (InstallerInfo)InstallerInfoHelper.getInstance().getRootWrapper(infoFile);
                dinfo = InstallerInfoHelper.getInstance().getInstallerDistributionInfo(this._installerInfo, this.getDistributionLoader().getDistributionName(), this.getDistributionLoader().getDistributionVersion());
            } else {
                _log.finer("Unable to update the installer-info.xml since it did not exist at " + infoFile);
            }
        }
        this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.PACKAGE_SHIPHOME, this._distributionLoader.getFeatureSets(), this._distributionLoader.getDirectoryMap(), dinfo, this.getLabelMap());
    }

    protected void validate() throws GdrException, IOException, DataHandlerException, DependencyException {
        Set<FeatureSet> features = this.getDistributionLoader().getFeatureSets();
        features.addAll(this.getDistributionLoader().getDistributionTarget().getDummyExternalFeatureSets());
        Home h = Home.getHome(this.getDistributionLoader().getMetaDataHome().getGdrMetaDataHomePath());
        InstallationValidator validator = new InstallationValidator(this.getDistributionLoader().getDistributionTarget(), features, this.getComponentLoader(), h);
        validator.validatePackage();
        validator.validatePackagingDependencies();
        validator.validateLanguages();
        FeatureSetHelper.getInstance().findUnusedSymbols(features, this.getDistributionLoader().getDirectoryMap(), this.getComponentLoader().getComponentsMap());
        FeatureSetHelper.getInstance().validateFeatureInclude(features, this.getComponentLoader().getComponents());
        if (this.isLibValidationEnabled()) {
            FeatureSetHelper.getInstance().validateLibraryLocations(features, this.getComponentLoader().getComponents(), this.getDistributionLoader().getDirectoryMap(), Mode.PACKAGE_SHIPHOME);
        }
        FeatureSetHelper.getInstance().setFeatureLibrariesSize(features, this.getComponentLoader().getComponents());
        this._consumer = new FeatureSetConsumer(this.getMetaDataHomeDir(), features);
        for (FeatureSet featureSet : features) {
            if (this._consumer.isConsumable(featureSet)) continue;
            throw new GdrException("The feature set " + featureSet + " is not consumable.");
        }
        Set<FeatureSetReference> externalFeatureRefs = this.getExternalFeatureRefs();
        this._externalDistributionMap = new HashMap<FeatureSetReference, Set<Distribution>>();
        if (externalFeatureRefs != null && !externalFeatureRefs.isEmpty()) {
            Set<Distribution> distributions = DistributionHelper.getInstance().getDistributions(this.getDistributionLoader().getMetaDataHome());
            distributions.remove(this.getDistributionLoader().getDistribution());
            for (Distribution distribution : distributions) {
                Set<FeatureSetReference> distRefs = DistributionHelper.getInstance().getFeatureSetReferences(distribution);
                for (FeatureSetReference ref : externalFeatureRefs) {
                    if (!distRefs.contains((Object)ref)) continue;
                    Set<Distribution> dists = this._externalDistributionMap.get((Object)ref);
                    if (dists == null) {
                        dists = new HashSet<Distribution>();
                        this._externalDistributionMap.put(ref, dists);
                    }
                    dists.add(distribution);
                }
            }
        }
    }

    public Set<FeatureSetReference> getExternalFeatureRefs() {
        return this.getDistributionLoader().getDistributionTarget().getExternalFeatureRefs();
    }

    public Map<FeatureSetReference, Set<Distribution>> getExternalDistributions() {
        return this._externalDistributionMap;
    }

    private InstallerInfo getInstallerInfo() {
        if (this._installerInfo == null) {
            this._installerInfo = new InstallerInfo();
            this._installerInfo.setPlatform(this.getServiceHolder().getPlatformService().getPlatforms().iterator().next());
            InstallerDistributionInfo dinfo = InstallerInfoHelper.getInstance().createInstallerDistributionInfo(this.getDistributionLoader().getDistributionName(), this.getDistributionLoader().getDistributionVersion(), this.getComponentsMap());
            if (!StringUtil.isNullOrEmpty((String)this.getServiceHolder().getVariableResolverService().get("BUG_LIST"))) {
                dinfo.setBugInfo(this.generateBugInfo(this.getServiceHolder().getVariableResolverService().get("BUG_LIST"), dinfo.getBugInfo()));
            }
            ArrayList<InstallerDistributionInfo> dinfos = new ArrayList<InstallerDistributionInfo>();
            dinfos.add(dinfo);
            this._installerInfo.getInstallerPackageInfo(true).setInstallerDistributionInfo(dinfos);
            Map<FeatureSetReference, Set<Distribution>> externalDists = this.getExternalDistributions();
            if (externalDists != null && !externalDists.isEmpty()) {
                this._installerInfo.setExternalDeps(InstallerInfoHelper.getInstance().getExternalDeps(externalDists));
            }
        }
        return this._installerInfo;
    }

    private BugInfo generateBugInfo(String bugList, BugInfo baseBugInfo) {
        String[] bugIds = bugList.split(",");
        ArrayList<Bug> bugs = new ArrayList<Bug>();
        List<Bug> baseBugs = null;
        Bug bug = null;
        BugInfo bugInfo = new BugInfo();
        for (String bugId : bugIds) {
            bug = new Bug(bugId, "");
            bugs.add(bug);
        }
        if (baseBugInfo != null) {
            baseBugs = baseBugInfo.getBugInfoList();
            for (Bug aBug : baseBugs) {
                if (bugs.contains((Object)aBug)) continue;
                bugs.add(aBug);
            }
        }
        bugInfo.setBugInfoList(bugs);
        return bugInfo;
    }

    public void saveInstallerInfo(File dir) throws DataHandlerException {
        _log.finer("saveInstallerInfo dir=" + dir);
        InstallerInfo installerInfo = this.getInstallerInfo();
        if (installerInfo != null) {
            File parentDir = new File(dir, InstallerInfoHelper.getInstance().getPath());
            parentDir.mkdirs();
            _log.finer("parentDir=" + parentDir);
            File infoFile = new File(parentDir, "installer-info.xml");
            InstallerInfoHelper.getInstance().save((IDataHandlerWrapper)installerInfo, infoFile);
        }
    }

    @Override
    public void updateInstallerInfo(File dir) throws DataHandlerException, IOException {
        _log.finer("updateInstallerInfo dir=" + dir);
        InstallerInfo installerInfo = this.getInstallerInfo();
        InstallerInfoHelper.getInstance().updateInstallerInfo(installerInfo, this.getDistributionLoader().getDistributionName(), this.getDistributionLoader().getDistributionVersion(), this.getComponentsMap());
        this.saveInstallerInfo(dir);
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this.getComponentLoader().getComponentsMap();
    }

    @Override
    public void saveShiphomeMetadata(File dir) throws GdrException, DataHandlerException, IOException {
        File compatibilityFile;
        _log.finer("saveShiphomeMetadata dir=" + dir);
        if (!dir.exists() && !dir.mkdirs()) {
            GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
            _log.throwing(DistributionPackager.class.getName(), "saveShiphomeMetadata", ex);
            throw ex;
        }
        if (!dir.isDirectory()) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(DistributionPackager.class.getName(), "saveShiphomeMetadata", ex);
            throw ex;
        }
        if (this.isRepositoryShiphome()) {
            Repository installRepo = RepositoryService.getInstallRepo(dir);
            this.getDistributionLoader().saveDistribution(installRepo);
            this.getDistributionLoader().saveDistributionInfo(installRepo);
            this.getDistributionLoader().getFeatureLoader().saveFeatures(installRepo);
            this.getComponentLoader().saveComponents(installRepo);
            File repoDir = new File(installRepo.getCacheLocation(), "com.oracle.cie.gdr".replaceAll("\\.", "/"));
            this.saveInstallerInfo(repoDir);
            this.savePatchAttachmentInfo(repoDir);
        } else {
            File distributionDir = new File(dir, DistributionHelper.getInstance().getPath());
            this.getDistributionLoader().saveDistribution(distributionDir);
            File featuresDir = new File(dir, FeatureSetHelper.getInstance().getPath());
            this.getDistributionLoader().getFeatureLoader().saveFeatures(featuresDir);
            this.getComponentLoader().saveComponents(dir, true);
            this.saveInstallerInfo(dir);
            this.saveMetadataPatch(dir, this.getMetaDataHome().getSrchomePath().getParent().toFile());
            this.savePatchAttachmentInfo(dir);
        }
        String compatibilityFilePath = this.getServiceHolder().getVariableResolverService().get("COMPATIBILITY_FILE");
        if (!StringUtil.isNullOrEmpty((String)compatibilityFilePath) && (compatibilityFile = new File(Util.getCanonicalPath((String)compatibilityFilePath))).exists()) {
            FeatureDependencyManager depManager = this.getMetaDataHome().getFeatureDependencyManager();
            depManager.loadDistributionCompatibilityFile(compatibilityFile);
            if (this.isRepositoryShiphome()) {
                Repository installRepo = RepositoryService.getInstallRepo(dir);
                File repoDir = new File(installRepo.getCacheLocation(), "com.oracle.cie.gdr".replaceAll("\\.", "/"));
                depManager.saveFeatureDependencies(new File(repoDir, FeatureDependencyManager.getFeatureSetDependencyPath()));
            } else {
                depManager.saveFeatureDependencies(new File(dir, FeatureDependencyManager.getFeatureSetDependencyPath()));
            }
        }
        ComponentHelper.getInstance().createLauncherProperties(dir.getParentFile(), this.getComponents(), this.getDistributionLoader().getDirectoryMap());
        try {
            DistributionHelper.getInstance().saveProductVariables(dir, this.getComponents(), this.getDistributionLoader().getDistributionName(), this.getDistributionLoader().getDistributionVersion());
        }
        catch (InputHandlerException e) {
            throw new DataHandlerException((Throwable)e);
        }
    }

    private void saveMetadataPatch(File stageLoc, File carbDiffOutputDir) throws GdrException {
        File metadataPatchDir = new File(stageLoc, "patches");
        PatchHelper.getInstance().createMetaDataPatch(metadataPatchDir.toPath(), carbDiffOutputDir.toPath(), this.getBugList(this.getInstallerInfo().getInstallerPackageInfo().getInstallerDistributionInfo()), this.getServiceHolder().getVariableResolverService(), this.getServiceHolder().getRepositoryService().getRepositories());
    }

    private Map<String, String> getBugList(List<InstallerDistributionInfo> dInfos) {
        HashMap<String, String> bugList = new HashMap<String, String>();
        if (dInfos != null) {
            for (InstallerDistributionInfo info : dInfos) {
                if (info.getBugInfo() == null) continue;
                for (Bug aBug : info.getBugInfo().getBugInfoList()) {
                    bugList.put(aBug.getNumber(), "bug " + aBug.getNumber());
                }
            }
        }
        return bugList;
    }

    public void savePatchAttachmentInfo(File dir) throws DataHandlerException, GdrException {
        _log.finer("savePatchAttachmentInfo dir=" + dir);
        this.getPatchAttachmentInfo(dir);
        if (this._patchAttachmentInfo != null) {
            File parentDir = new File(dir, PatchAttachmentInfoHelper.getInstance().getPath());
            parentDir.mkdirs();
            _log.finer("parentDir=" + parentDir);
            File patchAttachmentInfoFile = new File(parentDir, "patch-attachment-info.xml");
            if (!this._patchAttachmentInfo.getPatchInfos().isEmpty() || !this._patchAttachmentInfo.getDistributionPatchId().isEmpty()) {
                PatchAttachmentInfoHelper.getInstance().save((IDataHandlerWrapper)this._patchAttachmentInfo, patchAttachmentInfoFile);
            }
        }
    }

    private PatchAttachmentInfo getPatchAttachmentInfo(File dir) throws GdrException {
        if (this._patchAttachmentInfo == null) {
            this._patchAttachmentInfo = new PatchAttachmentInfo();
            List<PatchInfo> patchInfos = PatchAttachmentInfoHelper.getInstance().getPatchInfos(this.getServiceHolder().getRepositoryService(), dir, this.getDistributionLoader().getDistributionInfo(), this.getComponentLoader().getComponents(), this.getServiceHolder().getPlatformService().getPlatforms());
            if (patchInfos.isEmpty()) {
                return null;
            }
            this._patchAttachmentInfo.setPatchInfos(patchInfos);
        }
        return this._patchAttachmentInfo;
    }

    public boolean isLibValidationEnabled() {
        String libValidations = this.getServiceHolder().getVariableResolverService().get("LIBRARY_VALIDATIONS");
        if (StringUtil.isNullOrEmpty((String)libValidations, (boolean)true)) {
            _log.finest("LIBRARY_VALIDATIONS property not set");
            return true;
        }
        _log.finest("LIBRARY_VALIDATIONS property value: " + Boolean.parseBoolean(libValidations));
        return Boolean.parseBoolean(libValidations);
    }
}

