/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.orchestration.action.impl.StringSubsInstallAction;
import com.oracle.cie.gdr.patch.StringSubsEnvHandler;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.inputs.apis.Inputs;
import com.oracle.cie.nextgen.common.inputs.apis.Variable;
import com.oracle.cie.nextgen.common.inputs.helpers.InputHandler;
import com.oracle.cie.nextgen.common.inventory.InventoryUtils;
import java.io.IOException;
import java.util.Map;

public class StringSubsEnvHandlerImpl
implements StringSubsEnvHandler {
    private String _homeLocation;
    private String _homeName;

    public StringSubsEnvHandlerImpl(String homeLocation, String homeName) throws GdrException {
        this._homeLocation = homeLocation;
        this._homeName = homeName;
        if (StringUtil.isNullOrEmpty((String)homeLocation)) {
            throw new GdrException("The home location is a requireds parameter.");
        }
    }

    @Override
    public void initVariables(IObjectStore oStore) throws GdrException {
        try {
            String productLoc = InventoryUtils.getProductVariableFiles((String)this._homeLocation);
            if (productLoc != null) {
                System.setProperty("variables.xml.location", productLoc);
            }
            Inputs inputs = InputHandler.getInputs();
            inputs.loadVariables();
            inputs.setVariable("ORACLE_HOME", (Object)this._homeLocation);
            if (null != this._homeName) {
                inputs.setVariable("ORACLE_HOME_NAME", (Object)this._homeName);
            }
            Map installerVars = inputs.getInstallerVariables();
            for (Variable var : installerVars.values()) {
                oStore.storeObject((Object)var.getName(), (Object)var.getStringValue());
            }
            Map productVars = inputs.getProductVariables();
            for (Variable var : productVars.values()) {
                oStore.storeObject((Object)var.getName(), (Object)var.getStringValue());
            }
        }
        catch (Exception e) {
            throw new GdrException((Throwable)e);
        }
    }

    @Override
    public void fixBackupPermissions(Map<String, String> backupFiles) throws IOException {
        StringSubsInstallAction.fixBackupPermissions(backupFiles);
    }
}

