/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch.cin;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cin.CentralInventory;
import com.oracle.cie.gdr.dao.cin.Home;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.cin.CentralInventoryUpdater;
import com.oracle.cie.gdr.utils.GdrException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;

public class DetachUpdater
implements CentralInventoryUpdater {
    private static final Logger _log = Logger.getLogger(DetachUpdater.class.getName());
    private String homeLocation;
    private String[] params;

    public DetachUpdater(String homeLocation, String[] params) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)homeLocation, (boolean)true)) {
            throw new GdrException("The homeLocation is null or empty.");
        }
        this.homeLocation = homeLocation;
        this.params = params;
    }

    @Override
    public void update(CentralInventory centralInventory) {
        _log.info("Updating central inventory - Detach. homeLocation[" + this.homeLocation);
        List<Home> homes = centralInventory.getHomes();
        if (homes == null || homes.isEmpty()) {
            _log.info("homes list from Central Inventory was null or empty.");
            return;
        }
        Path homeLocationPath = NioHelper.getInstance().getPath(this.homeLocation.trim(), new String[0]);
        Home homeToRemove = null;
        for (Home home : homes) {
            Path indexHomeLocationPath;
            if (home == null || home.isRemoved() || !homeLocationPath.equals(indexHomeLocationPath = NioHelper.getInstance().getPath(home.getLoc(), new String[0]))) continue;
            homeToRemove = home;
            break;
        }
        _log.info("Home object to detach[" + homeToRemove + "]");
        if (homeToRemove != null) {
            centralInventory.removeHome(homeToRemove);
        }
    }
}

