/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.repository;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RepositoryBOMConfig {
    private Properties _props;
    private List<Repository> _repositories;
    private Set<FeatureSetReference> _featuresets;
    private File _cacheRepo = null;
    private static final PropertyKey[] ConfigurationProperties = new PropertyKey[]{PropertyKey.FEATURESETS, PropertyKey.REPOSITORIES, PropertyKey.CACHE_REPO};
    private static HashMap<String, PropertyKey> validConfigurationProperties = new HashMap();

    public RepositoryBOMConfig(Properties properties) throws RepositoryCommonException {
        this._props = properties;
        this.createDepGenConfig();
    }

    private void createDepGenConfig() throws RepositoryCommonException {
        Set<String> propNames = this._props.stringPropertyNames();
        for (String propName : propNames) {
            if (!validConfigurationProperties.containsKey(propName)) continue;
            PropertyKey propKey = validConfigurationProperties.get(propName);
            String propValue = this._props.getProperty(propName);
            switch (propKey.ordinal()) {
                case 0: {
                    this._featuresets = this.processFeatureSetRefs(propValue);
                    break;
                }
                case 1: {
                    this._repositories = this.processRepositories(propValue);
                    break;
                }
                case 2: {
                    this._cacheRepo = new File(propValue.trim());
                }
            }
        }
    }

    private List<Repository> processRepositories(String repos) throws RepositoryCommonException {
        String[] reposList;
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (StringUtil.isNullOrEmpty((String)repos, (boolean)true)) {
            throw new RepositoryCommonException("Unable to parse null/empty repositories string.");
        }
        for (String repo : reposList = repos.split(",")) {
            repositories.add(RestFactory.getRepository(null, (String)repo.trim(), null, null));
        }
        return repositories;
    }

    private Set<FeatureSetReference> processFeatureSetRefs(String features) throws RepositoryCommonException {
        Collection nameVersions = RepositoryUtils.parseNameVersionString((String)features);
        LinkedHashSet<FeatureSetReference> featureSetRefs = new LinkedHashSet<FeatureSetReference>();
        for (String[] nameVersion : nameVersions) {
            featureSetRefs.add(new FeatureSetReference(nameVersion[0], nameVersion[1]));
        }
        return featureSetRefs;
    }

    public RepoCommonConfig getRepoCommonConfig() throws RestException, RepositoryCommonException {
        return RepoCommonConfig.createRepoCommonConfig(this._repositories, (File)this._cacheRepo, (Properties)this._props, null);
    }

    public Set<FeatureSetReference> getFeaturesets() {
        return this._featuresets;
    }

    public List<Repository> getRepositories() {
        return this._repositories;
    }

    static {
        for (PropertyKey propKey : ConfigurationProperties) {
            validConfigurationProperties.put(propKey.name(), propKey);
        }
    }

    private static enum PropertyKey {
        FEATURESETS,
        REPOSITORIES,
        CACHE_REPO;

    }
}

