/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.di.ProductFamily;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.installation.Installer;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProductFamilyService {
    private static final ProductFamilyService _instance = new ProductFamilyService();

    private ProductFamilyService() {
    }

    public static ProductFamilyService getInstance() {
        return _instance;
    }

    public Map<String, String> generateProductFamilyVariables(String productFamily, File homeDir) throws GdrException {
        return this.generateProductFamilyVariables(productFamily, NioHelper.getInstance().getPath(homeDir));
    }

    public Map<String, String> generateProductFamilyVariables(String productFamily, Path homePath) throws GdrException {
        if (StringUtil.isNullOrEmpty((String)productFamily)) {
            throw new GdrException("The product family cannot be null or empty.");
        }
        String productFamilyOH = productFamily.toUpperCase() + "_ORACLE_HOME";
        String productFamilyOHName = productFamily.toUpperCase() + "_ORACLE_HOME_NAME";
        LinkedHashMap<String, String> productFamilyVariables = new LinkedHashMap<String, String>();
        productFamilyVariables.put(productFamilyOH, homePath.toAbsolutePath().toString());
        productFamilyVariables.put(productFamilyOHName, homePath.getFileName().toString());
        return productFamilyVariables;
    }

    public Map<String, String> getFederatedOracleHomeProductFamiliesMap(Installer installer) throws GdrException {
        InstallationSession installationSession = installer.getInstallationSession();
        DistributionInfo currentDistributionInfo = installationSession.getDistributionInfo();
        return this.getFederatedOracleHomeProductFamiliesMap(currentDistributionInfo, installer.getHome());
    }

    public Map<String, String> getFederatedOracleHomeProductFamiliesMap(DistributionInfo currentDistributionInfo, Home home) throws GdrException {
        List currentProductFamilies;
        LinkedHashMap<String, String> fohProdFamilyMap = new LinkedHashMap<String, String>();
        if (currentDistributionInfo != null && (currentProductFamilies = currentDistributionInfo.getProductFamilies()) != null) {
            for (ProductFamily prodFamily : currentProductFamilies) {
                fohProdFamilyMap.putAll(this.generateProductFamilyVariables(prodFamily.getName(), home.getHomePath()));
            }
        }
        Set<Home> fohSet = home.getAllFederatedHomes(true);
        for (Home foh : fohSet) {
            for (String productFamily : foh.getProductFamilies()) {
                fohProdFamilyMap.putAll(this.generateProductFamilyVariables(productFamily, foh.getHomePath()));
            }
        }
        return fohProdFamilyMap;
    }
}

