/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.services.RepositoryArtifact;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.repository.resolver.RepositoryVersionResolverException;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.RestHelper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryService {
    private static final Logger _log = Logger.getLogger(RepositoryService.class.getName());
    public static final String REPOSITORY_URLS = "REPOSITORY_URLS";
    public static final String REPOSITORY_USERNAME = "REPOSITORY_USERNAME";
    public static final String REPOSITORY_PASSWORD = "REPOSITORY_PASSWORD";
    public static final String INSTALL_REPO_DIR = "install-repo";
    public static final String LOCAL_CACHE_REPOSITORY = "LOCAL_CACHE_REPOSITORY";
    public static final String REPO_URL_PROPERTY = "repoURL";
    public static final String AUX_LOCAL_REPO_PROPERTY = "auxLocalRepos";
    public static final String READ_ONLY_LOCAL_REPO_PROPERTY = "readOnlyLocalRepos";
    private static RestHandler _restHandler;
    private static RestHelper _restHelper;
    private static NextGenHelper _nextGenHelper;
    private static RepositoryVersionResolver _repositoryVersionResolver;
    private static Repository _localCacheRepository;
    private VariableResolverService _variableResolverService;
    private List<Artifact> _consumedArtifacts = new ArrayList<Artifact>();
    private static String _versionQualifier;
    private boolean _convertLegacyCarbs;

    public RepositoryService(VariableResolverService variableResolverService) throws GdrException {
        this(variableResolverService, (RepositoryVersionResolver)null);
    }

    public RepositoryService(VariableResolverService variableResolverService, List<Module> consumptionModules) throws GdrException {
        this(variableResolverService, consumptionModules, null);
    }

    public RepositoryService(VariableResolverService variableResolverService, List<Module> consumptionModules, RepositoryVersionResolver repositoryVersionResolver) throws GdrException {
        this._variableResolverService = variableResolverService;
        if (repositoryVersionResolver != null) {
            _repositoryVersionResolver = repositoryVersionResolver;
        } else {
            try {
                String repo = this._variableResolverService.get("repo");
                String repoURL = this._variableResolverService.get(REPO_URL_PROPERTY);
                String cacheRepo = this.getLocalCacheRepositoryLocation().getAbsolutePath();
                String username = this._variableResolverService.get("username");
                String password = this._variableResolverService.get("password");
                String auxLocalRepos = this._variableResolverService.get(AUX_LOCAL_REPO_PROPERTY);
                String readOnlyLocalRepos = this._variableResolverService.get(READ_ONLY_LOCAL_REPO_PROPERTY);
                RepoCommonConfig commonConfig = RepoCommonConfig.createRepoCommonConfig((String)repo, (String)repoURL, (String)cacheRepo, null, null, (String)username, (String)password);
                commonConfig.configureAuxLocalRepos(auxLocalRepos, readOnlyLocalRepos);
                if (consumptionModules == null) {
                    consumptionModules = RepositoryService.getNextGenHelper().getOverrideDependencyModules(this._variableResolverService.get("DEPENDENCY_OVERRIDE_COORDINATES"), this._variableResolverService.get("DEPENDENCY_OVERRIDE_FILE"), Arrays.asList(commonConfig.getRepositories()));
                }
                _repositoryVersionResolver = new RepositoryVersionResolver(RepositoryService.getNextGenHelper(), commonConfig.getRepositories(), consumptionModules, Boolean.valueOf(this._variableResolverService.get("USE_LATEST")).booleanValue());
            }
            catch (RepositoryVersionResolverException e) {
                throw new GdrException("Failed to create repository version resolver with consumption modules " + consumptionModules, (Throwable)e);
            }
            catch (Exception e) {
                throw new GdrException("Failed to create repository version resolver.", (Throwable)e);
            }
        }
    }

    public RepositoryService(VariableResolverService variableResolverService, RepositoryVersionResolver repositoryVersionResolver) throws GdrException {
        this(variableResolverService, null, repositoryVersionResolver);
    }

    public VariableResolverService getVariableResolverService() {
        return this._variableResolverService;
    }

    public boolean isConvertLegacyCarbs() {
        return this._convertLegacyCarbs;
    }

    public void setConvertLegacyCarbs(boolean convertLegacyCarbs) {
        this._convertLegacyCarbs = convertLegacyCarbs;
    }

    public static RestHandler getRestHandler() {
        if (_restHandler == null) {
            _restHandler = RestFactory.getRestHandler();
        }
        return _restHandler;
    }

    public static RestHelper getRestHelper() {
        if (_restHelper == null) {
            _restHelper = RestFactory.getRestHelper((RestHandler)RepositoryService.getRestHandler());
        }
        return _restHelper;
    }

    public static NextGenHelper getNextGenHelper() {
        if (_nextGenHelper == null) {
            _nextGenHelper = NextGenHelperFactory.getNextGenHelper((RestHandler)RepositoryService.getRestHandler());
        }
        return _nextGenHelper;
    }

    public List<Repository> getRepositories() {
        return Arrays.asList(_repositoryVersionResolver.getRepositories());
    }

    public Repository[] getRepositoriesArray() {
        return _repositoryVersionResolver.getRepositories();
    }

    public File getLocalCacheRepositoryLocation() throws GdrException {
        return this.getLocalCacheRepository().getCacheLocation();
    }

    public Repository getLocalCacheRepository() throws GdrException {
        if (_localCacheRepository == null) {
            try {
                _localCacheRepository = RestFactory.getRestHandlerConfig().getDefaultCacheRepository();
            }
            catch (RestException e) {
                throw new GdrException("Failed to get default local cache repository.", (Throwable)e);
            }
            String variableValue = this._variableResolverService.get(LOCAL_CACHE_REPOSITORY);
            if (!StringUtil.isNullOrEmpty((String)variableValue, (boolean)true)) {
                try {
                    File variableLocation = new File(variableValue);
                    if (!_localCacheRepository.getCacheLocation().equals(variableLocation)) {
                        _localCacheRepository = RestFactory.getRestHandlerConfig().setDefaultCacheRepository(variableLocation);
                    }
                }
                catch (RestException e) {
                    throw new GdrException("Failed to set default local cache repository.", (Throwable)e);
                }
            }
        }
        return _localCacheRepository;
    }

    public static void setLocalCacheRepository(Repository localCacheRepository) {
        _localCacheRepository = localCacheRepository;
    }

    public File getArtifactLocation(Artifact artifact) throws GdrException {
        if (artifact == null) {
            throw new GdrException("The artifact specified was null.");
        }
        File artifactFile = artifact.getLocalLocation(this.getLocalCacheRepository().getCacheLocation());
        if (!artifactFile.exists()) {
            for (Repository repo : this.getRepositories()) {
                if (repo.getCacheLocation() == null || !artifact.getLocalLocation(repo.getCacheLocation()).exists()) continue;
                return artifact.getLocalLocation(repo.getCacheLocation());
            }
        }
        return artifactFile;
    }

    public RepositoryVersionResolver getRepositoryVersionResolver() {
        return _repositoryVersionResolver;
    }

    public static String getVersionQualifier() {
        if (_versionQualifier == null) {
            Calendar currentCalendar = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd.HHmm");
            _versionQualifier = sdf.format(currentCalendar.getTime());
        }
        return _versionQualifier;
    }

    public static void setVersionQualifier(String versionQualifier) {
        _versionQualifier = versionQualifier;
    }

    public static Repository getInstallRepo(File parentDir) {
        return RestFactory.getRepository((String)INSTALL_REPO_DIR, (RepositoryType)RepositoryType.CACHE, (String)new File(parentDir, INSTALL_REPO_DIR).getAbsolutePath(), null, (String)null);
    }

    public List<Artifact> getConsumedArtifacts() {
        return this._consumedArtifacts;
    }

    public boolean hasConsumedArtifacts() {
        return !this._consumedArtifacts.isEmpty();
    }

    public static void saveMergedConsumptionModule(Collection<Component> components, File consumptionFile) throws GdrException, IOException {
        Module consumptionModule = DependencyManagementFactory.getInstance().getModule("com.oracle.cie.gdr.carb.artifacts", "merged-carb-artifacts", "1.0.0", DependencyFileType.pom.name());
        if (components != null && !components.isEmpty()) {
            ArrayList<Artifact> consumedArtifacts = new ArrayList<Artifact>();
            for (Component component : components) {
                List<Artifact> compArtifacts;
                RepositoryService repositoryService = component.getRepositoryService();
                if (repositoryService == null || (compArtifacts = repositoryService.getConsumedArtifacts()) == null || compArtifacts.isEmpty()) continue;
                consumedArtifacts.addAll(compArtifacts);
            }
            if (!consumedArtifacts.isEmpty()) {
                consumptionModule.setDependencies(DependencyManagementHelper.convertToDependencies(consumedArtifacts, (boolean)true));
            }
        }
        try {
            DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(consumptionModule, consumptionFile);
        }
        catch (DependencyManagementException e) {
            throw new GdrException((Throwable)e);
        }
    }

    public void saveConsumptionModule(String name, String version, File consumptionFile) throws GdrException, IOException {
        Module consumptionModule = DependencyManagementFactory.getInstance().getModule("com.oracle.cie.gdr.carb", name, version, "carb");
        if (this._consumedArtifacts != null && !this._consumedArtifacts.isEmpty()) {
            consumptionModule.setDependencies(DependencyManagementHelper.convertToDependencies(this._consumedArtifacts, (boolean)true));
        }
        try {
            if (consumptionFile.isDirectory()) {
                Artifact consumptionModuleArtifact = consumptionModule.getArtifact();
                consumptionModuleArtifact.setType(DependencyFileType.pom.name());
                consumptionFile = new File(consumptionFile, consumptionModuleArtifact.getFileName());
            }
            DependencyManagementFactory.getInstance().getDependencyFileHandler(DependencyFileType.pom).writeDependenciesFile(consumptionModule, consumptionFile);
        }
        catch (DependencyManagementException e) {
            throw new GdrException((Throwable)e);
        }
    }

    public File retrieveRepositoryArtifact(RepositoryArtifact repoArtifact) throws IOException, RestException, GdrException, DependencyManagementException, RepositoryCommonException {
        Version version;
        if (repoArtifact == null) {
            GdrException ex = new GdrException("The repository artifact specified was null.");
            _log.throwing(RepositoryService.class.getName(), "retrieveRepositoryArtifact", (Throwable)ex);
            throw ex;
        }
        String group = repoArtifact.getGroup();
        if (StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
            GdrException ex = new GdrException("The group value specified was null or empty for " + repoArtifact);
            _log.throwing(RepositoryService.class.getName(), "retrieveRepositoryArtifact", (Throwable)ex);
            throw ex;
        }
        String artifactName = repoArtifact.getArtifact();
        if (StringUtil.isNullOrEmpty((String)artifactName, (boolean)true)) {
            GdrException ex = new GdrException("The artifact name value specified was null or empty for " + repoArtifact);
            _log.throwing(RepositoryService.class.getName(), "retrieveRepositoryArtifact", (Throwable)ex);
            throw ex;
        }
        String classifier = repoArtifact.getClassifier();
        String type = repoArtifact.getType();
        String versionStr = repoArtifact.getVersion();
        String baseVersionStr = repoArtifact.getBaseVersion();
        try {
            version = this.getRepositoryVersionResolver().getBuildArtifactVersion(group, artifactName, versionStr, repoArtifact.isIgnoreVersionKeywords(), baseVersionStr, type, classifier);
            repoArtifact.setVersion(version.getVersion());
        }
        catch (RepositoryCommonException e) {
            _log.log(Level.SEVERE, "Failed to get version for repository artifact: " + repoArtifact, e);
            throw e;
        }
        Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(group, artifactName, version, type);
        if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
            artifact.setClassifier(classifier);
        }
        return this.retrieveRepositoryArtifact(artifact, false);
    }

    public File retrieveRepositoryArtifact(Artifact artifact, boolean resolveVersion) throws IOException, RestException, GdrException, DependencyManagementException, RepositoryCommonException {
        IObjectStore objectStore;
        File artifactFile;
        if (artifact == null) {
            GdrException ex = new GdrException("The artifact specified was null.");
            _log.throwing(RepositoryService.class.getName(), "retrieveRepositoryArtifact", (Throwable)ex);
            throw ex;
        }
        if (resolveVersion) {
            Version version;
            try {
                String baseVersion = artifact.getVersion().isEmptyVersion() ? null : artifact.getVersion().getBaseVersion();
                version = this.getRepositoryVersionResolver().getBuildArtifactVersion(artifact.getGroup(), artifact.getName(), null, baseVersion, artifact.getType(), artifact.getClassifier());
            }
            catch (RepositoryCommonException e) {
                _log.log(Level.SEVERE, "Failed to get version for repository artifact: " + artifact, e);
                throw e;
            }
            artifact.setVersion(version);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Attempting to retrieve artifact:" + artifact + " from repositories " + this.getRepositories());
        }
        if ((artifactFile = RepositoryService.getRestHandler().retrieveArtifact(artifact, this.getRepositories(), false)) == null) {
            GdrException ex = new GdrException("Failed to retrieve artifact from repositories " + this.getRepositories() + ", File returned was null for artifact: " + artifact);
            _log.throwing(RepositoryService.class.getName(), "retrieveRepositoryArtifact", (Throwable)ex);
            throw ex;
        }
        this._consumedArtifacts.add(artifact);
        IObjectStore iObjectStore = objectStore = this._variableResolverService != null ? this._variableResolverService.getObjectStore("repo-artifact-namespace") : null;
        if (objectStore != null) {
            objectStore.storeObject((Object)"group", (Object)artifact.getGroup());
            objectStore.storeObject((Object)"artifact", (Object)artifact.getName());
            objectStore.storeObject((Object)"extension", (Object)artifact.getType());
            objectStore.storeObject((Object)"version", (Object)artifact.getVersion());
            objectStore.storeObject((Object)"baseVersion", (Object)artifact.getBaseVersion());
            String qualifiers = null;
            if (artifact.getVersion().hasQualifier()) {
                for (int x = 1; x < 5; ++x) {
                    String q = artifact.getVersion().getQualifier(x);
                    if (q != null) {
                        objectStore.storeObject((Object)("qualifier" + x), (Object)q);
                        if (qualifiers == null) {
                            qualifiers = q;
                            continue;
                        }
                        qualifiers = qualifiers + "-" + q;
                        continue;
                    }
                    objectStore.removeObject((Object)("qualifier" + x));
                }
            }
            if (qualifiers != null) {
                objectStore.storeObject((Object)"qualifiers", qualifiers);
            } else {
                objectStore.removeObject((Object)"qualifiers");
            }
        }
        return artifactFile;
    }

    public static boolean equalsRepositoryArtifact(RepositoryArtifact repositoryArtifact, Artifact artifact) {
        if (repositoryArtifact != null && artifact != null) {
            Artifact a = DependencyManagementFactory.getInstance().getArtifact(repositoryArtifact.getGroup(), repositoryArtifact.getArtifact(), repositoryArtifact.getVersion(), repositoryArtifact.getType());
            a.setClassifier(repositoryArtifact.getClassifier());
            return artifact.equals((Object)a);
        }
        return false;
    }
}

